/*
 * Decompiled with CFR 0.152.
 */
package com.goide.quickfix;

import com.goide.GoTypes;
import com.goide.formatter.GoFormatterUtil;
import com.goide.i18n.GoBundle;
import com.goide.inspections.GoBoolExpressionsInspection;
import com.goide.psi.GoAndExpr;
import com.goide.psi.GoBinaryExpr;
import com.goide.psi.GoConditionalExpr;
import com.goide.psi.GoExpression;
import com.goide.psi.impl.GoElementFactory;
import com.goide.psi.impl.GoExpressionUtil;
import com.goide.psi.impl.GoReferenceBase;
import com.intellij.codeInspection.LocalQuickFixOnPsiElement;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.SmartList;
import com.intellij.util.ThreeState;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GoSimplifyBoolExprQuickFix
extends LocalQuickFixOnPsiElement {
    @Nls
    @NotNull
    public static String getQuickFixName() {
        String string = GoBundle.message((String)"go.fix.simplify.bool.expr.name", (Object[])new Object[0]);
        if (string == null) {
            GoSimplifyBoolExprQuickFix.$$$reportNull$$$0(0);
        }
        return string;
    }

    public GoSimplifyBoolExprQuickFix(@NotNull PsiElement element) {
        if (element == null) {
            GoSimplifyBoolExprQuickFix.$$$reportNull$$$0(1);
        }
        super(element);
    }

    @NotNull
    public String getFamilyName() {
        String string = this.getName();
        if (string == null) {
            GoSimplifyBoolExprQuickFix.$$$reportNull$$$0(2);
        }
        return string;
    }

    @NotNull
    public String getText() {
        return GoSimplifyBoolExprQuickFix.getQuickFixName();
    }

    public void invoke(@NotNull Project project, @NotNull PsiFile file, @NotNull PsiElement startElement, @NotNull PsiElement endElement) {
        GoBinaryExpr o;
        block10: {
            block9: {
                if (project == null) {
                    GoSimplifyBoolExprQuickFix.$$$reportNull$$$0(3);
                }
                if (file == null) {
                    GoSimplifyBoolExprQuickFix.$$$reportNull$$$0(4);
                }
                if (startElement == null) {
                    GoSimplifyBoolExprQuickFix.$$$reportNull$$$0(5);
                }
                if (endElement == null) {
                    GoSimplifyBoolExprQuickFix.$$$reportNull$$$0(6);
                }
                if (!(startElement instanceof GoBinaryExpr)) break block9;
                o = (GoBinaryExpr)startElement;
                if (startElement.isValid()) break block10;
            }
            return;
        }
        boolean and = o instanceof GoAndExpr;
        List<GoExpression> elements = GoBoolExpressionsInspection.collect(o, and);
        List<GoBoolExpressionsInspection.ExpressionGroup> groups = GoBoolExpressionsInspection.split(elements);
        SmartList remainingExpressions = new SmartList();
        for (GoBoolExpressionsInspection.ExpressionGroup group : groups) {
            if (group.hasSideEffects) {
                remainingExpressions.addAll(group.expressions);
                continue;
            }
            PsiElement context = GoReferenceBase.getSubstitutionContextOrSelf(startElement);
            List<GoExpression> simplified = GoSimplifyBoolExprQuickFix.simplify(group.expressions, and, context);
            int literalIndex = ContainerUtil.indexOf(simplified, e -> {
                Boolean value = GoExpressionUtil.getBoolConst(e);
                return and ? Boolean.FALSE.equals(value) : Boolean.TRUE.equals(value);
            });
            int sublistEnd = literalIndex != -1 ? literalIndex + 1 : simplified.size();
            remainingExpressions.addAll(simplified.subList(0, sublistEnd));
            if (literalIndex == -1) continue;
            break;
        }
        GoSimplifyBoolExprQuickFix.replace(project, o, and, (List<GoExpression>)remainingExpressions);
    }

    @NotNull
    private static List<GoExpression> simplify(@NotNull List<GoExpression> elements, boolean and, @Nullable PsiElement context) {
        if (elements == null) {
            GoSimplifyBoolExprQuickFix.$$$reportNull$$$0(7);
        }
        SmartList toRemove = new SmartList();
        for (int i = 0; i < elements.size(); ++i) {
            GoExpression l = elements.get(i);
            for (int j = i + 1; j < elements.size(); ++j) {
                boolean isLeftEquals;
                GoExpression r = elements.get(j);
                if (GoBoolExpressionsInspection.isEqualsWithNot(l, r, context) || GoBoolExpressionsInspection.isEqualsWithNot(r, l, context)) {
                    List<GoExpression> list = Collections.singletonList(GoElementFactory.createExpression(l.getProject(), String.valueOf(!and)));
                    if (list == null) {
                        GoSimplifyBoolExprQuickFix.$$$reportNull$$$0(8);
                    }
                    return list;
                }
                if (GoExpressionUtil.identical(l, r, context)) {
                    toRemove.add(l);
                    continue;
                }
                ThreeState valuesEquals = GoBoolExpressionsInspection.areSameExpressions(l, r, context);
                if (valuesEquals == ThreeState.UNSURE) continue;
                boolean operatorsEquals = GoExpressionUtil.identicalOperators(l, r);
                if (valuesEquals.toBoolean()) {
                    if (operatorsEquals) {
                        toRemove.add(l);
                        continue;
                    }
                    List<GoExpression> list = Collections.singletonList(GoElementFactory.createExpression(l.getProject(), String.valueOf(!and)));
                    if (list == null) {
                        GoSimplifyBoolExprQuickFix.$$$reportNull$$$0(9);
                    }
                    return list;
                }
                boolean bl = isLeftEquals = ((GoConditionalExpr)l).getEq() != null;
                if (operatorsEquals) {
                    if (isLeftEquals != and) continue;
                    List<GoExpression> list = Collections.singletonList(GoElementFactory.createExpression(l.getProject(), String.valueOf(!and)));
                    if (list == null) {
                        GoSimplifyBoolExprQuickFix.$$$reportNull$$$0(10);
                    }
                    return list;
                }
                toRemove.add(and ^ isLeftEquals ? l : r);
            }
        }
        elements.removeAll((Collection<?>)toRemove);
        List<GoExpression> list = elements;
        if (list == null) {
            GoSimplifyBoolExprQuickFix.$$$reportNull$$$0(11);
        }
        return list;
    }

    public static void replace(@NotNull Project project, @NotNull GoBinaryExpr o, boolean and, @NotNull List<GoExpression> remainingExpressions) {
        PsiElement replacement;
        if (project == null) {
            GoSimplifyBoolExprQuickFix.$$$reportNull$$$0(12);
        }
        if (o == null) {
            GoSimplifyBoolExprQuickFix.$$$reportNull$$$0(13);
        }
        if (remainingExpressions == null) {
            GoSimplifyBoolExprQuickFix.$$$reportNull$$$0(14);
        }
        ExpressionWithAfterComments expressionWithAfterComments = GoSimplifyBoolExprQuickFix.joinPreservingComments(remainingExpressions, and);
        if (StringUtil.isEmpty((String)expressionWithAfterComments.expression)) {
            LOG.error("we've collected an empty expressions subset from '" + o.getText() + "', isValid: " + o.isValid());
        }
        GoExpression newExpression = GoElementFactory.createExpression(project, expressionWithAfterComments.expression);
        List newAfterComments = ContainerUtil.map(expressionWithAfterComments.afterComments, c -> GoElementFactory.createComment(project, c));
        List<PsiComment> afterComments2 = GoSimplifyBoolExprQuickFix.getAfterComments(o);
        PsiElement anchor = (PsiElement)ObjectUtils.notNull((Object)((PsiElement)ContainerUtil.getLastItem(afterComments2)), (Object)o);
        PsiElement parent = anchor.getParent();
        if (parent == null) {
            return;
        }
        anchor = replacement = parent.addAfter((PsiElement)newExpression, anchor);
        for (PsiElement newAfterComment : newAfterComments) {
            anchor = parent.addAfter(newAfterComment, anchor);
        }
        o.delete();
        afterComments2.forEach(PsiElement::delete);
        GoFormatterUtil.reformat(replacement);
    }

    @NotNull
    private static ExpressionWithAfterComments joinPreservingComments(@NotNull List<GoExpression> remainingExpressions, boolean and) {
        if (remainingExpressions == null) {
            GoSimplifyBoolExprQuickFix.$$$reportNull$$$0(15);
        }
        ArrayList<List<PsiComment>> comments = new ArrayList<List<PsiComment>>(remainingExpressions.size());
        boolean hasNonEmptyComments = false;
        for (GoExpression expression : remainingExpressions) {
            List<PsiComment> afterComments2;
            PsiElement nextLeaf = PsiTreeUtil.nextVisibleLeaf((PsiElement)expression);
            IElementType elementType = nextLeaf != null ? nextLeaf.getNode().getElementType() : null;
            List<PsiComment> list = afterComments2 = elementType == GoTypes.COND_AND || elementType == GoTypes.COND_OR ? GoSimplifyBoolExprQuickFix.getAfterComments(nextLeaf) : GoSimplifyBoolExprQuickFix.getAfterComments(expression);
            if (!afterComments2.isEmpty()) {
                hasNonEmptyComments = true;
            }
            comments.add(afterComments2);
        }
        StringBuilder builder = new StringBuilder();
        String separator = and ? " && " : " || ";
        for (int i = 0; i < remainingExpressions.size(); ++i) {
            boolean notLast;
            boolean bl = notLast = i != remainingExpressions.size() - 1;
            if (notLast) {
                builder.append(remainingExpressions.get(i).getText()).append(separator).append(StringUtil.join((Collection)((Collection)comments.get(i)), PsiElement::getText, (String)" ")).append(hasNonEmptyComments ? "\n" : "");
                continue;
            }
            builder.append(remainingExpressions.get(i).getText());
        }
        List lastComments = (List)ContainerUtil.getLastItem(comments);
        if (lastComments == null) {
            throw new IllegalStateException("number of expressions and comments mismatch");
        }
        return new ExpressionWithAfterComments(builder.toString(), ContainerUtil.map((Collection)lastComments, PsiElement::getText));
    }

    @NotNull
    private static List<PsiComment> getAfterComments(@NotNull PsiElement element) {
        if (element == null) {
            GoSimplifyBoolExprQuickFix.$$$reportNull$$$0(16);
        }
        if (element instanceof PsiComment) {
            List<PsiComment> list = Collections.emptyList();
            if (list == null) {
                GoSimplifyBoolExprQuickFix.$$$reportNull$$$0(17);
            }
            return list;
        }
        SmartList result = new SmartList();
        while ((element = PsiTreeUtil.nextLeaf((PsiElement)element)) != null) {
            if (element instanceof PsiComment) {
                result.add((PsiComment)element);
                continue;
            }
            if (element instanceof PsiWhiteSpace && !element.getText().contains("\n")) continue;
        }
        SmartList smartList = result;
        if (smartList == null) {
            GoSimplifyBoolExprQuickFix.$$$reportNull$$$0(18);
        }
        return smartList;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 1, 3, 4, 5, 6, 7, 12, 13, 14, 15, 16 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/goide/quickfix/GoSimplifyBoolExprQuickFix";
                break;
            }
            case 1: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 3: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "startElement";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "endElement";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elements";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "o";
                break;
            }
            case 14: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "remainingExpressions";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getQuickFixName";
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "com/goide/quickfix/GoSimplifyBoolExprQuickFix";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "simplify";
                break;
            }
            case 17: 
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "getAfterComments";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "invoke";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "simplify";
                break;
            }
            case 12: 
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "replace";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "joinPreservingComments";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "getAfterComments";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 1, 3, 4, 5, 6, 7, 12, 13, 14, 15, 16 -> new IllegalArgumentException(string);
        };
    }

    private static final class ExpressionWithAfterComments {
        public final String expression;
        public final List<String> afterComments;

        private ExpressionWithAfterComments(@NotNull String expression, @NotNull List<String> afterComments2) {
            if (expression == null) {
                ExpressionWithAfterComments.$$$reportNull$$$0(0);
            }
            if (afterComments2 == null) {
                ExpressionWithAfterComments.$$$reportNull$$$0(1);
            }
            this.expression = expression;
            this.afterComments = afterComments2;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "expression";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "afterComments";
                    break;
                }
            }
            objectArray[1] = "com/goide/quickfix/GoSimplifyBoolExprQuickFix$ExpressionWithAfterComments";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

