/*
 * Decompiled with CFR 0.152.
 */
package com.goide.psi.properties;

import com.goide.GoFileType;
import com.goide.execution.testing.GoTestFinder;
import com.goide.psi.GoFile;
import com.goide.psi.properties.GoFilePropertiesParser;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.testFramework.LightVirtualFile;
import com.intellij.util.gist.GistManager;
import com.intellij.util.gist.VirtualFileGist;
import com.intellij.util.io.DataExternalizer;
import com.intellij.util.io.IOUtil;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.VisibleForTesting;

public class GoFileProperties {
    private static final GoFileProperties EMPTY_PROPERTIES = new GoFileProperties(null, null, null, false, false);
    @VisibleForTesting
    public static final int READ_FILE_LIMIT = 4096;
    public static final int VERSION = 8;
    public static final VirtualFileGist<GoFileProperties> GIST = GistManager.getInstance().newVirtualFileGist("GO_FILE_PROPERTIES", 8, (DataExternalizer)new DataExternalizer<GoFileProperties>(){

        public void save(@NotNull DataOutput out, GoFileProperties value) throws IOException {
            if (out == null) {
                1.$$$reportNull$$$0(0);
            }
            IOUtil.writeUTF((DataOutput)out, (String)StringUtil.notNullize((String)value.packageName));
            IOUtil.writeUTF((DataOutput)out, (String)StringUtil.notNullize((String)value.buildFlags));
            IOUtil.writeUTF((DataOutput)out, (String)StringUtil.notNullize((String)value.goBuildConstraint));
            out.writeBoolean(value.hasCImport);
            out.writeBoolean(value.isGenerated);
        }

        public GoFileProperties read(@NotNull DataInput in) throws IOException {
            if (in == null) {
                1.$$$reportNull$$$0(1);
            }
            return new GoFileProperties(StringUtil.nullize((String)IOUtil.readUTF((DataInput)in)), StringUtil.nullize((String)IOUtil.readUTF((DataInput)in)), StringUtil.nullize((String)IOUtil.readUTF((DataInput)in)), in.readBoolean(), in.readBoolean());
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "out";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "in";
                    break;
                }
            }
            objectArray2[1] = "com/goide/psi/properties/GoFileProperties$1";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "save";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "read";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }, (project, file) -> {
        GoFilePropertiesParser propertiesParser = new GoFilePropertiesParser();
        if (file instanceof LightVirtualFile) {
            return propertiesParser.parse(((LightVirtualFile)file).getContent());
        }
        byte[] buf = new byte[4096];
        try (InputStream stream = file.getInputStream();){
            while (!propertiesParser.isFinished()) {
                int nread = stream.read(buf);
                if (nread == -1) {
                    break;
                }
                propertiesParser.partialParse(propertiesParser.getPrefixForNextIteration() + new String(buf, 0, nread, StandardCharsets.UTF_8));
            }
        }
        catch (ProcessCanceledException e) {
            throw e;
        }
        catch (Throwable ignore) {
            return EMPTY_PROPERTIES;
        }
        return propertiesParser.getFileProperties();
    });
    @Nullable
    public final String packageName;
    @Nullable
    public final String buildFlags;
    @Nullable
    public final String goBuildConstraint;
    public final boolean hasCImport;
    public final boolean isGenerated;

    public GoFileProperties(@Nullable String packageName, @Nullable String buildFlags, @Nullable String goBuildConstraint, boolean hasCImport, boolean isGenerated) {
        this.packageName = packageName;
        this.buildFlags = buildFlags;
        this.goBuildConstraint = goBuildConstraint;
        this.hasCImport = hasCImport;
        this.isGenerated = isGenerated;
    }

    public String getCanonicalPackageName(@NotNull VirtualFile file) {
        if (file == null) {
            GoFileProperties.$$$reportNull$$$0(0);
        }
        if (StringUtil.isNotEmpty((String)this.packageName) && GoTestFinder.isTestFile(file)) {
            return StringUtil.trimEnd((String)this.packageName, (String)"_test");
        }
        return this.packageName;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        GoFileProperties that = (GoFileProperties)o;
        return this.hasCImport == that.hasCImport && this.isGenerated == that.isGenerated && Objects.equals(this.packageName, that.packageName) && Objects.equals(this.buildFlags, that.buildFlags) && Objects.equals(this.goBuildConstraint, that.goBuildConstraint);
    }

    public int hashCode() {
        return Objects.hash(this.packageName, this.buildFlags, this.goBuildConstraint, this.hasCImport, this.isGenerated);
    }

    @Nullable
    public static GoFileProperties of(@Nullable PsiFile file) {
        return file instanceof GoFile ? ((GoFile)file).getFileProperties() : GoFileProperties.calcFileProperties(file);
    }

    @Nullable
    private static GoFileProperties calcFileProperties(@Nullable PsiFile file) {
        if (file == null || file.getFileType() != GoFileType.INSTANCE) {
            return null;
        }
        VirtualFile virtualFile = file.getViewProvider().getVirtualFile();
        if (FileDocumentManager.getInstance().isFileModified(virtualFile)) {
            return (GoFileProperties)CachedValuesManager.getCachedValue((PsiElement)file, () -> new CachedValueProvider.Result((Object)new GoFilePropertiesParser().parse(file.getText()), new Object[]{file}));
        }
        return (GoFileProperties)GIST.getFileData(file.getProject(), virtualFile);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/goide/psi/properties/GoFileProperties", "getCanonicalPackageName"));
    }
}

