/*
 * Decompiled with CFR 0.152.
 */
package com.goide.psi.presentation;

import com.goide.documentation.GoDocumentationProvider;
import com.goide.editor.GoParameterInfoHandler;
import com.goide.editor.GoTypeArgumentsParameterInfoHandler;
import com.goide.psi.GoAnonymousFieldDefinition;
import com.goide.psi.GoArrayOrSliceType;
import com.goide.psi.GoChannelType;
import com.goide.psi.GoConstraintElem;
import com.goide.psi.GoConstraintTerm;
import com.goide.psi.GoFieldDeclaration;
import com.goide.psi.GoFunctionLit;
import com.goide.psi.GoFunctionType;
import com.goide.psi.GoInterfaceType;
import com.goide.psi.GoMapType;
import com.goide.psi.GoMethodDeclaration;
import com.goide.psi.GoMethodSpec;
import com.goide.psi.GoNamedSignatureOwner;
import com.goide.psi.GoParType;
import com.goide.psi.GoParameters;
import com.goide.psi.GoPointerType;
import com.goide.psi.GoReceiver;
import com.goide.psi.GoResult;
import com.goide.psi.GoSignature;
import com.goide.psi.GoSignatureOwner;
import com.goide.psi.GoSpecType;
import com.goide.psi.GoStructType;
import com.goide.psi.GoType;
import com.goide.psi.GoTypeArguments;
import com.goide.psi.GoTypeList;
import com.goide.psi.GoTypeParamDefinition;
import com.goide.psi.GoTypeParameter;
import com.goide.psi.GoTypeParameters;
import com.goide.psi.GoTypeReferenceExpression;
import com.goide.psi.GoTypeSpec;
import com.goide.psi.impl.GoCType;
import com.goide.psi.impl.GoElementFactory;
import com.goide.psi.impl.GoLightType;
import com.goide.psi.impl.GoPsiImplUtil;
import com.goide.psi.impl.generics.GoSubstitution;
import com.goide.psi.impl.generics.GoTypeArgument;
import com.goide.psi.presentation.GoPsiPresentationFunction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.Function;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GoPsiPresentationBuilder {
    public static final String INDENT = StringUtil.repeat((String)" ", (int)4);
    private static final String INDENT_HTML = INDENT.replaceAll(" ", "&nbsp;");
    private static final Logger LOG = Logger.getInstance(GoPsiPresentationBuilder.class);
    @NotNull
    private Function<? super PsiElement, String> myPresentationFunction = PsiElement::getText;
    private boolean myResolveAllowed = true;
    private boolean myMultiline = true;
    private boolean myStructureAndInterfaceContent = true;
    private boolean myWithoutParameterNames;
    private boolean myHtml;
    private int myIndent = 0;

    public static GoPsiPresentationBuilder create() {
        return new GoPsiPresentationBuilder();
    }

    public GoPsiPresentationBuilder withPresentationFunction(@NotNull GoPsiPresentationFunction presentationFunction) {
        if (presentationFunction == null) {
            GoPsiPresentationBuilder.$$$reportNull$$$0(0);
        }
        this.myPresentationFunction = presentationFunction;
        return this;
    }

    public GoPsiPresentationBuilder withoutResolve() {
        this.myResolveAllowed = false;
        return this;
    }

    public GoPsiPresentationBuilder withoutStructureAndInterfaceContent() {
        this.myStructureAndInterfaceContent = false;
        return this;
    }

    public GoPsiPresentationBuilder withoutParameterNames() {
        this.myWithoutParameterNames = true;
        return this;
    }

    public GoPsiPresentationBuilder oneline() {
        this.myMultiline = false;
        return this;
    }

    public GoPsiPresentationBuilder withMultiline(boolean multiline) {
        this.myMultiline = multiline;
        return this;
    }

    public GoPsiPresentationBuilder html() {
        this.myHtml = true;
        return this;
    }

    @NotNull
    @NlsSafe
    public String build(@Nullable GoType type2) {
        if (type2 == null) {
            return "";
        }
        if (type2 instanceof GoSpecType) {
            String string = (String)this.myPresentationFunction.fun((Object)type2);
            if (string == null) {
                GoPsiPresentationBuilder.$$$reportNull$$$0(1);
            }
            return string;
        }
        if (type2 instanceof GoFunctionType) {
            String string = this.build((GoSignatureOwner)((Object)type2), true);
            if (string == null) {
                GoPsiPresentationBuilder.$$$reportNull$$$0(2);
            }
            return string;
        }
        if (type2 instanceof GoLightType.LightUntypedType) {
            String string = this.build(((GoLightType.LightUntypedType)type2).getDefaultType());
            if (string == null) {
                GoPsiPresentationBuilder.$$$reportNull$$$0(3);
            }
            return string;
        }
        if (type2 instanceof GoLightType.LightVoidType) {
            return "void type";
        }
        if (type2 instanceof GoMapType) {
            GoType keyType = ((GoMapType)type2).getKeyType();
            GoType valueType = ((GoMapType)type2).getValueType();
            String string = "map[" + this.build(keyType) + "]" + this.build(valueType);
            if (string == null) {
                GoPsiPresentationBuilder.$$$reportNull$$$0(4);
            }
            return string;
        }
        if (type2 instanceof GoChannelType) {
            StringBuilder result = new StringBuilder();
            switch (((GoChannelType)type2).getDirection()) {
                case SEND: {
                    result.append(this.myHtml ? "chan&lt;- " : "chan<- ");
                    break;
                }
                case RECEIVE: {
                    result.append(this.myHtml ? "&lt;-chan " : "<-chan ");
                    break;
                }
                case BIDIRECTIONAL: {
                    result.append("chan ");
                }
            }
            String string = result.append(this.build(((GoChannelType)type2).getType())).toString();
            if (string == null) {
                GoPsiPresentationBuilder.$$$reportNull$$$0(5);
            }
            return string;
        }
        if (type2 instanceof GoParType) {
            String string = "(" + this.build(((GoParType)type2).getType()) + ")";
            if (string == null) {
                GoPsiPresentationBuilder.$$$reportNull$$$0(6);
            }
            return string;
        }
        if (type2 instanceof GoArrayOrSliceType) {
            GoArrayOrSliceType arrayOrSliceType = (GoArrayOrSliceType)type2;
            int length = arrayOrSliceType.getLength();
            String lengthString = length >= 0 ? String.valueOf(length) : "";
            String string = "[" + lengthString + "]" + this.build(arrayOrSliceType.getType());
            if (string == null) {
                GoPsiPresentationBuilder.$$$reportNull$$$0(7);
            }
            return string;
        }
        if (type2 instanceof GoPointerType) {
            GoType inner = ((GoPointerType)type2).getType();
            String string = "*" + this.build(inner);
            if (string == null) {
                GoPsiPresentationBuilder.$$$reportNull$$$0(8);
            }
            return string;
        }
        if (type2 instanceof GoTypeList) {
            List<GoType> typeList = ((GoTypeList)type2).getTypeList();
            String string = "(" + StringUtil.join(typeList, this::build, (String)", ") + ")";
            if (string == null) {
                GoPsiPresentationBuilder.$$$reportNull$$$0(9);
            }
            return string;
        }
        if (type2 instanceof GoInterfaceType) {
            return this.build((GoInterfaceType)type2);
        }
        if (type2 instanceof GoCType) {
            return "C";
        }
        if (type2 instanceof GoLightType) {
            LOG.error("Cannot build presentable text for type: " + type2.getClass().getSimpleName() + " - " + type2.getPresentationText());
            return "";
        }
        if (type2 instanceof GoStructType) {
            return this.build((GoStructType)type2);
        }
        if (type2 instanceof GoTypeParameter) {
            String string = this.build((GoTypeParameter)type2);
            if (string == null) {
                GoPsiPresentationBuilder.$$$reportNull$$$0(10);
            }
            return string;
        }
        if (this.myResolveAllowed) {
            PsiElement result;
            GoTypeReferenceExpression typeRef = GoPsiImplUtil.findTypeReference(type2);
            PsiElement psiElement = result = typeRef != null ? typeRef.resolve() : null;
            if (result instanceof GoTypeSpec) {
                String typePresentation = this.build(((GoTypeSpec)result).getSpecType());
                String string = typePresentation + this.build(type2.getTypeArguments());
                if (string == null) {
                    GoPsiPresentationBuilder.$$$reportNull$$$0(11);
                }
                return string;
            }
            if (result instanceof GoTypeParamDefinition) {
                String string = this.build(((GoTypeParamDefinition)result).getTypeParameter());
                if (string == null) {
                    GoPsiPresentationBuilder.$$$reportNull$$$0(12);
                }
                return string;
            }
        }
        String string = (String)this.myPresentationFunction.fun((Object)type2);
        if (string == null) {
            GoPsiPresentationBuilder.$$$reportNull$$$0(13);
        }
        return string;
    }

    @NotNull
    private String build(@NotNull GoInterfaceType type2) {
        if (type2 == null) {
            GoPsiPresentationBuilder.$$$reportNull$$$0(14);
        }
        if (type2 instanceof GoLightType.LightSingleConstraintElemInterfaceType) {
            String string = "interface{ " + this.build((GoConstraintElem)ContainerUtil.getOnlyItem(type2.getConstraintElemList())) + " }";
            if (string == null) {
                GoPsiPresentationBuilder.$$$reportNull$$$0(15);
            }
            return string;
        }
        List<GoConstraintElem> constraints = type2.getConstraintElemList();
        List<GoMethodSpec> methods = type2.getMethodSpecList();
        if (constraints.isEmpty() && methods.isEmpty()) {
            return "interface{}";
        }
        if (!this.myStructureAndInterfaceContent) {
            return "interface {...}";
        }
        StringBuilder result = new StringBuilder("interface " + (this.myMultiline ? "{\n" : "{"));
        this.runWithIncreasedIndent(() -> {
            StringUtil.join((Iterable)constraints, constraint -> this.getIndent() + this.build((GoConstraintElem)constraint), (String)this.getItemDelimiter(), (StringBuilder)result);
            if (!constraints.isEmpty() && !methods.isEmpty()) {
                result.append(this.getItemDelimiter());
            }
            result.append(StringUtil.join((Collection)methods, spec -> {
                GoType expressionType;
                GoTypeReferenceExpression embeddedType = spec.getTypeReferenceExpression();
                if (embeddedType == null) {
                    return this.getIndent() + this.build((GoSignatureOwner)spec, false, true);
                }
                if (this.myResolveAllowed && (expressionType = embeddedType.resolveType(null)) != null) {
                    return this.getIndent() + this.build(expressionType);
                }
                return this.getIndent() + (String)this.myPresentationFunction.fun((Object)embeddedType);
            }, (String)this.getItemDelimiter()));
        });
        String string = result.append(this.myMultiline ? "\n}" : "}").toString();
        if (string == null) {
            GoPsiPresentationBuilder.$$$reportNull$$$0(16);
        }
        return string;
    }

    @NotNull
    private String build(@NotNull GoStructType type2) {
        List<GoFieldDeclaration> fields;
        if (type2 == null) {
            GoPsiPresentationBuilder.$$$reportNull$$$0(17);
        }
        if ((fields = type2.getFieldDeclarationList()).isEmpty()) {
            return "struct{}";
        }
        if (!this.myStructureAndInterfaceContent) {
            return "struct {...}";
        }
        Pair<List<String>, List<String>> spaces = this.getTypeAndTagSpaces(type2);
        StringBuilder result = new StringBuilder("struct " + (this.myMultiline ? "{\n" : "{"));
        this.runWithIncreasedIndent(() -> {
            for (int i = 0; i < fields.size(); ++i) {
                GoFieldDeclaration declaration = (GoFieldDeclaration)fields.get(i);
                String typeSpace = (String)((List)spaces.first).get(i);
                String tagSpace = (String)((List)spaces.second).get(i);
                GoAnonymousFieldDefinition anon = declaration.getAnonymousFieldDefinition();
                String typePresentation = this.build(declaration.getType());
                String fieldString = anon != null ? this.build(anon.getGoType(null)) : StringUtil.join(declaration.getFieldDefinitionList(), this.myPresentationFunction, (String)", ") + typeSpace + typePresentation;
                String tag = declaration.getTagText();
                Object tagMarkup = this.myHtml ? tagSpace + GoDocumentationProvider.calcTagMarkup(type2.getProject(), tag) : (StringUtil.isEmpty((String)tag) ? "" : tagSpace + tag);
                this.appendField(fieldString + (String)tagMarkup, result);
            }
        });
        if (!this.myHtml && !this.myMultiline) {
            result.deleteCharAt(result.length() - 1);
        }
        if (this.myMultiline) {
            result.append(this.getIndent());
        }
        result.append("}");
        String string = result.toString();
        if (string == null) {
            GoPsiPresentationBuilder.$$$reportNull$$$0(18);
        }
        return string;
    }

    private void appendField(@NotNull String fieldLine, @NotNull StringBuilder target) {
        if (fieldLine == null) {
            GoPsiPresentationBuilder.$$$reportNull$$$0(19);
        }
        if (target == null) {
            GoPsiPresentationBuilder.$$$reportNull$$$0(20);
        }
        if (this.myMultiline) {
            target.append(this.getIndent());
        }
        target.append(fieldLine);
        target.append(this.getItemDelimiter());
    }

    @NotNull
    private String getItemDelimiter() {
        return this.myMultiline ? "\n" : ";";
    }

    private void runWithIncreasedIndent(@NotNull Runnable r) {
        if (r == null) {
            GoPsiPresentationBuilder.$$$reportNull$$$0(21);
        }
        try {
            ++this.myIndent;
            r.run();
        }
        finally {
            --this.myIndent;
        }
    }

    @NotNull
    private String getIndent() {
        String string = StringUtil.repeat((String)(this.myHtml ? INDENT_HTML : INDENT), (int)this.myIndent);
        if (string == null) {
            GoPsiPresentationBuilder.$$$reportNull$$$0(22);
        }
        return string;
    }

    @NotNull
    private Pair<List<String>, List<String>> getTypeAndTagSpaces(@NotNull GoStructType type2) {
        if (type2 == null) {
            GoPsiPresentationBuilder.$$$reportNull$$$0(23);
        }
        ArrayList<String> typeSpaces = new ArrayList<String>();
        ArrayList<String> tagSpaces = new ArrayList<String>();
        for (GoFieldDeclaration declaration : this.getFormattedFields(type2)) {
            typeSpaces.add(GoPsiPresentationBuilder.getSpacesBefore(declaration.getType()));
            tagSpaces.add(GoPsiPresentationBuilder.getSpacesBefore(declaration.getTag()));
        }
        Pair pair = Pair.create(typeSpaces, tagSpaces);
        if (pair == null) {
            GoPsiPresentationBuilder.$$$reportNull$$$0(24);
        }
        return pair;
    }

    @NotNull
    private List<GoFieldDeclaration> getFormattedFields(@NotNull GoStructType type2) {
        if (type2 == null) {
            GoPsiPresentationBuilder.$$$reportNull$$$0(25);
        }
        if (!this.myMultiline) {
            List<GoFieldDeclaration> list = type2.getFieldDeclarationList();
            if (list == null) {
                GoPsiPresentationBuilder.$$$reportNull$$$0(26);
            }
            return list;
        }
        GoType goType = GoElementFactory.createTypeCheap(type2.getProject(), GoPsiPresentationBuilder.getTypeTextWithoutComments(type2));
        GoStructType typeCopy = (GoStructType)ObjectUtils.tryCast((Object)goType, GoStructType.class);
        if (typeCopy == null) {
            List<GoFieldDeclaration> list = type2.getFieldDeclarationList();
            if (list == null) {
                GoPsiPresentationBuilder.$$$reportNull$$$0(27);
            }
            return list;
        }
        CodeStyleManager.getInstance((Project)type2.getProject()).reformat((PsiElement)typeCopy);
        List<GoFieldDeclaration> list = typeCopy.getFieldDeclarationList();
        if (list == null) {
            GoPsiPresentationBuilder.$$$reportNull$$$0(28);
        }
        return list;
    }

    @NotNull
    private static String getTypeTextWithoutComments(@NotNull GoStructType type2) {
        if (type2 == null) {
            GoPsiPresentationBuilder.$$$reportNull$$$0(29);
        }
        StringBuilder result = new StringBuilder();
        result.append("struct {");
        for (GoFieldDeclaration declaration : type2.getFieldDeclarationList()) {
            result.append(declaration.getText()).append("\n");
        }
        result.append("}");
        String string = result.toString();
        if (string == null) {
            GoPsiPresentationBuilder.$$$reportNull$$$0(30);
        }
        return string;
    }

    @NotNull
    private static String getSpacesBefore(@Nullable PsiElement element) {
        if (element == null) {
            return "";
        }
        PsiElement prevSibling = element.getPrevSibling();
        return prevSibling instanceof PsiWhiteSpace ? element.getPrevSibling().getText() : " ";
    }

    @NotNull
    public String build(@NotNull GoSignatureOwner signatureOwner, boolean showCompleteSignature) {
        if (signatureOwner == null) {
            GoPsiPresentationBuilder.$$$reportNull$$$0(31);
        }
        String string = this.build(signatureOwner, showCompleteSignature, false);
        if (string == null) {
            GoPsiPresentationBuilder.$$$reportNull$$$0(32);
        }
        return string;
    }

    @NotNull
    public String build(@NotNull GoSignatureOwner signatureOwner, boolean showCompleteSignature, boolean applyPresentationFunctionToName) {
        if (signatureOwner == null) {
            GoPsiPresentationBuilder.$$$reportNull$$$0(33);
        }
        String name = signatureOwner instanceof GoNamedSignatureOwner ? ((GoNamedSignatureOwner)signatureOwner).getName() : null;
        GoSignature signature = signatureOwner.getSignature();
        if (name == null && signature == null) {
            return "";
        }
        StringBuilder builder = new StringBuilder();
        if (showCompleteSignature) {
            String presentation;
            builder.append("func");
            String receiverText = this.getReceiverText(signatureOwner);
            if (StringUtil.isNotEmpty((String)receiverText)) {
                builder.append(' ').append(receiverText);
            }
            String string = presentation = applyPresentationFunctionToName ? (String)this.myPresentationFunction.fun((Object)signatureOwner) : name;
            if (StringUtil.isNotEmpty((String)presentation)) {
                builder.append(' ').append(presentation);
            }
        } else if (signatureOwner instanceof GoFunctionLit) {
            builder.append("func");
        } else {
            builder.append(StringUtil.notNullize((String)(applyPresentationFunctionToName ? (String)this.myPresentationFunction.fun((Object)signatureOwner) : name)));
        }
        builder.append(this.build(signature != null ? signature.getTypeParameters() : null));
        builder.append('(');
        if (signature != null) {
            builder.append(this.build(signature.getParameters()));
        }
        builder.append(')');
        String returnType = this.build(signature != null ? signature.getResult() : null);
        if (!returnType.isEmpty()) {
            builder.append(" ").append(returnType);
        }
        String string = builder.toString();
        if (string == null) {
            GoPsiPresentationBuilder.$$$reportNull$$$0(34);
        }
        return string;
    }

    @NotNull
    public String build(@Nullable GoResult result) {
        GoType type2;
        GoParameters parameters = result != null ? result.getParameters() : null;
        GoType goType = type2 = result != null ? result.getType() : null;
        if (parameters != null) {
            String signatureParameters = this.build(parameters);
            if (!signatureParameters.isEmpty()) {
                String string = "(" + signatureParameters + ")";
                if (string == null) {
                    GoPsiPresentationBuilder.$$$reportNull$$$0(35);
                }
                return string;
            }
        } else if (type2 != null) {
            String string = this.build(type2);
            if (string == null) {
                GoPsiPresentationBuilder.$$$reportNull$$$0(36);
            }
            return string;
        }
        return "";
    }

    @NotNull
    public String build(@NotNull GoParameters parameters) {
        if (parameters == null) {
            GoPsiPresentationBuilder.$$$reportNull$$$0(37);
        }
        String string = StringUtil.join(GoParameterInfoHandler.getParameterPresentations(parameters, (Function<? super GoType, String>)((Function)this::build), this.myWithoutParameterNames), (String)", ");
        if (string == null) {
            GoPsiPresentationBuilder.$$$reportNull$$$0(38);
        }
        return string;
    }

    @NotNull
    public String build(@Nullable GoTypeParameters typeParameters) {
        if (typeParameters == null) {
            return "";
        }
        List<String> presentations = GoTypeArgumentsParameterInfoHandler.getTypeParameterPresentations(typeParameters, (Function<? super GoType, String>)((Function)this::build), this.myWithoutParameterNames);
        Object object = presentations.isEmpty() ? "" : "[" + StringUtil.join(presentations, (String)", ") + "]";
        if (object == null) {
            GoPsiPresentationBuilder.$$$reportNull$$$0(39);
        }
        return object;
    }

    @NotNull
    public String build(@Nullable GoTypeParameter typeParam) {
        GoTypeParamDefinition definition = typeParam != null ? typeParam.getTypeParamDefinition() : null;
        String string = StringUtil.notNullize((String)(definition != null ? definition.getName() : null));
        if (string == null) {
            GoPsiPresentationBuilder.$$$reportNull$$$0(40);
        }
        return string;
    }

    @NotNull
    private String build(@Nullable GoTypeArguments typeArguments) {
        if (typeArguments == null) {
            return "";
        }
        List typePresentations = ContainerUtil.map(typeArguments.getTypes(), it -> this.build((GoType)it));
        Object object = typePresentations.isEmpty() ? "" : "[" + StringUtil.join((Collection)typePresentations, (String)", ") + "]";
        if (object == null) {
            GoPsiPresentationBuilder.$$$reportNull$$$0(41);
        }
        return object;
    }

    private String build(@Nullable GoConstraintElem constraintElem) {
        if (constraintElem == null) {
            return "";
        }
        return StringUtil.join(constraintElem.getConstraintTermList(), term -> this.build((GoConstraintTerm)term), (String)" | ");
    }

    @NotNull
    private String build(@NotNull GoConstraintTerm term) {
        if (term == null) {
            GoPsiPresentationBuilder.$$$reportNull$$$0(42);
        }
        String string = (term.hasTilde() ? "~" : "") + this.build(term.getType());
        if (string == null) {
            GoPsiPresentationBuilder.$$$reportNull$$$0(43);
        }
        return string;
    }

    @NotNull
    public String build(@NotNull GoSubstitution substitution) {
        if (substitution == null) {
            GoPsiPresentationBuilder.$$$reportNull$$$0(44);
        }
        Map<GoTypeParamDefinition, GoTypeArgument> substitutionParameters = substitution.getParams();
        String string = substitutionParameters.entrySet().stream().map(entry -> {
            String typeParameterString = this.build(((GoTypeParamDefinition)entry.getKey()).getTypeParameter());
            String typeArgumentString = this.build(((GoTypeArgument)entry.getValue()).getType());
            return typeParameterString + " \u2192 " + typeArgumentString;
        }).collect(Collectors.joining("\n"));
        if (string == null) {
            GoPsiPresentationBuilder.$$$reportNull$$$0(45);
        }
        return string;
    }

    @NotNull
    private String getReceiverText(@NotNull GoSignatureOwner signatureOwner) {
        GoType receiverType;
        GoSpecType parent;
        if (signatureOwner == null) {
            GoPsiPresentationBuilder.$$$reportNull$$$0(46);
        }
        if (signatureOwner instanceof GoMethodSpec && (parent = (GoSpecType)PsiTreeUtil.getStubOrPsiParentOfType((PsiElement)signatureOwner, GoSpecType.class)) != null) {
            String string = "(" + this.build(parent) + ")";
            if (string == null) {
                GoPsiPresentationBuilder.$$$reportNull$$$0(47);
            }
            return string;
        }
        if (signatureOwner instanceof GoMethodDeclaration && (receiverType = ((GoMethodDeclaration)signatureOwner).getReceiverType()) != null) {
            GoReceiver receiver = ((GoMethodDeclaration)signatureOwner).getReceiver();
            String receiverName = receiver != null ? receiver.getName() : null;
            String string = "(" + (String)(StringUtil.isNotEmpty((String)receiverName) ? receiverName + " " : "") + this.build(receiverType) + ")";
            if (string == null) {
                GoPsiPresentationBuilder.$$$reportNull$$$0(48);
            }
            return string;
        }
        return "";
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 15, 16, 18, 22, 24, 26, 27, 28, 30, 32, 34, 35, 36, 38, 39, 40, 41, 43, 45, 47, 48 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "presentationFunction";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 15: 
            case 16: 
            case 18: 
            case 22: 
            case 24: 
            case 26: 
            case 27: 
            case 28: 
            case 30: 
            case 32: 
            case 34: 
            case 35: 
            case 36: 
            case 38: 
            case 39: 
            case 40: 
            case 41: 
            case 43: 
            case 45: 
            case 47: 
            case 48: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/goide/psi/presentation/GoPsiPresentationBuilder";
                break;
            }
            case 14: 
            case 17: 
            case 23: 
            case 25: 
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fieldLine";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "target";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "r";
                break;
            }
            case 31: 
            case 33: 
            case 46: {
                objectArray2 = objectArray3;
                objectArray3[0] = "signatureOwner";
                break;
            }
            case 37: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parameters";
                break;
            }
            case 42: {
                objectArray2 = objectArray3;
                objectArray3[0] = "term";
                break;
            }
            case 44: {
                objectArray2 = objectArray3;
                objectArray3[0] = "substitution";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/goide/psi/presentation/GoPsiPresentationBuilder";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 15: 
            case 16: 
            case 18: 
            case 32: 
            case 34: 
            case 35: 
            case 36: 
            case 38: 
            case 39: 
            case 40: 
            case 41: 
            case 43: 
            case 45: {
                objectArray = objectArray2;
                objectArray2[1] = "build";
                break;
            }
            case 22: {
                objectArray = objectArray2;
                objectArray2[1] = "getIndent";
                break;
            }
            case 24: {
                objectArray = objectArray2;
                objectArray2[1] = "getTypeAndTagSpaces";
                break;
            }
            case 26: 
            case 27: 
            case 28: {
                objectArray = objectArray2;
                objectArray2[1] = "getFormattedFields";
                break;
            }
            case 30: {
                objectArray = objectArray2;
                objectArray2[1] = "getTypeTextWithoutComments";
                break;
            }
            case 47: 
            case 48: {
                objectArray = objectArray2;
                objectArray2[1] = "getReceiverText";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "withPresentationFunction";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 15: 
            case 16: 
            case 18: 
            case 22: 
            case 24: 
            case 26: 
            case 27: 
            case 28: 
            case 30: 
            case 32: 
            case 34: 
            case 35: 
            case 36: 
            case 38: 
            case 39: 
            case 40: 
            case 41: 
            case 43: 
            case 45: 
            case 47: 
            case 48: {
                break;
            }
            case 14: 
            case 17: 
            case 31: 
            case 33: 
            case 37: 
            case 42: 
            case 44: {
                objectArray = objectArray;
                objectArray[2] = "build";
                break;
            }
            case 19: 
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "appendField";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "runWithIncreasedIndent";
                break;
            }
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "getTypeAndTagSpaces";
                break;
            }
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "getFormattedFields";
                break;
            }
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "getTypeTextWithoutComments";
                break;
            }
            case 46: {
                objectArray = objectArray;
                objectArray[2] = "getReceiverText";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 15, 16, 18, 22, 24, 26, 27, 28, 30, 32, 34, 35, 36, 38, 39, 40, 41, 43, 45, 47, 48 -> new IllegalStateException(string);
        };
    }
}

