/*
 * Decompiled with CFR 0.152.
 */
package com.goide.psi.impl.imports;

import com.goide.codeInsight.imports.GoGetPackageFix;
import com.goide.i18n.GoBundle;
import com.goide.psi.impl.GoPackage;
import com.goide.psi.impl.GoPsiImplUtil;
import com.goide.psi.impl.imports.GoImportPathUtil;
import com.goide.psi.impl.imports.GoImportReference;
import com.goide.psi.impl.imports.GoImportReferenceSet;
import com.goide.psi.impl.imports.GoImportResolver;
import com.goide.sdk.GoSdkService;
import com.goide.sdk.GoSdkUtil;
import com.goide.util.GoGetPackageUtil;
import com.goide.util.GoUtil;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.ModificationTracker;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementResolveResult;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileSystemItem;
import com.intellij.psi.PsiManager;
import com.intellij.psi.ResolveResult;
import com.intellij.psi.ResolveState;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.FileReferenceSet;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.util.ObjectUtils;
import com.intellij.util.ThreeState;
import com.intellij.util.containers.CollectionFactory;
import com.intellij.util.containers.ConcurrentFactoryMap;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.ConcurrentMap;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class DefaultGoImportResolver
implements GoImportResolver {
    private static final Logger LOG = Logger.getInstance(DefaultGoImportResolver.class);

    @Override
    @Nullable
    public Collection<GoPackage> resolve(@NotNull String importPath, @NotNull Project project, @Nullable Module contextModule, @Nullable ResolveState resolveState) {
        PsiFile file;
        Module module;
        if (importPath == null) {
            DefaultGoImportResolver.$$$reportNull$$$0(0);
        }
        if (project == null) {
            DefaultGoImportResolver.$$$reportNull$$$0(1);
        }
        PsiElement currentElement = GoPsiImplUtil.getCurrentElement(resolveState);
        PsiElement contextElement = GoPsiImplUtil.getContextElement(resolveState);
        if (currentElement != null) {
            module = GoUtil.module(currentElement);
            file = currentElement.getContainingFile();
        } else {
            module = contextModule;
            file = contextElement != null ? contextElement.getContainingFile() : null;
        }
        UserDataHolder cacheHolder = (UserDataHolder)ObjectUtils.notNull((Object)file, (Object)((UserDataHolder)ObjectUtils.notNull((Object)module, (Object)project)));
        if (file != null && module != null && GoUtil.module((PsiElement)file) != module) {
            LOG.error("Resolve is requested with a file and unrelated module");
            return DefaultGoImportResolver.innerResolve(importPath, project, module, (PsiElement)file);
        }
        ConcurrentMap cachedMap = module != null ? (ConcurrentMap)CachedValuesManager.getManager((Project)project).getCachedValue(cacheHolder, () -> DefaultGoImportResolver.createResolveMap(project, cacheHolder)) : (ConcurrentMap)CachedValuesManager.getManager((Project)project).getCachedValue(cacheHolder, () -> DefaultGoImportResolver.createResolveMap(project, null, file));
        return cachedMap != null ? (Collection)cachedMap.get(importPath) : null;
    }

    @Nullable
    private static CachedValueProvider.Result<ConcurrentMap<String, Collection<GoPackage>>> createResolveMap(@NotNull Project project, @NotNull UserDataHolder cacheHolder) {
        if (project == null) {
            DefaultGoImportResolver.$$$reportNull$$$0(2);
        }
        if (cacheHolder == null) {
            DefaultGoImportResolver.$$$reportNull$$$0(3);
        }
        PsiFile file = cacheHolder instanceof PsiFile ? (PsiFile)cacheHolder : null;
        Module module = file != null ? GoUtil.module((PsiElement)file) : (Module)ObjectUtils.tryCast((Object)cacheHolder, Module.class);
        return DefaultGoImportResolver.createResolveMap(project, module, file);
    }

    @Nullable
    private static CachedValueProvider.Result<ConcurrentMap<String, Collection<GoPackage>>> createResolveMap(@NotNull Project project, @Nullable Module module, @Nullable PsiFile file) {
        if (project == null) {
            DefaultGoImportResolver.$$$reportNull$$$0(4);
        }
        if (module != null && module.isDisposed() || project.isDisposed()) {
            return null;
        }
        ConcurrentMap map = ConcurrentFactoryMap.create(s -> DefaultGoImportResolver.innerResolve(s, project, module, (PsiElement)file), () -> CollectionFactory.createConcurrentWeakValueMap());
        ModificationTracker structure = VirtualFileManager.VFS_STRUCTURE_MODIFICATIONS;
        return CachedValueProvider.Result.create((Object)map, GoSdkUtil.getSdkAndLibrariesCacheDependencies(project, module, structure));
    }

    @NotNull
    private static Collection<GoPackage> innerResolve(@NotNull String importPath, @NotNull Project project, @Nullable Module module, @Nullable PsiElement context) {
        List importPathContexts;
        if (importPath == null) {
            DefaultGoImportResolver.$$$reportNull$$$0(5);
        }
        if (project == null) {
            DefaultGoImportResolver.$$$reportNull$$$0(6);
        }
        PsiManager manager = PsiManager.getInstance((Project)project);
        String canonicalImportPath = FileUtil.toCanonicalPath((String)importPath);
        List<GoPackage> packages2 = DefaultGoImportResolver.findPackagesInContexts(canonicalImportPath, importPathContexts = GoImportReferenceSet.getImportPathContexts(importPath, project, module, context).toList(), manager, module);
        if (!packages2.isEmpty()) {
            List<GoPackage> list = packages2;
            if (list == null) {
                DefaultGoImportResolver.$$$reportNull$$$0(7);
            }
            return list;
        }
        TextRange versionElementRange = GoImportPathUtil.findVersionElement(canonicalImportPath);
        if (versionElementRange.isEmpty()) {
            List<GoPackage> list = Collections.emptyList();
            if (list == null) {
                DefaultGoImportResolver.$$$reportNull$$$0(8);
            }
            return list;
        }
        return DefaultGoImportResolver.findVersionedPackage(canonicalImportPath, versionElementRange, importPathContexts, manager, module);
    }

    @NotNull
    private static Collection<GoPackage> findVersionedPackage(@NotNull String canonicalImportPath, @NotNull TextRange versionElementRange, @NotNull List<VirtualFile> importPathContexts, @NotNull PsiManager manager, @Nullable Module module) {
        if (canonicalImportPath == null) {
            DefaultGoImportResolver.$$$reportNull$$$0(9);
        }
        if (versionElementRange == null) {
            DefaultGoImportResolver.$$$reportNull$$$0(10);
        }
        if (importPathContexts == null) {
            DefaultGoImportResolver.$$$reportNull$$$0(11);
        }
        if (manager == null) {
            DefaultGoImportResolver.$$$reportNull$$$0(12);
        }
        String rootPackageImportPath = canonicalImportPath.substring(0, versionElementRange.getStartOffset());
        String rootPackageImportPathWithVersion = canonicalImportPath.substring(0, versionElementRange.getEndOffset());
        String subPackageImportPath = canonicalImportPath.substring(versionElementRange.getEndOffset());
        StreamEx versionedPackageDirectories = (StreamEx)DefaultGoImportResolver.findByRelativePath(rootPackageImportPath, importPathContexts).filter(directory -> DefaultGoImportResolver.isVersionedPackage(rootPackageImportPathWithVersion, directory));
        List<GoPackage> list = DefaultGoImportResolver.findPackagesInContexts(subPackageImportPath, versionedPackageDirectories.toList(), manager, module);
        if (list == null) {
            DefaultGoImportResolver.$$$reportNull$$$0(13);
        }
        return list;
    }

    private static boolean isVersionedPackage(@NotNull String importPathWithVersion, @NotNull VirtualFile packageDirectory) {
        VirtualFile goModFile;
        if (importPathWithVersion == null) {
            DefaultGoImportResolver.$$$reportNull$$$0(14);
        }
        if (packageDirectory == null) {
            DefaultGoImportResolver.$$$reportNull$$$0(15);
        }
        return (goModFile = packageDirectory.findChild("go.mod")) != null && importPathWithVersion.equals(GoUtil.getModuleName(goModFile));
    }

    public static List<GoPackage> findPackagesInContexts(@NotNull String importPath, @NotNull List<VirtualFile> importPathContexts, @NotNull PsiManager manager, @Nullable Module module) {
        if (importPath == null) {
            DefaultGoImportResolver.$$$reportNull$$$0(16);
        }
        if (importPathContexts == null) {
            DefaultGoImportResolver.$$$reportNull$$$0(17);
        }
        if (manager == null) {
            DefaultGoImportResolver.$$$reportNull$$$0(18);
        }
        return ((StreamEx)((StreamEx)DefaultGoImportResolver.findByRelativePath(importPath, importPathContexts).filter(f -> GoImportReferenceSet.isImportableDirectory(f, module))).map(arg_0 -> ((PsiManager)manager).findDirectory(arg_0)).nonNull().limit(1L)).flatCollection(dir -> GoPackage.in(dir, module)).toList();
    }

    @NotNull
    private static StreamEx<VirtualFile> findByRelativePath(@NotNull String path, @NotNull List<VirtualFile> roots) {
        if (path == null) {
            DefaultGoImportResolver.$$$reportNull$$$0(19);
        }
        if (roots == null) {
            DefaultGoImportResolver.$$$reportNull$$$0(20);
        }
        StreamEx streamEx = StreamEx.of(roots).map(context -> context.findFileByRelativePath(path)).nonNull();
        if (streamEx == null) {
            DefaultGoImportResolver.$$$reportNull$$$0(21);
        }
        return streamEx;
    }

    @Override
    public ResolveResult[] resolve(@NotNull GoImportReference reference) {
        if (reference == null) {
            DefaultGoImportResolver.$$$reportNull$$$0(22);
        }
        String partText = reference.getCanonicalText();
        if (reference.isFirst()) {
            PsiDirectory directory = reference.getElement().getContainingFile().getOriginalFile().getParent();
            if (".".equals(partText)) {
                ResolveResult[] resolveResultArray;
                if (directory != null) {
                    PsiElementResolveResult[] psiElementResolveResultArray = new PsiElementResolveResult[1];
                    resolveResultArray = psiElementResolveResultArray;
                    psiElementResolveResultArray[0] = new PsiElementResolveResult((PsiElement)directory);
                } else {
                    resolveResultArray = ResolveResult.EMPTY_ARRAY;
                }
                return resolveResultArray;
            }
            if ("..".equals(partText)) {
                ResolveResult[] resolveResultArray;
                PsiDirectory grandParent;
                PsiDirectory psiDirectory = grandParent = directory != null ? directory.getParentDirectory() : null;
                if (grandParent != null) {
                    PsiElementResolveResult[] psiElementResolveResultArray = new PsiElementResolveResult[1];
                    resolveResultArray = psiElementResolveResultArray;
                    psiElementResolveResultArray[0] = new PsiElementResolveResult((PsiElement)grandParent);
                } else {
                    resolveResultArray = ResolveResult.EMPTY_ARRAY;
                }
                return resolveResultArray;
            }
        } else if (GoImportPathUtil.isVersionElement(partText)) {
            VirtualFile contextDirectory;
            FileReferenceSet referenceSet = reference.getFileReferenceSet();
            int startOffset = referenceSet.getReference(0).getRangeInElement().getStartOffset();
            int endOffset = reference.getRangeInElement().getEndOffset();
            String importPathWithVersion = referenceSet.getElement().getText().substring(startOffset, endOffset);
            PsiFileSystemItem context = referenceSet.getReference(reference.getIndex() - 1).resolve();
            VirtualFile virtualFile = contextDirectory = context != null ? context.getVirtualFile() : null;
            if (contextDirectory != null && contextDirectory.findChild(partText) == null && DefaultGoImportResolver.isVersionedPackage(importPathWithVersion, contextDirectory)) {
                return new PsiElementResolveResult[]{new PsiElementResolveResult((PsiElement)context)};
            }
        }
        return null;
    }

    @Override
    @NotNull
    public ThreeState supportsCanonicalImportPath(@NotNull Project project, @Nullable Module module) {
        if (project == null) {
            DefaultGoImportResolver.$$$reportNull$$$0(23);
        }
        ThreeState threeState = ThreeState.fromBoolean((boolean)GoSdkService.getInstance(project).getSdk(module).supportsCanonicalPaths());
        if (threeState == null) {
            DefaultGoImportResolver.$$$reportNull$$$0(24);
        }
        return threeState;
    }

    @Override
    @NotNull
    public ThreeState supportsRelativeImportPaths(@NotNull Project project, @Nullable Module module) {
        if (project == null) {
            DefaultGoImportResolver.$$$reportNull$$$0(25);
        }
        ThreeState threeState = ThreeState.YES;
        if (threeState == null) {
            DefaultGoImportResolver.$$$reportNull$$$0(26);
        }
        return threeState;
    }

    @Override
    public @Nullable List<@NotNull LocalQuickFix> getUnresolvedQuickFixes(@NotNull GoImportReference reference) {
        if (reference == null) {
            DefaultGoImportResolver.$$$reportNull$$$0(27);
        }
        return Collections.singletonList(new GoGetPackageFix(reference.getFileReferenceSet().getPathString()));
    }

    @Override
    @Nullable
    public List<NotificationAction> getInstallPackageActions(@NotNull String importPath, @NotNull Project project, @NotNull Notification notification) {
        if (importPath == null) {
            DefaultGoImportResolver.$$$reportNull$$$0(28);
        }
        if (project == null) {
            DefaultGoImportResolver.$$$reportNull$$$0(29);
        }
        if (notification == null) {
            DefaultGoImportResolver.$$$reportNull$$$0(30);
        }
        return Collections.singletonList(NotificationAction.createSimple((String)GoBundle.message((String)"go.notification.add.to.gopath.action.text", (Object[])new Object[0]), () -> {
            notification.expire();
            GoGetPackageUtil.goGetPackage(project, null, null, importPath);
        }));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 7, 8, 13, 21, 24, 26 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "importPath";
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 6: 
            case 23: 
            case 25: 
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "cacheHolder";
                break;
            }
            case 7: 
            case 8: 
            case 13: 
            case 21: 
            case 24: 
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/goide/psi/impl/imports/DefaultGoImportResolver";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "canonicalImportPath";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "versionElementRange";
                break;
            }
            case 11: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "importPathContexts";
                break;
            }
            case 12: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "manager";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "importPathWithVersion";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "packageDirectory";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "roots";
                break;
            }
            case 22: 
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "reference";
                break;
            }
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "notification";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/goide/psi/impl/imports/DefaultGoImportResolver";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "innerResolve";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "findVersionedPackage";
                break;
            }
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "findByRelativePath";
                break;
            }
            case 24: {
                objectArray = objectArray2;
                objectArray2[1] = "supportsCanonicalImportPath";
                break;
            }
            case 26: {
                objectArray = objectArray2;
                objectArray2[1] = "supportsRelativeImportPaths";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "resolve";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "createResolveMap";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "innerResolve";
                break;
            }
            case 7: 
            case 8: 
            case 13: 
            case 21: 
            case 24: 
            case 26: {
                break;
            }
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "findVersionedPackage";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "isVersionedPackage";
                break;
            }
            case 16: 
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "findPackagesInContexts";
                break;
            }
            case 19: 
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "findByRelativePath";
                break;
            }
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "supportsCanonicalImportPath";
                break;
            }
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "supportsRelativeImportPaths";
                break;
            }
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "getUnresolvedQuickFixes";
                break;
            }
            case 28: 
            case 29: 
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "getInstallPackageActions";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 7, 8, 13, 21, 24, 26 -> new IllegalStateException(string);
        };
    }
}

