/*
 * Decompiled with CFR 0.152.
 */
package com.goide.psi.impl;

import com.goide.GoParserDefinition;
import com.goide.GoTypes;
import com.goide.inspections.GoInspectionUtil;
import com.goide.psi.GoArgumentList;
import com.goide.psi.GoAssignmentStatement;
import com.goide.psi.GoBlock;
import com.goide.psi.GoBuiltinArgumentList;
import com.goide.psi.GoBuiltinCallExpr;
import com.goide.psi.GoCallExpr;
import com.goide.psi.GoCallLikeExpr;
import com.goide.psi.GoCodeFragment;
import com.goide.psi.GoCompositeElement;
import com.goide.psi.GoCompositeLit;
import com.goide.psi.GoCompositeType;
import com.goide.psi.GoConversionExpr;
import com.goide.psi.GoElement;
import com.goide.psi.GoExprSwitchStatement;
import com.goide.psi.GoExpression;
import com.goide.psi.GoFieldDefinition;
import com.goide.psi.GoFile;
import com.goide.psi.GoForClause;
import com.goide.psi.GoForStatement;
import com.goide.psi.GoFunctionDeclaration;
import com.goide.psi.GoFunctionLit;
import com.goide.psi.GoFunctionOrMethodDeclaration;
import com.goide.psi.GoIfStatement;
import com.goide.psi.GoImportList;
import com.goide.psi.GoImportSpec;
import com.goide.psi.GoIndexOrSliceExpr;
import com.goide.psi.GoInterfaceType;
import com.goide.psi.GoKey;
import com.goide.psi.GoLabeledStatement;
import com.goide.psi.GoLiteralValue;
import com.goide.psi.GoMethodSpec;
import com.goide.psi.GoNamedElement;
import com.goide.psi.GoNamedSignatureOwner;
import com.goide.psi.GoPackageClause;
import com.goide.psi.GoParType;
import com.goide.psi.GoParenthesesExpr;
import com.goide.psi.GoQualifier;
import com.goide.psi.GoReferenceExpression;
import com.goide.psi.GoReferenceExpressionBase;
import com.goide.psi.GoResolvable;
import com.goide.psi.GoSelectStatement;
import com.goide.psi.GoSignature;
import com.goide.psi.GoSimpleStatement;
import com.goide.psi.GoSpecType;
import com.goide.psi.GoStatement;
import com.goide.psi.GoSwitchStatement;
import com.goide.psi.GoTopLevelDeclaration;
import com.goide.psi.GoType;
import com.goide.psi.GoTypeAssertionExpr;
import com.goide.psi.GoTypeDeclaration;
import com.goide.psi.GoTypeParamDefinition;
import com.goide.psi.GoTypeParameter;
import com.goide.psi.GoTypeReferenceExpression;
import com.goide.psi.GoTypeSpec;
import com.goide.psi.GoTypeSwitchStatement;
import com.goide.psi.GoUnaryExpr;
import com.goide.psi.GoValue;
import com.goide.psi.GoVarDefinition;
import com.goide.psi.GoVarOrConstDeclaration;
import com.goide.psi.GoVarOrConstDefinition;
import com.goide.psi.GoVarOrConstSpec;
import com.goide.psi.impl.GoCType;
import com.goide.psi.impl.GoElementFactory;
import com.goide.psi.impl.GoElementWithSubst;
import com.goide.psi.impl.GoLightType;
import com.goide.psi.impl.GoPackage;
import com.goide.psi.impl.GoPsiImplUtil;
import com.goide.psi.impl.GoTypeUtil;
import com.goide.psi.impl.generics.GoTypeInstantiationKt;
import com.goide.sdk.GoPackageUtil;
import com.goide.sdk.GoSdkUtil;
import com.goide.sdk.GoSdkVersion;
import com.goide.util.GoCacheUtilKt;
import com.goide.util.GoUtil;
import com.goide.util.Value;
import com.intellij.lang.ASTNode;
import com.intellij.lang.parser.GeneratedParserUtilBase;
import com.intellij.openapi.fileEditor.impl.NonProjectFileWritingAccessProvider;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiErrorElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiRecursiveElementWalkingVisitor;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.ResolveState;
import com.intellij.psi.SyntaxTraverser;
import com.intellij.psi.TokenType;
import com.intellij.psi.impl.source.tree.LeafElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.util.Function;
import com.intellij.util.ObjectUtils;
import com.intellij.util.PairProcessor;
import com.intellij.util.Processor;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.Convertor;
import com.intellij.util.containers.MultiMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class GoPsiUtil {
    public static boolean processDefinitions(@Nullable GoStatement statement, @NotNull Processor<? super GoNamedElement> processor2) {
        if (processor2 == null) {
            GoPsiUtil.$$$reportNull$$$0(0);
        }
        if (statement == null) {
            return true;
        }
        ProgressManager.checkCanceled();
        Processor wrapper = e -> !GoInspectionUtil.isPrimaryDefinition(e) || processor2.process(e);
        if (!GoPsiUtil.processDefinitions(statement.getConstDeclaration(), (Processor<GoNamedElement>)wrapper)) {
            return false;
        }
        if (!GoPsiUtil.processDefinitions(statement.getVarDeclaration(), (Processor<GoNamedElement>)wrapper)) {
            return false;
        }
        if (!GoPsiUtil.processDefinitions(statement.getTypeDeclaration(), (Processor<GoNamedElement>)wrapper)) {
            return false;
        }
        if (statement instanceof GoSimpleStatement) {
            return GoPsiUtil.processDefinitions(((GoSimpleStatement)statement).getShortVarDeclaration(), (Processor<GoNamedElement>)wrapper);
        }
        if (statement instanceof GoLabeledStatement) {
            return GoPsiUtil.processDefinitions(((GoLabeledStatement)statement).getStatement(), (Processor<? super GoNamedElement>)wrapper);
        }
        return true;
    }

    public static boolean processDefinitions(@Nullable GoVarOrConstDeclaration<?> declaration, @NotNull Processor<GoNamedElement> processor2) {
        if (processor2 == null) {
            GoPsiUtil.$$$reportNull$$$0(1);
        }
        if (declaration == null) {
            return true;
        }
        for (GoVarOrConstSpec spec : declaration.getSpecList()) {
            if (GoPsiUtil.processDefinitions(spec, processor2)) continue;
            return false;
        }
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static boolean processDefinitions(@Nullable GoTypeDeclaration typeDeclaration, @NotNull Processor<GoNamedElement> processor2) {
        if (processor2 == null) {
            GoPsiUtil.$$$reportNull$$$0(2);
        }
        if (typeDeclaration == null) return true;
        if (!ContainerUtil.and(typeDeclaration.getTypeSpecList(), arg_0 -> processor2.process(arg_0))) return false;
        return true;
    }

    private static boolean processDefinitions(@Nullable GoVarOrConstSpec<?> spec, @NotNull Processor<GoNamedElement> processor2) {
        if (processor2 == null) {
            GoPsiUtil.$$$reportNull$$$0(3);
        }
        if (spec == null) {
            return true;
        }
        return ContainerUtil.and(spec.getDefinitionList(), arg_0 -> processor2.process(arg_0));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static boolean isBuiltinFunctionCall(@NotNull GoCallExpr callExpr, String ... names) {
        GoExpression unwrapped;
        GoReferenceExpression referenceExpr;
        if (callExpr == null) {
            GoPsiUtil.$$$reportNull$$$0(4);
        }
        if (names == null) {
            GoPsiUtil.$$$reportNull$$$0(5);
        }
        if ((referenceExpr = (GoReferenceExpression)ObjectUtils.tryCast((Object)(unwrapped = callExpr.getExpression().unwrapParentheses()), GoReferenceExpression.class)) == null) return false;
        String string = referenceExpr.getIdentifier().getText();
        String text = string;
        if (text == null) return false;
        if (!ContainerUtil.exists((Object[])names, text::equals)) return false;
        if (!GoPsiImplUtil.builtin(referenceExpr.resolve())) return false;
        return true;
    }

    public static boolean isFlaggedComment(@NotNull String commentText, @NotNull String flag) {
        if (commentText == null) {
            GoPsiUtil.$$$reportNull$$$0(6);
        }
        if (flag == null) {
            GoPsiUtil.$$$reportNull$$$0(7);
        }
        int flagLength = flag.length();
        return commentText.startsWith(flag) && (commentText.length() <= flagLength || StringUtil.isWhiteSpace((char)commentText.charAt(flagLength)));
    }

    public static boolean isFlaggedComment(@Nullable PsiElement o, @NotNull String flag) {
        if (flag == null) {
            GoPsiUtil.$$$reportNull$$$0(8);
        }
        return o instanceof PsiComment && o.getParent() instanceof GoFile && GoPsiUtil.isFlaggedComment(StringUtil.trimStart((String)o.getText(), (String)"//"), flag);
    }

    public static boolean isBuildTagComment(@Nullable PsiElement o) {
        return o instanceof PsiComment && GoPsiUtil.isBuildTagComment(StringUtil.trimStart((String)o.getText(), (String)"//"));
    }

    public static boolean isBuildTagComment(@NotNull String commentText) {
        if (commentText == null) {
            GoPsiUtil.$$$reportNull$$$0(9);
        }
        return GoPsiUtil.isFlaggedComment(StringUtil.trimLeading((String)commentText), "+build");
    }

    public static boolean isGoBuildDirective(@NotNull PsiElement o) {
        if (o == null) {
            GoPsiUtil.$$$reportNull$$$0(10);
        }
        return o instanceof PsiComment && GoPsiUtil.isGoBuildDirective(StringUtil.trimStart((String)o.getText(), (String)"//"));
    }

    public static boolean isGoBuildDirective(@NotNull String commentText) {
        if (commentText == null) {
            GoPsiUtil.$$$reportNull$$$0(11);
        }
        return GoPsiUtil.isFlaggedComment(commentText, "go:build");
    }

    @Nullable
    public static GoCompositeElement getContinueStatementOwner(@NotNull PsiElement o) {
        if (o == null) {
            GoPsiUtil.$$$reportNull$$$0(12);
        }
        return (GoCompositeElement)ObjectUtils.tryCast((Object)PsiTreeUtil.getParentOfType((PsiElement)o, (Class[])new Class[]{GoForStatement.class, GoFunctionLit.class}), GoForStatement.class);
    }

    @Nullable
    public static PsiElement getBreakStatementOwner(@NotNull PsiElement o) {
        GoCompositeElement owner;
        if (o == null) {
            GoPsiUtil.$$$reportNull$$$0(13);
        }
        return (owner = (GoCompositeElement)PsiTreeUtil.getParentOfType((PsiElement)o, (Class[])new Class[]{GoSwitchStatement.class, GoForStatement.class, GoSelectStatement.class, GoFunctionLit.class})) instanceof GoFunctionLit ? null : owner;
    }

    public static boolean isWhiteSpaceOrCommentOrEmpty(@Nullable PsiElement e) {
        ASTNode node = e != null ? e.getNode() : null;
        return GoPsiUtil.isWhiteSpaceOrCommentOrEmptyNode(node);
    }

    private static boolean isWhiteSpaceOrCommentOrEmptyNode(@Nullable ASTNode node) {
        if (node == null) {
            return false;
        }
        IElementType type2 = node.getElementType();
        return GoParserDefinition.Lazy.COMMENTS.contains(type2) || TokenType.WHITE_SPACE == type2 || node.getTextRange().isEmpty();
    }

    @NotNull
    public static Function<PsiElement, String> getTextAndSkipLiterals() {
        Function function = e -> {
            final StringBuffer b = new StringBuffer();
            e.accept((PsiElementVisitor)new PsiRecursiveElementWalkingVisitor(){

                public void visitElement(@NotNull PsiElement o) {
                    if (o == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    if (o instanceof GoLiteralValue || o instanceof GoBlock) {
                        b.append("{}");
                        return;
                    }
                    if (o instanceof PsiComment) {
                        return;
                    }
                    if (o instanceof LeafElement) {
                        b.append(o.getText());
                    }
                    super.visitElement(o);
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "o", "com/goide/psi/impl/GoPsiUtil$1", "visitElement"));
                }
            });
            return b.toString();
        };
        if (function == null) {
            GoPsiUtil.$$$reportNull$$$0(14);
        }
        return function;
    }

    @Contract(value="null -> false")
    public static boolean isIfCondition(@Nullable GoExpression e) {
        GoIfStatement ifStatement = e != null ? GoPsiUtil.getParentIfStatement(e) : null;
        return ifStatement != null && ifStatement.getCondition() == e;
    }

    @Contract(value="null -> false")
    public static boolean isForCondition(@Nullable GoExpression e) {
        GoForStatement forStatement = e != null ? GoPsiUtil.getParentForStatement(e) : null;
        return forStatement != null && forStatement.getExpression() == e;
    }

    @Nullable
    public static GoIfStatement getParentIfStatement(@NotNull PsiElement expr) {
        PsiElement parent;
        if (expr == null) {
            GoPsiUtil.$$$reportNull$$$0(15);
        }
        if ((parent = PsiTreeUtil.getParentOfType((PsiElement)expr, GoStatement.class)) == null) {
            return null;
        }
        return parent instanceof GoIfStatement ? (GoIfStatement)parent : (GoIfStatement)ObjectUtils.tryCast((Object)parent.getParent(), GoIfStatement.class);
    }

    @Nullable
    public static GoForStatement getParentForStatement(@NotNull PsiElement expr) {
        if (expr == null) {
            GoPsiUtil.$$$reportNull$$$0(16);
        }
        PsiElement parent = PsiTreeUtil.getParentOfType((PsiElement)expr, GoStatement.class);
        return (GoForStatement)ObjectUtils.tryCast((Object)parent, GoForStatement.class);
    }

    public static boolean isSimpleStatementFromIfForSwitch(@NotNull GoSimpleStatement statement) {
        PsiElement parent;
        if (statement == null) {
            GoPsiUtil.$$$reportNull$$$0(17);
        }
        if ((parent = statement.getParent()) instanceof GoIfStatement) {
            return ((GoIfStatement)parent).getExpression() != null;
        }
        if (parent instanceof GoForClause) {
            return ((GoForClause)parent).getExpression() != null;
        }
        if (parent instanceof GoExprSwitchStatement) {
            return ((GoExprSwitchStatement)parent).getExpression() != null;
        }
        return parent instanceof GoTypeSwitchStatement;
    }

    @Nullable
    public static <L, R> R getCorrespondingRightExpr(@NotNull L leftExpr, @NotNull List<L> leftExprs, @NotNull List<R> rightExprs) {
        if (leftExpr == null) {
            GoPsiUtil.$$$reportNull$$$0(18);
        }
        if (leftExprs == null) {
            GoPsiUtil.$$$reportNull$$$0(19);
        }
        if (rightExprs == null) {
            GoPsiUtil.$$$reportNull$$$0(20);
        }
        return GoPsiUtil.getByIndex(rightExprs, leftExprs.indexOf(leftExpr));
    }

    @Nullable
    public static <L, R> L getCorrespondingLeftExpr(@NotNull R rightExpr, @NotNull List<R> rightExprs, @NotNull List<L> leftExprs) {
        if (rightExpr == null) {
            GoPsiUtil.$$$reportNull$$$0(21);
        }
        if (rightExprs == null) {
            GoPsiUtil.$$$reportNull$$$0(22);
        }
        if (leftExprs == null) {
            GoPsiUtil.$$$reportNull$$$0(23);
        }
        return GoPsiUtil.getByIndex(leftExprs, rightExprs.indexOf(rightExpr));
    }

    @Nullable
    public static <T> T getByIndex(@NotNull List<T> list, int index) {
        if (list == null) {
            GoPsiUtil.$$$reportNull$$$0(24);
        }
        return 0 <= index && index < list.size() ? (T)list.get(index) : null;
    }

    public static boolean isInsideTypeSwitchAssertion(@NotNull GoTypeReferenceExpression o) {
        PsiElement parent;
        PsiElement grandParent;
        if (o == null) {
            GoPsiUtil.$$$reportNull$$$0(25);
        }
        PsiElement psiElement = grandParent = (parent = o.getParent()) != null ? parent.getParent() : null;
        if (!(parent instanceof GoType) || !(grandParent instanceof GoTypeAssertionExpr)) {
            return false;
        }
        return GoPsiUtil.isInsideTypeSwitchAssertion((GoStatement)PsiTreeUtil.getParentOfType((PsiElement)grandParent, GoStatement.class));
    }

    public static boolean isInsideTypeSwitchAssertion(@Nullable GoStatement statement) {
        if (!(statement instanceof GoSimpleStatement) && !(statement instanceof GoAssignmentStatement)) {
            return false;
        }
        PsiElement nextSibling = PsiTreeUtil.skipWhitespacesAndCommentsForward((PsiElement)statement);
        if (nextSibling != null && nextSibling.getNode().getElementType() == GoTypes.SEMICOLON || GoPsiUtil.hasNewLineAfter(statement)) {
            return false;
        }
        return statement.getParent() instanceof GoExprSwitchStatement;
    }

    @Nullable
    public static GoReferenceExpression getCallReference(@NotNull GoExpression callExpr) {
        if (callExpr == null) {
            GoPsiUtil.$$$reportNull$$$0(26);
        }
        GoExpression calledExpr = null;
        if (callExpr instanceof GoCallExpr) {
            calledExpr = GoPsiImplUtil.unwrapMulOrPar(((GoCallExpr)callExpr).getExpression());
            if (calledExpr instanceof GoIndexOrSliceExpr && GoPsiUtil.isCallOrConversionWithTypeInstantiation((GoIndexOrSliceExpr)calledExpr)) {
                calledExpr = ((GoIndexOrSliceExpr)calledExpr).getExpression();
            }
        } else if (callExpr instanceof GoBuiltinCallExpr) {
            calledExpr = GoPsiImplUtil.unwrapMulOrPar(((GoBuiltinCallExpr)callExpr).getExpression());
        }
        return (GoReferenceExpression)ObjectUtils.tryCast((Object)calledExpr, GoReferenceExpression.class);
    }

    @Contract(value="null -> false")
    public static boolean isConversionExpression(@Nullable GoExpression expr) {
        return expr instanceof GoConversionExpr || expr != null && GoPsiUtil.getTypeFromCallLikeConversion(expr) != null;
    }

    @Nullable
    public static GoType getTypeIfConversion(@Nullable PsiElement element) {
        if (element instanceof GoCallExpr) {
            return GoPsiUtil.getTypeIfConversion((GoCallExpr)element);
        }
        if (element instanceof GoBuiltinCallExpr) {
            return GoPsiUtil.getTypeIfConversion((GoBuiltinCallExpr)element);
        }
        if (element instanceof GoConversionExpr) {
            return GoPsiImplUtil.getTypeFromSpecIfNeeded(((GoConversionExpr)element).getType());
        }
        return null;
    }

    @Nullable
    public static GoType getTypeIfConversion(@NotNull GoCallExpr callExpr) {
        GoType typeFromExpression;
        if (callExpr == null) {
            GoPsiUtil.$$$reportNull$$$0(27);
        }
        if ((typeFromExpression = GoPsiUtil.getTypeFromCallLikeConversion(callExpr)) != null) {
            List typeArguments = Optional.of(callExpr).map(c -> (GoExpression)ObjectUtils.doIfCast((Object)c, GoCallExpr.class, GoCallExpr::getExpression)).map(e -> GoPsiImplUtil.unwrapMulOrPar(e)).map(e -> (GoIndexOrSliceExpr)ObjectUtils.tryCast((Object)e, GoIndexOrSliceExpr.class)).map(i -> Collections.singletonList(GoPsiUtil.getTypeArgument(i))).orElse(Collections.emptyList());
            GoReferenceExpression reference = GoPsiUtil.getCallReference(callExpr);
            if (reference == null) {
                return null;
            }
            GoType type2 = GoPsiImplUtil.createTypeFromReference(reference, typeArguments);
            return GoPsiUtil.wrapWithPointers(type2, callExpr.getExpression());
        }
        return null;
    }

    @Nullable
    public static PsiElement getTypeArgument(@NotNull GoIndexOrSliceExpr indexOrSliceExpr) {
        if (indexOrSliceExpr == null) {
            GoPsiUtil.$$$reportNull$$$0(28);
        }
        if (GoPsiUtil.isCallOrConversionWithTypeInstantiation(indexOrSliceExpr)) {
            GoType type2 = indexOrSliceExpr.getType();
            return type2 != null ? type2 : (PsiElement)indexOrSliceExpr.getIndices().first;
        }
        return null;
    }

    @Nullable
    public static GoType getTypeIfConversion(@NotNull GoBuiltinCallExpr callExpr) {
        GoType typeFromExpression;
        if (callExpr == null) {
            GoPsiUtil.$$$reportNull$$$0(29);
        }
        return (typeFromExpression = GoPsiUtil.getTypeFromCallLikeConversion(callExpr)) != null ? GoPsiImplUtil.getTypeFromSpecIfNeeded(typeFromExpression) : null;
    }

    @Nullable
    private static GoType getTypeFromCallLikeConversion(@NotNull GoExpression callExpr) {
        GoReferenceExpression calledRef;
        if (callExpr == null) {
            GoPsiUtil.$$$reportNull$$$0(30);
        }
        if ((calledRef = GoPsiUtil.getCallReference(callExpr)) != null) {
            PsiElement element = calledRef.resolve();
            if (element instanceof GoTypeSpec) {
                return ((GoTypeSpec)element).getSpecType();
            }
            if (element instanceof GoTypeParamDefinition) {
                return ((GoTypeParamDefinition)element).getTypeParameter();
            }
        }
        return null;
    }

    @NotNull
    public static GoType wrapWithPointers(@NotNull GoType type2, @NotNull GoExpression exprWithUnaryMul) {
        if (type2 == null) {
            GoPsiUtil.$$$reportNull$$$0(31);
        }
        if (exprWithUnaryMul == null) {
            GoPsiUtil.$$$reportNull$$$0(32);
        }
        GoExpression expr = GoPsiImplUtil.unwrapParentheses(exprWithUnaryMul);
        while (expr instanceof GoUnaryExpr && ((GoUnaryExpr)expr).getMul() != null) {
            type2 = new GoLightType.LightPointerType(type2);
            expr = GoPsiImplUtil.unwrapParentheses(((GoUnaryExpr)expr).getExpression());
        }
        GoType goType = type2;
        if (goType == null) {
            GoPsiUtil.$$$reportNull$$$0(33);
        }
        return goType;
    }

    @Contract(value="null -> null")
    public static GoType getTypeIfTypeReference(@Nullable GoExpression expression) {
        if (expression == null) {
            return null;
        }
        GoReferenceExpression referenceExpression = GoPsiImplUtil.unwrapMulOrParOfReference(expression);
        PsiElement resolve2 = referenceExpression != null ? referenceExpression.resolve() : null;
        GoTypeSpec typeSpec = (GoTypeSpec)ObjectUtils.tryCast((Object)resolve2, GoTypeSpec.class);
        GoSpecType type2 = typeSpec != null ? typeSpec.getSpecType() : null;
        return type2 != null ? GoPsiUtil.wrapWithPointers(type2, expression) : null;
    }

    @NotNull
    public static <K, V> MultiMap<K, V> toMultiMap(@NotNull List<V> list, @NotNull Convertor<? super V, ? extends K> convertor) {
        if (list == null) {
            GoPsiUtil.$$$reportNull$$$0(34);
        }
        if (convertor == null) {
            GoPsiUtil.$$$reportNull$$$0(35);
        }
        MultiMap map = MultiMap.createLinkedSet();
        for (V type2 : list) {
            map.putValue(convertor.convert(type2), type2);
        }
        MultiMap multiMap = map;
        if (multiMap == null) {
            GoPsiUtil.$$$reportNull$$$0(36);
        }
        return multiMap;
    }

    public static boolean notQualified(@Nullable PsiElement e) {
        if (!(e instanceof GoReferenceExpression) && !(e instanceof GoTypeReferenceExpression)) {
            return false;
        }
        return ((GoReferenceExpressionBase)e).getQualifier() == null;
    }

    @Contract(value="null -> false")
    public static boolean isImportSpecOrPackage(@Nullable PsiElement resolve2) {
        return resolve2 instanceof GoImportSpec || GoPackageUtil.isGoPackage(resolve2);
    }

    @NotNull
    private static List<PsiComment> findLastCommentGroup(@Nullable GoBlock block) {
        if (block == null) {
            List list = ContainerUtil.emptyList();
            if (list == null) {
                GoPsiUtil.$$$reportNull$$$0(37);
            }
            return list;
        }
        SmartList result = new SmartList();
        for (PsiElement child = block.getLastChild(); child != null; child = child.getPrevSibling()) {
            if (child instanceof PsiComment) {
                result.add((PsiComment)child);
                continue;
            }
            if (!(child instanceof PsiWhiteSpace) && !result.isEmpty()) break;
        }
        List list = ContainerUtil.reverse((List)result);
        if (list == null) {
            GoPsiUtil.$$$reportNull$$$0(38);
        }
        return list;
    }

    private static boolean isExpectedOutputComments(@NotNull List<PsiComment> comments) {
        PsiComment first;
        if (comments == null) {
            GoPsiUtil.$$$reportNull$$$0(39);
        }
        String text = (first = (PsiComment)ContainerUtil.getFirstItem(comments)) != null ? StringUtil.trimStart((String)first.getText(), (String)"//").trim() : "";
        return StringUtil.startsWithIgnoreCase((String)text, (String)"Output:") || StringUtil.startsWithIgnoreCase((String)text, (String)"Unordered output:");
    }

    @Nullable
    public static Pair<String, String> getExampleCodeAndOutput(@NotNull GoFunctionDeclaration declaration) {
        if (declaration == null) {
            GoPsiUtil.$$$reportNull$$$0(40);
        }
        return (Pair)CachedValuesManager.getCachedValue((PsiElement)declaration, () -> {
            String output2;
            GoBlock block = declaration.getBlock();
            if (block == null) {
                return CachedValueProvider.Result.create(null, (Object[])new Object[]{declaration});
            }
            List<PsiComment> comments = GoPsiUtil.findLastCommentGroup(block);
            StringBuilder codeText = new StringBuilder();
            if (GoPsiUtil.isExpectedOutputComments(comments)) {
                PsiComment outputStart = comments.get(0);
                for (PsiElement child : block.getChildren()) {
                    if (child == outputStart) break;
                    codeText.append(child.getText());
                }
                output2 = GoPsiUtil.getOutput(ContainerUtil.map(comments, comment -> comment.getText()));
            } else {
                codeText.append(block.getText());
                output2 = null;
            }
            String code = StringUtil.trimStart((String)StringUtil.trimStart((String)codeText.toString(), (String)"{"), (String)"\n");
            code = StringUtil.trimEnd((String)StringUtil.trimEnd((String)code, (String)"}"), (String)"\n");
            return CachedValueProvider.Result.create((Object)Pair.create((Object)code, (Object)output2), (Object[])new Object[]{declaration});
        });
    }

    @NotNull
    public static String getOutput(@NotNull List<String> commentTexts) {
        if (commentTexts == null) {
            GoPsiUtil.$$$reportNull$$$0(41);
        }
        StringBuilder result = new StringBuilder();
        boolean first = true;
        for (String commentText : commentTexts) {
            String text = StringUtil.trimLeading((String)StringUtil.trimStart((String)commentText, (String)"//"));
            if (first) {
                if (StringUtil.startsWithIgnoreCase((String)text, (String)"Output:")) {
                    text = StringUtil.trimLeading((String)text.substring("Output:".length()));
                } else if (StringUtil.startsWithIgnoreCase((String)text, (String)"Unordered output:")) {
                    text = StringUtil.trimLeading((String)text.substring("Unordered output:".length()));
                }
            }
            result.append(text).append("\n");
            first = false;
        }
        String string = result.toString();
        if (string == null) {
            GoPsiUtil.$$$reportNull$$$0(42);
        }
        return string;
    }

    public static boolean isMethodExpressionCall(@NotNull GoCallLikeExpr call) {
        if (call == null) {
            GoPsiUtil.$$$reportNull$$$0(43);
        }
        return Optional.of(call).map(GoPsiUtil::getCallReference).map(r -> r.getQualifier()).filter(GoPsiUtil::isMethodExpressionQualifier).isPresent();
    }

    public static boolean isMethodExpressionQualifier(@NotNull PsiElement element) {
        GoExpression goExpression;
        GoUnaryExpr unaryExpr;
        GoReferenceExpression refExpr;
        PsiElement adjustedElement;
        PsiElement parent;
        boolean isQualifier;
        if (element == null) {
            GoPsiUtil.$$$reportNull$$$0(44);
        }
        boolean bl = isQualifier = (parent = (adjustedElement = GoPsiUtil.skipParens(element)).getParent()) instanceof GoReferenceExpression && adjustedElement == (refExpr = (GoReferenceExpression)parent).getRawQualifier();
        if (!isQualifier) {
            return false;
        }
        if (element instanceof GoType) {
            return true;
        }
        GoExpression expression = GoPsiImplUtil.unwrapParentheses((GoExpression)ObjectUtils.tryCast((Object)element, GoExpression.class));
        if (expression == null) {
            return false;
        }
        GoExpression innerExpr = expression instanceof GoUnaryExpr && (unaryExpr = (GoUnaryExpr)expression).getMul() != null ? unaryExpr.getExpression() : expression;
        GoExpression innerExprUnwrap = GoPsiImplUtil.unwrapParentheses(innerExpr);
        if (innerExprUnwrap instanceof GoIndexOrSliceExpr) {
            GoIndexOrSliceExpr indexOrSliceExpr = (GoIndexOrSliceExpr)innerExprUnwrap;
            goExpression = indexOrSliceExpr.getExpression();
        } else {
            goExpression = innerExprUnwrap;
        }
        GoExpression baseExpr = goExpression;
        GoReferenceExpression ref = (GoReferenceExpression)ObjectUtils.tryCast((Object)baseExpr, GoReferenceExpression.class);
        PsiElement resolved = ref != null ? ref.resolve() : null;
        return resolved instanceof GoTypeSpec || resolved instanceof GoTypeParamDefinition;
    }

    @Nullable
    @Contract(value="!null -> !null; null -> null")
    public static PsiElement skipParens(@Nullable PsiElement element) {
        Class<GoParenthesesExpr> parensClass = element instanceof GoExpression ? GoParenthesesExpr.class : (element instanceof GoType ? GoParType.class : null);
        return parensClass != null ? GoPsiUtil.skipParents(element, parensClass) : element;
    }

    @Nullable
    @Contract(value="!null, _ -> !null; null, _ -> null")
    public static PsiElement skipParents(@Nullable PsiElement element, @NotNull Class<?> aClass) {
        if (aClass == null) {
            GoPsiUtil.$$$reportNull$$$0(45);
        }
        PsiElement parent = element != null ? element.getParent() : null;
        PsiElement prev = element;
        while (aClass.isInstance(parent)) {
            prev = parent;
            parent = parent.getParent();
        }
        return prev;
    }

    @Contract(value="null -> false")
    public static boolean isTopLevelDeclaration(@Nullable PsiElement element) {
        if (element instanceof GoPackageClause || element instanceof GoImportList) {
            return true;
        }
        if (element instanceof GoTopLevelDeclaration) {
            return PsiTreeUtil.getStubOrPsiParent((PsiElement)element) instanceof GoFile;
        }
        GoTopLevelDeclaration topLevelDeclaration = (GoTopLevelDeclaration)PsiTreeUtil.getStubOrPsiParentOfType((PsiElement)element, GoTopLevelDeclaration.class);
        if (topLevelDeclaration instanceof GoFunctionOrMethodDeclaration) {
            return false;
        }
        return topLevelDeclaration != null && (element instanceof GoTypeSpec || element instanceof GoVarOrConstDefinition || element instanceof GoVarOrConstSpec) ? PsiTreeUtil.getStubOrPsiParent((PsiElement)topLevelDeclaration) instanceof GoFile : PsiTreeUtil.getStubOrPsiParent((PsiElement)element) instanceof GoFile;
    }

    @Contract(value="_, null -> false", pure=true)
    public static boolean isExportable(@NotNull Project project, @Nullable GoNamedElement namedElement) {
        if (project == null) {
            GoPsiUtil.$$$reportNull$$$0(46);
        }
        return namedElement != null && !namedElement.isPublic() && GoPsiUtil.canBePublic(namedElement) && GoPsiUtil.isWriteable(project, namedElement);
    }

    private static boolean canBePublic(@NotNull GoNamedElement namedElement) {
        if (namedElement == null) {
            GoPsiUtil.$$$reportNull$$$0(47);
        }
        return namedElement instanceof GoMethodSpec || namedElement instanceof GoFieldDefinition || GoPsiUtil.isTopLevelDeclaration(namedElement) && !GoPsiUtil.isMainOrInitFunction(namedElement);
    }

    private static boolean isWriteable(@NotNull Project project, @NotNull PsiElement element) {
        if (project == null) {
            GoPsiUtil.$$$reportNull$$$0(48);
        }
        if (element == null) {
            GoPsiUtil.$$$reportNull$$$0(49);
        }
        if (!PsiManager.getInstance((Project)project).isInProject(element)) {
            VirtualFile virtualFile;
            if (element.isPhysical() && ((virtualFile = PsiUtilCore.getVirtualFile((PsiElement)element)) == null || !NonProjectFileWritingAccessProvider.isWriteAccessAllowed((VirtualFile)virtualFile, (Project)project))) {
                return false;
            }
            if (!element.isWritable()) {
                return false;
            }
        }
        return true;
    }

    @Nullable
    public static GoTypeSpec findBaseAliasedTypeSpec(@Nullable GoTypeSpec spec) {
        if (spec == null) {
            return null;
        }
        return (GoTypeSpec)CachedValuesManager.getCachedValue((PsiElement)spec, () -> GoCacheUtilKt.createResolveDependentResult(spec.getProject(), GoPsiUtil.findBaseAliasedTypeSpec(spec, new HashSet<GoTypeSpec>()), new Object[0]));
    }

    private static GoTypeSpec findBaseAliasedTypeSpec(@Nullable GoTypeSpec spec, @NotNull Set<GoTypeSpec> visitedSpecs) {
        if (visitedSpecs == null) {
            GoPsiUtil.$$$reportNull$$$0(50);
        }
        if (spec == null || !visitedSpecs.add(spec)) {
            return null;
        }
        if (spec.isTypeAlias()) {
            GoType aliasedType = GoTypeUtil.unwrapPointerAndParTypes(spec.getSpecType().getType());
            GoTypeSpec resolve2 = aliasedType != null ? (GoTypeSpec)ObjectUtils.tryCast((Object)aliasedType.contextlessResolve(), GoTypeSpec.class) : null;
            return (GoTypeSpec)ObjectUtils.chooseNotNull((Object)GoPsiUtil.findBaseAliasedTypeSpec(resolve2, visitedSpecs), (Object)resolve2);
        }
        return spec;
    }

    @Nullable
    public static GoElementWithSubst<GoTypeSpec> findBaseAliasedTypeSpecWithSubstitution(@Nullable GoTypeSpec spec) {
        if (spec == null) {
            return null;
        }
        return (GoElementWithSubst)CachedValuesManager.getCachedValue((PsiElement)spec, () -> GoCacheUtilKt.createResolveDependentResult(spec.getProject(), GoPsiUtil.findBaseAliasedTypeSpecWithSubstitution(spec, new HashSet<GoTypeSpec>()), new Object[0]));
    }

    @Nullable
    private static GoElementWithSubst<GoTypeSpec> findBaseAliasedTypeSpecWithSubstitution(@Nullable GoTypeSpec spec, @NotNull Set<GoTypeSpec> visitedSpecs) {
        if (visitedSpecs == null) {
            GoPsiUtil.$$$reportNull$$$0(51);
        }
        if (spec == null || !visitedSpecs.add(spec)) {
            return null;
        }
        if (spec.isTypeAlias()) {
            GoTypeSpec resolve2;
            GoType aliasedType = GoTypeUtil.unwrapPointerAndParTypes(spec.getSpecType().getType());
            GoTypeSpec goTypeSpec = resolve2 = aliasedType != null ? (GoTypeSpec)ObjectUtils.tryCast((Object)aliasedType.contextlessResolve(), GoTypeSpec.class) : null;
            if (resolve2 == null) {
                return null;
            }
            GoElementWithSubst<GoTypeSpec> base = GoPsiUtil.findBaseAliasedTypeSpecWithSubstitution(resolve2, visitedSpecs);
            List<GoType> typeArgs = GoPsiImplUtil.getTypeArguments(aliasedType);
            if (!typeArgs.isEmpty()) {
                GoTypeSpec baseTypeSpec = base != null ? base.getElement() : resolve2;
                GoSpecType baseSpecType = baseTypeSpec.getSpecType();
                GoType substitutionSource = GoTypeInstantiationKt.getInstantiatedSpecType(baseSpecType, typeArgs);
                return GoElementWithSubst.create(baseTypeSpec, substitutionSource);
            }
            return (GoElementWithSubst)ObjectUtils.chooseNotNull(base, GoElementWithSubst.create(resolve2, null));
        }
        return GoElementWithSubst.create(spec, null);
    }

    @Nullable
    @Contract(value="null -> null")
    public static GoType unwrapAlias(@Nullable GoTypeSpec spec) {
        if (spec == null) {
            return null;
        }
        return (GoType)CachedValuesManager.getCachedValue((PsiElement)spec, () -> GoCacheUtilKt.createResolveDependentResult(spec.getProject(), GoPsiUtil.unwrapAlias(spec, new HashSet<GoTypeSpec>()), new Object[0]));
    }

    @Contract(value="null, _ -> null")
    private static GoType unwrapAlias(@Nullable GoTypeSpec spec, @NotNull Set<GoTypeSpec> visitedSpecs) {
        if (visitedSpecs == null) {
            GoPsiUtil.$$$reportNull$$$0(52);
        }
        if (spec == null || !visitedSpecs.add(spec)) {
            return null;
        }
        if (!spec.isTypeAlias()) {
            return spec.getSpecType();
        }
        GoType aliasedType = spec.getSpecType().getType();
        if (!GoTypeUtil.isNamedType(aliasedType)) {
            return aliasedType;
        }
        GoTypeSpec resolve2 = (GoTypeSpec)ObjectUtils.tryCast((Object)aliasedType.contextlessResolve(), GoTypeSpec.class);
        return GoPsiUtil.unwrapAlias(resolve2, visitedSpecs);
    }

    public static boolean isCompositeLiteralElementValue(@Nullable PsiElement element) {
        if (element == null) {
            return false;
        }
        GoValue value = (GoValue)PsiTreeUtil.getParentOfType((PsiElement)element, GoValue.class);
        return value != null && value.getParent() instanceof GoElement && value.getTextRange().getStartOffset() == element.getTextRange().getStartOffset();
    }

    public static boolean isExpression(@Nullable PsiElement element) {
        return element instanceof GoExpression && (!(element instanceof GoReferenceExpression) || !(((GoReferenceExpression)element).resolve() instanceof GoTypeSpec));
    }

    public static boolean hasNewLineAfter(@Nullable PsiElement element) {
        PsiElement next;
        PsiElement psiElement = next = element != null ? PsiTreeUtil.nextLeaf((PsiElement)element) : null;
        while (next instanceof PsiWhiteSpace || next instanceof PsiComment) {
            if (next.textContains('\n')) {
                return true;
            }
            next = PsiTreeUtil.nextLeaf((PsiElement)next);
        }
        return false;
    }

    @Nullable
    public static PsiElement findTrailingSemicolon(@Nullable PsiElement statement) {
        if (statement == null) {
            return null;
        }
        PsiElement element = PsiTreeUtil.nextVisibleLeaf((PsiElement)statement);
        ASTNode node = element != null ? element.getNode() : null;
        IElementType type2 = node != null ? node.getElementType() : null;
        return type2 == GoTypes.SEMICOLON ? element : null;
    }

    public static void processMapEntries(@Nullable GoVarDefinition mapDefinition, @NotNull PairProcessor<? super String, ? super GoElement> processor2) {
        GoElement element;
        GoKey key;
        Value value;
        String keyString;
        if (processor2 == null) {
            GoPsiUtil.$$$reportNull$$$0(53);
        }
        GoExpression expression = mapDefinition != null ? mapDefinition.findExpression() : null;
        GoLiteralValue literalValue = expression instanceof GoCompositeLit ? ((GoCompositeLit)expression).getLiteralValue() : null;
        List<Object> elements = literalValue != null ? literalValue.getElementList() : Collections.emptyList();
        Iterator<Object> iterator = elements.iterator();
        while (iterator.hasNext() && ((keyString = (value = (key = (element = (GoElement)iterator.next()).getKey()) != null ? key.getValue() : null) != null ? value.toString() : null) == null || processor2.process((Object)keyString, (Object)element))) {
        }
    }

    @Contract(value="null, _ -> false", pure=true)
    public static boolean isUnexportedAndFromOtherPackage(@Nullable PsiElement element, @NotNull PsiElement context) {
        GoNamedElement namedElement;
        if (context == null) {
            GoPsiUtil.$$$reportNull$$$0(54);
        }
        if ((namedElement = (GoNamedElement)ObjectUtils.tryCast((Object)element, GoNamedElement.class)) == null || namedElement.isPublic()) {
            return false;
        }
        element = (PsiElement)ObjectUtils.notNull((Object)element.getContext(), (Object)element);
        Object contextContainingFile = (context = (PsiElement)ObjectUtils.notNull((Object)context.getContext(), (Object)context)).getContainingFile();
        if (contextContainingFile instanceof GoCodeFragment) {
            contextContainingFile = ((GoCodeFragment)((Object)contextContainingFile)).getContextFile();
        }
        return !GoUtil.isDirectlyAccessible(element.getContainingFile(), contextContainingFile);
    }

    public static boolean isTypeReferenceBeforeUnexpectedTokens(@Nullable PsiElement typeReferenceExpression, String ... tokens) {
        PsiErrorElement finalError;
        GoType type2 = (GoType)ObjectUtils.tryCast((Object)(typeReferenceExpression != null ? typeReferenceExpression.getParent() : null), GoType.class);
        GoSpecType specType = (GoSpecType)ObjectUtils.tryCast((Object)(type2 != null ? type2.getParent() : null), GoSpecType.class);
        GoTypeSpec typeSpec = (GoTypeSpec)ObjectUtils.tryCast((Object)(specType != null ? specType.getParent() : null), GoTypeSpec.class);
        GoTypeDeclaration declaration = (GoTypeDeclaration)ObjectUtils.tryCast((Object)(typeSpec != null ? typeSpec.getParent() : null), GoTypeDeclaration.class);
        if (declaration == null) {
            return false;
        }
        PsiElement element = PsiTreeUtil.skipWhitespacesForward((PsiElement)declaration);
        PsiErrorElement error = (PsiErrorElement)ObjectUtils.tryCast((Object)element, PsiErrorElement.class);
        if (error == null && element != null && element.getNode().getElementType() == GeneratedParserUtilBase.DUMMY_BLOCK) {
            error = (PsiErrorElement)SyntaxTraverser.psiTraverser((PsiElement)element).traverse().filter(PsiErrorElement.class).first();
        }
        return (finalError = error) != null && ContainerUtil.exists((Object[])tokens, token -> finalError.textMatches((CharSequence)token));
    }

    public static boolean isUnexpectedTypeReferenceInsteadOfChan(@Nullable PsiElement typeReferenceExpression) {
        GoType type2 = (GoType)ObjectUtils.tryCast((Object)(typeReferenceExpression != null ? typeReferenceExpression.getParent() : null), GoType.class);
        PsiErrorElement errorBefore = (PsiErrorElement)ObjectUtils.tryCast((Object)PsiTreeUtil.skipWhitespacesBackward((PsiElement)type2), PsiErrorElement.class);
        if (errorBefore != null && errorBefore.getErrorDescription().contains("chan expected, got '" + typeReferenceExpression.getText() + "'")) {
            return true;
        }
        PsiErrorElement errorAfter = (PsiErrorElement)ObjectUtils.tryCast((Object)PsiTreeUtil.skipWhitespacesForward((PsiElement)type2), PsiErrorElement.class);
        return errorAfter != null && errorAfter.textMatches((CharSequence)"<-");
    }

    public static boolean isMainFunction(@NotNull GoNamedElement function) {
        if (function == null) {
            GoPsiUtil.$$$reportNull$$$0(55);
        }
        return function instanceof GoFunctionDeclaration && "main".equals(function.getName()) && "main".equals(function.getContainingFile().getPackageName());
    }

    public static boolean isInitFunction(@NotNull GoNamedElement function) {
        if (function == null) {
            GoPsiUtil.$$$reportNull$$$0(56);
        }
        return function instanceof GoFunctionDeclaration && "init".equals(function.getName());
    }

    public static boolean isMainOrInitFunction(@NotNull GoNamedElement function) {
        if (function == null) {
            GoPsiUtil.$$$reportNull$$$0(57);
        }
        return GoPsiUtil.isMainFunction(function) || GoPsiUtil.isInitFunction(function);
    }

    public static boolean isExpressionInControlElement(@NotNull PsiElement o) {
        GoIfStatement ifStmt;
        if (o == null) {
            GoPsiUtil.$$$reportNull$$$0(58);
        }
        if ((ifStmt = (GoIfStatement)PsiTreeUtil.getParentOfType((PsiElement)o, GoIfStatement.class)) != null && ifStmt.getCondition() == o) {
            return true;
        }
        GoForStatement forStmt = (GoForStatement)PsiTreeUtil.getParentOfType((PsiElement)o, GoForStatement.class);
        if (forStmt != null && (forStmt.getForClause() != null && forStmt.getForClause().getExpression() == o || forStmt.getExpression() == o || forStmt.getRangeClause() != null && forStmt.getRangeClause().getRangeExpression() == o)) {
            return true;
        }
        GoExprSwitchStatement exprSwitchStmt = (GoExprSwitchStatement)PsiTreeUtil.getParentOfType((PsiElement)o, GoExprSwitchStatement.class);
        return exprSwitchStmt != null && exprSwitchStmt.getCondition() == o;
    }

    public static boolean isInControlElementHeader(@NotNull PsiElement o) {
        GoIfStatement ifStmt;
        if (o == null) {
            GoPsiUtil.$$$reportNull$$$0(59);
        }
        if ((ifStmt = (GoIfStatement)PsiTreeUtil.getParentOfType((PsiElement)o, GoIfStatement.class)) != null && (ifStmt.getCondition() == o || ifStmt.getInitStatement() != null && PsiTreeUtil.isAncestor((PsiElement)ifStmt.getInitStatement(), (PsiElement)o, (boolean)true))) {
            return true;
        }
        GoForStatement forStmt = (GoForStatement)PsiTreeUtil.getParentOfType((PsiElement)o, GoForStatement.class);
        if (forStmt != null && forStmt.getForClause() != null && (forStmt.getForClause() != null && forStmt.getForClause().getExpression() == o || forStmt.getExpression() == o || forStmt.getRangeClause() != null && forStmt.getRangeClause().getRangeExpression() == o || PsiTreeUtil.isAncestor((PsiElement)forStmt.getForClause().getInitStatement(), (PsiElement)o, (boolean)true) || PsiTreeUtil.isAncestor((PsiElement)forStmt.getForClause().getPostStatement(), (PsiElement)o, (boolean)true))) {
            return true;
        }
        GoExprSwitchStatement exprSwitchStmt = (GoExprSwitchStatement)PsiTreeUtil.getParentOfType((PsiElement)o, GoExprSwitchStatement.class);
        return exprSwitchStmt != null && (exprSwitchStmt.getCondition() == o || PsiTreeUtil.isAncestor((PsiElement)exprSwitchStmt.getInitStatement(), (PsiElement)o, (boolean)true));
    }

    public static boolean onDifferentLines(@NotNull PsiElement left, @NotNull PsiElement right) {
        if (left == null) {
            GoPsiUtil.$$$reportNull$$$0(60);
        }
        if (right == null) {
            GoPsiUtil.$$$reportNull$$$0(61);
        }
        while (left != right && left != null) {
            if (left instanceof PsiWhiteSpace && left.textContains('\n')) {
                return true;
            }
            left = PsiTreeUtil.nextLeaf((PsiElement)left);
        }
        return false;
    }

    @Nullable
    public static PsiDirectory findPsiDirectoryByUrl(@NotNull Project project, @Nullable String url) {
        VirtualFile workingDir;
        if (project == null) {
            GoPsiUtil.$$$reportNull$$$0(62);
        }
        if (StringUtil.isNotEmpty((String)url) && (workingDir = VirtualFileManager.getInstance().findFileByUrl(url)) != null) {
            return PsiManager.getInstance((Project)project).findDirectory(workingDir);
        }
        return null;
    }

    public static boolean isSameNamedMethod(@NotNull GoNamedSignatureOwner method, @NotNull GoNamedSignatureOwner m, boolean strict) {
        if (method == null) {
            GoPsiUtil.$$$reportNull$$$0(63);
        }
        if (m == null) {
            GoPsiUtil.$$$reportNull$$$0(64);
        }
        return GoPsiUtil.isSameNamedMethod(method, m, false, strict, null);
    }

    public static boolean isSameNamedMethod(@NotNull GoNamedSignatureOwner method, @NotNull GoNamedSignatureOwner m, boolean checkPossibleIdentity, boolean strict, @Nullable PsiElement context) {
        if (method == null) {
            GoPsiUtil.$$$reportNull$$$0(65);
        }
        if (m == null) {
            GoPsiUtil.$$$reportNull$$$0(66);
        }
        return Objects.equals(method.getName(), m.getName()) && GoPsiImplUtil.allowed((PsiFile)m.getContainingFile(), null, GoUtil.module(m)) && GoTypeUtil.areSignaturesIdentical(method.getSignature(), m.getSignature(), checkPossibleIdentity, strict, context);
    }

    public static <T extends GoNamedElement> boolean allowedDuplicateMethodsFromOverlappingInterfaces(@NotNull Collection<GoElementWithSubst<T>> duplicates, @Nullable PsiElement context) {
        if (duplicates == null) {
            GoPsiUtil.$$$reportNull$$$0(67);
        }
        if (context == null) {
            return true;
        }
        return GoPsiUtil.supportsOverlappingEmbeddedInterfaces(context) && GoPsiUtil.areIdenticalMethodSpecsFromDistinctInterfaces(new HashSet<GoElementWithSubst<T>>(duplicates));
    }

    private static boolean supportsOverlappingEmbeddedInterfaces(@NotNull PsiElement context) {
        if (context == null) {
            GoPsiUtil.$$$reportNull$$$0(68);
        }
        return GoSdkUtil.featureSupported(context, false, GoSdkVersion::supportsOverlappingEmbeddedInterfaces) == GoSdkUtil.FeatureSupported.YES;
    }

    private static <T extends GoNamedElement> boolean areIdenticalMethodSpecsFromDistinctInterfaces(@NotNull Set<GoElementWithSubst<T>> methods) {
        if (methods == null) {
            GoPsiUtil.$$$reportNull$$$0(69);
        }
        if (!ContainerUtil.all(methods, m -> m.getElement() instanceof GoMethodSpec)) {
            return false;
        }
        if (methods.size() < 2) {
            return true;
        }
        Set parentInterfaces = ContainerUtil.map2Set(methods, m -> Pair.create((Object)((GoInterfaceType)m.getElement().getParent()), (Object)m.getSubstitutionSource()));
        if (parentInterfaces.size() != methods.size()) {
            return false;
        }
        GoElementWithSubst firstItem = (GoElementWithSubst)ContainerUtil.getFirstItem(methods);
        GoMethodSpec firstMethod = (GoMethodSpec)((GoElementWithSubst)ContainerUtil.getFirstItem(methods)).getElement();
        GoType firstSubstitutionSource = firstItem.getSubstitutionSource();
        GoSignature firstSig = firstSubstitutionSource != null ? firstMethod.getSignature(firstSubstitutionSource) : firstMethod.getSignature();
        for (GoElementWithSubst<T> p : methods) {
            GoMethodSpec methodSpec = (GoMethodSpec)p.getElement();
            GoType substitutionSource = p.getSubstitutionSource();
            GoSignature sig = substitutionSource != null ? methodSpec.getSignature(substitutionSource) : methodSpec.getSignature();
            if (GoTypeUtil.areSignaturesIdentical(sig, firstSig, false, false, null)) continue;
            return false;
        }
        return true;
    }

    @NotNull
    public static List<? extends PsiElement> getArguments(@NotNull GoArgumentList argList) {
        if (argList == null) {
            GoPsiUtil.$$$reportNull$$$0(70);
        }
        if (argList instanceof GoBuiltinArgumentList) {
            ArrayList<GoExpression> result = new ArrayList<GoExpression>();
            ContainerUtil.addIfNotNull(result, (Object)((GoBuiltinArgumentList)argList).getType());
            result.addAll(argList.getExpressionList());
            ArrayList<GoExpression> arrayList = result;
            if (arrayList == null) {
                GoPsiUtil.$$$reportNull$$$0(71);
            }
            return arrayList;
        }
        List<GoExpression> list = argList.getExpressionList();
        if (list == null) {
            GoPsiUtil.$$$reportNull$$$0(72);
        }
        return list;
    }

    public static boolean isCallOrConversionWithTypeInstantiation(@NotNull GoIndexOrSliceExpr expression) {
        PsiElement element;
        if (expression == null) {
            GoPsiUtil.$$$reportNull$$$0(73);
        }
        if (!expression.isIndexExpression()) {
            return false;
        }
        if (expression.getType() != null) {
            return true;
        }
        List<GoExpression> expressions = expression.getExpressionList();
        if (expressions.size() == 2) {
            GoExpression indexExpr = expressions.get(1);
            if (!GoPsiUtil.canBeParsedAsType(indexExpr)) {
                return false;
            }
            PsiElement element2 = (PsiElement)ObjectUtils.doIfCast((Object)expressions.get(0), GoResolvable.class, GoResolvable::resolve);
            GoType type2 = indexExpr.getGoType(null);
            if ((element2 instanceof GoFunctionDeclaration || element2 instanceof GoTypeSpec) && GoPsiUtil.isSuitableForInstantiation(type2)) {
                return true;
            }
        } else if (expressions.size() == 1 && ((element = (PsiElement)ObjectUtils.doIfCast((Object)expressions.get(0), GoResolvable.class, GoResolvable::resolve)) instanceof GoFunctionDeclaration || element instanceof GoTypeSpec)) {
            return true;
        }
        return false;
    }

    @Nullable
    public static GoNamedElement resolveInstantiatedDeclaration(@NotNull GoIndexOrSliceExpr indexOrSliceExpr) {
        if (indexOrSliceExpr == null) {
            GoPsiUtil.$$$reportNull$$$0(74);
        }
        if (GoPsiUtil.isCallOrConversionWithTypeInstantiation(indexOrSliceExpr)) {
            return Optional.of(indexOrSliceExpr).map(i -> (GoResolvable)ObjectUtils.tryCast((Object)i.getExpression(), GoResolvable.class)).map(r -> (GoNamedElement)ObjectUtils.tryCast((Object)r.resolve(), GoNamedElement.class)).orElse(null);
        }
        return null;
    }

    private static boolean isSuitableForInstantiation(@Nullable GoType type2) {
        return type2 instanceof GoCompositeType || type2 instanceof GoTypeParameter || type2 instanceof GoCType || type2 != null && type2.getTypeReferenceExpression() != null && type2.getTypeArguments() != null;
    }

    private static boolean canBeParsedAsType(@Nullable GoExpression e) {
        while (e != null) {
            if (e instanceof GoReferenceExpression) {
                return true;
            }
            if (e instanceof GoParenthesesExpr) {
                e = ((GoParenthesesExpr)e).getExpression();
                continue;
            }
            if (e instanceof GoUnaryExpr) {
                if (((GoUnaryExpr)e).getMul() != null) {
                    e = ((GoUnaryExpr)e).getExpression();
                    continue;
                }
                return false;
            }
            if (e instanceof GoIndexOrSliceExpr) {
                e = ((GoIndexOrSliceExpr)e).getExpression();
                continue;
            }
            return false;
        }
        return false;
    }

    public static PsiElement addLineCommentBefore(@NotNull String commentText, @NotNull PsiElement anchor) {
        if (commentText == null) {
            GoPsiUtil.$$$reportNull$$$0(75);
        }
        if (anchor == null) {
            GoPsiUtil.$$$reportNull$$$0(76);
        }
        Project project = anchor.getProject();
        PsiElement parent = anchor.getParent();
        PsiElement comment = parent.addBefore((PsiElement)GoElementFactory.createLineCommentFromText(project, commentText), anchor);
        PsiElement next = comment.getNextSibling();
        if (anchor instanceof PsiComment && next instanceof PsiWhiteSpace && !next.textMatches((CharSequence)"\n")) {
            parent.addBefore(next, comment);
            next.replace(GoElementFactory.createNewLine(project, 1));
        }
        return comment;
    }

    @Nullable
    public static GoTypeParamDefinition getReceiverTypeParamDefinition(@Nullable GoType type2) {
        return (GoTypeParamDefinition)PsiTreeUtil.getStubChildOfType((PsiElement)type2, GoTypeParamDefinition.class);
    }

    @Nullable
    public static GoType getReceiverTypeArg(@Nullable GoNamedElement e) {
        return e instanceof GoTypeParamDefinition ? (GoType)ObjectUtils.tryCast((Object)PsiTreeUtil.getStubOrPsiParent((PsiElement)e), GoType.class) : null;
    }

    @Nullable
    public static GoPackage getPackageQualifier(@NotNull GoReferenceExpression expr) {
        GoPackage goPackage;
        PsiElement resolve2;
        GoQualifier qualifierExpr;
        if (expr == null) {
            GoPsiUtil.$$$reportNull$$$0(77);
        }
        if ((qualifierExpr = expr.getQualifier()) == null) {
            return null;
        }
        if (qualifierExpr instanceof GoReferenceExpression) {
            GoReferenceExpression qualifierRefExpr = (GoReferenceExpression)qualifierExpr;
            v0 = qualifierRefExpr.resolve();
        } else {
            v0 = resolve2 = null;
        }
        if (resolve2 == null) {
            return null;
        }
        if (resolve2 instanceof GoImportSpec) {
            GoImportSpec importSpec = (GoImportSpec)resolve2;
            goPackage = (GoPackage)ContainerUtil.getFirstItem(importSpec.resolve(ResolveState.initial()));
        } else {
            goPackage = GoPackageUtil.unwrapGoPackage(resolve2);
        }
        return goPackage;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 14, 33, 36, 37, 38, 42, 71, 72 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processor";
                break;
            }
            case 4: 
            case 26: 
            case 27: 
            case 29: 
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "callExpr";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "names";
                break;
            }
            case 6: 
            case 9: 
            case 11: 
            case 75: {
                objectArray2 = objectArray3;
                objectArray3[0] = "commentText";
                break;
            }
            case 7: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "flag";
                break;
            }
            case 10: 
            case 12: 
            case 13: 
            case 25: 
            case 58: 
            case 59: {
                objectArray2 = objectArray3;
                objectArray3[0] = "o";
                break;
            }
            case 14: 
            case 33: 
            case 36: 
            case 37: 
            case 38: 
            case 42: 
            case 71: 
            case 72: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/goide/psi/impl/GoPsiUtil";
                break;
            }
            case 15: 
            case 16: 
            case 77: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expr";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "statement";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "leftExpr";
                break;
            }
            case 19: 
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "leftExprs";
                break;
            }
            case 20: 
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rightExprs";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rightExpr";
                break;
            }
            case 24: 
            case 34: {
                objectArray2 = objectArray3;
                objectArray3[0] = "list";
                break;
            }
            case 28: 
            case 74: {
                objectArray2 = objectArray3;
                objectArray3[0] = "indexOrSliceExpr";
                break;
            }
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "exprWithUnaryMul";
                break;
            }
            case 35: {
                objectArray2 = objectArray3;
                objectArray3[0] = "convertor";
                break;
            }
            case 39: {
                objectArray2 = objectArray3;
                objectArray3[0] = "comments";
                break;
            }
            case 40: {
                objectArray2 = objectArray3;
                objectArray3[0] = "declaration";
                break;
            }
            case 41: {
                objectArray2 = objectArray3;
                objectArray3[0] = "commentTexts";
                break;
            }
            case 43: {
                objectArray2 = objectArray3;
                objectArray3[0] = "call";
                break;
            }
            case 44: 
            case 49: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 45: {
                objectArray2 = objectArray3;
                objectArray3[0] = "aClass";
                break;
            }
            case 46: 
            case 48: 
            case 62: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 47: {
                objectArray2 = objectArray3;
                objectArray3[0] = "namedElement";
                break;
            }
            case 50: 
            case 51: 
            case 52: {
                objectArray2 = objectArray3;
                objectArray3[0] = "visitedSpecs";
                break;
            }
            case 54: 
            case 68: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 55: 
            case 56: 
            case 57: {
                objectArray2 = objectArray3;
                objectArray3[0] = "function";
                break;
            }
            case 60: {
                objectArray2 = objectArray3;
                objectArray3[0] = "left";
                break;
            }
            case 61: {
                objectArray2 = objectArray3;
                objectArray3[0] = "right";
                break;
            }
            case 63: 
            case 65: {
                objectArray2 = objectArray3;
                objectArray3[0] = "method";
                break;
            }
            case 64: 
            case 66: {
                objectArray2 = objectArray3;
                objectArray3[0] = "m";
                break;
            }
            case 67: {
                objectArray2 = objectArray3;
                objectArray3[0] = "duplicates";
                break;
            }
            case 69: {
                objectArray2 = objectArray3;
                objectArray3[0] = "methods";
                break;
            }
            case 70: {
                objectArray2 = objectArray3;
                objectArray3[0] = "argList";
                break;
            }
            case 73: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expression";
                break;
            }
            case 76: {
                objectArray2 = objectArray3;
                objectArray3[0] = "anchor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/goide/psi/impl/GoPsiUtil";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "getTextAndSkipLiterals";
                break;
            }
            case 33: {
                objectArray = objectArray2;
                objectArray2[1] = "wrapWithPointers";
                break;
            }
            case 36: {
                objectArray = objectArray2;
                objectArray2[1] = "toMultiMap";
                break;
            }
            case 37: 
            case 38: {
                objectArray = objectArray2;
                objectArray2[1] = "findLastCommentGroup";
                break;
            }
            case 42: {
                objectArray = objectArray2;
                objectArray2[1] = "getOutput";
                break;
            }
            case 71: 
            case 72: {
                objectArray = objectArray2;
                objectArray2[1] = "getArguments";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "processDefinitions";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "isBuiltinFunctionCall";
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "isFlaggedComment";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "isBuildTagComment";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "isGoBuildDirective";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "getContinueStatementOwner";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "getBreakStatementOwner";
                break;
            }
            case 14: 
            case 33: 
            case 36: 
            case 37: 
            case 38: 
            case 42: 
            case 71: 
            case 72: {
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "getParentIfStatement";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "getParentForStatement";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "isSimpleStatementFromIfForSwitch";
                break;
            }
            case 18: 
            case 19: 
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "getCorrespondingRightExpr";
                break;
            }
            case 21: 
            case 22: 
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "getCorrespondingLeftExpr";
                break;
            }
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "getByIndex";
                break;
            }
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "isInsideTypeSwitchAssertion";
                break;
            }
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "getCallReference";
                break;
            }
            case 27: 
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "getTypeIfConversion";
                break;
            }
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "getTypeArgument";
                break;
            }
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "getTypeFromCallLikeConversion";
                break;
            }
            case 31: 
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "wrapWithPointers";
                break;
            }
            case 34: 
            case 35: {
                objectArray = objectArray;
                objectArray[2] = "toMultiMap";
                break;
            }
            case 39: {
                objectArray = objectArray;
                objectArray[2] = "isExpectedOutputComments";
                break;
            }
            case 40: {
                objectArray = objectArray;
                objectArray[2] = "getExampleCodeAndOutput";
                break;
            }
            case 41: {
                objectArray = objectArray;
                objectArray[2] = "getOutput";
                break;
            }
            case 43: {
                objectArray = objectArray;
                objectArray[2] = "isMethodExpressionCall";
                break;
            }
            case 44: {
                objectArray = objectArray;
                objectArray[2] = "isMethodExpressionQualifier";
                break;
            }
            case 45: {
                objectArray = objectArray;
                objectArray[2] = "skipParents";
                break;
            }
            case 46: {
                objectArray = objectArray;
                objectArray[2] = "isExportable";
                break;
            }
            case 47: {
                objectArray = objectArray;
                objectArray[2] = "canBePublic";
                break;
            }
            case 48: 
            case 49: {
                objectArray = objectArray;
                objectArray[2] = "isWriteable";
                break;
            }
            case 50: {
                objectArray = objectArray;
                objectArray[2] = "findBaseAliasedTypeSpec";
                break;
            }
            case 51: {
                objectArray = objectArray;
                objectArray[2] = "findBaseAliasedTypeSpecWithSubstitution";
                break;
            }
            case 52: {
                objectArray = objectArray;
                objectArray[2] = "unwrapAlias";
                break;
            }
            case 53: {
                objectArray = objectArray;
                objectArray[2] = "processMapEntries";
                break;
            }
            case 54: {
                objectArray = objectArray;
                objectArray[2] = "isUnexportedAndFromOtherPackage";
                break;
            }
            case 55: {
                objectArray = objectArray;
                objectArray[2] = "isMainFunction";
                break;
            }
            case 56: {
                objectArray = objectArray;
                objectArray[2] = "isInitFunction";
                break;
            }
            case 57: {
                objectArray = objectArray;
                objectArray[2] = "isMainOrInitFunction";
                break;
            }
            case 58: {
                objectArray = objectArray;
                objectArray[2] = "isExpressionInControlElement";
                break;
            }
            case 59: {
                objectArray = objectArray;
                objectArray[2] = "isInControlElementHeader";
                break;
            }
            case 60: 
            case 61: {
                objectArray = objectArray;
                objectArray[2] = "onDifferentLines";
                break;
            }
            case 62: {
                objectArray = objectArray;
                objectArray[2] = "findPsiDirectoryByUrl";
                break;
            }
            case 63: 
            case 64: 
            case 65: 
            case 66: {
                objectArray = objectArray;
                objectArray[2] = "isSameNamedMethod";
                break;
            }
            case 67: {
                objectArray = objectArray;
                objectArray[2] = "allowedDuplicateMethodsFromOverlappingInterfaces";
                break;
            }
            case 68: {
                objectArray = objectArray;
                objectArray[2] = "supportsOverlappingEmbeddedInterfaces";
                break;
            }
            case 69: {
                objectArray = objectArray;
                objectArray[2] = "areIdenticalMethodSpecsFromDistinctInterfaces";
                break;
            }
            case 70: {
                objectArray = objectArray;
                objectArray[2] = "getArguments";
                break;
            }
            case 73: {
                objectArray = objectArray;
                objectArray[2] = "isCallOrConversionWithTypeInstantiation";
                break;
            }
            case 74: {
                objectArray = objectArray;
                objectArray[2] = "resolveInstantiatedDeclaration";
                break;
            }
            case 75: 
            case 76: {
                objectArray = objectArray;
                objectArray[2] = "addLineCommentBefore";
                break;
            }
            case 77: {
                objectArray = objectArray;
                objectArray[2] = "getPackageQualifier";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 14, 33, 36, 37, 38, 42, 71, 72 -> new IllegalStateException(string);
        };
    }
}

