/*
 * Decompiled with CFR 0.152.
 */
package com.goide.project;

import com.goide.GoPluginDisposable;
import com.goide.project.GoOpenedDirectoryConfigurator;
import com.goide.project.GoOpenedDirectoryConfiguratorKt;
import com.goide.project.GoProjectLibrariesService;
import com.goide.vgo.configuration.VgoProjectSettings;
import com.goide.vgo.mod.VgoFileType;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.platform.DirectoryProjectConfigurator;
import com.intellij.psi.search.FileTypeIndex;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.util.concurrency.NonUrgentExecutor;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.Executor;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010 \n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J.\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\n2\u0006\u0010\f\u001a\u00020\rH\u0016J&\u0010\u000e\u001a\u00020\r2\u0006\u0010\u000f\u001a\u00020\u000b2\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\b0\u00112\u0006\u0010\u0007\u001a\u00020\bH\u0002\u00a8\u0006\u0012"}, d2={"Lcom/goide/project/GoOpenedDirectoryConfigurator;", "Lcom/intellij/platform/DirectoryProjectConfigurator;", "()V", "configureProject", "", "project", "Lcom/intellij/openapi/project/Project;", "baseDir", "Lcom/intellij/openapi/vfs/VirtualFile;", "moduleRef", "Lcom/intellij/openapi/util/Ref;", "Lcom/intellij/openapi/module/Module;", "isProjectCreatedWithWizard", "", "isGopathBasedProject", "module", "goPathRoots", "", "intellij.go.impl"})
@SourceDebugExtension(value={"SMAP\nGoOpenedDirectoryConfigurator.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GoOpenedDirectoryConfigurator.kt\ncom/goide/project/GoOpenedDirectoryConfigurator\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,73:1\n1747#2,3:74\n*S KotlinDebug\n*F\n+ 1 GoOpenedDirectoryConfigurator.kt\ncom/goide/project/GoOpenedDirectoryConfigurator\n*L\n59#1:74,3\n*E\n"})
public final class GoOpenedDirectoryConfigurator
implements DirectoryProjectConfigurator {
    public void configureProject(@NotNull Project project, @NotNull VirtualFile baseDir, @NotNull Ref<Module> moduleRef, boolean isProjectCreatedWithWizard) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)baseDir, (String)"baseDir");
        Intrinsics.checkNotNullParameter(moduleRef, (String)"moduleRef");
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            return;
        }
        VgoProjectSettings.getInstance(project).setSettingsMigrated(true);
        if (isProjectCreatedWithWizard) {
            return;
        }
        Module module = (Module)moduleRef.get();
        if (module == null) {
            return;
        }
        ApplicationManager.getApplication().executeOnPooledThread(() -> GoOpenedDirectoryConfigurator.configureProject$lambda$2(project, module, this, baseDir));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean isGopathBasedProject(Module module, List<? extends VirtualFile> goPathRoots, VirtualFile baseDir) {
        VirtualFile root;
        if (module.isDisposed()) return false;
        if (FileTypeIndex.containsFileOfType((FileType)((FileType)VgoFileType.INSTANCE), (GlobalSearchScope)module.getModuleContentScope())) return false;
        Iterable $this$any$iv = goPathRoots;
        boolean $i$f$any = false;
        if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
            return false;
        }
        Iterator iterator = $this$any$iv.iterator();
        do {
            if (!iterator.hasNext()) return false;
            Object element$iv = iterator.next();
            root = (VirtualFile)element$iv;
            boolean bl = false;
        } while (!VfsUtil.isAncestor((VirtualFile)root, (VirtualFile)baseDir, (boolean)true));
        return true;
    }

    private static final Boolean configureProject$lambda$2$lambda$0(GoOpenedDirectoryConfigurator this$0, Module $module, List $goPathRoots, VirtualFile $baseDir) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$goPathRoots, (String)"$goPathRoots");
        Intrinsics.checkNotNullParameter((Object)$baseDir, (String)"$baseDir");
        Intrinsics.checkNotNull((Object)$module);
        return this$0.isGopathBasedProject($module, $goPathRoots, $baseDir);
    }

    private static final Unit configureProject$lambda$2$lambda$1(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (Unit)$tmp0.invoke(p0);
    }

    private static final void configureProject$lambda$2(Project $project, Module $module, GoOpenedDirectoryConfigurator this$0, VirtualFile $baseDir) {
        Intrinsics.checkNotNullParameter((Object)$project, (String)"$project");
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$baseDir, (String)"$baseDir");
        if ($project.isDisposed()) {
            return;
        }
        List goPathRoots = GoOpenedDirectoryConfiguratorKt.access$getGoPathRoots($project);
        ReadAction.nonBlocking(() -> GoOpenedDirectoryConfigurator.configureProject$lambda$2$lambda$0(this$0, $module, goPathRoots, $baseDir)).inSmartMode($project).expireWith(GoPluginDisposable.getInstance($module)).submit((Executor)NonUrgentExecutor.getInstance()).then(arg_0 -> GoOpenedDirectoryConfigurator.configureProject$lambda$2$lambda$1((Function1)new Function1<Boolean, Unit>($project){
            final /* synthetic */ Project $project;
            {
                this.$project = $project;
                super(1);
            }

            public final void invoke(Boolean isGopathBasedProject) {
                ApplicationManager.getApplication().invokeLater(() -> configureProject.1.2.invoke$lambda$0(this.$project, isGopathBasedProject));
            }

            private static final void invoke$lambda$0(Project $project, Boolean $isGopathBasedProject) {
                Intrinsics.checkNotNullParameter((Object)$project, (String)"$project");
                if (!$project.isDisposed()) {
                    Intrinsics.checkNotNull((Object)$isGopathBasedProject);
                    if ($isGopathBasedProject.booleanValue()) {
                        GoProjectLibrariesService.getInstance($project).setIndexEntireGopath(true);
                        VgoProjectSettings.getInstance($project).setIntegrationEnabled(false);
                    }
                }
            }
        }, arg_0));
    }
}

