/*
 * Decompiled with CFR 0.152.
 */
package com.goide.project;

import com.goide.GoLibrariesUtil;
import com.goide.GoOsManager;
import com.goide.project.GoApplicationLibrariesService;
import com.goide.project.GoLibrariesState;
import com.goide.project.GoModuleLibrariesService;
import com.goide.project.GoProjectLibrariesService;
import com.goide.sdk.GoSdk;
import com.goide.sdk.GoSdkService;
import com.goide.sdk.combobox.GoSdkPathDiscoverer;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.RootsChangeRescanningInfo;
import com.intellij.openapi.util.ModificationTracker;
import com.intellij.openapi.util.SimpleModificationTracker;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.messages.Topic;
import com.intellij.util.xmlb.XmlSerializerUtil;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class GoLibrariesService<T extends GoLibrariesState>
extends SimpleModificationTracker
implements PersistentStateComponent<T> {
    public static final Topic<LibrariesListener> LIBRARIES_TOPIC = Topic.create((String)"libraries changes", LibrariesListener.class);
    protected final T myState;

    protected GoLibrariesService(@NotNull T state) {
        if (state == null) {
            GoLibrariesService.$$$reportNull$$$0(0);
        }
        this.myState = state;
    }

    @NotNull
    public T getState() {
        T t = this.myState;
        if (t == null) {
            GoLibrariesService.$$$reportNull$$$0(1);
        }
        return t;
    }

    public void loadState(@NotNull T state) {
        if (state == null) {
            GoLibrariesService.$$$reportNull$$$0(2);
        }
        XmlSerializerUtil.copyBean(state, this.myState);
    }

    @NotNull
    public static Collection<? extends VirtualFile> getUserDefinedLibraries(@NotNull Module module) {
        if (module == null) {
            GoLibrariesService.$$$reportNull$$$0(3);
        }
        LinkedHashSet<VirtualFile> result = new LinkedHashSet<VirtualFile>();
        result.addAll(GoLibrariesService.goRootsFromUrls(GoModuleLibrariesService.getInstance(module).getLibraryRootUrls()));
        result.addAll(GoLibrariesService.getUserDefinedLibraries(module.getProject()));
        LinkedHashSet<VirtualFile> linkedHashSet = result;
        if (linkedHashSet == null) {
            GoLibrariesService.$$$reportNull$$$0(4);
        }
        return linkedHashSet;
    }

    @NotNull
    public static Collection<? extends VirtualFile> getUserDefinedLibraries(@NotNull Project project) {
        if (project == null) {
            GoLibrariesService.$$$reportNull$$$0(5);
        }
        LinkedHashSet<VirtualFile> result = new LinkedHashSet<VirtualFile>();
        if (project.isDisposed()) {
            LinkedHashSet<VirtualFile> linkedHashSet = result;
            if (linkedHashSet == null) {
                GoLibrariesService.$$$reportNull$$$0(6);
            }
            return linkedHashSet;
        }
        result.addAll(GoLibrariesService.goRootsFromUrls(GoProjectLibrariesService.getInstance(project).getLibraryRootUrls()));
        result.addAll(GoLibrariesService.getUserDefinedLibraries());
        LinkedHashSet<VirtualFile> linkedHashSet = result;
        if (linkedHashSet == null) {
            GoLibrariesService.$$$reportNull$$$0(7);
        }
        return linkedHashSet;
    }

    @NotNull
    public static Collection<? extends VirtualFile> getUserDefinedLibraries() {
        return GoLibrariesService.goRootsFromUrls(GoApplicationLibrariesService.getInstance().getLibraryRootUrls());
    }

    @NotNull
    public static Collection<VirtualFile> getAsdfDefinedLibraries(@NotNull Project project, @Nullable Module module) {
        VirtualFile packagesDir;
        VirtualFile parent;
        if (project == null) {
            GoLibrariesService.$$$reportNull$$$0(8);
        }
        if (GoOsManager.isWindows()) {
            List<VirtualFile> list = Collections.emptyList();
            if (list == null) {
                GoLibrariesService.$$$reportNull$$$0(9);
            }
            return list;
        }
        GoSdk sdk = GoSdkService.getInstance(project).getSdk(module);
        VirtualFile sdkRoot = sdk.getSdkRoot();
        Path asdfInstallsDir = GoSdkPathDiscoverer.findAsdfInstallsDir();
        if (asdfInstallsDir != null && sdkRoot != null && sdkRoot.getName().equals("go") && VfsUtilCore.isAncestorOrSelf((String)asdfInstallsDir.toString(), (VirtualFile)sdkRoot) && (parent = sdkRoot.getParent()) != null && (packagesDir = parent.findChild("packages")) != null && packagesDir.isDirectory()) {
            List<VirtualFile> list = List.of(packagesDir);
            if (list == null) {
                GoLibrariesService.$$$reportNull$$$0(10);
            }
            return list;
        }
        List<VirtualFile> list = Collections.emptyList();
        if (list == null) {
            GoLibrariesService.$$$reportNull$$$0(11);
        }
        return list;
    }

    public static ModificationTracker @NotNull [] getModificationTrackers(@NotNull Project project, @Nullable Module module) {
        ModificationTracker[] modificationTrackerArray;
        if (project == null) {
            GoLibrariesService.$$$reportNull$$$0(12);
        }
        if (module != null) {
            ModificationTracker[] modificationTrackerArray2 = new ModificationTracker[3];
            modificationTrackerArray2[0] = GoProjectLibrariesService.getInstance(module.getProject());
            modificationTrackerArray2[1] = GoApplicationLibrariesService.getInstance();
            modificationTrackerArray = modificationTrackerArray2;
            modificationTrackerArray2[2] = GoModuleLibrariesService.getInstance(module);
        } else {
            ModificationTracker[] modificationTrackerArray3 = new ModificationTracker[2];
            modificationTrackerArray3[0] = GoProjectLibrariesService.getInstance(project);
            modificationTrackerArray = modificationTrackerArray3;
            modificationTrackerArray3[1] = GoApplicationLibrariesService.getInstance();
        }
        if (modificationTrackerArray == null) {
            GoLibrariesService.$$$reportNull$$$0(13);
        }
        return modificationTrackerArray;
    }

    public void setLibraryRootUrls(String ... libraryRootUrls) {
        if (libraryRootUrls == null) {
            GoLibrariesService.$$$reportNull$$$0(14);
        }
        this.setLibraryRootUrls(Arrays.asList(libraryRootUrls));
    }

    public void setLibraryRootUrls(@NotNull Collection<String> libraryRootUrls) {
        if (libraryRootUrls == null) {
            GoLibrariesService.$$$reportNull$$$0(15);
        }
        if (!((GoLibrariesState)this.myState).getUrls().equals(libraryRootUrls)) {
            this.notifyProjectsAboutChangedRoots(RootsChangeRescanningInfo.RESCAN_DEPENDENCIES_IF_NEEDED, () -> {
                ((GoLibrariesState)this.myState).setUrls(libraryRootUrls);
                this.incModificationCount();
            }, () -> ((LibrariesListener)ApplicationManager.getApplication().getMessageBus().syncPublisher(LIBRARIES_TOPIC)).librariesChanged(libraryRootUrls));
        }
    }

    protected void notifyProjectsAboutChangedRoots(@NotNull RootsChangeRescanningInfo info, @NotNull Runnable changeRoots, @NotNull Runnable after) {
        if (info == null) {
            GoLibrariesService.$$$reportNull$$$0(16);
        }
        if (changeRoots == null) {
            GoLibrariesService.$$$reportNull$$$0(17);
        }
        if (after == null) {
            GoLibrariesService.$$$reportNull$$$0(18);
        }
        for (Project project : this.getProjectsToNotify()) {
            GoLibrariesUtil.updateLibraries(project, info, changeRoots, after);
        }
    }

    protected abstract Project @NotNull [] getProjectsToNotify();

    @NotNull
    public Collection<String> getLibraryRootUrls() {
        Collection<String> collection = ((GoLibrariesState)this.myState).getUrls();
        if (collection == null) {
            GoLibrariesService.$$$reportNull$$$0(19);
        }
        return collection;
    }

    @NotNull
    private static Collection<? extends VirtualFile> goRootsFromUrls(@NotNull Collection<String> urls) {
        if (urls == null) {
            GoLibrariesService.$$$reportNull$$$0(20);
        }
        List list = ContainerUtil.mapNotNull(urls, url -> VirtualFileManager.getInstance().findFileByUrl(url));
        if (list == null) {
            GoLibrariesService.$$$reportNull$$$0(21);
        }
        return list;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 4, 6, 7, 9, 10, 11, 13, 19, 21 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
            case 1: 
            case 4: 
            case 6: 
            case 7: 
            case 9: 
            case 10: 
            case 11: 
            case 13: 
            case 19: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/goide/project/GoLibrariesService";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 5: 
            case 8: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 14: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "libraryRootUrls";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "info";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "changeRoots";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "after";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "urls";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/goide/project/GoLibrariesService";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getState";
                break;
            }
            case 4: 
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getUserDefinedLibraries";
                break;
            }
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getAsdfDefinedLibraries";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getModificationTrackers";
                break;
            }
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "getLibraryRootUrls";
                break;
            }
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "goRootsFromUrls";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 4: 
            case 6: 
            case 7: 
            case 9: 
            case 10: 
            case 11: 
            case 13: 
            case 19: 
            case 21: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "loadState";
                break;
            }
            case 3: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getUserDefinedLibraries";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getAsdfDefinedLibraries";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "getModificationTrackers";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "setLibraryRootUrls";
                break;
            }
            case 16: 
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "notifyProjectsAboutChangedRoots";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "goRootsFromUrls";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 4, 6, 7, 9, 10, 11, 13, 19, 21 -> new IllegalStateException(string);
        };
    }

    public static interface LibrariesListener {
        public void librariesChanged(@NotNull Collection<String> var1);
    }
}

