/*
 * Decompiled with CFR 0.152.
 */
package com.goide.microservices;

import com.goide.GoGeneratedIcons;
import com.goide.i18n.GoBundle;
import com.goide.microservices.GoHttpServerModelKt;
import com.goide.microservices.GoLangModificationTracker;
import com.goide.microservices.GoUrlData;
import com.goide.psi.GoExpression;
import com.goide.psi.GoFile;
import com.goide.sdk.GoSdkUtil;
import com.intellij.microservices.endpoints.EndpointType;
import com.intellij.microservices.endpoints.EndpointTypes;
import com.intellij.microservices.endpoints.EndpointsFilter;
import com.intellij.microservices.endpoints.EndpointsProvider;
import com.intellij.microservices.endpoints.EndpointsUrlTargetProvider;
import com.intellij.microservices.endpoints.FrameworkPresentation;
import com.intellij.microservices.endpoints.SearchScopeEndpointsFilter;
import com.intellij.microservices.endpoints.presentation.HttpMethodPresentation;
import com.intellij.microservices.url.UrlTargetInfo;
import com.intellij.navigation.ItemPresentation;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.ServicesKt;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.ModificationTracker;
import com.intellij.psi.PsiElement;
import java.util.Collection;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.VisibleForTesting;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000`\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u001c\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\b\u0007\u0018\u00002\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001B\u0005\u00a2\u0006\u0002\u0010\u0004J\u001a\u0010\r\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\u000f\u001a\u00020\u00022\u0006\u0010\u0010\u001a\u00020\u0003H\u0016J\u001e\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016H\u0016J\u0018\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u000f\u001a\u00020\u00022\u0006\u0010\u0010\u001a\u00020\u0003H\u0016J\u0016\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u00030\u00122\u0006\u0010\u000f\u001a\u00020\u0002H\u0016J\u0010\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u0013\u001a\u00020\u0014H\u0016J\u001a\u0010\u001c\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\u000f\u001a\u00020\u00022\u0006\u0010\u0010\u001a\u00020\u0003H\u0016J\u0010\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u0013\u001a\u00020\u0014H\u0016J\u001e\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020 0\u00122\u0006\u0010\u000f\u001a\u00020\u00022\u0006\u0010\u0010\u001a\u00020\u0003H\u0016J\u0018\u0010!\u001a\u00020\"2\u0006\u0010\u000f\u001a\u00020\u00022\u0006\u0010\u0010\u001a\u00020\u0003H\u0016R\u0014\u0010\u0005\u001a\u00020\u00068VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\bR\u0014\u0010\t\u001a\u00020\nX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\f\u00a8\u0006#"}, d2={"Lcom/goide/microservices/GoHttpEndpointsProvider;", "Lcom/intellij/microservices/endpoints/EndpointsUrlTargetProvider;", "Lcom/goide/psi/GoFile;", "Lcom/goide/microservices/GoUrlData;", "()V", "endpointType", "Lcom/intellij/microservices/endpoints/EndpointType;", "getEndpointType", "()Lcom/intellij/microservices/endpoints/EndpointType;", "presentation", "Lcom/intellij/microservices/endpoints/FrameworkPresentation;", "getPresentation", "()Lcom/intellij/microservices/endpoints/FrameworkPresentation;", "getDocumentationElement", "Lcom/intellij/psi/PsiElement;", "group", "endpoint", "getEndpointGroups", "", "project", "Lcom/intellij/openapi/project/Project;", "filter", "Lcom/intellij/microservices/endpoints/EndpointsFilter;", "getEndpointPresentation", "Lcom/intellij/navigation/ItemPresentation;", "getEndpoints", "getModificationTracker", "Lcom/intellij/openapi/util/ModificationTracker;", "getNavigationElement", "getStatus", "Lcom/intellij/microservices/endpoints/EndpointsProvider$Status;", "getUrlTargetInfo", "Lcom/intellij/microservices/url/UrlTargetInfo;", "isValidEndpoint", "", "intellij.go.microservices"})
@VisibleForTesting
@SourceDebugExtension(value={"SMAP\nGoHttpEndpointsProvider.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GoHttpEndpointsProvider.kt\ncom/goide/microservices/GoHttpEndpointsProvider\n+ 2 services.kt\ncom/intellij/openapi/components/ServicesKt\n*L\n1#1,65:1\n31#2,2:66\n*S KotlinDebug\n*F\n+ 1 GoHttpEndpointsProvider.kt\ncom/goide/microservices/GoHttpEndpointsProvider\n*L\n63#1:66,2\n*E\n"})
public final class GoHttpEndpointsProvider
implements EndpointsUrlTargetProvider<GoFile, GoUrlData> {
    @NotNull
    private final FrameworkPresentation presentation;

    public GoHttpEndpointsProvider() {
        String string = GoBundle.message((String)"go.microservices.http.server.endpoint.title", (Object[])new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        this.presentation = new FrameworkPresentation("GoHttpServer", string, GoGeneratedIcons.GO);
    }

    @NotNull
    public EndpointType getEndpointType() {
        return EndpointTypes.HTTP_SERVER_TYPE;
    }

    @NotNull
    public FrameworkPresentation getPresentation() {
        return this.presentation;
    }

    @NotNull
    public EndpointsProvider.Status getStatus(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Collection<Module> collection = GoSdkUtil.getGoModules(project);
        Intrinsics.checkNotNullExpressionValue(collection, (String)"getGoModules(...)");
        return !collection.isEmpty() ? EndpointsProvider.Status.AVAILABLE : EndpointsProvider.Status.UNAVAILABLE;
    }

    @NotNull
    public Iterable<GoFile> getEndpointGroups(@NotNull Project project, @NotNull EndpointsFilter filter) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)filter, (String)"filter");
        if (!(filter instanceof SearchScopeEndpointsFilter)) {
            return CollectionsKt.emptyList();
        }
        return GoHttpServerModelKt.findGoFilesWithServerDeclarations(project, ((SearchScopeEndpointsFilter)filter).getTransitiveSearchScope());
    }

    @NotNull
    public Iterable<GoUrlData> getEndpoints(@NotNull GoFile group) {
        Intrinsics.checkNotNullParameter((Object)((Object)group), (String)"group");
        return GoHttpServerModelKt.getOrComputeEndpointsInFile(group);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean isValidEndpoint(@NotNull GoFile group, @NotNull GoUrlData endpoint) {
        Intrinsics.checkNotNullParameter((Object)((Object)group), (String)"group");
        Intrinsics.checkNotNullParameter((Object)endpoint, (String)"endpoint");
        if (!group.isValid()) return false;
        GoExpression goExpression = endpoint.getSourcePsi();
        if (goExpression == null) return false;
        boolean bl = goExpression.isValid();
        if (!bl) return false;
        return true;
    }

    @NotNull
    public ItemPresentation getEndpointPresentation(@NotNull GoFile group, @NotNull GoUrlData endpoint) {
        Intrinsics.checkNotNullParameter((Object)((Object)group), (String)"group");
        Intrinsics.checkNotNullParameter((Object)endpoint, (String)"endpoint");
        return (ItemPresentation)new HttpMethodPresentation(endpoint.getUrl(), "*", null, GoGeneratedIcons.GO, null);
    }

    @Nullable
    public PsiElement getDocumentationElement(@NotNull GoFile group, @NotNull GoUrlData endpoint) {
        Intrinsics.checkNotNullParameter((Object)((Object)group), (String)"group");
        Intrinsics.checkNotNullParameter((Object)endpoint, (String)"endpoint");
        return null;
    }

    @Nullable
    public PsiElement getNavigationElement(@NotNull GoFile group, @NotNull GoUrlData endpoint) {
        Intrinsics.checkNotNullParameter((Object)((Object)group), (String)"group");
        Intrinsics.checkNotNullParameter((Object)endpoint, (String)"endpoint");
        return endpoint.getSourcePsi();
    }

    @NotNull
    public Iterable<UrlTargetInfo> getUrlTargetInfo(@NotNull GoFile group, @NotNull GoUrlData endpoint) {
        Intrinsics.checkNotNullParameter((Object)((Object)group), (String)"group");
        Intrinsics.checkNotNullParameter((Object)endpoint, (String)"endpoint");
        return CollectionsKt.listOf((Object)GoHttpServerModelKt.createUrlTargetInfo(endpoint));
    }

    @NotNull
    public ModificationTracker getModificationTracker(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        ComponentManager $this$service$iv = (ComponentManager)project;
        boolean $i$f$service = false;
        Class<GoLangModificationTracker> serviceClass$iv = GoLangModificationTracker.class;
        Object object = $this$service$iv.getService(serviceClass$iv);
        if (object == null) {
            throw ServicesKt.serviceNotFoundError((ComponentManager)$this$service$iv, serviceClass$iv);
        }
        return (ModificationTracker)object;
    }
}

