/*
 * Decompiled with CFR 0.152.
 */
package com.goide.intentions.expressions.structLiteral;

import com.goide.inspections.GoInspectionUtil;
import com.goide.psi.GoElement;
import com.goide.psi.GoFieldName;
import com.goide.psi.GoKey;
import com.goide.psi.GoLiteralValue;
import com.goide.psi.GoNamedElement;
import com.goide.psi.GoStructType;
import com.goide.psi.GoType;
import com.goide.util.GoUtil;
import com.intellij.openapi.util.Pair;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GoFillStructInfo {
    @NotNull
    private final GoLiteralValue literalValue;
    @NotNull
    private final GoStructType structType;
    @NotNull
    private final Map<GoNamedElement, GoElement> filledFields;

    GoFillStructInfo(@NotNull GoLiteralValue value, @NotNull GoStructType type2, @NotNull Map<GoNamedElement, GoElement> filled) {
        if (value == null) {
            GoFillStructInfo.$$$reportNull$$$0(0);
        }
        if (type2 == null) {
            GoFillStructInfo.$$$reportNull$$$0(1);
        }
        if (filled == null) {
            GoFillStructInfo.$$$reportNull$$$0(2);
        }
        this.literalValue = value;
        this.structType = type2;
        this.filledFields = filled;
    }

    @NotNull
    public GoLiteralValue getLiteralValue() {
        GoLiteralValue goLiteralValue = this.literalValue;
        if (goLiteralValue == null) {
            GoFillStructInfo.$$$reportNull$$$0(3);
        }
        return goLiteralValue;
    }

    @NotNull
    public GoStructType getStructType() {
        GoStructType goStructType = this.structType;
        if (goStructType == null) {
            GoFillStructInfo.$$$reportNull$$$0(4);
        }
        return goStructType;
    }

    @NotNull
    public Map<GoNamedElement, GoElement> getFilledFields() {
        Map<GoNamedElement, GoElement> map = this.filledFields;
        if (map == null) {
            GoFillStructInfo.$$$reportNull$$$0(5);
        }
        return map;
    }

    @Nullable
    public static GoFillStructInfo get(@NotNull PsiElement context, boolean allowEmptyLiteral, boolean allowAllFieldsFilled, boolean forCompletion) {
        GoElement ignoredElement;
        Pair<GoLiteralValue, GoType> pair;
        if (context == null) {
            GoFillStructInfo.$$$reportNull$$$0(6);
        }
        if ((pair = GoInspectionUtil.findValueAndStructType(context)) == null) {
            return null;
        }
        GoLiteralValue literalValue = (GoLiteralValue)pair.first;
        List<GoElement> elementList = literalValue.getElementList();
        if (!allowEmptyLiteral && elementList.isEmpty()) {
            return null;
        }
        GoElement goElement = ignoredElement = forCompletion ? (GoElement)PsiTreeUtil.getParentOfType((PsiElement)context, GoElement.class) : null;
        if (GoFillStructInfo.hasElementsWithoutKey(elementList, ignoredElement)) {
            return null;
        }
        GoStructType structType = (GoStructType)ObjectUtils.tryCast((Object)pair.second, GoStructType.class);
        if (structType == null) {
            return null;
        }
        List<GoNamedElement> fields = structType.getFieldDefinitions();
        if (fields.isEmpty()) {
            return null;
        }
        int availableFieldsCount = GoFillStructInfo.getAccessibleFieldsCount(structType, fields, context);
        if (availableFieldsCount == 0 || forCompletion && availableFieldsCount < 2) {
            return null;
        }
        Map<GoNamedElement, GoElement> filledFields = GoFillStructInfo.getFilledFields(elementList, fields);
        if (!allowAllFieldsFilled && !GoFillStructInfo.hasFieldsWithoutValue(structType, filledFields)) {
            return null;
        }
        if (forCompletion && availableFieldsCount - filledFields.size() < 2) {
            return null;
        }
        return new GoFillStructInfo(literalValue, structType, filledFields);
    }

    private static boolean hasElementsWithoutKey(@NotNull List<GoElement> elements, @Nullable GoElement ignoredElement) {
        if (elements == null) {
            GoFillStructInfo.$$$reportNull$$$0(7);
        }
        return ContainerUtil.or(elements, e -> e != ignoredElement && e.getKey() == null);
    }

    public static int getAccessibleFieldsCount(@NotNull GoStructType structType, @NotNull List<GoNamedElement> fields, @NotNull PsiElement context) {
        if (structType == null) {
            GoFillStructInfo.$$$reportNull$$$0(8);
        }
        if (fields == null) {
            GoFillStructInfo.$$$reportNull$$$0(9);
        }
        if (context == null) {
            GoFillStructInfo.$$$reportNull$$$0(10);
        }
        boolean isStructFromCurrentPackage = GoUtil.isDirectlyAccessible(structType.getContainingFile(), context.getContainingFile());
        return ContainerUtil.count(fields, f -> GoInspectionUtil.canAccessField(f, isStructFromCurrentPackage));
    }

    private static boolean hasFieldsWithoutValue(@NotNull GoStructType structType, @NotNull Map<GoNamedElement, GoElement> filledFields) {
        if (structType == null) {
            GoFillStructInfo.$$$reportNull$$$0(11);
        }
        if (filledFields == null) {
            GoFillStructInfo.$$$reportNull$$$0(12);
        }
        return ContainerUtil.or(structType.getFieldDefinitions(), f -> !filledFields.containsKey(f));
    }

    @NotNull
    private static Map<GoNamedElement, GoElement> getFilledFields(@NotNull List<GoElement> literalElements, @NotNull List<GoNamedElement> structFields) {
        if (literalElements == null) {
            GoFillStructInfo.$$$reportNull$$$0(13);
        }
        if (structFields == null) {
            GoFillStructInfo.$$$reportNull$$$0(14);
        }
        HashMap<GoNamedElement, GoElement> filledFields = new HashMap<GoNamedElement, GoElement>();
        for (GoElement element : literalElements) {
            GoKey key = element.getKey();
            GoFieldName fieldName = key != null ? key.getFieldName() : null;
            PsiElement resolve2 = fieldName != null ? fieldName.resolve() : null;
            if (!(resolve2 instanceof GoNamedElement) || !structFields.contains(resolve2)) continue;
            filledFields.put((GoNamedElement)resolve2, element);
        }
        HashMap<GoNamedElement, GoElement> hashMap = filledFields;
        if (hashMap == null) {
            GoFillStructInfo.$$$reportNull$$$0(15);
        }
        return hashMap;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 3, 4, 5, 15 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "value";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "filled";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/goide/intentions/expressions/structLiteral/GoFillStructInfo";
                break;
            }
            case 6: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elements";
                break;
            }
            case 8: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "structType";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fields";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "filledFields";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "literalElements";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "structFields";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/goide/intentions/expressions/structLiteral/GoFillStructInfo";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getLiteralValue";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getStructType";
                break;
            }
            case 5: 
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "getFilledFields";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 15: {
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "get";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "hasElementsWithoutKey";
                break;
            }
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "getAccessibleFieldsCount";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "hasFieldsWithoutValue";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "getFilledFields";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 3, 4, 5, 15 -> new IllegalStateException(string);
        };
    }
}

