/*
 * Decompiled with CFR 0.152.
 */
package com.goide.intentions.expressions;

import com.goide.GoTypes;
import com.goide.formatter.GoFormatterUtil;
import com.goide.i18n.GoBundle;
import com.goide.intentions.GoBaseIntentionAction;
import com.goide.psi.GoBinaryExpr;
import com.goide.psi.GoConditionalExpr;
import com.goide.psi.GoExpression;
import com.goide.psi.GoFunctionLit;
import com.goide.psi.GoStatement;
import com.goide.psi.impl.GoElementFactory;
import com.goide.psi.impl.GoExpressionUtil;
import com.goide.stubs.GoTokenSets;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.ObjectUtils;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class GoFlipBinaryOperatorIntention
extends GoBaseIntentionAction {
    @Nls
    @NotNull
    public String getFamilyName() {
        String string = GoBundle.message((String)"go.intention.flip.binary.operator.name", (Object[])new Object[0]);
        if (string == null) {
            GoFlipBinaryOperatorIntention.$$$reportNull$$$0(0);
        }
        return string;
    }

    @Override
    public boolean isAvailable(@NotNull Project project, @NotNull Editor editor, @NotNull PsiElement element) {
        GoBinaryExpr binaryExpr;
        PsiElement operator;
        if (project == null) {
            GoFlipBinaryOperatorIntention.$$$reportNull$$$0(1);
        }
        if (editor == null) {
            GoFlipBinaryOperatorIntention.$$$reportNull$$$0(2);
        }
        if (element == null) {
            GoFlipBinaryOperatorIntention.$$$reportNull$$$0(3);
        }
        PsiElement psiElement = operator = (binaryExpr = GoFlipBinaryOperatorIntention.binaryExpression(element)) != null ? binaryExpr.getOperator() : null;
        if (operator == null || binaryExpr.getRight() == null) {
            return false;
        }
        GoExpression left = binaryExpr.getLeft();
        if (left instanceof GoConditionalExpr && binaryExpr instanceof GoConditionalExpr) {
            return false;
        }
        this.setText(GoFlipBinaryOperatorIntention.intentionName(operator));
        return true;
    }

    public void invoke(@NotNull Project project, @NotNull Editor editor, @NotNull PsiElement element) throws IncorrectOperationException {
        GoBinaryExpr binaryExpr;
        PsiElement operator;
        if (project == null) {
            GoFlipBinaryOperatorIntention.$$$reportNull$$$0(4);
        }
        if (editor == null) {
            GoFlipBinaryOperatorIntention.$$$reportNull$$$0(5);
        }
        if (element == null) {
            GoFlipBinaryOperatorIntention.$$$reportNull$$$0(6);
        }
        PsiElement psiElement = operator = (binaryExpr = GoFlipBinaryOperatorIntention.binaryExpression(element)) != null ? binaryExpr.getOperator() : null;
        if (operator == null) {
            return;
        }
        GoExpression right = binaryExpr.getRight();
        if (right == null) {
            return;
        }
        GoExpression left = binaryExpr.getLeft();
        if (left instanceof GoBinaryExpr) {
            GoBinaryExpr leftBinaryExpr = (GoBinaryExpr)left;
            if (leftBinaryExpr instanceof GoConditionalExpr && binaryExpr instanceof GoConditionalExpr) {
                return;
            }
            IElementType leftOperator = GoExpressionUtil.getOperatorType(leftBinaryExpr);
            if (leftOperator != operator.getNode().getElementType()) {
                GoFlipBinaryOperatorIntention.simpleFlip(project, binaryExpr, operator, left, right);
                return;
            }
            GoExpression leftExpressionRightOperand = leftBinaryExpr.getRight();
            if (leftExpressionRightOperand == null) {
                GoFlipBinaryOperatorIntention.simpleFlip(project, binaryExpr, operator, left, right);
                return;
            }
            GoExpression leftExpressionLeftOperand = leftBinaryExpr.getLeft();
            String operatorText = operator.getText();
            String flipped = leftExpressionLeftOperand.getText() + operatorText + right.getText() + operatorText + leftExpressionRightOperand.getText();
            GoFormatterUtil.reformat(binaryExpr.replace(GoElementFactory.createExpression(project, flipped)));
            return;
        }
        GoFlipBinaryOperatorIntention.simpleFlip(project, binaryExpr, operator, left, right);
    }

    private static void simpleFlip(@NotNull Project project, @NotNull GoBinaryExpr binaryExpr, @NotNull PsiElement operator, @NotNull PsiElement left, @NotNull PsiElement right) {
        if (project == null) {
            GoFlipBinaryOperatorIntention.$$$reportNull$$$0(7);
        }
        if (binaryExpr == null) {
            GoFlipBinaryOperatorIntention.$$$reportNull$$$0(8);
        }
        if (operator == null) {
            GoFlipBinaryOperatorIntention.$$$reportNull$$$0(9);
        }
        if (left == null) {
            GoFlipBinaryOperatorIntention.$$$reportNull$$$0(10);
        }
        if (right == null) {
            GoFlipBinaryOperatorIntention.$$$reportNull$$$0(11);
        }
        GoFormatterUtil.reformat(binaryExpr.replace(GoElementFactory.createExpression(project, right.getText() + GoFlipBinaryOperatorIntention.flippedOperatorText(operator) + left.getText())));
    }

    @Nullable
    private static GoBinaryExpr binaryExpression(@NotNull PsiElement element) {
        if (element == null) {
            GoFlipBinaryOperatorIntention.$$$reportNull$$$0(12);
        }
        PsiElement parent = PsiTreeUtil.getParentOfType((PsiElement)element, (Class[])new Class[]{GoBinaryExpr.class, GoStatement.class, GoFunctionLit.class});
        return (GoBinaryExpr)ObjectUtils.tryCast((Object)parent, GoBinaryExpr.class);
    }

    @NotNull
    private static String flippedOperatorText(@NotNull PsiElement operator) {
        IElementType operatorType;
        if (operator == null) {
            GoFlipBinaryOperatorIntention.$$$reportNull$$$0(13);
        }
        if (GoTypes.LESS.equals(operatorType = operator.getNode().getElementType())) {
            return ">";
        }
        if (GoTypes.LESS_OR_EQUAL.equals(operatorType)) {
            return ">=";
        }
        if (GoTypes.GREATER.equals(operatorType)) {
            return "<";
        }
        if (GoTypes.GREATER_OR_EQUAL.equals(operatorType)) {
            return "<=";
        }
        String string = operator.getText();
        if (string == null) {
            GoFlipBinaryOperatorIntention.$$$reportNull$$$0(14);
        }
        return string;
    }

    @NotNull
    @Nls
    private static String intentionName(@NotNull PsiElement operator) {
        String operatorText;
        if (operator == null) {
            GoFlipBinaryOperatorIntention.$$$reportNull$$$0(15);
        }
        if (GoTokenSets.ASYMMETRIC_ARITHMETIC_OPERATORS.contains(operator.getNode().getElementType())) {
            String string = GoBundle.message((String)"go.intention.flip.binary.operator.changes.semantics.text", (Object[])new Object[]{operator.getText()});
            if (string == null) {
                GoFlipBinaryOperatorIntention.$$$reportNull$$$0(16);
            }
            return string;
        }
        String flippedOperatorText = GoFlipBinaryOperatorIntention.flippedOperatorText(operator);
        String string = !flippedOperatorText.equals(operatorText = operator.getText()) ? GoBundle.message((String)"go.intention.flip.binary.operator.changes.operator.text", (Object[])new Object[]{operatorText, flippedOperatorText}) : GoBundle.message((String)"go.intention.flip.binary.operator.text", (Object[])new Object[]{operatorText});
        if (string == null) {
            GoFlipBinaryOperatorIntention.$$$reportNull$$$0(17);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 15 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/goide/intentions/expressions/GoFlipBinaryOperatorIntention";
                break;
            }
            case 1: 
            case 4: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 3: 
            case 6: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "binaryExpr";
                break;
            }
            case 9: 
            case 13: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "operator";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "left";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "right";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "com/goide/intentions/expressions/GoFlipBinaryOperatorIntention";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "flippedOperatorText";
                break;
            }
            case 16: 
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "intentionName";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "isAvailable";
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "invoke";
                break;
            }
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "simpleFlip";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "binaryExpression";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "flippedOperatorText";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "intentionName";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 15 -> new IllegalArgumentException(string);
        };
    }
}

