/*
 * Decompiled with CFR 0.152.
 */
package com.goide.intentions;

import com.goide.formatter.GoFormatterUtil;
import com.goide.i18n.GoBundle;
import com.goide.intentions.GoBaseIntentionAction;
import com.goide.psi.GoAssignmentStatement;
import com.goide.psi.GoCompositeLit;
import com.goide.psi.GoElement;
import com.goide.psi.GoExpression;
import com.goide.psi.GoFieldName;
import com.goide.psi.GoKey;
import com.goide.psi.GoLiteralValue;
import com.goide.psi.GoNamedElement;
import com.goide.psi.GoReferenceExpression;
import com.goide.psi.GoResolvable;
import com.goide.psi.GoShortVarDeclaration;
import com.goide.psi.GoSimpleStatement;
import com.goide.psi.GoStatement;
import com.goide.psi.GoStructType;
import com.goide.psi.GoType;
import com.goide.psi.GoVarDefinition;
import com.goide.psi.impl.GoElementFactory;
import com.goide.psi.impl.GoPsiImplUtil;
import com.goide.psi.impl.GoPsiUtil;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.MultiMap;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class GoMoveToStructInitializationIntention
extends GoBaseIntentionAction {
    @Nls(capitalization=Nls.Capitalization.Sentence)
    @NotNull
    public String getText() {
        String string = this.getFamilyName();
        if (string == null) {
            GoMoveToStructInitializationIntention.$$$reportNull$$$0(0);
        }
        return string;
    }

    @Nls
    @NotNull
    public String getFamilyName() {
        String string = GoBundle.message((String)"go.intention.move.to.struct.initialization.name", (Object[])new Object[0]);
        if (string == null) {
            GoMoveToStructInitializationIntention.$$$reportNull$$$0(1);
        }
        return string;
    }

    @Override
    public boolean isAvailable(@NotNull Project project, @NotNull Editor editor, @NotNull PsiElement element) {
        if (project == null) {
            GoMoveToStructInitializationIntention.$$$reportNull$$$0(2);
        }
        if (editor == null) {
            GoMoveToStructInitializationIntention.$$$reportNull$$$0(3);
        }
        if (element == null) {
            GoMoveToStructInitializationIntention.$$$reportNull$$$0(4);
        }
        return GoMoveToStructInitializationIntention.getData(element) != null;
    }

    @Nullable
    private static Data getData(@NotNull PsiElement element) {
        GoCompositeLit compositeLit;
        if (element == null) {
            GoMoveToStructInitializationIntention.$$$reportNull$$$0(5);
        }
        if (!element.isValid()) {
            return null;
        }
        GoAssignmentStatement assignment = GoMoveToStructInitializationIntention.getValidAssignmentParent(element);
        GoReferenceExpression selectedFieldReference = assignment != null ? GoMoveToStructInitializationIntention.getFieldReferenceExpression(element, assignment) : null;
        GoCompositeLit goCompositeLit = compositeLit = selectedFieldReference != null ? GoMoveToStructInitializationIntention.getStructLiteralByReference(selectedFieldReference, assignment) : null;
        if (compositeLit == null) {
            return null;
        }
        List<GoReferenceExpression> references = GoMoveToStructInitializationIntention.getUninitializedSingleFieldReferences(assignment, selectedFieldReference, compositeLit);
        return !references.isEmpty() ? new Data(assignment, compositeLit, references) : null;
    }

    @Nullable
    private static GoAssignmentStatement getValidAssignmentParent(@Nullable PsiElement element) {
        GoAssignmentStatement assignment = (GoAssignmentStatement)PsiTreeUtil.getNonStrictParentOfType((PsiElement)element, (Class[])new Class[]{GoAssignmentStatement.class});
        return assignment != null && assignment.isValid() && GoMoveToStructInitializationIntention.getLeftHandElements(assignment).size() == assignment.getExpressionList().size() ? assignment : null;
    }

    @Nullable
    private static GoReferenceExpression getFieldReferenceExpression(@NotNull PsiElement selectedElement, @NotNull GoAssignmentStatement assignment) {
        GoReferenceExpression selectedReferenceExpression;
        if (selectedElement == null) {
            GoMoveToStructInitializationIntention.$$$reportNull$$$0(6);
        }
        if (assignment == null) {
            GoMoveToStructInitializationIntention.$$$reportNull$$$0(7);
        }
        if (GoMoveToStructInitializationIntention.isFieldReferenceExpression(selectedReferenceExpression = (GoReferenceExpression)PsiTreeUtil.getTopmostParentOfType((PsiElement)selectedElement, GoReferenceExpression.class))) {
            return !GoMoveToStructInitializationIntention.isAssignedInPreviousStatement(selectedReferenceExpression, assignment) ? selectedReferenceExpression : null;
        }
        List<GoReferenceExpression> fieldReferenceExpressions = GoMoveToStructInitializationIntention.getFieldReferenceExpressions(assignment);
        if (ContainerUtil.exists(fieldReferenceExpressions, expression -> GoMoveToStructInitializationIntention.isAssignedInPreviousStatement(expression, assignment))) {
            return null;
        }
        Set resolvedFields = ContainerUtil.map2Set(fieldReferenceExpressions, GoMoveToStructInitializationIntention::resolveQualifier);
        return resolvedFields.size() == 1 ? (GoReferenceExpression)ContainerUtil.getFirstItem(fieldReferenceExpressions) : null;
    }

    @NotNull
    private static List<GoReferenceExpression> getFieldReferenceExpressions(@NotNull GoAssignmentStatement assignment) {
        if (assignment == null) {
            GoMoveToStructInitializationIntention.$$$reportNull$$$0(8);
        }
        List list = ContainerUtil.filter((Collection)ContainerUtil.map(GoMoveToStructInitializationIntention.getLeftHandElements(assignment), GoMoveToStructInitializationIntention::unwrapParensAndCast), GoMoveToStructInitializationIntention::isFieldReferenceExpression);
        if (list == null) {
            GoMoveToStructInitializationIntention.$$$reportNull$$$0(9);
        }
        return list;
    }

    @Nullable
    private static GoReferenceExpression unwrapParensAndCast(@Nullable PsiElement e) {
        return (GoReferenceExpression)ObjectUtils.tryCast((Object)GoPsiImplUtil.unwrapParentheses((GoExpression)ObjectUtils.tryCast((Object)e, GoExpression.class)), GoReferenceExpression.class);
    }

    @Contract(value="null -> false")
    private static boolean isFieldReferenceExpression(@Nullable PsiElement element) {
        return element instanceof GoReferenceExpression && GoPsiImplUtil.isFieldDefinition(((GoReferenceExpression)element).resolve());
    }

    private static boolean isAssignedInPreviousStatement(@NotNull GoExpression referenceExpression, @NotNull GoAssignmentStatement assignment) {
        GoReferenceExpression rightExpression;
        if (referenceExpression == null) {
            GoMoveToStructInitializationIntention.$$$reportNull$$$0(10);
        }
        if (assignment == null) {
            GoMoveToStructInitializationIntention.$$$reportNull$$$0(11);
        }
        PsiElement resolve2 = (rightExpression = GoMoveToStructInitializationIntention.unwrapParensAndCast(GoMoveToStructInitializationIntention.getRightExpression(assignment, GoMoveToStructInitializationIntention.getTopmostExpression(referenceExpression)))) != null ? rightExpression.resolve() : null;
        GoStatement previousElement = resolve2 != null ? (GoStatement)PsiTreeUtil.getPrevSiblingOfType((PsiElement)assignment, GoStatement.class) : null;
        return previousElement != null && ContainerUtil.exists(GoMoveToStructInitializationIntention.getLeftHandElements(previousElement), e -> GoMoveToStructInitializationIntention.isResolvedTo(e, resolve2));
    }

    @NotNull
    private static GoExpression getTopmostExpression(@NotNull GoExpression expression) {
        if (expression == null) {
            GoMoveToStructInitializationIntention.$$$reportNull$$$0(12);
        }
        GoExpression goExpression = (GoExpression)ObjectUtils.notNull((Object)((GoExpression)PsiTreeUtil.getTopmostParentOfType((PsiElement)expression, GoExpression.class)), (Object)expression);
        if (goExpression == null) {
            GoMoveToStructInitializationIntention.$$$reportNull$$$0(13);
        }
        return goExpression;
    }

    private static boolean isResolvedTo(@Nullable PsiElement e, @Nullable PsiElement resolve2) {
        if (e instanceof GoVarDefinition) {
            return resolve2 == e;
        }
        GoReferenceExpression refExpression = GoMoveToStructInitializationIntention.unwrapParensAndCast(e);
        return refExpression != null && refExpression.resolve() == resolve2;
    }

    @NotNull
    private static List<GoReferenceExpression> getUninitializedSingleFieldReferences(@NotNull GoAssignmentStatement assignment, @NotNull GoReferenceExpression fieldReferenceExpression, @NotNull GoCompositeLit compositeLit) {
        if (assignment == null) {
            GoMoveToStructInitializationIntention.$$$reportNull$$$0(14);
        }
        if (fieldReferenceExpression == null) {
            GoMoveToStructInitializationIntention.$$$reportNull$$$0(15);
        }
        if (compositeLit == null) {
            GoMoveToStructInitializationIntention.$$$reportNull$$$0(16);
        }
        PsiElement resolve2 = GoMoveToStructInitializationIntention.resolveQualifier(fieldReferenceExpression);
        List<GoReferenceExpression> exprs = GoMoveToStructInitializationIntention.getUninitializedFieldReferenceExpressions(assignment, compositeLit);
        List uninitializedFieldReferencesByQualifier = ContainerUtil.filter(exprs, e -> GoMoveToStructInitializationIntention.isResolvedTo(e.getQualifier(), resolve2));
        MultiMap resolved = ContainerUtil.groupBy((Iterable)uninitializedFieldReferencesByQualifier, GoResolvable::resolve);
        List list = ContainerUtil.map((Collection)ContainerUtil.filter((Collection)resolved.entrySet(), set -> ((Collection)set.getValue()).size() == 1), set -> (GoReferenceExpression)ContainerUtil.getFirstItem((Collection)((Collection)set.getValue())));
        if (list == null) {
            GoMoveToStructInitializationIntention.$$$reportNull$$$0(17);
        }
        return list;
    }

    @Nullable
    private static GoCompositeLit getStructLiteralByReference(@NotNull GoReferenceExpression fieldReferenceExpression, @NotNull GoAssignmentStatement assignment) {
        GoStatement previousStatement;
        if (fieldReferenceExpression == null) {
            GoMoveToStructInitializationIntention.$$$reportNull$$$0(18);
        }
        if (assignment == null) {
            GoMoveToStructInitializationIntention.$$$reportNull$$$0(19);
        }
        if ((previousStatement = (GoStatement)PsiTreeUtil.getPrevSiblingOfType((PsiElement)assignment, GoStatement.class)) instanceof GoSimpleStatement) {
            return GoMoveToStructInitializationIntention.getStructLiteral(fieldReferenceExpression, (GoSimpleStatement)previousStatement);
        }
        if (previousStatement instanceof GoAssignmentStatement) {
            return GoMoveToStructInitializationIntention.getStructLiteral(fieldReferenceExpression, (GoAssignmentStatement)previousStatement);
        }
        return null;
    }

    @Nullable
    private static GoCompositeLit getStructLiteral(@NotNull GoReferenceExpression fieldReferenceExpression, @NotNull GoSimpleStatement structDeclaration) {
        GoShortVarDeclaration varDeclaration;
        if (fieldReferenceExpression == null) {
            GoMoveToStructInitializationIntention.$$$reportNull$$$0(20);
        }
        if (structDeclaration == null) {
            GoMoveToStructInitializationIntention.$$$reportNull$$$0(21);
        }
        if ((varDeclaration = structDeclaration.getShortVarDeclaration()) == null) {
            return null;
        }
        PsiElement resolve2 = GoMoveToStructInitializationIntention.resolveQualifier(fieldReferenceExpression);
        GoVarDefinition structVarDefinition = (GoVarDefinition)ContainerUtil.find(varDeclaration.getVarDefinitionList(), definition -> resolve2 == definition);
        return structVarDefinition != null ? (GoCompositeLit)ObjectUtils.tryCast((Object)structVarDefinition.findExpression(), GoCompositeLit.class) : null;
    }

    @Nullable
    private static PsiElement resolveQualifier(@NotNull GoReferenceExpression fieldReferenceExpression) {
        GoResolvable qualifier;
        if (fieldReferenceExpression == null) {
            GoMoveToStructInitializationIntention.$$$reportNull$$$0(22);
        }
        return (qualifier = fieldReferenceExpression.getResolvableQualifier()) != null ? qualifier.resolve() : null;
    }

    @Nullable
    private static GoCompositeLit getStructLiteral(@NotNull GoReferenceExpression fieldReferenceExpression, @NotNull GoAssignmentStatement structAssignment) {
        if (fieldReferenceExpression == null) {
            GoMoveToStructInitializationIntention.$$$reportNull$$$0(23);
        }
        if (structAssignment == null) {
            GoMoveToStructInitializationIntention.$$$reportNull$$$0(24);
        }
        GoVarDefinition varDefinition = (GoVarDefinition)ObjectUtils.tryCast((Object)GoMoveToStructInitializationIntention.resolveQualifier(fieldReferenceExpression), GoVarDefinition.class);
        PsiElement field = fieldReferenceExpression.resolve();
        if (varDefinition == null || !GoPsiImplUtil.isFieldDefinition(field) || !GoMoveToStructInitializationIntention.hasStructTypeWithField(varDefinition, (GoNamedElement)field)) {
            return null;
        }
        GoExpression structReferenceExpression = (GoExpression)ContainerUtil.find(structAssignment.getLeftHandExprList().getExpressionList(), expression -> GoMoveToStructInitializationIntention.isResolvedTo(expression, varDefinition));
        if (structReferenceExpression == null) {
            return null;
        }
        GoExpression compositeLit = GoMoveToStructInitializationIntention.getRightExpression(structAssignment, structReferenceExpression);
        return (GoCompositeLit)ObjectUtils.tryCast((Object)compositeLit, GoCompositeLit.class);
    }

    private static boolean hasStructTypeWithField(@NotNull GoVarDefinition structVarDefinition, @NotNull GoNamedElement field) {
        GoType type2;
        if (structVarDefinition == null) {
            GoMoveToStructInitializationIntention.$$$reportNull$$$0(25);
        }
        if (field == null) {
            GoMoveToStructInitializationIntention.$$$reportNull$$$0(26);
        }
        return (type2 = structVarDefinition.getGoUnderlyingType(null)) instanceof GoStructType && PsiTreeUtil.isAncestor((PsiElement)type2, (PsiElement)field, (boolean)true);
    }

    private static boolean isFieldInitialization(@NotNull GoElement element, @NotNull PsiElement field) {
        GoKey key;
        if (element == null) {
            GoMoveToStructInitializationIntention.$$$reportNull$$$0(27);
        }
        if (field == null) {
            GoMoveToStructInitializationIntention.$$$reportNull$$$0(28);
        }
        GoFieldName fieldName = (key = element.getKey()) != null ? key.getFieldName() : null;
        return fieldName != null && fieldName.resolve() == field;
    }

    @NotNull
    private static List<GoReferenceExpression> getUninitializedFieldReferenceExpressions(@NotNull GoAssignmentStatement assignment, @NotNull GoCompositeLit structLiteral) {
        if (assignment == null) {
            GoMoveToStructInitializationIntention.$$$reportNull$$$0(29);
        }
        if (structLiteral == null) {
            GoMoveToStructInitializationIntention.$$$reportNull$$$0(30);
        }
        List list = ContainerUtil.filter(GoMoveToStructInitializationIntention.getFieldReferenceExpressions(assignment), expression -> GoMoveToStructInitializationIntention.isUninitializedFieldReferenceExpression(expression, structLiteral) && !GoMoveToStructInitializationIntention.isAssignedInPreviousStatement(expression, assignment));
        if (list == null) {
            GoMoveToStructInitializationIntention.$$$reportNull$$$0(31);
        }
        return list;
    }

    @Contract(value="null, _-> false")
    private static boolean isUninitializedFieldReferenceExpression(@Nullable GoReferenceExpression fieldReferenceExpression, @NotNull GoCompositeLit structLiteral) {
        if (structLiteral == null) {
            GoMoveToStructInitializationIntention.$$$reportNull$$$0(32);
        }
        if (fieldReferenceExpression == null) {
            return false;
        }
        GoLiteralValue literalValue = structLiteral.getLiteralValue();
        PsiElement resolve2 = fieldReferenceExpression.resolve();
        return literalValue != null && GoPsiImplUtil.isFieldDefinition(resolve2) && !ContainerUtil.exists(literalValue.getElementList(), element -> GoMoveToStructInitializationIntention.isFieldInitialization(element, resolve2));
    }

    @NotNull
    private static List<? extends PsiElement> getLeftHandElements(@NotNull GoStatement statement) {
        if (statement == null) {
            GoMoveToStructInitializationIntention.$$$reportNull$$$0(33);
        }
        if (statement instanceof GoSimpleStatement) {
            GoShortVarDeclaration varDeclaration = ((GoSimpleStatement)statement).getShortVarDeclaration();
            List<GoVarDefinition> list = varDeclaration != null ? varDeclaration.getVarDefinitionList() : ContainerUtil.emptyList();
            if (list == null) {
                GoMoveToStructInitializationIntention.$$$reportNull$$$0(34);
            }
            return list;
        }
        if (statement instanceof GoAssignmentStatement) {
            List<GoExpression> list = ((GoAssignmentStatement)statement).getLeftHandExprList().getExpressionList();
            if (list == null) {
                GoMoveToStructInitializationIntention.$$$reportNull$$$0(35);
            }
            return list;
        }
        List list = ContainerUtil.emptyList();
        if (list == null) {
            GoMoveToStructInitializationIntention.$$$reportNull$$$0(36);
        }
        return list;
    }

    public void invoke(@NotNull Project project, @NotNull Editor editor, @NotNull PsiElement element) throws IncorrectOperationException {
        Data data;
        if (project == null) {
            GoMoveToStructInitializationIntention.$$$reportNull$$$0(37);
        }
        if (editor == null) {
            GoMoveToStructInitializationIntention.$$$reportNull$$$0(38);
        }
        if (element == null) {
            GoMoveToStructInitializationIntention.$$$reportNull$$$0(39);
        }
        if ((data = GoMoveToStructInitializationIntention.getData(element)) == null) {
            return;
        }
        GoMoveToStructInitializationIntention.moveFieldReferenceExpressions(data);
    }

    private static void moveFieldReferenceExpressions(@NotNull Data data) {
        GoLiteralValue literalValue;
        if (data == null) {
            GoMoveToStructInitializationIntention.$$$reportNull$$$0(40);
        }
        if ((literalValue = data.getCompositeLit().getLiteralValue()) == null) {
            return;
        }
        for (GoReferenceExpression expression : data.getReferenceExpressions()) {
            GoExpression anchor = GoMoveToStructInitializationIntention.getTopmostExpression(expression);
            GoExpression fieldValue = GoMoveToStructInitializationIntention.getRightExpression(data.getAssignment(), anchor);
            if (fieldValue == null) continue;
            data.getAssignment().deleteExpression(anchor);
            GoMoveToStructInitializationIntention.addFieldDefinition(literalValue, expression.getIdentifier().getText(), fieldValue.getText());
        }
        GoFormatterUtil.reformat(literalValue);
    }

    private static void addFieldDefinition(@NotNull GoLiteralValue literalValue, @NotNull String name, @NotNull String value) {
        if (literalValue == null) {
            GoMoveToStructInitializationIntention.$$$reportNull$$$0(41);
        }
        if (name == null) {
            GoMoveToStructInitializationIntention.$$$reportNull$$$0(42);
        }
        if (value == null) {
            GoMoveToStructInitializationIntention.$$$reportNull$$$0(43);
        }
        Project project = literalValue.getProject();
        PsiElement newField = GoElementFactory.createLiteralValueElement(project, name, value);
        GoElement lastElement = (GoElement)ContainerUtil.getLastItem(literalValue.getElementList());
        if (lastElement == null) {
            literalValue.addAfter(newField, literalValue.getLbrace());
        } else {
            lastElement.add(GoElementFactory.createComma(project));
            lastElement.add(newField);
        }
    }

    @Nullable
    private static GoExpression getRightExpression(@NotNull GoAssignmentStatement assignment, @NotNull GoExpression leftExpression) {
        if (assignment == null) {
            GoMoveToStructInitializationIntention.$$$reportNull$$$0(44);
        }
        if (leftExpression == null) {
            GoMoveToStructInitializationIntention.$$$reportNull$$$0(45);
        }
        return GoPsiUtil.getCorrespondingRightExpr(leftExpression, assignment.getLeftHandExprList().getExpressionList(), assignment.getExpressionList());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 2, 3, 4, 5, 6, 7, 8, 10, 11, 12, 14, 15, 16, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 32, 33, 37, 38, 39, 40, 41, 42, 43, 44, 45 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/goide/intentions/GoMoveToStructInitializationIntention";
                break;
            }
            case 2: 
            case 37: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 3: 
            case 38: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 4: 
            case 5: 
            case 27: 
            case 39: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "selectedElement";
                break;
            }
            case 7: 
            case 8: 
            case 11: 
            case 14: 
            case 19: 
            case 29: 
            case 44: {
                objectArray2 = objectArray3;
                objectArray3[0] = "assignment";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "referenceExpression";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expression";
                break;
            }
            case 15: 
            case 18: 
            case 20: 
            case 22: 
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fieldReferenceExpression";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "compositeLit";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "structDeclaration";
                break;
            }
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "structAssignment";
                break;
            }
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "structVarDefinition";
                break;
            }
            case 26: 
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "field";
                break;
            }
            case 30: 
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "structLiteral";
                break;
            }
            case 33: {
                objectArray2 = objectArray3;
                objectArray3[0] = "statement";
                break;
            }
            case 40: {
                objectArray2 = objectArray3;
                objectArray3[0] = "data";
                break;
            }
            case 41: {
                objectArray2 = objectArray3;
                objectArray3[0] = "literalValue";
                break;
            }
            case 42: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 43: {
                objectArray2 = objectArray3;
                objectArray3[0] = "value";
                break;
            }
            case 45: {
                objectArray2 = objectArray3;
                objectArray3[0] = "leftExpression";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getText";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 10: 
            case 11: 
            case 12: 
            case 14: 
            case 15: 
            case 16: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 32: 
            case 33: 
            case 37: 
            case 38: 
            case 39: 
            case 40: 
            case 41: 
            case 42: 
            case 43: 
            case 44: 
            case 45: {
                objectArray = objectArray2;
                objectArray2[1] = "com/goide/intentions/GoMoveToStructInitializationIntention";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getFieldReferenceExpressions";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getTopmostExpression";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "getUninitializedSingleFieldReferences";
                break;
            }
            case 31: {
                objectArray = objectArray2;
                objectArray2[1] = "getUninitializedFieldReferenceExpressions";
                break;
            }
            case 34: 
            case 35: 
            case 36: {
                objectArray = objectArray2;
                objectArray2[1] = "getLeftHandElements";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "isAvailable";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getData";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getFieldReferenceExpression";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getFieldReferenceExpressions";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "isAssignedInPreviousStatement";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "getTopmostExpression";
                break;
            }
            case 14: 
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "getUninitializedSingleFieldReferences";
                break;
            }
            case 18: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "getStructLiteralByReference";
                break;
            }
            case 20: 
            case 21: 
            case 23: 
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "getStructLiteral";
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "resolveQualifier";
                break;
            }
            case 25: 
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "hasStructTypeWithField";
                break;
            }
            case 27: 
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "isFieldInitialization";
                break;
            }
            case 29: 
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "getUninitializedFieldReferenceExpressions";
                break;
            }
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "isUninitializedFieldReferenceExpression";
                break;
            }
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "getLeftHandElements";
                break;
            }
            case 37: 
            case 38: 
            case 39: {
                objectArray = objectArray;
                objectArray[2] = "invoke";
                break;
            }
            case 40: {
                objectArray = objectArray;
                objectArray[2] = "moveFieldReferenceExpressions";
                break;
            }
            case 41: 
            case 42: 
            case 43: {
                objectArray = objectArray;
                objectArray[2] = "addFieldDefinition";
                break;
            }
            case 44: 
            case 45: {
                objectArray = objectArray;
                objectArray[2] = "getRightExpression";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 2, 3, 4, 5, 6, 7, 8, 10, 11, 12, 14, 15, 16, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 32, 33, 37, 38, 39, 40, 41, 42, 43, 44, 45 -> new IllegalArgumentException(string);
        };
    }

    private static final class Data {
        private final GoCompositeLit myCompositeLit;
        private final GoAssignmentStatement myAssignment;
        private final List<GoReferenceExpression> myReferenceExpressions;

        private Data(@NotNull GoAssignmentStatement assignment, @NotNull GoCompositeLit compositeLit, @NotNull List<GoReferenceExpression> referenceExpressions) {
            if (assignment == null) {
                Data.$$$reportNull$$$0(0);
            }
            if (compositeLit == null) {
                Data.$$$reportNull$$$0(1);
            }
            if (referenceExpressions == null) {
                Data.$$$reportNull$$$0(2);
            }
            this.myCompositeLit = compositeLit;
            this.myAssignment = assignment;
            this.myReferenceExpressions = referenceExpressions;
        }

        public GoCompositeLit getCompositeLit() {
            return this.myCompositeLit;
        }

        public GoAssignmentStatement getAssignment() {
            return this.myAssignment;
        }

        public List<GoReferenceExpression> getReferenceExpressions() {
            return this.myReferenceExpressions;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "assignment";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "compositeLit";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[0] = "referenceExpressions";
                    break;
                }
            }
            objectArray[1] = "com/goide/intentions/GoMoveToStructInitializationIntention$Data";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

