/*
 * Decompiled with CFR 0.152.
 */
package com.goide.intentions;

import com.goide.i18n.GoBundle;
import com.goide.inspections.core.GoInspectionProblemUtil;
import com.goide.intentions.GoBaseIntentionAction;
import com.goide.intentions.GoFunctionParameterToMethodReceiverMigrator;
import com.goide.intentions.GoMethodReceiverToFunctionParameterMigrator;
import com.goide.intentions.GoMigrationUtil;
import com.goide.psi.GoCompositeElement;
import com.goide.psi.GoFile;
import com.goide.psi.GoFunctionDeclaration;
import com.goide.psi.GoFunctionOrMethodDeclaration;
import com.goide.psi.GoMethodDeclaration;
import com.goide.psi.GoParameterDeclaration;
import com.goide.psi.GoReceiver;
import com.goide.psi.GoSignature;
import com.goide.psi.GoType;
import com.goide.psi.impl.GoReceiverUtil;
import com.goide.psi.impl.GoTypeUtil;
import com.goide.stubs.GoFunctionDeclarationStub;
import com.intellij.codeInsight.intention.preview.IntentionPreviewInfo;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.StubBasedPsiElement;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.refactoring.util.CommonRefactoringUtil;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0005\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0012\u0010\u0003\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0002J\u001a\u0010\u0007\u001a\u0004\u0018\u00010\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0002J \u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016J\b\u0010\u0011\u001a\u00020\u0012H\u0016J!\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u0015\u001a\u00020\bH\u0096\u0002J \u0010\u0016\u001a\u00020\u00172\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u0015\u001a\u00020\bH\u0016J\u0010\u0010\u0018\u001a\u00020\u00172\u0006\u0010\u0015\u001a\u00020\bH\u0002J\u0010\u0010\u0019\u001a\u00020\u00172\u0006\u0010\u0015\u001a\u00020\bH\u0002J \u0010\u001a\u001a\u00020\u00172\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u0005\u001a\u00020\u0006H\u0002J\b\u0010\u001b\u001a\u00020\u0017H\u0016\u00a8\u0006\u001c"}, d2={"Lcom/goide/intentions/GoMigrateFunctionParameterToMethodReceiverIntention;", "Lcom/goide/intentions/GoBaseIntentionAction;", "()V", "checkBaseReceiverType", "Lcom/goide/psi/impl/GoReceiverUtil$ReceiverTypeCheckError;", "funcDecl", "Lcom/goide/psi/GoFunctionDeclaration;", "findElementAtCaret", "Lcom/intellij/psi/PsiElement;", "editor", "Lcom/intellij/openapi/editor/Editor;", "file", "Lcom/intellij/psi/PsiFile;", "generatePreview", "Lcom/intellij/codeInsight/intention/preview/IntentionPreviewInfo;", "project", "Lcom/intellij/openapi/project/Project;", "getFamilyName", "", "invoke", "", "element", "isAvailable", "", "isFunctionParameterToMethodReceiverMigrationAvailable", "isMethodReceiverToFunctionParameterMigrationAvailable", "showErrorHintsIfMigrationNotDesirable", "startInWriteAction", "intellij.go.impl"})
@SourceDebugExtension(value={"SMAP\nGoMigrateFunctionParameterToMethodReceiverIntention.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GoMigrateFunctionParameterToMethodReceiverIntention.kt\ncom/goide/intentions/GoMigrateFunctionParameterToMethodReceiverIntention\n+ 2 psiTreeUtil.kt\ncom/intellij/psi/util/PsiTreeUtilKt\n*L\n1#1,690:1\n66#2,2:691\n66#2,2:693\n66#2,2:695\n66#2,2:697\n66#2,2:699\n66#2,2:701\n66#2,2:703\n66#2,2:705\n*S KotlinDebug\n*F\n+ 1 GoMigrateFunctionParameterToMethodReceiverIntention.kt\ncom/goide/intentions/GoMigrateFunctionParameterToMethodReceiverIntention\n*L\n58#1:691,2\n59#1:693,2\n68#1:695,2\n70#1:697,2\n83#1:699,2\n91#1:701,2\n106#1:703,2\n111#1:705,2\n*E\n"})
public final class GoMigrateFunctionParameterToMethodReceiverIntention
extends GoBaseIntentionAction {
    @NotNull
    public String getFamilyName() {
        String string = GoBundle.message((String)"go.intention.migrate.function.parameter.to.method.receiver.name", (Object[])new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        return string;
    }

    @Override
    public boolean isAvailable(@NotNull Project project, @NotNull Editor editor, @NotNull PsiElement element) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        if (this.isFunctionParameterToMethodReceiverMigrationAvailable(element)) {
            this.setText(GoBundle.message((String)"go.intention.migrate.function.parameter.to.method.receiver", (Object[])new Object[0]));
            return true;
        }
        if (this.isMethodReceiverToFunctionParameterMigrationAvailable(element)) {
            this.setText(GoBundle.message((String)"go.intention.migrate.method.receiver.to.function.parameter", (Object[])new Object[0]));
            return true;
        }
        return false;
    }

    private final boolean isFunctionParameterToMethodReceiverMigrationAvailable(PsiElement element) {
        PsiElement $this$parentOfType_u24default$iv = element;
        boolean withSelf$iv = false;
        boolean $i$f$parentOfType = false;
        GoParameterDeclaration goParameterDeclaration = (GoParameterDeclaration)PsiTreeUtil.getParentOfType((PsiElement)$this$parentOfType_u24default$iv, GoParameterDeclaration.class, (boolean)true);
        if (goParameterDeclaration == null) {
            return false;
        }
        GoParameterDeclaration paramDecl = goParameterDeclaration;
        PsiElement $this$parentOfType_u24default$iv2 = element;
        boolean withSelf$iv2 = false;
        boolean $i$f$parentOfType2 = false;
        GoFunctionDeclaration goFunctionDeclaration = (GoFunctionDeclaration)PsiTreeUtil.getParentOfType((PsiElement)$this$parentOfType_u24default$iv2, GoFunctionDeclaration.class, (boolean)true);
        if (goFunctionDeclaration == null) {
            return false;
        }
        GoFunctionDeclaration funcDecl = goFunctionDeclaration;
        if (funcDecl.getBlock() == null) {
            return false;
        }
        GoParameterDeclaration firstParameterDeclaration = GoMigrationUtil.INSTANCE.getFirstParameterDeclaration(funcDecl);
        if (!Intrinsics.areEqual((Object)firstParameterDeclaration, (Object)paramDecl)) {
            return false;
        }
        return firstParameterDeclaration.getType() != null;
    }

    private final boolean isMethodReceiverToFunctionParameterMigrationAvailable(PsiElement element) {
        PsiElement $this$parentOfType_u24default$iv = element;
        boolean withSelf$iv = false;
        boolean $i$f$parentOfType = false;
        GoReceiver goReceiver = (GoReceiver)PsiTreeUtil.getParentOfType((PsiElement)$this$parentOfType_u24default$iv, GoReceiver.class, (boolean)true);
        if (goReceiver == null) {
            return false;
        }
        GoReceiver receiver = goReceiver;
        if (receiver.getType() == null) {
            return false;
        }
        PsiElement $this$parentOfType_u24default$iv2 = receiver;
        boolean withSelf$iv2 = false;
        boolean $i$f$parentOfType2 = false;
        GoMethodDeclaration goMethodDeclaration = (GoMethodDeclaration)PsiTreeUtil.getParentOfType((PsiElement)$this$parentOfType_u24default$iv2, GoMethodDeclaration.class, (boolean)true);
        if (goMethodDeclaration == null) {
            return false;
        }
        GoMethodDeclaration methodDecl = goMethodDeclaration;
        return methodDecl.getBlock() != null;
    }

    @NotNull
    public IntentionPreviewInfo generatePreview(@NotNull Project project, @NotNull Editor editor, @NotNull PsiFile file) {
        PsiElement copy;
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        PsiElement element = this.findElementAtCaret(editor, file);
        PsiElement psiElement = PsiTreeUtil.findSameElementInCopy((PsiElement)element, (PsiFile)file);
        if (psiElement == null) {
            IntentionPreviewInfo intentionPreviewInfo = IntentionPreviewInfo.EMPTY;
            Intrinsics.checkNotNullExpressionValue((Object)intentionPreviewInfo, (String)"EMPTY");
            return intentionPreviewInfo;
        }
        PsiElement $this$parentOfType_u24default$iv = copy = psiElement;
        boolean withSelf$iv = false;
        boolean $i$f$parentOfType = false;
        StubBasedPsiElement<GoFunctionDeclarationStub> stubBasedPsiElement = (GoFunctionDeclaration)PsiTreeUtil.getParentOfType((PsiElement)$this$parentOfType_u24default$iv, GoFunctionDeclaration.class, (boolean)true);
        if (stubBasedPsiElement != null) {
            GoFunctionDeclaration funcDecl = stubBasedPsiElement;
            boolean bl = false;
            if (this.checkBaseReceiverType(funcDecl) != null) {
                IntentionPreviewInfo intentionPreviewInfo = IntentionPreviewInfo.EMPTY;
                Intrinsics.checkNotNullExpressionValue((Object)intentionPreviewInfo, (String)"EMPTY");
                return intentionPreviewInfo;
            }
            GoSignature goSignature = funcDecl.getSignature();
            if ((goSignature != null ? goSignature.getTypeParameters() : null) != null) {
                IntentionPreviewInfo intentionPreviewInfo = IntentionPreviewInfo.EMPTY;
                Intrinsics.checkNotNullExpressionValue((Object)intentionPreviewInfo, (String)"EMPTY");
                return intentionPreviewInfo;
            }
            GoMethodDeclaration goMethodDeclaration = new GoFunctionParameterToMethodReceiverMigrator().createNewDeclaration(project, funcDecl);
            if (goMethodDeclaration == null) {
                IntentionPreviewInfo intentionPreviewInfo = IntentionPreviewInfo.EMPTY;
                Intrinsics.checkNotNullExpressionValue((Object)intentionPreviewInfo, (String)"EMPTY");
                return intentionPreviewInfo;
            }
            GoMethodDeclaration methodDecl = goMethodDeclaration;
            funcDecl.replace(methodDecl);
            IntentionPreviewInfo intentionPreviewInfo = IntentionPreviewInfo.DIFF;
            Intrinsics.checkNotNullExpressionValue((Object)intentionPreviewInfo, (String)"DIFF");
            return intentionPreviewInfo;
        }
        $this$parentOfType_u24default$iv = copy;
        withSelf$iv = false;
        $i$f$parentOfType = false;
        stubBasedPsiElement = (GoMethodDeclaration)PsiTreeUtil.getParentOfType((PsiElement)$this$parentOfType_u24default$iv, GoMethodDeclaration.class, (boolean)true);
        if (stubBasedPsiElement != null) {
            StubBasedPsiElement<GoFunctionDeclarationStub> methodDecl = stubBasedPsiElement;
            boolean bl = false;
            GoFunctionDeclaration goFunctionDeclaration = new GoMethodReceiverToFunctionParameterMigrator().createNewDeclaration(project, (GoMethodDeclaration)methodDecl);
            if (goFunctionDeclaration == null) {
                IntentionPreviewInfo intentionPreviewInfo = IntentionPreviewInfo.EMPTY;
                Intrinsics.checkNotNullExpressionValue((Object)intentionPreviewInfo, (String)"EMPTY");
                return intentionPreviewInfo;
            }
            GoFunctionDeclaration funcDecl = goFunctionDeclaration;
            methodDecl.replace(funcDecl);
            IntentionPreviewInfo intentionPreviewInfo = IntentionPreviewInfo.DIFF;
            Intrinsics.checkNotNullExpressionValue((Object)intentionPreviewInfo, (String)"DIFF");
            return intentionPreviewInfo;
        }
        IntentionPreviewInfo intentionPreviewInfo = IntentionPreviewInfo.EMPTY;
        Intrinsics.checkNotNullExpressionValue((Object)intentionPreviewInfo, (String)"EMPTY");
        return intentionPreviewInfo;
    }

    public boolean startInWriteAction() {
        return false;
    }

    public void invoke(@NotNull Project project, @NotNull Editor editor, @NotNull PsiElement element) {
        block3: {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
            Intrinsics.checkNotNullParameter((Object)element, (String)"element");
            PsiFile file = element.getContainingFile();
            if (file == null || !(file instanceof GoFile)) {
                return;
            }
            PsiElement $this$parentOfType_u24default$iv = element;
            boolean withSelf$iv = false;
            boolean $i$f$parentOfType = false;
            GoFunctionDeclaration goFunctionDeclaration = (GoFunctionDeclaration)PsiTreeUtil.getParentOfType((PsiElement)$this$parentOfType_u24default$iv, GoFunctionDeclaration.class, (boolean)true);
            if (goFunctionDeclaration != null) {
                GoFunctionDeclaration funcDecl = goFunctionDeclaration;
                boolean bl = false;
                if (this.showErrorHintsIfMigrationNotDesirable(project, editor, funcDecl)) {
                    return;
                }
                new GoFunctionParameterToMethodReceiverMigrator().migrate(project, (GoFunctionOrMethodDeclaration)funcDecl, (GoFile)file);
                return;
            }
            $this$parentOfType_u24default$iv = element;
            withSelf$iv = false;
            $i$f$parentOfType = false;
            GoMethodDeclaration goMethodDeclaration = (GoMethodDeclaration)PsiTreeUtil.getParentOfType((PsiElement)$this$parentOfType_u24default$iv, GoMethodDeclaration.class, (boolean)true);
            if (goMethodDeclaration == null) break block3;
            GoMethodDeclaration methodDecl = goMethodDeclaration;
            boolean bl = false;
            new GoMethodReceiverToFunctionParameterMigrator().migrate(project, (GoFunctionOrMethodDeclaration)methodDecl, (GoFile)file);
        }
    }

    private final boolean showErrorHintsIfMigrationNotDesirable(Project project, Editor editor, GoFunctionDeclaration funcDecl) {
        String string = GoBundle.message((String)"go.intention.migrate.function.parameter.to.method.receiver.error.hint.title", (Object[])new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        String title = string;
        GoReceiverUtil.ReceiverTypeCheckError result = this.checkBaseReceiverType(funcDecl);
        if (result != null) {
            String errorTypeCategory = GoReceiverUtil.getErrorTypeCategoryText(result.errorCategory());
            String flattenedReceiverType = GoReceiverUtil.getReceiverTypeText(result.flattenedReceiverType(), funcDecl);
            String errorType = GoReceiverUtil.getReceiverTypeText(result.errorType(), funcDecl);
            Object[] objectArray = new Object[]{"'" + GoInspectionProblemUtil.code(flattenedReceiverType) + "'", "'" + GoInspectionProblemUtil.code(errorType) + "'", errorTypeCategory};
            String string2 = GoBundle.message((String)"go.intention.migrate.function.parameter.to.method.receiver.error.hint.invalid.receiver.type", (Object[])objectArray);
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"message(...)");
            String reason = string2;
            Object[] objectArray2 = new Object[]{reason};
            String string3 = GoBundle.message((String)"go.intention.migrate.function.parameter.to.method.receiver.error.hint.message", (Object[])objectArray2);
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"message(...)");
            String message = string3;
            CommonRefactoringUtil.showErrorHint((Project)project, (Editor)editor, (String)message, (String)title, null);
            return true;
        }
        GoSignature goSignature = funcDecl.getSignature();
        if ((goSignature != null ? goSignature.getTypeParameters() : null) != null) {
            String string4 = GoBundle.message((String)"go.intention.migrate.function.parameter.to.method.receiver.error.hint.method.with.type.parameter", (Object[])new Object[0]);
            Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"message(...)");
            String reason = string4;
            Object[] objectArray = new Object[]{reason};
            String string5 = GoBundle.message((String)"go.intention.migrate.function.parameter.to.method.receiver.error.hint.message", (Object[])objectArray);
            Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"message(...)");
            String message = string5;
            CommonRefactoringUtil.showErrorHint((Project)project, (Editor)editor, (String)message, (String)title, null);
            return true;
        }
        return false;
    }

    private final GoReceiverUtil.ReceiverTypeCheckError checkBaseReceiverType(GoFunctionDeclaration funcDecl) {
        GoParameterDeclaration firstParameterDeclaration = GoMigrationUtil.INSTANCE.getFirstParameterDeclaration(funcDecl);
        GoCompositeElement goCompositeElement = firstParameterDeclaration;
        if (goCompositeElement == null || (goCompositeElement = goCompositeElement.getType()) == null) {
            return null;
        }
        GoCompositeElement baseReceiverType = goCompositeElement;
        return GoTypeUtil.checkBaseReceiverType((GoType)baseReceiverType, funcDecl);
    }

    private final PsiElement findElementAtCaret(Editor editor, PsiFile file) {
        int offset = editor.getCaretModel().getOffset();
        return file.findElementAt(offset);
    }
}

