/*
 * Decompiled with CFR 0.152.
 */
package com.goide.intentions;

import com.goide.formatter.GoFormatterUtil;
import com.goide.i18n.GoBundle;
import com.goide.intentions.GoGenerateTypeFromJsonDialog;
import com.goide.psi.GoBlock;
import com.goide.psi.GoFieldDeclaration;
import com.goide.psi.GoStructType;
import com.goide.psi.GoTypeSpec;
import com.goide.psi.impl.GoElementFactory;
import com.intellij.codeInsight.intention.BaseElementAtCaretIntentionAction;
import com.intellij.codeInspection.util.IntentionFamilyName;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.DocumentUtil;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.ObjectUtils;
import java.util.Objects;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class GoGenerateStructFieldsFromJsonIntention
extends BaseElementAtCaretIntentionAction {
    @Nls(capitalization=Nls.Capitalization.Sentence)
    @NotNull
    public String getText() {
        String string = this.getFamilyName();
        if (string == null) {
            GoGenerateStructFieldsFromJsonIntention.$$$reportNull$$$0(0);
        }
        return string;
    }

    @NotNull
    @IntentionFamilyName
    public String getFamilyName() {
        String string = GoBundle.message((String)"go.intention.generate.struct.fields.from.json", (Object[])new Object[0]);
        if (string == null) {
            GoGenerateStructFieldsFromJsonIntention.$$$reportNull$$$0(1);
        }
        return string;
    }

    public boolean isAvailable(@NotNull Project project, @NotNull Editor editor, @NotNull PsiElement element) {
        if (project == null) {
            GoGenerateStructFieldsFromJsonIntention.$$$reportNull$$$0(2);
        }
        if (editor == null) {
            GoGenerateStructFieldsFromJsonIntention.$$$reportNull$$$0(3);
        }
        if (element == null) {
            GoGenerateStructFieldsFromJsonIntention.$$$reportNull$$$0(4);
        }
        if (editor.getCaretModel().getCaretCount() != 1) {
            return false;
        }
        return PsiTreeUtil.getParentOfType((PsiElement)element, GoStructType.class) != null;
    }

    public boolean startInWriteAction() {
        return false;
    }

    public void invoke(@NotNull Project project, @NotNull Editor editor, @NotNull PsiElement element) throws IncorrectOperationException {
        GoStructType targetStruct;
        if (project == null) {
            GoGenerateStructFieldsFromJsonIntention.$$$reportNull$$$0(5);
        }
        if (editor == null) {
            GoGenerateStructFieldsFromJsonIntention.$$$reportNull$$$0(6);
        }
        if (element == null) {
            GoGenerateStructFieldsFromJsonIntention.$$$reportNull$$$0(7);
        }
        if ((targetStruct = (GoStructType)PsiTreeUtil.getParentOfType((PsiElement)element, GoStructType.class)) == null) {
            return;
        }
        GoGenerateStructFieldsFromJsonIntention.showDialogAndGenerate(project, editor, targetStruct);
    }

    public static void showDialogAndGenerate(@NotNull Project project, @NotNull Editor editor, @NotNull GoStructType target) {
        if (project == null) {
            GoGenerateStructFieldsFromJsonIntention.$$$reportNull$$$0(8);
        }
        if (editor == null) {
            GoGenerateStructFieldsFromJsonIntention.$$$reportNull$$$0(9);
        }
        if (target == null) {
            GoGenerateStructFieldsFromJsonIntention.$$$reportNull$$$0(10);
        }
        ApplicationManager.getApplication().invokeLater(() -> {
            GoGenerateTypeFromJsonDialog dialog = new GoGenerateTypeFromJsonDialog(project, target){

                @Override
                @Nls(capitalization=Nls.Capitalization.Sentence)
                @Nullable
                protected String validateGeneratedType(@NotNull GoTypeSpec type2) {
                    GoStructType struct;
                    if (type2 == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    if ((struct = (GoStructType)ObjectUtils.tryCast((Object)type2.getSpecType().getType(), GoStructType.class)) == null || struct.getLbrace() == null || struct.getRbrace() == null) {
                        return GoBundle.message((String)"go.intention.generate.struct.fields.from.json.error", (Object[])new Object[0]);
                    }
                    return super.validateGeneratedType(type2);
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/goide/intentions/GoGenerateStructFieldsFromJsonIntention$1", "validateGeneratedType"));
                }
            };
            if (dialog.showAndGet()) {
                DocumentUtil.writeInRunUndoTransparentAction(() -> {
                    GoTypeSpec type2 = Objects.requireNonNull(dialog.getGeneratedType());
                    GoStructType generatedStruct = Objects.requireNonNull((GoStructType)type2.getSpecType().getType());
                    int caretOffset = editor.getCaretModel().getOffset();
                    PsiElement anchor = GoGenerateStructFieldsFromJsonIntention.getAnchor(project, target, caretOffset);
                    boolean first = true;
                    for (GoFieldDeclaration declaration : generatedStruct.getFieldDeclarationList()) {
                        PsiElement added = target.addBefore(declaration, anchor);
                        if (!first) continue;
                        editor.getCaretModel().moveToOffset(added.getTextRange().getStartOffset());
                        first = false;
                    }
                    GoFormatterUtil.reformat(target);
                });
            }
        });
    }

    @NotNull
    private static PsiElement getAnchor(@NotNull Project project, @NotNull GoStructType target, int caretOffset) {
        if (project == null) {
            GoGenerateStructFieldsFromJsonIntention.$$$reportNull$$$0(11);
        }
        if (target == null) {
            GoGenerateStructFieldsFromJsonIntention.$$$reportNull$$$0(12);
        }
        for (GoFieldDeclaration field : target.getFieldDeclarationList()) {
            if (field.getTextRange().getStartOffset() < caretOffset) continue;
            GoFieldDeclaration goFieldDeclaration = field;
            if (goFieldDeclaration == null) {
                GoGenerateStructFieldsFromJsonIntention.$$$reportNull$$$0(13);
            }
            return goFieldDeclaration;
        }
        PsiElement anchor = target.getRbrace();
        if (anchor == null) {
            GoBlock block = GoElementFactory.createBlock(project);
            PsiElement newline = target.addAfter(GoElementFactory.createNewLine(project), target.getLbrace());
            anchor = target.addAfter(Objects.requireNonNull(block.getRbrace()), newline);
        }
        PsiElement psiElement = anchor;
        if (psiElement == null) {
            GoGenerateStructFieldsFromJsonIntention.$$$reportNull$$$0(14);
        }
        return psiElement;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/goide/intentions/GoGenerateStructFieldsFromJsonIntention";
                break;
            }
            case 2: 
            case 5: 
            case 8: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 3: 
            case 6: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 4: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 10: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "target";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getText";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "com/goide/intentions/GoGenerateStructFieldsFromJsonIntention";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "getAnchor";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "isAvailable";
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "invoke";
                break;
            }
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "showDialogAndGenerate";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "getAnchor";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12 -> new IllegalArgumentException(string);
        };
    }
}

