/*
 * Decompiled with CFR 0.152.
 */
package com.goide.intentions;

import com.goide.GoParserDefinition;
import com.goide.documentation.GoDocumentationProvider;
import com.goide.formatter.GoFormatterUtil;
import com.goide.i18n.GoBundle;
import com.goide.intentions.GoBaseIntentionAction;
import com.goide.psi.GoBlock;
import com.goide.psi.GoChannelType;
import com.goide.psi.GoExpression;
import com.goide.psi.GoFunctionLit;
import com.goide.psi.GoFunctionType;
import com.goide.psi.GoPointerType;
import com.goide.psi.GoShortVarDeclaration;
import com.goide.psi.GoStatement;
import com.goide.psi.GoStatementsHolder;
import com.goide.psi.GoType;
import com.goide.psi.GoVarDeclaration;
import com.goide.psi.GoVarDefinition;
import com.goide.psi.GoVarSpec;
import com.goide.psi.impl.GoElementFactory;
import com.goide.psi.impl.GoLightType;
import com.goide.psi.impl.GoPsiImplUtil;
import com.goide.psi.impl.GoPsiUtil;
import com.goide.psi.impl.GoTypeUtil;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.ObjectUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.function.BiFunction;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class GoConvertToShortVarDeclarationIntention
extends GoBaseIntentionAction {
    @Nls(capitalization=Nls.Capitalization.Sentence)
    @NotNull
    public String getText() {
        String string = this.getFamilyName();
        if (string == null) {
            GoConvertToShortVarDeclarationIntention.$$$reportNull$$$0(0);
        }
        return string;
    }

    @Nls(capitalization=Nls.Capitalization.Sentence)
    @NotNull
    public String getFamilyName() {
        String string = GoBundle.message((String)"go.intention.convert.to.short.var.declaration.name", (Object[])new Object[0]);
        if (string == null) {
            GoConvertToShortVarDeclarationIntention.$$$reportNull$$$0(1);
        }
        return string;
    }

    @Override
    public boolean isAvailable(@NotNull Project project, @NotNull Editor editor, @NotNull PsiElement element) {
        Pair<GoVarDefinition, GoVarSpec> pair;
        if (project == null) {
            GoConvertToShortVarDeclarationIntention.$$$reportNull$$$0(2);
        }
        if (editor == null) {
            GoConvertToShortVarDeclarationIntention.$$$reportNull$$$0(3);
        }
        if (element == null) {
            GoConvertToShortVarDeclarationIntention.$$$reportNull$$$0(4);
        }
        if ((pair = GoConvertToShortVarDeclarationIntention.findDefinitionAndSpec(element)) == null) {
            return false;
        }
        GoVarDefinition definition = (GoVarDefinition)pair.first;
        GoVarSpec spec = (GoVarSpec)pair.second;
        if (spec != null && !(spec instanceof GoShortVarDeclaration)) {
            int index = spec.getDefinitionList().indexOf(definition);
            if (GoPsiUtil.getByIndex(spec.getExpressionList(), index) == null && !GoConvertToShortVarDeclarationIntention.isMultiValue(spec)) {
                return false;
            }
            PsiElement parent = spec.getParent();
            return parent instanceof GoVarDeclaration && GoConvertToShortVarDeclarationIntention.isInBlock(parent);
        }
        return false;
    }

    public void invoke(@NotNull Project project, @NotNull Editor editor, @NotNull PsiElement element) throws IncorrectOperationException {
        Pair<GoVarDefinition, GoVarSpec> pair;
        if (project == null) {
            GoConvertToShortVarDeclarationIntention.$$$reportNull$$$0(5);
        }
        if (editor == null) {
            GoConvertToShortVarDeclarationIntention.$$$reportNull$$$0(6);
        }
        if (element == null) {
            GoConvertToShortVarDeclarationIntention.$$$reportNull$$$0(7);
        }
        if ((pair = GoConvertToShortVarDeclarationIntention.findDefinitionAndSpec(element)) == null) {
            return;
        }
        GoVarDefinition definition = (GoVarDefinition)pair.first;
        GoVarSpec spec = (GoVarSpec)pair.second;
        if (GoConvertToShortVarDeclarationIntention.isMultiValue(spec)) {
            PsiElement assign = spec.getAssign();
            if (assign != null) {
                Pair<String, String> parts = GoConvertToShortVarDeclarationIntention.splitSiblings(assign);
                GoStatement shortVarDeclarationStatement = GoElementFactory.createShortVarDeclarationStatement(project, (String)parts.first, (String)parts.second);
                GoFormatterUtil.reformat(spec.getParent().replace((PsiElement)shortVarDeclarationStatement));
            }
        } else {
            PsiElement block;
            int index = spec != null ? spec.getDefinitionList().indexOf(definition) : -1;
            GoExpression expression = spec != null ? GoPsiUtil.getByIndex(spec.getExpressionList(), index) : null;
            GoVarDeclaration declaration = spec != null ? (GoVarDeclaration)ObjectUtils.tryCast((Object)spec.getParent(), GoVarDeclaration.class) : null;
            PsiElement statement = declaration != null ? declaration.getParent() : null;
            PsiElement psiElement = block = statement != null ? (PsiElement)ObjectUtils.tryCast((Object)statement.getParent(), GoStatementsHolder.class) : null;
            if (expression == null || block == null) {
                return;
            }
            GoConvertToShortVarDeclarationIntention.moveDefinitionBefore(editor, spec, definition, expression, statement, (left, right) -> left + ":=" + right);
        }
    }

    static void moveDefinitionBefore(@NotNull Editor editor, @NotNull GoVarSpec spec, @NotNull GoVarDefinition definition, @NotNull GoExpression expression, @NotNull PsiElement anchor, @NotNull BiFunction<? super String, ? super String, String> definitionStatementBuilder) {
        if (editor == null) {
            GoConvertToShortVarDeclarationIntention.$$$reportNull$$$0(8);
        }
        if (spec == null) {
            GoConvertToShortVarDeclarationIntention.$$$reportNull$$$0(9);
        }
        if (definition == null) {
            GoConvertToShortVarDeclarationIntention.$$$reportNull$$$0(10);
        }
        if (expression == null) {
            GoConvertToShortVarDeclarationIntention.$$$reportNull$$$0(11);
        }
        if (anchor == null) {
            GoConvertToShortVarDeclarationIntention.$$$reportNull$$$0(12);
        }
        if (definitionStatementBuilder == null) {
            GoConvertToShortVarDeclarationIntention.$$$reportNull$$$0(13);
        }
        String leftSide = GoConvertToShortVarDeclarationIntention.prepareLeftSide(spec, definition);
        String rightSide = GoConvertToShortVarDeclarationIntention.prepareRightSide(spec, expression);
        String newStatement = definitionStatementBuilder.apply(leftSide, rightSide);
        GoBlock newBlock = GoElementFactory.createBlock(spec.getProject(), newStatement);
        List<PsiElement> inserted = GoConvertToShortVarDeclarationIntention.insertBlockContentsBefore(anchor.getParent(), newBlock, anchor);
        GoVarDefinition addedDefinition = GoConvertToShortVarDeclarationIntention.findFirstDefinition(inserted);
        if (addedDefinition != null) {
            if (!GoConvertToShortVarDeclarationIntention.isSingleDefinitionDeclaration(spec)) {
                anchor.getParent().addBefore(GoElementFactory.createNewLine(anchor.getProject()), anchor);
            }
            spec.deleteDefinition(definition);
            GoFormatterUtil.reformat((PsiFile)addedDefinition.getContainingFile(), inserted);
            editor.getCaretModel().moveToOffset(addedDefinition.getTextOffset());
        }
    }

    @NotNull
    private static List<PsiElement> insertBlockContentsBefore(@NotNull PsiElement parent, @NotNull GoBlock block, @NotNull PsiElement anchor) {
        if (parent == null) {
            GoConvertToShortVarDeclarationIntention.$$$reportNull$$$0(14);
        }
        if (block == null) {
            GoConvertToShortVarDeclarationIntention.$$$reportNull$$$0(15);
        }
        if (anchor == null) {
            GoConvertToShortVarDeclarationIntention.$$$reportNull$$$0(16);
        }
        PsiElement stop = PsiTreeUtil.skipWhitespacesBackward((PsiElement)block.getRbrace());
        ArrayList<PsiElement> result = new ArrayList<PsiElement>();
        for (PsiElement element = PsiTreeUtil.skipWhitespacesForward((PsiElement)block.getLbrace()); element != null; element = element.getNextSibling()) {
            result.add(parent.addBefore(element, anchor));
            if (element == stop) break;
        }
        ArrayList<PsiElement> arrayList = result;
        if (arrayList == null) {
            GoConvertToShortVarDeclarationIntention.$$$reportNull$$$0(17);
        }
        return arrayList;
    }

    @Nullable
    private static GoVarDefinition findFirstDefinition(@NotNull List<PsiElement> elements) {
        if (elements == null) {
            GoConvertToShortVarDeclarationIntention.$$$reportNull$$$0(18);
        }
        for (PsiElement element : elements) {
            GoVarDefinition definition = (GoVarDefinition)PsiTreeUtil.findChildOfType((PsiElement)element, GoVarDefinition.class);
            if (definition == null) continue;
            return definition;
        }
        return null;
    }

    private static boolean isSingleDefinitionDeclaration(@NotNull GoVarSpec spec) {
        if (spec == null) {
            GoConvertToShortVarDeclarationIntention.$$$reportNull$$$0(19);
        }
        if (spec.getDefinitionList().size() != 1) {
            return false;
        }
        if (spec instanceof GoShortVarDeclaration) {
            return true;
        }
        GoVarDeclaration declaration = (GoVarDeclaration)PsiTreeUtil.getParentOfType((PsiElement)spec, GoVarDeclaration.class);
        return declaration == null || declaration.getSpecList().size() == 1;
    }

    @NotNull
    private static String prepareRightSide(@NotNull GoVarSpec spec, @NotNull GoExpression expression) {
        if (spec == null) {
            GoConvertToShortVarDeclarationIntention.$$$reportNull$$$0(20);
        }
        if (expression == null) {
            GoConvertToShortVarDeclarationIntention.$$$reportNull$$$0(21);
        }
        StringBuilder result = new StringBuilder();
        GoConvertToShortVarDeclarationIntention.appendComments(result, GoDocumentationProvider.getUpperComments(expression));
        result.append(GoConvertToShortVarDeclarationIntention.convertIfNeeded(expression, spec.getType()));
        GoConvertToShortVarDeclarationIntention.appendComments(result, GoDocumentationProvider.getAfterComments(expression));
        if (spec.getDefinitionList().size() == 1) {
            GoConvertToShortVarDeclarationIntention.appendComments(result, GoDocumentationProvider.getAfterComments(spec));
        }
        String string = result.toString();
        if (string == null) {
            GoConvertToShortVarDeclarationIntention.$$$reportNull$$$0(22);
        }
        return string;
    }

    @NotNull
    private static String prepareLeftSide(@NotNull GoVarSpec spec, @NotNull GoVarDefinition definition) {
        if (spec == null) {
            GoConvertToShortVarDeclarationIntention.$$$reportNull$$$0(23);
        }
        if (definition == null) {
            GoConvertToShortVarDeclarationIntention.$$$reportNull$$$0(24);
        }
        StringBuilder result = new StringBuilder();
        if (spec.getDefinitionList().size() == 1) {
            GoConvertToShortVarDeclarationIntention.appendComments(result, GoDocumentationProvider.getUpperComments(spec));
        }
        GoConvertToShortVarDeclarationIntention.appendComments(result, GoDocumentationProvider.getUpperComments(definition));
        result.append(definition.getText());
        GoConvertToShortVarDeclarationIntention.appendComments(result, GoDocumentationProvider.getAfterComments(definition));
        String string = result.toString();
        if (string == null) {
            GoConvertToShortVarDeclarationIntention.$$$reportNull$$$0(25);
        }
        return string;
    }

    private static void appendComments(@NotNull StringBuilder result, @NotNull List<PsiComment> comments) {
        if (result == null) {
            GoConvertToShortVarDeclarationIntention.$$$reportNull$$$0(26);
        }
        if (comments == null) {
            GoConvertToShortVarDeclarationIntention.$$$reportNull$$$0(27);
        }
        for (PsiComment comment : comments) {
            result.append(comment.getText());
            if (comment.getTokenType() != GoParserDefinition.Lazy.LINE_COMMENT) continue;
            result.append("\n");
        }
    }

    @NotNull
    private static String convertIfNeeded(@NotNull GoExpression expression, @Nullable GoType type2) {
        if (expression == null) {
            GoConvertToShortVarDeclarationIntention.$$$reportNull$$$0(28);
        }
        if (type2 == null) {
            String string = expression.getText();
            if (string == null) {
                GoConvertToShortVarDeclarationIntention.$$$reportNull$$$0(29);
            }
            return string;
        }
        GoType expressionType = expression.getGoType(null);
        if (expressionType != null && GoTypeUtil.identical(type2, expressionType, true, expression)) {
            String string = expression.getText();
            if (string == null) {
                GoConvertToShortVarDeclarationIntention.$$$reportNull$$$0(30);
            }
            return string;
        }
        Object typeText = GoConvertToShortVarDeclarationIntention.canBeAmbiguous(type2) ? "(" + type2.getText() + ")" : type2.getText();
        String string = (String)typeText + "(" + expression.getText() + ")";
        if (string == null) {
            GoConvertToShortVarDeclarationIntention.$$$reportNull$$$0(31);
        }
        return string;
    }

    private static boolean canBeAmbiguous(@NotNull GoType type2) {
        if (type2 == null) {
            GoConvertToShortVarDeclarationIntention.$$$reportNull$$$0(32);
        }
        return type2 instanceof GoPointerType || type2 instanceof GoChannelType && ((GoChannelType)type2).getDirection() == GoPsiImplUtil.ChannelDirection.RECEIVE || type2 instanceof GoFunctionType && ((GoFunctionType)type2).getResultType() instanceof GoLightType.LightVoidType;
    }

    static boolean isInBlock(@NotNull PsiElement element) {
        PsiElement statement;
        if (element == null) {
            GoConvertToShortVarDeclarationIntention.$$$reportNull$$$0(33);
        }
        return ((statement = element.getParent()) != null ? statement.getParent() : null) instanceof GoStatementsHolder;
    }

    static boolean isMultiValue(@Nullable GoVarSpec spec) {
        return spec != null && spec.getDefinitionList().size() > 1 && spec.getExpressionList().size() == 1;
    }

    @NotNull
    static Pair<String, String> splitSiblings(@NotNull PsiElement element) {
        if (element == null) {
            GoConvertToShortVarDeclarationIntention.$$$reportNull$$$0(34);
        }
        PsiElement parent = element.getParent();
        StringBuilder beforeElement = new StringBuilder();
        StringBuilder afterElement = new StringBuilder();
        StringBuilder buf = beforeElement;
        for (PsiElement child = parent.getFirstChild(); child != null; child = child.getNextSibling()) {
            if (child == element) {
                buf = afterElement;
                continue;
            }
            buf.append(child.getText());
        }
        Pair pair = Pair.create((Object)beforeElement.toString(), (Object)afterElement.toString());
        if (pair == null) {
            GoConvertToShortVarDeclarationIntention.$$$reportNull$$$0(35);
        }
        return pair;
    }

    @Nullable
    private static Pair<GoVarDefinition, GoVarSpec> findDefinitionAndSpec(@NotNull PsiElement context) {
        GoVarDefinition definition;
        if (context == null) {
            GoConvertToShortVarDeclarationIntention.$$$reportNull$$$0(36);
        }
        if ((definition = (GoVarDefinition)PsiTreeUtil.getParentOfType((PsiElement)context, GoVarDefinition.class)) != null) {
            GoVarSpec spec = (GoVarSpec)PsiTreeUtil.getParentOfType((PsiElement)definition, GoVarSpec.class);
            return spec != null ? Pair.pair((Object)definition, (Object)spec) : null;
        }
        PsiElement parent = PsiTreeUtil.getParentOfType((PsiElement)context, (Class[])new Class[]{GoVarDeclaration.class, GoFunctionLit.class});
        GoVarDeclaration declaration = (GoVarDeclaration)ObjectUtils.tryCast((Object)parent, GoVarDeclaration.class);
        if (declaration == null) {
            return null;
        }
        List<GoVarSpec> specs = declaration.getVarSpecList();
        if (specs.size() != 1) {
            return null;
        }
        GoVarSpec spec = specs.get(0);
        List<GoVarDefinition> definitions = spec.getDefinitionList();
        return definitions.size() == 1 || GoConvertToShortVarDeclarationIntention.isMultiValue(spec) ? Pair.pair((Object)definitions.get(0), (Object)spec) : null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 18, 19, 20, 21, 23, 24, 26, 27, 28, 32, 33, 34, 36 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/goide/intentions/GoConvertToShortVarDeclarationIntention";
                break;
            }
            case 2: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 3: 
            case 6: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 4: 
            case 7: 
            case 33: 
            case 34: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 9: 
            case 19: 
            case 20: 
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "spec";
                break;
            }
            case 10: 
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "definition";
                break;
            }
            case 11: 
            case 21: 
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expression";
                break;
            }
            case 12: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "anchor";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "definitionStatementBuilder";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parent";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "block";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elements";
                break;
            }
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "comments";
                break;
            }
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 36: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getText";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 23: 
            case 24: 
            case 26: 
            case 27: 
            case 28: 
            case 32: 
            case 33: 
            case 34: 
            case 36: {
                objectArray = objectArray2;
                objectArray2[1] = "com/goide/intentions/GoConvertToShortVarDeclarationIntention";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "insertBlockContentsBefore";
                break;
            }
            case 22: {
                objectArray = objectArray2;
                objectArray2[1] = "prepareRightSide";
                break;
            }
            case 25: {
                objectArray = objectArray2;
                objectArray2[1] = "prepareLeftSide";
                break;
            }
            case 29: 
            case 30: 
            case 31: {
                objectArray = objectArray2;
                objectArray2[1] = "convertIfNeeded";
                break;
            }
            case 35: {
                objectArray = objectArray2;
                objectArray2[1] = "splitSiblings";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "isAvailable";
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "invoke";
                break;
            }
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "moveDefinitionBefore";
                break;
            }
            case 14: 
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "insertBlockContentsBefore";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "findFirstDefinition";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "isSingleDefinitionDeclaration";
                break;
            }
            case 20: 
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "prepareRightSide";
                break;
            }
            case 23: 
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "prepareLeftSide";
                break;
            }
            case 26: 
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "appendComments";
                break;
            }
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "convertIfNeeded";
                break;
            }
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "canBeAmbiguous";
                break;
            }
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "isInBlock";
                break;
            }
            case 34: {
                objectArray = objectArray;
                objectArray[2] = "splitSiblings";
                break;
            }
            case 36: {
                objectArray = objectArray;
                objectArray[2] = "findDefinitionAndSpec";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 18, 19, 20, 21, 23, 24, 26, 27, 28, 32, 33, 34, 36 -> new IllegalArgumentException(string);
        };
    }
}

