/*
 * Decompiled with CFR 0.152.
 */
package com.goide.inspections.vet;

import com.goide.GoTypes;
import com.goide.inspections.core.GoInspectionBase;
import com.goide.inspections.core.GoProblemsHolder;
import com.goide.psi.GoAssignOp;
import com.goide.psi.GoAssignmentStatement;
import com.goide.psi.GoBinaryExpr;
import com.goide.psi.GoExpression;
import com.goide.psi.GoType;
import com.goide.psi.GoVisitor;
import com.goide.psi.impl.GoExpressionEvaluator;
import com.goide.psi.impl.GoExpressionUtil;
import com.goide.psi.impl.GoSizes;
import com.goide.util.GoTargetSystem;
import com.goide.util.GoUtil;
import com.goide.util.Value;
import com.intellij.codeInspection.LocalInspectionToolSession;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.tree.IElementType;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class GoShiftInspection
extends GoInspectionBase {
    @Override
    @NotNull
    protected PsiElementVisitor buildVisitor(final @NotNull GoProblemsHolder holder, @NotNull LocalInspectionToolSession session) {
        if (holder == null) {
            GoShiftInspection.$$$reportNull$$$0(0);
        }
        if (session == null) {
            GoShiftInspection.$$$reportNull$$$0(1);
        }
        final GoSizes sizes = GoSizes.forTarget(GoTargetSystem.forModule(GoUtil.module((PsiElement)holder.getFile())));
        return new GoVisitor(){

            @Override
            public void visitBinaryExpr(@NotNull GoBinaryExpr o) {
                if (o == null) {
                    1.$$$reportNull$$$0(0);
                }
                super.visitBinaryExpr(o);
                IElementType operatorType = GoExpressionUtil.getOperatorType(o);
                if (operatorType == GoTypes.SHIFT_LEFT || operatorType == GoTypes.SHIFT_RIGHT) {
                    this.checkShift(o, o.getLeft(), o.getRight());
                }
            }

            @Override
            public void visitAssignmentStatement(@NotNull GoAssignmentStatement o) {
                if (o == null) {
                    1.$$$reportNull$$$0(1);
                }
                super.visitAssignmentStatement(o);
                GoAssignOp op = o.getAssignOp();
                if (op.getShiftLeftAssign() != null || op.getShiftRightAssign() != null) {
                    List<GoExpression> list = o.getLeftHandExprList().getExpressionList();
                    List<GoExpression> values = o.getExpressionList();
                    if (list.size() == 1 && values.size() == 1) {
                        this.checkShift(o, list.get(0), values.get(0));
                    }
                }
            }

            private void checkShift(@NotNull PsiElement o, @NotNull GoExpression left, @Nullable GoExpression right) {
                Long rightSize;
                if (o == null) {
                    1.$$$reportNull$$$0(2);
                }
                if (left == null) {
                    1.$$$reportNull$$$0(3);
                }
                if (right == null) {
                    return;
                }
                if (GoExpressionUtil.isConstant(left)) {
                    return;
                }
                GoType leftType = left.getGoType(null);
                if (leftType == null) {
                    return;
                }
                Value<?> rightValue = GoExpressionEvaluator.evaluateExpression(right);
                Long l = rightSize = rightValue != null ? rightValue.getInteger() : null;
                if (rightSize == null) {
                    return;
                }
                long leftSize = 8L * sizes.sizeOf(leftType, null);
                if (rightSize >= leftSize && leftSize > 0L) {
                    holder.registerProblem(o, GoShiftInspection.message("go.inspection.problem.expression.is.too.small.for.shift", new Object[]{GoShiftInspection.code(left), leftSize, rightSize}), new LocalQuickFix[0]);
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "o";
                        break;
                    }
                    case 3: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "left";
                        break;
                    }
                }
                objectArray2[1] = "com/goide/inspections/vet/GoShiftInspection$1";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "visitBinaryExpr";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "visitAssignmentStatement";
                        break;
                    }
                    case 2: 
                    case 3: {
                        objectArray = objectArray2;
                        objectArray2[2] = "checkShift";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        };
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "holder";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "session";
                break;
            }
        }
        objectArray[1] = "com/goide/inspections/vet/GoShiftInspection";
        objectArray[2] = "buildVisitor";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

