/*
 * Decompiled with CFR 0.152.
 */
package com.goide.inspections.vet;

import com.goide.i18n.GoBundle;
import com.goide.psi.GoCallExpr;
import com.goide.psi.GoExpression;
import com.goide.psi.GoReferenceExpression;
import com.goide.psi.GoStatement;
import com.goide.psi.impl.GoElementFactory;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiTreeUtil;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0018\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016J\b\u0010\r\u001a\u00020\u0003H\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u000e"}, d2={"Lcom/goide/inspections/vet/GoReplaceAndReturnFix;", "Lcom/intellij/codeInspection/LocalQuickFix;", "newFunctionName", "", "(Ljava/lang/String;)V", "getNewFunctionName", "()Ljava/lang/String;", "applyFix", "", "project", "Lcom/intellij/openapi/project/Project;", "descriptor", "Lcom/intellij/codeInspection/ProblemDescriptor;", "getFamilyName", "intellij.go.impl"})
final class GoReplaceAndReturnFix
implements LocalQuickFix {
    @NotNull
    private final String newFunctionName;

    public GoReplaceAndReturnFix(@NotNull String newFunctionName) {
        Intrinsics.checkNotNullParameter((Object)newFunctionName, (String)"newFunctionName");
        this.newFunctionName = newFunctionName;
    }

    @NotNull
    public final String getNewFunctionName() {
        return this.newFunctionName;
    }

    @NotNull
    public String getFamilyName() {
        Object[] objectArray = new Object[]{this.newFunctionName};
        String string = GoBundle.message((String)"go.fix.replace.and.return", (Object[])objectArray);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        return string;
    }

    public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)descriptor, (String)"descriptor");
        PsiElement psiElement = descriptor.getPsiElement();
        Intrinsics.checkNotNull((Object)psiElement, (String)"null cannot be cast to non-null type com.goide.psi.GoCallExpr");
        GoCallExpr call = (GoCallExpr)psiElement;
        GoExpression goExpression = call.getExpression();
        GoReferenceExpression goReferenceExpression = goExpression instanceof GoReferenceExpression ? (GoReferenceExpression)goExpression : null;
        if (goReferenceExpression == null || (goReferenceExpression = goReferenceExpression.getIdentifier()) == null) {
            return;
        }
        GoReferenceExpression calledMethodIdentifier = goReferenceExpression;
        GoStatement goStatement = (GoStatement)PsiTreeUtil.getParentOfType((PsiElement)call, GoStatement.class);
        if (goStatement == null) {
            return;
        }
        GoStatement callStatement = goStatement;
        PsiElement psiElement2 = callStatement.getParent();
        if (psiElement2 == null) {
            return;
        }
        PsiElement parent = psiElement2;
        parent.addAfter((PsiElement)GoElementFactory.createReturnStatement(project, ""), (PsiElement)callStatement);
        calledMethodIdentifier.replace(GoElementFactory.createReferenceExpression(project, this.newFunctionName));
    }
}

