/*
 * Decompiled with CFR 0.152.
 */
package com.goide.inspections.tag;

import com.goide.i18n.GoBundle;
import com.goide.inspections.tag.GoTagFieldNameStyle;
import com.goide.inspections.tag.GoTagUtil;
import com.goide.intentions.GoBaseIntentionAction;
import com.goide.psi.GoAnonymousFieldDefinition;
import com.goide.psi.GoFieldDeclaration;
import com.goide.psi.GoFieldDefinition;
import com.goide.psi.GoFile;
import com.goide.psi.GoStringLiteral;
import com.goide.psi.GoStructType;
import com.goide.psi.GoTag;
import com.goide.psi.GoType;
import com.goide.psi.GoVarOrConstSpec;
import com.goide.refactor.template.GoTemplate;
import com.intellij.codeInsight.intention.PriorityAction;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.template.Expression;
import com.intellij.codeInsight.template.ExpressionContext;
import com.intellij.codeInsight.template.Result;
import com.intellij.codeInsight.template.Template;
import com.intellij.codeInsight.template.TemplateEditingAdapter;
import com.intellij.codeInsight.template.TemplateEditingListener;
import com.intellij.codeInsight.template.TextResult;
import com.intellij.codeInsight.template.impl.ConstantNode;
import com.intellij.codeInspection.util.IntentionFamilyName;
import com.intellij.codeInspection.util.IntentionName;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Iconable;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.SyntaxTraverser;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.containers.ContainerUtil;
import java.util.List;
import java.util.Objects;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class GoTagAddKeyIntention
extends GoBaseIntentionAction
implements Iconable,
PriorityAction {
    private static final Key<Boolean> IN_PROGRESS = Key.create((String)GoTagAddKeyIntention.class.getName());

    @NotNull
    @IntentionFamilyName
    public String getFamilyName() {
        String string = GoBundle.message((String)"go.intention.add.tag.key", (Object[])new Object[0]);
        if (string == null) {
            GoTagAddKeyIntention.$$$reportNull$$$0(0);
        }
        return string;
    }

    @IntentionName
    @NotNull
    public String getText() {
        String string = this.getFamilyName();
        if (string == null) {
            GoTagAddKeyIntention.$$$reportNull$$$0(1);
        }
        return string;
    }

    public Icon getIcon(int flags) {
        return AllIcons.Nodes.Tag;
    }

    @NotNull
    public PriorityAction.Priority getPriority() {
        PriorityAction.Priority priority = PriorityAction.Priority.TOP;
        if (priority == null) {
            GoTagAddKeyIntention.$$$reportNull$$$0(2);
        }
        return priority;
    }

    public static boolean isInProgress(@NotNull PsiFile file) {
        if (file == null) {
            GoTagAddKeyIntention.$$$reportNull$$$0(3);
        }
        return IN_PROGRESS.get((UserDataHolder)file.getOriginalFile()) == Boolean.TRUE;
    }

    @Override
    public boolean isAvailable(@NotNull Project project, @NotNull Editor editor, @NotNull PsiElement element) {
        if (project == null) {
            GoTagAddKeyIntention.$$$reportNull$$$0(4);
        }
        if (editor == null) {
            GoTagAddKeyIntention.$$$reportNull$$$0(5);
        }
        if (element == null) {
            GoTagAddKeyIntention.$$$reportNull$$$0(6);
        }
        if (!super.isAvailable(project, editor, element)) {
            return false;
        }
        GoStructType struct = (GoStructType)PsiTreeUtil.getParentOfType((PsiElement)element, GoStructType.class);
        if (struct == null) {
            return false;
        }
        return SyntaxTraverser.psiTraverser((PsiElement)struct).postOrderDfsTraversal().filter(GoFieldDeclaration.class).find(it -> GoTagAddKeyIntention.getFieldNameAndOffset(it, 0) != null) != null;
    }

    public void invoke(@NotNull Project project, @NotNull Editor editor, @NotNull PsiElement element) throws IncorrectOperationException {
        if (project == null) {
            GoTagAddKeyIntention.$$$reportNull$$$0(7);
        }
        if (editor == null) {
            GoTagAddKeyIntention.$$$reportNull$$$0(8);
        }
        if (element == null) {
            GoTagAddKeyIntention.$$$reportNull$$$0(9);
        }
        PsiDocumentManager.getInstance((Project)project).commitDocument(editor.getDocument());
        GoStructType struct = (GoStructType)PsiTreeUtil.getParentOfType((PsiElement)element, GoStructType.class);
        if (struct == null) {
            return;
        }
        StructTemplateBuilder builder = new StructTemplateBuilder(struct);
        GoTemplate template = builder.buildTemplate();
        if (template == null) {
            return;
        }
        GoTagAddKeyIntention.disableLiveTemplatesCompletionInTags(element.getContainingFile(), template);
        template.startTemplate(editor, builder.getTemplateStartOffset(), this.getText(), builder.getRangeToRemove());
    }

    @Nullable
    private static Pair<String, Integer> getFieldNameAndOffset(@NotNull GoFieldDeclaration field, int baseOffset) {
        GoTag tag;
        if (field == null) {
            GoTagAddKeyIntention.$$$reportNull$$$0(10);
        }
        if ((tag = field.getTag()) != null && tag.getStringLiteral().getRawString() == null) {
            return null;
        }
        GoFieldDefinition onlyDefinition = (GoFieldDefinition)ContainerUtil.getOnlyItem(field.getFieldDefinitionList());
        if (onlyDefinition != null) {
            String fieldName = onlyDefinition.getName();
            GoType type2 = field.getType();
            return type2 != null ? Pair.create((Object)fieldName, (Object)(type2.getTextRange().getEndOffset() - baseOffset)) : Pair.create((Object)fieldName, (Object)(onlyDefinition.getIdentifier().getTextRange().getEndOffset() - baseOffset));
        }
        GoAnonymousFieldDefinition anonymous = field.getAnonymousFieldDefinition();
        if (anonymous != null) {
            return Pair.create((Object)anonymous.getType().getText(), (Object)(anonymous.getTextRange().getEndOffset() - baseOffset));
        }
        return null;
    }

    private static void disableLiveTemplatesCompletionInTags(final @NotNull PsiFile file, @NotNull GoTemplate template) {
        if (file == null) {
            GoTagAddKeyIntention.$$$reportNull$$$0(11);
        }
        if (template == null) {
            GoTagAddKeyIntention.$$$reportNull$$$0(12);
        }
        file.putUserData(IN_PROGRESS, (Object)true);
        template.addListener((TemplateEditingListener)new TemplateEditingAdapter(){

            public void templateCancelled(Template template) {
                file.putUserData(IN_PROGRESS, null);
            }

            public void templateFinished(@NotNull Template template, boolean brokenOff) {
                if (template == null) {
                    1.$$$reportNull$$$0(0);
                }
                file.putUserData(IN_PROGRESS, null);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "template", "com/goide/inspections/tag/GoTagAddKeyIntention$1", "templateFinished"));
            }
        });
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 3, 4, 5, 6, 7, 8, 9, 10, 11, 12 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/goide/inspections/tag/GoTagAddKeyIntention";
                break;
            }
            case 3: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 4: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 5: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 6: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "field";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "template";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getText";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getPriority";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "com/goide/inspections/tag/GoTagAddKeyIntention";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "isInProgress";
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "isAvailable";
                break;
            }
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "invoke";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "getFieldNameAndOffset";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "disableLiveTemplatesCompletionInTags";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 3, 4, 5, 6, 7, 8, 9, 10, 11, 12 -> new IllegalArgumentException(string);
        };
    }

    private static class StructTemplateBuilder {
        private final GoFile myFile;
        private final List<GoFieldDeclaration> myFields;
        private final String myTemplateText;
        private final int myStartOffset;
        private final TextRange myRangeToRemove;
        private int myOffset;

        StructTemplateBuilder(@NotNull GoStructType struct) {
            if (struct == null) {
                StructTemplateBuilder.$$$reportNull$$$0(0);
            }
            this.myFile = (GoFile)struct.getContainingFile();
            this.myFields = SyntaxTraverser.psiTraverser((PsiElement)struct).postOrderDfsTraversal().filter(GoFieldDeclaration.class).toList();
            PsiElement templateElement = PsiTreeUtil.getParentOfType((PsiElement)struct, GoStructType.class);
            if (templateElement == null) {
                templateElement = struct;
            }
            if (templateElement.getParent() instanceof GoVarOrConstSpec) {
                templateElement = templateElement.getParent();
            }
            this.myTemplateText = templateElement.getText();
            this.myStartOffset = templateElement.getTextRange().getStartOffset();
            this.myRangeToRemove = templateElement.getTextRange();
        }

        private int getTemplateStartOffset() {
            return this.myStartOffset;
        }

        private TextRange getRangeToRemove() {
            return this.myRangeToRemove;
        }

        @Nullable
        GoTemplate buildTemplate() {
            if (this.myTemplateText == null) {
                return null;
            }
            this.myOffset = 0;
            GoTemplate template = new GoTemplate(this.myFile);
            GoFieldDeclaration primaryVarField = null;
            boolean tagAdded = false;
            GoTagFieldNameStyle style = GoTagFieldNameStyle.getLastUsedStyle();
            for (GoFieldDeclaration field : this.myFields) {
                Pair<String, Integer> fieldNameAndEndOffset = GoTagAddKeyIntention.getFieldNameAndOffset(field, this.myStartOffset);
                if (fieldNameAndEndOffset == null) continue;
                if (primaryVarField == null) {
                    primaryVarField = field;
                }
                this.writeField(template, (Integer)fieldNameAndEndOffset.second);
                GoTag existingTag = field.getTag();
                this.startTag(template, existingTag);
                StructTemplateBuilder.writeKey(template, style, primaryVarField, field, (String)fieldNameAndEndOffset.first, existingTag);
                StructTemplateBuilder.finishTag(template, existingTag);
                tagAdded = true;
            }
            template.addTextSegment(this.myTemplateText.substring(this.myOffset));
            return tagAdded ? template : null;
        }

        private void writeField(@NotNull GoTemplate template, int fieldEndOffset) {
            if (template == null) {
                StructTemplateBuilder.$$$reportNull$$$0(1);
            }
            template.addTextSegment(this.myTemplateText.substring(this.myOffset, fieldEndOffset));
            this.myOffset = fieldEndOffset;
        }

        private void startTag(@NotNull GoTemplate template, @Nullable GoTag existingTag) {
            if (template == null) {
                StructTemplateBuilder.$$$reportNull$$$0(2);
            }
            if (existingTag != null) {
                GoStringLiteral literal = existingTag.getStringLiteral();
                PsiElement rawString = Objects.requireNonNull(literal.getRawString());
                int tagEndOffset = rawString.getTextRange().getEndOffset() - 1;
                int newOffset = tagEndOffset - this.myStartOffset;
                template.addTextSegment(this.myTemplateText.substring(this.myOffset, newOffset));
                char lastChar = this.myTemplateText.charAt(newOffset - 1);
                if (lastChar != ' ' && lastChar != '`') {
                    template.addTextSegment(" ");
                }
                this.myOffset = newOffset;
            } else {
                template.addTextSegment(" `");
            }
        }

        private static void finishTag(@NotNull GoTemplate template, @Nullable GoTag existingTag) {
            if (template == null) {
                StructTemplateBuilder.$$$reportNull$$$0(3);
            }
            if (existingTag == null) {
                template.addTextSegment("`");
            }
        }

        private static void writeKey(@NotNull GoTemplate template, @NotNull GoTagFieldNameStyle style, @NotNull GoFieldDeclaration primaryVarField, @NotNull GoFieldDeclaration field, @NotNull String fieldName, @Nullable GoTag existingTag) {
            boolean addOmitEmpty;
            if (template == null) {
                StructTemplateBuilder.$$$reportNull$$$0(4);
            }
            if (style == null) {
                StructTemplateBuilder.$$$reportNull$$$0(5);
            }
            if (primaryVarField == null) {
                StructTemplateBuilder.$$$reportNull$$$0(6);
            }
            if (field == null) {
                StructTemplateBuilder.$$$reportNull$$$0(7);
            }
            if (fieldName == null) {
                StructTemplateBuilder.$$$reportNull$$$0(8);
            }
            String styledName = style.apply(fieldName);
            boolean bl = addOmitEmpty = !StructTemplateBuilder.isStructField(field);
            if (field == primaryVarField) {
                StructTemplateBuilder.addPrimaryKey(template, existingTag, styledName, addOmitEmpty);
            } else {
                StructTemplateBuilder.addSecondaryKey(template, styledName, addOmitEmpty);
            }
        }

        private static boolean isStructField(GoFieldDeclaration field) {
            GoType underlying;
            GoType type2 = field.getType();
            if (type2 == null) {
                GoAnonymousFieldDefinition anonymous = field.getAnonymousFieldDefinition();
                GoType goType = type2 = anonymous != null ? anonymous.getType() : null;
            }
            return type2 != null && (underlying = type2.getUnderlyingType(field)) instanceof GoStructType;
        }

        private static void addPrimaryKey(@NotNull GoTemplate template, @Nullable GoTag existingTag, @NotNull String fieldName, boolean addOmitEmpty) {
            if (template == null) {
                StructTemplateBuilder.$$$reportNull$$$0(9);
            }
            if (fieldName == null) {
                StructTemplateBuilder.$$$reportNull$$$0(10);
            }
            String defaultKey = existingTag != null && GoTagUtil.getKeys(existingTag).contains("json") ? null : "json";
            ConstantNode defaultValue = defaultKey != null ? new ConstantNode(defaultKey) : null;
            template.addPrimaryVariable("KEY", (Expression)defaultValue);
            template.addTextSegment(":\"" + fieldName);
            if (addOmitEmpty) {
                StructTemplateBuilder.addOmitEmptyVar(template);
            }
            template.addEndVariable();
            template.addTextSegment("\"");
        }

        private static void addSecondaryKey(@NotNull GoTemplate template, @NotNull String fieldName, boolean addOmitEmpty) {
            if (template == null) {
                StructTemplateBuilder.$$$reportNull$$$0(11);
            }
            if (fieldName == null) {
                StructTemplateBuilder.$$$reportNull$$$0(12);
            }
            template.addSecondaryVariable("KEY");
            template.addTextSegment(":\"" + fieldName);
            if (addOmitEmpty) {
                StructTemplateBuilder.addOmitEmptyVar(template);
            }
            template.addTextSegment("\"");
        }

        private static void addOmitEmptyVar(@NotNull GoTemplate template) {
            if (template == null) {
                StructTemplateBuilder.$$$reportNull$$$0(13);
            }
            template.getTemplate().addVariable(new Expression(){

                @NotNull
                public Result calculateResult(ExpressionContext context) {
                    TextResult keyResult = context.getVariableValue("KEY");
                    String key = keyResult != null ? keyResult.getText() : null;
                    return "json".equals(key) ? new TextResult(",omitempty") : new TextResult("");
                }

                public LookupElement @Nullable [] calculateLookupItems(ExpressionContext context) {
                    return LookupElement.EMPTY_ARRAY;
                }
            }, false);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "struct";
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 9: 
                case 11: 
                case 13: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "template";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "style";
                    break;
                }
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "primaryVarField";
                    break;
                }
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "field";
                    break;
                }
                case 8: 
                case 10: 
                case 12: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "fieldName";
                    break;
                }
            }
            objectArray2[1] = "com/goide/inspections/tag/GoTagAddKeyIntention$StructTemplateBuilder";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "writeField";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "startTag";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "finishTag";
                    break;
                }
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 8: {
                    objectArray = objectArray2;
                    objectArray2[2] = "writeKey";
                    break;
                }
                case 9: 
                case 10: {
                    objectArray = objectArray2;
                    objectArray2[2] = "addPrimaryKey";
                    break;
                }
                case 11: 
                case 12: {
                    objectArray = objectArray2;
                    objectArray2[2] = "addSecondaryKey";
                    break;
                }
                case 13: {
                    objectArray = objectArray2;
                    objectArray2[2] = "addOmitEmptyVar";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

