/*
 * Decompiled with CFR 0.152.
 */
package com.goide.inspections.buildTag;

import com.goide.GoConstants;
import com.goide.inspections.buildTag.GoBuildFile;
import com.goide.inspections.buildTag.GoBuildTagIndex;
import com.goide.sdk.GoSdk;
import com.goide.sdk.GoSdkService;
import com.goide.util.GoUtil;
import com.intellij.codeInsight.completion.CompletionContributor;
import com.intellij.codeInsight.completion.CompletionParameters;
import com.intellij.codeInsight.completion.CompletionProvider;
import com.intellij.codeInsight.completion.CompletionResultSet;
import com.intellij.codeInsight.completion.CompletionType;
import com.intellij.codeInsight.completion.PrefixMatcher;
import com.intellij.codeInsight.lookup.AutoCompletionPolicy;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementBuilder;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.patterns.ElementPattern;
import com.intellij.patterns.PlatformPatterns;
import com.intellij.psi.PsiElement;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.util.ProcessingContext;
import com.intellij.util.indexing.FileBasedIndex;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class GoBuildCompletionContributor
extends CompletionContributor
implements DumbAware {
    public static final Set<String> WELL_KNOWN_TAGS = new HashSet<String>();

    public GoBuildCompletionContributor() {
        this.extend(CompletionType.BASIC, (ElementPattern)PlatformPatterns.psiElement().inside(GoBuildFile.class), new GoBuildCompletionProvider());
    }

    public static void addBuildTagElements(@NotNull Project project, @Nullable Module module, @NotNull CompletionResultSet result) {
        if (project == null) {
            GoBuildCompletionContributor.$$$reportNull$$$0(0);
        }
        if (result == null) {
            GoBuildCompletionContributor.$$$reportNull$$$0(1);
        }
        for (String tag : WELL_KNOWN_TAGS) {
            result.addElement(GoBuildCompletionContributor.createBuildTagElement(tag));
        }
        GoSdk sdk = GoSdkService.getInstance(project).getSdk(module);
        if (sdk.supportsUnixBuildConstraint()) {
            result.addElement(GoBuildCompletionContributor.createBuildTagElement("unix"));
        }
        if (module == null || DumbService.getInstance((Project)module.getProject()).isDumb()) {
            return;
        }
        GlobalSearchScope scope = GoUtil.moduleScopeWithoutLibraries(project, module);
        Collection tags = FileBasedIndex.getInstance().getAllKeys(GoBuildTagIndex.KEY, project);
        PrefixMatcher matcher = result.getPrefixMatcher();
        for (String tag : tags) {
            if (WELL_KNOWN_TAGS.contains(tag) || "unix".equals(tag) && sdk.supportsUnixBuildConstraint() || !matcher.prefixMatches(tag) || FileBasedIndex.getInstance().getContainingFiles(GoBuildTagIndex.KEY, (Object)tag, scope).isEmpty()) continue;
            result.addElement(GoBuildCompletionContributor.createBuildTagElement(tag));
        }
    }

    @NotNull
    private static LookupElement createBuildTagElement(@NotNull String tag) {
        if (tag == null) {
            GoBuildCompletionContributor.$$$reportNull$$$0(2);
        }
        LookupElement lookupElement = LookupElementBuilder.create((String)tag).withAutoCompletionPolicy(AutoCompletionPolicy.NEVER_AUTOCOMPLETE);
        if (lookupElement == null) {
            GoBuildCompletionContributor.$$$reportNull$$$0(3);
        }
        return lookupElement;
    }

    static {
        WELL_KNOWN_TAGS.addAll(GoConstants.KNOWN_OS);
        WELL_KNOWN_TAGS.addAll(GoConstants.KNOWN_ARCH);
        WELL_KNOWN_TAGS.addAll(GoConstants.KNOWN_VERSIONS);
        WELL_KNOWN_TAGS.addAll(GoConstants.KNOWN_COMPILERS);
        WELL_KNOWN_TAGS.add("cgo");
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 3 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tag";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/goide/inspections/buildTag/GoBuildCompletionContributor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/goide/inspections/buildTag/GoBuildCompletionContributor";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "createBuildTagElement";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "addBuildTagElements";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "createBuildTagElement";
                break;
            }
            case 3: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 3 -> new IllegalStateException(string);
        };
    }

    private static class GoBuildCompletionProvider
    extends CompletionProvider<CompletionParameters> {
        private GoBuildCompletionProvider() {
        }

        protected void addCompletions(@NotNull CompletionParameters parameters, @NotNull ProcessingContext context, @NotNull CompletionResultSet result) {
            if (parameters == null) {
                GoBuildCompletionProvider.$$$reportNull$$$0(0);
            }
            if (context == null) {
                GoBuildCompletionProvider.$$$reportNull$$$0(1);
            }
            if (result == null) {
                GoBuildCompletionProvider.$$$reportNull$$$0(2);
            }
            Project project = parameters.getPosition().getProject();
            Module module = GoUtil.module((PsiElement)parameters.getOriginalFile());
            GoBuildCompletionContributor.addBuildTagElements(project, module, result);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "parameters";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "context";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[0] = "result";
                    break;
                }
            }
            objectArray[1] = "com/goide/inspections/buildTag/GoBuildCompletionContributor$GoBuildCompletionProvider";
            objectArray[2] = "addCompletions";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

