/*
 * Decompiled with CFR 0.152.
 */
package com.goide.inspections;

import com.goide.GoTypes;
import com.goide.controlflow.GoControlFlowProvider;
import com.goide.controlflow.GoControlFlowUtil;
import com.goide.controlflow.instructions.GoForLoopStartInstruction;
import com.goide.dataflow.GoDataFlow;
import com.goide.dataflow.GoDataFlowBuilder;
import com.goide.dataflow.GoDataFlowUtil;
import com.goide.dataflow.GoNilness;
import com.goide.inspections.core.GoInspectionBase;
import com.goide.inspections.core.GoInspectionMessage;
import com.goide.inspections.core.GoProblemsHolder;
import com.goide.psi.GoAnonymousFieldDefinition;
import com.goide.psi.GoArgumentList;
import com.goide.psi.GoArrayOrSliceType;
import com.goide.psi.GoAssignmentStatement;
import com.goide.psi.GoCallExpr;
import com.goide.psi.GoCommCase;
import com.goide.psi.GoCompositeElement;
import com.goide.psi.GoConditionalExpr;
import com.goide.psi.GoExpression;
import com.goide.psi.GoFieldDefinition;
import com.goide.psi.GoForClause;
import com.goide.psi.GoForStatement;
import com.goide.psi.GoFunctionLit;
import com.goide.psi.GoFunctionOrMethodDeclaration;
import com.goide.psi.GoFunctionType;
import com.goide.psi.GoIndexOrSliceExpr;
import com.goide.psi.GoMapType;
import com.goide.psi.GoMethodDeclaration;
import com.goide.psi.GoMethodSpec;
import com.goide.psi.GoNamedElement;
import com.goide.psi.GoParamDefinition;
import com.goide.psi.GoPointerType;
import com.goide.psi.GoRangeClause;
import com.goide.psi.GoReceiver;
import com.goide.psi.GoRecursiveVisitor;
import com.goide.psi.GoRecvStatement;
import com.goide.psi.GoReferenceExpression;
import com.goide.psi.GoResolvable;
import com.goide.psi.GoSelectStatement;
import com.goide.psi.GoSendStatement;
import com.goide.psi.GoType;
import com.goide.psi.GoUnaryExpr;
import com.goide.psi.GoVarDefinition;
import com.goide.psi.GoVisitor;
import com.goide.psi.impl.GoPsiUtil;
import com.goide.util.GoStdlibUtil;
import com.goide.util.Value;
import com.intellij.codeInsight.controlflow.ControlFlow;
import com.intellij.codeInsight.controlflow.Instruction;
import com.intellij.codeInspection.LocalInspectionToolSession;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.Trinity;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Predicate;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class GoNilnessInspection
extends GoInspectionBase {
    private static final Key<Map<PsiElement, GoDataFlow>> DATAFLOW_CACHE = Key.create((String)"Dataflow cache: function -> dataflow");

    @Override
    @NotNull
    protected PsiElementVisitor buildVisitor(final @NotNull GoProblemsHolder holder, final @NotNull LocalInspectionToolSession session) {
        if (holder == null) {
            GoNilnessInspection.$$$reportNull$$$0(0);
        }
        if (session == null) {
            GoNilnessInspection.$$$reportNull$$$0(1);
        }
        session.putUserData(DATAFLOW_CACHE, new HashMap());
        return new GoVisitor(){

            @Override
            public void visitCallExpr(@NotNull GoCallExpr callExpr) {
                PsiElement resolve2;
                if (callExpr == null) {
                    1.$$$reportNull$$$0(0);
                }
                super.visitCallExpr(callExpr);
                GoReferenceExpression ref = GoPsiUtil.getCallReference(callExpr);
                PsiElement psiElement = resolve2 = ref != null ? ref.resolve() : null;
                if (resolve2 instanceof GoMethodDeclaration || resolve2 instanceof GoMethodSpec) {
                    GoNamedElement var;
                    GoResolvable qualifier = ref.getResolvableQualifier();
                    GoNamedElement goNamedElement = var = qualifier != null ? GoNilnessInspection.tryCastToVariableOrParameterDefinition(qualifier.resolve()) : null;
                    if (var == null) {
                        return;
                    }
                    DataFlowAtContext dataFlow = GoNilnessInspection.getDataFlowAtContext(session, callExpr);
                    if (this.checkCorrespondingError(var, qualifier, dataFlow)) {
                        return;
                    }
                    if (this.mayBeNil(var, dataFlow)) {
                        if (GoNilnessInspection.allowsNilReceiver((GoMethodDeclaration)ObjectUtils.tryCast((Object)resolve2, GoMethodDeclaration.class))) {
                            GoInspectionMessage msg = GoNilnessInspection.message("go.inspection.problem.receiver.may.be.nil.in.call", new Object[]{GoNilnessInspection.code(qualifier), GoNilnessInspection.code("nil")});
                            holder.registerProblem((PsiElement)callExpr, msg, GoNilnessInspection.this.nonDefaultHighlightingType(ProblemHighlightType.WEAK_WARNING, callExpr), new LocalQuickFix[0]);
                        } else {
                            GoInspectionMessage msg = GoNilnessInspection.message("go.inspection.problem.method.call.may.lead.to.nil.pointer.dereference", new Object[]{REF});
                            holder.registerProblem((PsiElement)callExpr, msg, new LocalQuickFix[0]);
                        }
                    }
                    return;
                }
                GoNamedElement varOrParameter = GoNilnessInspection.tryCastToVariableOrParameterDefinition(resolve2);
                if (ref != null && ref.getQualifier() == null && varOrParameter != null) {
                    GoType underlyingType = ref.getGoUnderlyingType(null);
                    if (!(underlyingType instanceof GoFunctionType)) {
                        return;
                    }
                    DataFlowAtContext dataFlow = GoNilnessInspection.getDataFlowAtContext(session, callExpr);
                    if (this.checkCorrespondingError(varOrParameter, callExpr, dataFlow)) {
                        return;
                    }
                    if (this.mayBeNil(varOrParameter, dataFlow)) {
                        holder.registerProblem((PsiElement)callExpr, GoNilnessInspection.message("go.inspection.problem.function.call.may.lead.to.nil.pointer.dereference", new Object[]{REF}), new LocalQuickFix[0]);
                    }
                }
            }

            @Override
            public void visitReferenceExpression(@NotNull GoReferenceExpression ref) {
                GoNamedElement varOrParameter;
                if (ref == null) {
                    1.$$$reportNull$$$0(1);
                }
                super.visitReferenceExpression(ref);
                PsiElement resolve2 = ref.resolve();
                if (!(resolve2 instanceof GoFieldDefinition) && !(resolve2 instanceof GoAnonymousFieldDefinition)) {
                    return;
                }
                GoResolvable qualifier = ref.getResolvableQualifier();
                GoNamedElement goNamedElement = varOrParameter = qualifier != null ? GoNilnessInspection.tryCastToVariableOrParameterDefinition(qualifier.resolve()) : null;
                if (varOrParameter == null) {
                    return;
                }
                DataFlowAtContext dataFlow = GoNilnessInspection.getDataFlowAtContext(session, ref);
                if (this.checkCorrespondingError(varOrParameter, qualifier, dataFlow)) {
                    return;
                }
                if (this.mayBeNil(varOrParameter, dataFlow)) {
                    holder.registerProblem((PsiElement)ref, GoNilnessInspection.message("go.inspection.problem.accessing.field.may.lead.to.nil.pointer.dereference", new Object[]{REF}), new LocalQuickFix[0]);
                }
            }

            @Override
            public void visitSendStatement(@NotNull GoSendStatement sendStmt) {
                if (sendStmt == null) {
                    1.$$$reportNull$$$0(2);
                }
                super.visitSendStatement(sendStmt);
                if (GoNilnessInspection.isFromSelectCaseWithDefault(sendStmt)) {
                    return;
                }
                GoReferenceExpression chanRef = (GoReferenceExpression)ObjectUtils.tryCast((Object)sendStmt.getChannelExpression(), GoReferenceExpression.class);
                if (chanRef == null || chanRef.getQualifier() != null) {
                    return;
                }
                GoNamedElement varOrParameter = GoNilnessInspection.tryCastToVariableOrParameterDefinition(chanRef.resolve());
                if (varOrParameter == null) {
                    return;
                }
                DataFlowAtContext dataFlow = GoNilnessInspection.getDataFlowAtContext(session, sendStmt);
                if (this.checkCorrespondingError(varOrParameter, sendStmt, dataFlow)) {
                    return;
                }
                if (this.mayBeNil(varOrParameter, dataFlow)) {
                    GoInspectionMessage message = GoNilnessInspection.message("go.inspection.problem.send.may.block.because.of.nil.channel", new Object[]{GoNilnessInspection.code("nil")});
                    holder.registerProblem((PsiElement)sendStmt, message, GoNilnessInspection.this.nonDefaultHighlightingType(ProblemHighlightType.WEAK_WARNING, sendStmt), new LocalQuickFix[0]);
                }
            }

            @Override
            public void visitUnaryExpr(@NotNull GoUnaryExpr unaryExpr) {
                GoNamedElement varOrParameter;
                GoRecvStatement receiveStatement;
                boolean isChannelRead;
                if (unaryExpr == null) {
                    1.$$$reportNull$$$0(3);
                }
                super.visitUnaryExpr(unaryExpr);
                boolean bl = isChannelRead = unaryExpr.getArrow() != null;
                if (!isChannelRead && unaryExpr.getMul() == null) {
                    return;
                }
                GoRecvStatement goRecvStatement = receiveStatement = isChannelRead ? (GoRecvStatement)ObjectUtils.tryCast((Object)unaryExpr.getParent(), GoRecvStatement.class) : null;
                if (GoNilnessInspection.isFromSelectCaseWithDefault(receiveStatement)) {
                    return;
                }
                GoReferenceExpression ref = (GoReferenceExpression)ObjectUtils.tryCast((Object)unaryExpr.getExpression(), GoReferenceExpression.class);
                GoNamedElement goNamedElement = varOrParameter = ref != null ? GoNilnessInspection.tryCastToVariableOrParameterDefinition(ref.resolve()) : null;
                if (varOrParameter == null) {
                    return;
                }
                DataFlowAtContext dataFlow = GoNilnessInspection.getDataFlowAtContext(session, unaryExpr);
                if (this.checkCorrespondingError(varOrParameter, unaryExpr, dataFlow)) {
                    return;
                }
                if (this.mayBeNil(varOrParameter, dataFlow)) {
                    GoInspectionMessage message = isChannelRead ? GoNilnessInspection.message("go.inspection.problem.receive.may.block.because.of.nil.channel", new Object[]{GoNilnessInspection.code("nil")}) : GoNilnessInspection.message("go.inspection.problem.potential.nil.pointer.dereference");
                    ProblemHighlightType highlightingType = isChannelRead ? GoNilnessInspection.this.nonDefaultHighlightingType(ProblemHighlightType.WEAK_WARNING, unaryExpr) : ProblemHighlightType.GENERIC_ERROR_OR_WARNING;
                    holder.registerProblem((PsiElement)unaryExpr, message, highlightingType, new LocalQuickFix[0]);
                }
            }

            @Override
            public void visitAssignmentStatement(@NotNull GoAssignmentStatement assignmentStatement) {
                if (assignmentStatement == null) {
                    1.$$$reportNull$$$0(4);
                }
                super.visitAssignmentStatement(assignmentStatement);
                List<GoExpression> targetExprs = assignmentStatement.getLeftHandExprList().getExpressionList();
                for (GoExpression targetExpr : targetExprs) {
                    if (!(targetExpr instanceof GoIndexOrSliceExpr)) continue;
                    if (!this.containerMayBeNil((GoIndexOrSliceExpr)targetExpr, GoMapType.class::isInstance, false)) continue;
                    holder.registerProblem((PsiElement)targetExpr, GoNilnessInspection.message("go.inspection.problem.assignment.to.entry.may.panic.because.of.nil.map", new Object[]{GoNilnessInspection.code("nil")}), new LocalQuickFix[0]);
                }
            }

            @Override
            public void visitIndexOrSliceExpr(@NotNull GoIndexOrSliceExpr indexOrSliceExpr) {
                if (indexOrSliceExpr == null) {
                    1.$$$reportNull$$$0(5);
                }
                super.visitIndexOrSliceExpr(indexOrSliceExpr);
                if (!GoNilnessInspection.safeIndexing(indexOrSliceExpr) && this.containerMayBeNil(indexOrSliceExpr, t -> t instanceof GoArrayOrSliceType && !((GoArrayOrSliceType)t).isArray(), true)) {
                    holder.registerProblem((PsiElement)indexOrSliceExpr, GoNilnessInspection.message("go.inspection.problem.indexing.may.panic.because.of.nil.slice", new Object[]{GoNilnessInspection.code("nil")}), new LocalQuickFix[0]);
                }
            }

            @Override
            public void visitConditionalExpr(@NotNull GoConditionalExpr conditionalExpr) {
                GoNilness nilness;
                if (conditionalExpr == null) {
                    1.$$$reportNull$$$0(6);
                }
                super.visitConditionalExpr(conditionalExpr);
                GoNamedElement var = GoDataFlowUtil.findVarEqNil(conditionalExpr);
                if (var != null) {
                    GoNilness nilness2 = 1.getNilness(var, GoNilnessInspection.getDataFlowAtContext(session, conditionalExpr));
                    if (nilness2 == GoNilness.NIL) {
                        this.reportAlwaysTrueFalse(conditionalExpr, var, true, true);
                    } else if (nilness2 == GoNilness.NOT_NIL) {
                        this.reportAlwaysTrueFalse(conditionalExpr, var, false, false);
                    }
                    return;
                }
                var = GoDataFlowUtil.findVarNotEqNil(conditionalExpr);
                if (var != null) {
                    GoNilness nilness3 = 1.getNilness(var, GoNilnessInspection.getDataFlowAtContext(session, conditionalExpr));
                    if (nilness3 == GoNilness.NOT_NIL) {
                        this.reportAlwaysTrueFalse(conditionalExpr, var, true, false);
                    } else if (nilness3 == GoNilness.NIL) {
                        this.reportAlwaysTrueFalse(conditionalExpr, var, false, true);
                    }
                    return;
                }
                var = GoDataFlowUtil.findVarLenEqZero(conditionalExpr);
                if (var != null) {
                    GoNilness nilness4 = 1.getNilness(var, GoNilnessInspection.getDataFlowAtContext(session, conditionalExpr));
                    if (nilness4 == GoNilness.NIL) {
                        this.reportAlwaysTrueFalse(conditionalExpr, var, true, true);
                    }
                    return;
                }
                var = GoDataFlowUtil.findVarLenNotEqZero(conditionalExpr);
                if (var != null && (nilness = 1.getNilness(var, GoNilnessInspection.getDataFlowAtContext(session, conditionalExpr))) == GoNilness.NIL) {
                    this.reportAlwaysTrueFalse(conditionalExpr, var, false, true);
                }
            }

            @Override
            public void visitRangeClause(@NotNull GoRangeClause o) {
                if (o == null) {
                    1.$$$reportNull$$$0(7);
                }
                super.visitRangeClause(o);
                GoReferenceExpression ref = (GoReferenceExpression)ObjectUtils.tryCast((Object)o.getRangeExpression(), GoReferenceExpression.class);
                GoNamedElement varOrParameter = ref != null ? GoNilnessInspection.tryCastToVariableOrParameterDefinition(ref.resolve()) : null;
                GoNilness nilness = this.getNilnessBeforeLoopStart(o, varOrParameter);
                if (nilness == GoNilness.NIL) {
                    holder.registerProblem((PsiElement)o, GoNilnessInspection.message("go.inspection.problem.nil.loop.is.always.skipped", new Object[]{GoNilnessInspection.code(Objects.requireNonNull(varOrParameter)), GoNilnessInspection.code("nil")}), new LocalQuickFix[0]);
                }
            }

            private boolean checkCorrespondingError(@NotNull GoNamedElement var, @NotNull PsiElement usage, @Nullable DataFlowAtContext dataFlow) {
                if (var == null) {
                    1.$$$reportNull$$$0(8);
                }
                if (usage == null) {
                    1.$$$reportNull$$$0(9);
                }
                if (dataFlow == null) {
                    return false;
                }
                Set<GoNamedElement> errors = dataFlow.varsAndErrors.get(var);
                if (errors == null) {
                    return false;
                }
                if (!errors.isEmpty() && 1.getNilness(var, dataFlow) != GoNilness.NOT_NIL) {
                    holder.registerProblem(usage, GoNilnessInspection.message("go.inspection.problem.corresponding.error.may.be.not.nil", new Object[]{GoNilnessInspection.code(var), GoNilnessInspection.code("nil"), GoNilnessInspection.code("nil")}), new LocalQuickFix[0]);
                }
                return true;
            }

            private boolean containerMayBeNil(@NotNull GoIndexOrSliceExpr indexOrSliceExpr, @NotNull Predicate<GoType> containerTypePredicate, boolean notNilInsideLoop) {
                GoExpression indexedExpr;
                GoType type2;
                if (indexOrSliceExpr == null) {
                    1.$$$reportNull$$$0(10);
                }
                if (containerTypePredicate == null) {
                    1.$$$reportNull$$$0(11);
                }
                GoType goType = type2 = (indexedExpr = indexOrSliceExpr.getExpression()) != null ? indexedExpr.getGoUnderlyingType(null) : null;
                if (!containerTypePredicate.test(type2)) {
                    return false;
                }
                GoReferenceExpression ref = (GoReferenceExpression)ObjectUtils.tryCast((Object)indexedExpr, GoReferenceExpression.class);
                GoNamedElement varOrParameter = ref != null ? GoNilnessInspection.tryCastToVariableOrParameterDefinition(ref.resolve()) : null;
                boolean mayBeNil = varOrParameter != null && this.mayBeNil(varOrParameter, GoNilnessInspection.getDataFlowAtContext(session, indexOrSliceExpr));
                return mayBeNil && (!notNilInsideLoop || !GoNilnessInspection.isInsideLoopWithConditionDependingOnIndexedExpressionLen(indexOrSliceExpr, varOrParameter));
            }

            private boolean mayBeNil(@NotNull GoNamedElement var, @Nullable DataFlowAtContext dataFlow) {
                GoNilness nilness;
                if (var == null) {
                    1.$$$reportNull$$$0(12);
                }
                return (nilness = 1.getNilness(var, dataFlow)) == GoNilness.NIL || nilness == GoNilness.MAYBE_NIL;
            }

            @NotNull
            private static GoNilness getNilness(@NotNull GoNamedElement var, @Nullable DataFlowAtContext dataFlow) {
                if (var == null) {
                    1.$$$reportNull$$$0(13);
                }
                GoNilness goNilness = dataFlow != null ? dataFlow.nilnessMap.getOrDefault(var, GoNilness.UNKNOWN) : GoNilness.UNKNOWN;
                if (goNilness == null) {
                    1.$$$reportNull$$$0(14);
                }
                return goNilness;
            }

            @NotNull
            private GoNilness getNilnessBeforeLoopStart(@NotNull PsiElement usage, @Nullable GoNamedElement var) {
                Instruction loopStart;
                if (usage == null) {
                    1.$$$reportNull$$$0(15);
                }
                if (var == null) {
                    GoNilness goNilness = GoNilness.UNKNOWN;
                    if (goNilness == null) {
                        1.$$$reportNull$$$0(16);
                    }
                    return goNilness;
                }
                PsiElement enclosingFunction = PsiTreeUtil.getParentOfType((PsiElement)usage, (Class[])new Class[]{GoFunctionOrMethodDeclaration.class, GoFunctionLit.class});
                ControlFlow controlFlow = enclosingFunction != null ? GoControlFlowProvider.INSTANCE.getControlFlow(enclosingFunction) : null;
                Instruction instruction = controlFlow != null ? GoControlFlowUtil.correspondingInstruction(usage, enclosingFunction, controlFlow) : null;
                Instruction instruction2 = loopStart = instruction != null ? 1.findLoopStart(controlFlow, instruction) : null;
                if (loopStart == null) {
                    GoNilness goNilness = GoNilness.UNKNOWN;
                    if (goNilness == null) {
                        1.$$$reportNull$$$0(17);
                    }
                    return goNilness;
                }
                GoDataFlow dataFlow = GoNilnessInspection.getDataFlow(session, enclosingFunction, controlFlow);
                if (dataFlow == GoDataFlow.EMPTY || dataFlow.isUnreachable(instruction)) {
                    GoNilness goNilness = GoNilness.UNKNOWN;
                    if (goNilness == null) {
                        1.$$$reportNull$$$0(18);
                    }
                    return goNilness;
                }
                Map<GoNamedElement, GoNilness> nilnessMap = GoDataFlowBuilder.getNilnessBefore(loopStart, dataFlow);
                GoNilness goNilness = nilnessMap.getOrDefault(var, GoNilness.UNKNOWN);
                if (goNilness == null) {
                    1.$$$reportNull$$$0(19);
                }
                return goNilness;
            }

            @Nullable
            private static Instruction findLoopStart(@NotNull ControlFlow controlFlow, @NotNull Instruction instruction) {
                if (controlFlow == null) {
                    1.$$$reportNull$$$0(20);
                }
                if (instruction == null) {
                    1.$$$reportNull$$$0(21);
                }
                Instruction[] instructions = controlFlow.getInstructions();
                for (int i = instruction.num() - 1; i >= 0; --i) {
                    Instruction prev = instructions[i];
                    if (!(prev instanceof GoForLoopStartInstruction)) continue;
                    return prev;
                }
                return null;
            }

            private void reportAlwaysTrueFalse(@NotNull GoConditionalExpr conditionalExpr, @NotNull GoNamedElement var, boolean isTrue, boolean isNil) {
                if (conditionalExpr == null) {
                    1.$$$reportNull$$$0(22);
                }
                if (var == null) {
                    1.$$$reportNull$$$0(23);
                }
                if (isNil) {
                    holder.registerProblem((PsiElement)conditionalExpr, GoNilnessInspection.message("go.inspection.problem.condition.is.always.true.or.false.because.of.nil", new Object[]{GoNilnessInspection.code(String.valueOf(isTrue)), GoNilnessInspection.code(var), GoNilnessInspection.code("nil")}), new LocalQuickFix[0]);
                } else {
                    holder.registerProblem((PsiElement)conditionalExpr, GoNilnessInspection.message("go.inspection.problem.condition.is.always.true.or.false.because.of.not.nil", new Object[]{GoNilnessInspection.code(String.valueOf(isTrue)), GoNilnessInspection.code(var), GoNilnessInspection.code("nil")}), new LocalQuickFix[0]);
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[switch (n) {
                    default -> 3;
                    case 14, 16, 17, 18, 19 -> 2;
                }];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "callExpr";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "ref";
                        break;
                    }
                    case 2: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "sendStmt";
                        break;
                    }
                    case 3: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "unaryExpr";
                        break;
                    }
                    case 4: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "assignmentStatement";
                        break;
                    }
                    case 5: 
                    case 10: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "indexOrSliceExpr";
                        break;
                    }
                    case 6: 
                    case 22: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "conditionalExpr";
                        break;
                    }
                    case 7: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "o";
                        break;
                    }
                    case 8: 
                    case 12: 
                    case 13: 
                    case 23: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "var";
                        break;
                    }
                    case 9: 
                    case 15: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "usage";
                        break;
                    }
                    case 11: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "containerTypePredicate";
                        break;
                    }
                    case 14: 
                    case 16: 
                    case 17: 
                    case 18: 
                    case 19: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/goide/inspections/GoNilnessInspection$1";
                        break;
                    }
                    case 20: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "controlFlow";
                        break;
                    }
                    case 21: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "instruction";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/goide/inspections/GoNilnessInspection$1";
                        break;
                    }
                    case 14: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getNilness";
                        break;
                    }
                    case 16: 
                    case 17: 
                    case 18: 
                    case 19: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getNilnessBeforeLoopStart";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray;
                        objectArray[2] = "visitCallExpr";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray;
                        objectArray[2] = "visitReferenceExpression";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray;
                        objectArray[2] = "visitSendStatement";
                        break;
                    }
                    case 3: {
                        objectArray = objectArray;
                        objectArray[2] = "visitUnaryExpr";
                        break;
                    }
                    case 4: {
                        objectArray = objectArray;
                        objectArray[2] = "visitAssignmentStatement";
                        break;
                    }
                    case 5: {
                        objectArray = objectArray;
                        objectArray[2] = "visitIndexOrSliceExpr";
                        break;
                    }
                    case 6: {
                        objectArray = objectArray;
                        objectArray[2] = "visitConditionalExpr";
                        break;
                    }
                    case 7: {
                        objectArray = objectArray;
                        objectArray[2] = "visitRangeClause";
                        break;
                    }
                    case 8: 
                    case 9: {
                        objectArray = objectArray;
                        objectArray[2] = "checkCorrespondingError";
                        break;
                    }
                    case 10: 
                    case 11: {
                        objectArray = objectArray;
                        objectArray[2] = "containerMayBeNil";
                        break;
                    }
                    case 12: {
                        objectArray = objectArray;
                        objectArray[2] = "mayBeNil";
                        break;
                    }
                    case 13: {
                        objectArray = objectArray;
                        objectArray[2] = "getNilness";
                        break;
                    }
                    case 14: 
                    case 16: 
                    case 17: 
                    case 18: 
                    case 19: {
                        break;
                    }
                    case 15: {
                        objectArray = objectArray;
                        objectArray[2] = "getNilnessBeforeLoopStart";
                        break;
                    }
                    case 20: 
                    case 21: {
                        objectArray = objectArray;
                        objectArray[2] = "findLoopStart";
                        break;
                    }
                    case 22: 
                    case 23: {
                        objectArray = objectArray;
                        objectArray[2] = "reportAlwaysTrueFalse";
                        break;
                    }
                }
                String string = String.format(v0, objectArray);
                throw switch (n) {
                    default -> new IllegalArgumentException(string);
                    case 14, 16, 17, 18, 19 -> new IllegalStateException(string);
                };
            }
        };
    }

    @Nullable
    public static GoNamedElement tryCastToVariableOrParameterDefinition(@Nullable PsiElement element) {
        return element instanceof GoVarDefinition ? (GoNamedElement)element : (GoNamedElement)ObjectUtils.tryCast((Object)element, GoParamDefinition.class);
    }

    public static GoNamedElement tryCastToVariableOrParameterOrReceiverDefinition(@Nullable PsiElement element) {
        GoNamedElement varOrParam = GoNilnessInspection.tryCastToVariableOrParameterDefinition(element);
        if (varOrParam != null) {
            return varOrParam;
        }
        return (GoNamedElement)ObjectUtils.tryCast((Object)element, GoReceiver.class);
    }

    @Nullable
    private static DataFlowAtContext getDataFlowAtContext(@NotNull LocalInspectionToolSession session, @NotNull PsiElement context) {
        Instruction instruction;
        PsiElement parent;
        if (session == null) {
            GoNilnessInspection.$$$reportNull$$$0(2);
        }
        if (context == null) {
            GoNilnessInspection.$$$reportNull$$$0(3);
        }
        if (GoStdlibUtil.isUnsafeFunctionCall((GoCallExpr)ObjectUtils.tryCast((Object)(parent = PsiTreeUtil.getParentOfType((PsiElement)context, (Class[])new Class[]{GoCallExpr.class, GoFunctionOrMethodDeclaration.class, GoFunctionLit.class})), GoCallExpr.class))) {
            return null;
        }
        PsiElement enclosingFunction = PsiTreeUtil.getParentOfType((PsiElement)context, (Class[])new Class[]{GoFunctionOrMethodDeclaration.class, GoFunctionLit.class});
        ControlFlow controlFlow = enclosingFunction != null ? GoControlFlowProvider.INSTANCE.getControlFlow(enclosingFunction) : null;
        Instruction instruction2 = instruction = controlFlow != null ? GoControlFlowUtil.correspondingInstruction(context, enclosingFunction, controlFlow) : null;
        if (instruction == null) {
            return null;
        }
        GoDataFlow dataFlow = GoNilnessInspection.getDataFlow(session, enclosingFunction, controlFlow);
        if (dataFlow == GoDataFlow.EMPTY || dataFlow.isUnreachable(instruction)) {
            return null;
        }
        Map<GoNamedElement, GoNilness> nilnessMap = dataFlow.getNilnessDataFlow().getNilnessMap(instruction);
        Map<GoNamedElement, Set<GoNamedElement>> varsAndErrors = dataFlow.getVarsAndErrorsDataFlow().getVarsAndErrors(instruction);
        return new DataFlowAtContext((Map)ObjectUtils.notNull(nilnessMap, Collections.emptyMap()), varsAndErrors);
    }

    @NotNull
    private static GoDataFlow getDataFlow(@NotNull LocalInspectionToolSession session, @NotNull PsiElement enclosingFunction, @NotNull ControlFlow controlFlow) {
        if (session == null) {
            GoNilnessInspection.$$$reportNull$$$0(4);
        }
        if (enclosingFunction == null) {
            GoNilnessInspection.$$$reportNull$$$0(5);
        }
        if (controlFlow == null) {
            GoNilnessInspection.$$$reportNull$$$0(6);
        }
        Map dataFlowCache = Objects.requireNonNull((Map)session.getUserData(DATAFLOW_CACHE));
        GoDataFlow goDataFlow = dataFlowCache.computeIfAbsent(enclosingFunction, __ -> GoDataFlowBuilder.build(controlFlow, enclosingFunction));
        if (goDataFlow == null) {
            GoNilnessInspection.$$$reportNull$$$0(7);
        }
        return goDataFlow;
    }

    public static boolean allowsNilReceiver(@Nullable GoMethodDeclaration methodDeclaration) {
        if (methodDeclaration == null) {
            return false;
        }
        GoType receiverType = methodDeclaration.getReceiverType();
        if (receiverType instanceof GoPointerType) {
            return true;
        }
        GoType underlyingType = receiverType != null ? receiverType.getContextlessUnderlyingType() : null;
        return underlyingType instanceof GoArrayOrSliceType && !((GoArrayOrSliceType)underlyingType).isArray() || underlyingType instanceof GoMapType;
    }

    private static boolean isInsideLoopWithConditionDependingOnIndexedExpressionLen(@NotNull GoIndexOrSliceExpr indexOrSliceExpr, final @NotNull GoNamedElement indexedVar) {
        GoCompositeElement condition;
        GoForStatement forStatement;
        if (indexOrSliceExpr == null) {
            GoNilnessInspection.$$$reportNull$$$0(8);
        }
        if (indexedVar == null) {
            GoNilnessInspection.$$$reportNull$$$0(9);
        }
        if ((forStatement = (GoForStatement)PsiTreeUtil.getParentOfType((PsiElement)indexOrSliceExpr, GoForStatement.class)) == null || forStatement.getRangeClause() != null) {
            return false;
        }
        GoForClause forClause = forStatement.getForClause();
        GoCompositeElement goCompositeElement = condition = forClause != null ? forClause : forStatement.getExpression();
        if (condition == null) {
            return false;
        }
        final Ref conditionDependsOnIndexedExpressionLen = Ref.create();
        condition.accept(new GoRecursiveVisitor(){

            @Override
            public void visitReferenceExpression(@NotNull GoReferenceExpression o) {
                GoCallExpr call;
                if (o == null) {
                    2.$$$reportNull$$$0(0);
                }
                super.visitReferenceExpression(o);
                if (!indexedVar.isEquivalentTo(o.resolve())) {
                    return;
                }
                GoArgumentList argumentList = (GoArgumentList)ObjectUtils.tryCast((Object)o.getParent(), GoArgumentList.class);
                GoCallExpr goCallExpr = call = argumentList != null ? (GoCallExpr)ObjectUtils.tryCast((Object)argumentList.getParent(), GoCallExpr.class) : null;
                if (call != null && GoPsiUtil.isBuiltinFunctionCall(call, "len")) {
                    conditionDependsOnIndexedExpressionLen.set((Object)Boolean.TRUE);
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "o", "com/goide/inspections/GoNilnessInspection$2", "visitReferenceExpression"));
            }
        });
        return Boolean.TRUE.equals(conditionDependsOnIndexedExpressionLen.get());
    }

    private static boolean safeIndexing(@NotNull GoIndexOrSliceExpr indexOrSliceExpr) {
        if (indexOrSliceExpr == null) {
            GoNilnessInspection.$$$reportNull$$$0(10);
        }
        Trinity<GoExpression, GoExpression, GoExpression> indices = indexOrSliceExpr.getIndices();
        Long firstValue = GoNilnessInspection.indexValue((GoExpression)indices.first);
        Long secondValue = GoNilnessInspection.indexValue((GoExpression)indices.second);
        Long thirdValue = GoNilnessInspection.indexValue((GoExpression)indices.third);
        return !(firstValue != null && firstValue != 0L || secondValue != null && secondValue != 0L || thirdValue != null && thirdValue != 0L || indexOrSliceExpr.getNode().findChildByType(GoTypes.COLON) == null);
    }

    @Contract(value="null -> null")
    private static Long indexValue(@Nullable GoExpression expression) {
        Value value = expression != null ? expression.getValue() : null;
        return value != null ? value.getInteger() : null;
    }

    private static boolean isFromSelectCaseWithDefault(@Nullable PsiElement statement) {
        GoCommCase commCase;
        GoCommCase goCommCase = commCase = statement != null ? (GoCommCase)ObjectUtils.tryCast((Object)statement.getParent(), GoCommCase.class) : null;
        if (commCase == null) {
            return false;
        }
        GoSelectStatement selectStatement = (GoSelectStatement)PsiTreeUtil.getParentOfType((PsiElement)commCase, GoSelectStatement.class);
        if (selectStatement == null) {
            return false;
        }
        return ContainerUtil.or(selectStatement.getCommClauseList(), c -> c.getDefault() != null);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 7 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 1: 
            case 2: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "session";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "enclosingFunction";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "controlFlow";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/goide/inspections/GoNilnessInspection";
                break;
            }
            case 8: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "indexOrSliceExpr";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "indexedVar";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/goide/inspections/GoNilnessInspection";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getDataFlow";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "buildVisitor";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getDataFlowAtContext";
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getDataFlow";
                break;
            }
            case 7: {
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "isInsideLoopWithConditionDependingOnIndexedExpressionLen";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "safeIndexing";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 7 -> new IllegalStateException(string);
        };
    }

    private static final class DataFlowAtContext {
        final Map<GoNamedElement, GoNilness> nilnessMap;
        final Map<GoNamedElement, Set<GoNamedElement>> varsAndErrors;

        private DataFlowAtContext(@NotNull Map<GoNamedElement, GoNilness> map, @NotNull Map<GoNamedElement, Set<GoNamedElement>> errors) {
            if (map == null) {
                DataFlowAtContext.$$$reportNull$$$0(0);
            }
            if (errors == null) {
                DataFlowAtContext.$$$reportNull$$$0(1);
            }
            this.nilnessMap = map;
            this.varsAndErrors = errors;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "map";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "errors";
                    break;
                }
            }
            objectArray[1] = "com/goide/inspections/GoNilnessInspection$DataFlowAtContext";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

