/*
 * Decompiled with CFR 0.152.
 */
package com.goide.inspections;

import com.goide.psi.GoBlock;
import com.goide.psi.GoFile;
import com.goide.psi.GoFunctionLit;
import com.goide.psi.GoFunctionType;
import com.goide.psi.GoImportSpec;
import com.goide.psi.GoInterfaceType;
import com.goide.psi.GoLabelDefinition;
import com.goide.psi.GoMethodDeclaration;
import com.goide.psi.GoMethodSpec;
import com.goide.psi.GoNamedElement;
import com.goide.psi.GoNamedSignatureOwner;
import com.goide.psi.GoParamDefinition;
import com.goide.psi.GoParameterDeclaration;
import com.goide.psi.GoParameters;
import com.goide.psi.GoReceiver;
import com.goide.psi.GoRecursiveVisitor;
import com.goide.psi.GoResult;
import com.goide.psi.GoSignature;
import com.goide.psi.GoSignatureOwner;
import com.goide.psi.GoSpecType;
import com.goide.psi.GoStatement;
import com.goide.psi.GoStatementsHolder;
import com.goide.psi.GoStructType;
import com.goide.psi.GoType;
import com.goide.psi.GoTypeArguments;
import com.goide.psi.GoTypeParamDefinition;
import com.goide.psi.GoTypeParameterDeclaration;
import com.goide.psi.GoTypeParameters;
import com.goide.psi.GoTypeReferenceExpression;
import com.goide.psi.GoTypeSpec;
import com.goide.psi.impl.GoElementWithSubst;
import com.goide.psi.impl.GoPackage;
import com.goide.psi.impl.GoPsiImplUtil;
import com.goide.psi.impl.GoPsiUtil;
import com.goide.psi.impl.generics.GoTypeInstantiationKt;
import com.goide.util.GoUtil;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.ResolveState;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.PairProcessor;
import com.intellij.util.Processor;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class GoDuplicatesSearch<T extends PsiElement> {
    @NotNull
    private final String myTitle;

    @NotNull
    public String getTitle() {
        String string = this.myTitle;
        if (string == null) {
            GoDuplicatesSearch.$$$reportNull$$$0(0);
        }
        return string;
    }

    GoDuplicatesSearch(@NotNull String title) {
        if (title == null) {
            GoDuplicatesSearch.$$$reportNull$$$0(1);
        }
        this.myTitle = title;
    }

    public static void processDuplicates(@NotNull String name, @NotNull GoNamedElement element, @NotNull Processor<? super Duplicate> processor2) {
        PsiElement container;
        if (name == null) {
            GoDuplicatesSearch.$$$reportNull$$$0(2);
        }
        if (element == null) {
            GoDuplicatesSearch.$$$reportNull$$$0(3);
        }
        if (processor2 == null) {
            GoDuplicatesSearch.$$$reportNull$$$0(4);
        }
        if ((container = GoDuplicatesSearch.getContainer(element)) == null) {
            return;
        }
        if (container instanceof GoBlock) {
            new StatementsHolderScopeSearch().processElementsWithName(name, (GoStatementsHolder)container, processor2);
        } else if (container instanceof GoStructType) {
            new StructScopeSearch().processElementsWithName(name, (GoStructType)container, processor2);
        } else if (container instanceof GoInterfaceType) {
            new InterfaceScopeSearch().processElementsWithName(name, (GoInterfaceType)container, processor2);
        } else if (container instanceof GoNamedSignatureOwner || container instanceof GoFunctionLit) {
            if (element instanceof GoLabelDefinition) {
                new LabelScopeSearch().processElementsWithName(name, (GoSignatureOwner)container, processor2);
            } else {
                new SignatureOwnerScopeSearch().processElementsWithName(name, (GoSignatureOwner)container, processor2);
            }
        } else if (container instanceof GoFunctionType) {
            new SignatureScopeSearch().processElementsWithName(name, (GoSignatureOwner)container, processor2);
        } else if (container instanceof GoTypeSpec) {
            new TypeSpecScopeSearch().processElementsWithName(name, (GoTypeSpec)container, processor2);
        } else if (container instanceof GoFile) {
            new TopLevelScopeSearch().processElementsWithName(name, (GoFile)container, processor2);
        }
    }

    @Nullable
    private static PsiElement getContainer(@NotNull GoNamedElement element) {
        if (element == null) {
            GoDuplicatesSearch.$$$reportNull$$$0(5);
        }
        if (element instanceof GoMethodDeclaration) {
            return GoPsiImplUtil.getTypeSpecFromReceiver(((GoMethodDeclaration)element).getReceiver());
        }
        PsiElement parent = PsiTreeUtil.getParentOfType((PsiElement)element, (Class[])new Class[]{GoTypeSpec.class, GoStructType.class, GoInterfaceType.class, GoSignatureOwner.class, GoBlock.class, GoFile.class});
        if (parent == null) {
            return null;
        }
        PsiElement grandParent = parent.getParent();
        if (grandParent instanceof GoSignatureOwner && parent instanceof GoBlock) {
            return grandParent;
        }
        if (grandParent instanceof GoSpecType && parent instanceof GoStructType) {
            return grandParent.getParent();
        }
        return parent;
    }

    public void processElementsWithName(@NotNull String name, @NotNull T container, @NotNull Processor<? super Duplicate> processor2) {
        if (name == null) {
            GoDuplicatesSearch.$$$reportNull$$$0(6);
        }
        if (container == null) {
            GoDuplicatesSearch.$$$reportNull$$$0(7);
        }
        if (processor2 == null) {
            GoDuplicatesSearch.$$$reportNull$$$0(8);
        }
        this.processAllElements(container, (PairProcessor<String, Duplicate>)((PairProcessor)(s, element) -> {
            if (StringUtil.equals((CharSequence)name, (CharSequence)s)) {
                return processor2.process(element);
            }
            return true;
        }));
    }

    public void processAllElements(@Nullable T container, @NotNull PairProcessor<? super String, ? super Duplicate> processor2) {
        if (processor2 == null) {
            GoDuplicatesSearch.$$$reportNull$$$0(9);
        }
        if (container == null) {
            return;
        }
        this.processElements(container, (PairProcessor<String, Duplicate>)((PairProcessor)(name, duplicate) -> {
            if (StringUtil.isEmpty((String)name) || "_".equals(name)) {
                return true;
            }
            return processor2.process(name, duplicate);
        }));
    }

    protected abstract void processElements(@NotNull T var1, @NotNull PairProcessor<? super String, ? super Duplicate> var2);

    private static boolean processPackage(@NotNull GoFile contextFile, @NotNull GoPackage aPackage, @Nullable Module module, @Nullable Condition<GoFile> filesFilter, boolean exportedOnly, @NotNull PairProcessor<? super String, ? super Duplicate> processor2) {
        if (contextFile == null) {
            GoDuplicatesSearch.$$$reportNull$$$0(10);
        }
        if (aPackage == null) {
            GoDuplicatesSearch.$$$reportNull$$$0(11);
        }
        if (processor2 == null) {
            GoDuplicatesSearch.$$$reportNull$$$0(12);
        }
        Condition funcFilter = function -> {
            String functionName = function.getName();
            return !"init".equals(functionName) && (!"main".equals(functionName) || ((Object)((Object)contextFile)).equals((Object)function.getContainingFile()));
        };
        PsiFile originalFile = contextFile.getOriginalFile();
        aPackage.processBuildableFiles((PsiFile)contextFile, module, (Processor<? super PsiFile>)((Processor)file -> {
            if (file == originalFile) {
                file = contextFile;
            }
            if (!(file instanceof GoFile)) {
                return true;
            }
            if (filesFilter != null && !filesFilter.value((Object)((GoFile)((Object)((Object)file))))) {
                return true;
            }
            return GoDuplicatesSearch.processNamedElements(ContainerUtil.filter(((GoFile)((Object)((Object)file))).getFunctions(), (Condition)funcFilter), exportedOnly, processor2) && GoDuplicatesSearch.processNamedElements(((GoFile)((Object)((Object)file))).getVars(), exportedOnly, processor2) && GoDuplicatesSearch.processNamedElements(((GoFile)((Object)((Object)file))).getTypes(), exportedOnly, processor2) && GoDuplicatesSearch.processNamedElements(((GoFile)((Object)((Object)file))).getConstants(), exportedOnly, processor2);
        }));
        return true;
    }

    private static void processImports(@NotNull GoFile file, @Nullable GoPackage contextPackage, @NotNull String contextPackageName, @Nullable Module module, @NotNull PairProcessor<? super String, ? super Duplicate> processor2) {
        if (file == null) {
            GoDuplicatesSearch.$$$reportNull$$$0(13);
        }
        if (contextPackageName == null) {
            GoDuplicatesSearch.$$$reportNull$$$0(14);
        }
        if (processor2 == null) {
            GoDuplicatesSearch.$$$reportNull$$$0(15);
        }
        for (Map.Entry entry : file.getImportMap().entrySet()) {
            for (GoImportSpec spec : (Collection)entry.getValue()) {
                Collection<GoPackage> packages2 = spec.resolve(ResolveState.initial());
                if (packages2.isEmpty()) continue;
                if (!(spec.isDot() || spec.isForSideEffects() || processor2.process(entry.getKey(), (Object)new Duplicate(spec)))) {
                    return;
                }
                if (!spec.isDot()) continue;
                Iterator<GoPackage> iterator = packages2.iterator();
                while (iterator.hasNext()) {
                    GoPackage aPackage;
                    Condition condition = (aPackage = iterator.next()).equals(contextPackage) ? f -> f != file && !StringUtil.equals((CharSequence)f.getPackageName(), (CharSequence)contextPackageName) : null;
                    if (GoDuplicatesSearch.processPackage(file, aPackage, module, (Condition<GoFile>)condition, true, (PairProcessor<? super String, ? super Duplicate>)((PairProcessor)(s, duplicate) -> processor2.process(s, (Object)new Duplicate(duplicate.duplicatedElement, spec))))) continue;
                    return;
                }
            }
        }
    }

    private static boolean processNamedElements(@NotNull Collection<? extends GoNamedElement> elements, boolean exportedOnly, @NotNull PairProcessor<? super String, ? super Duplicate> processor2) {
        if (elements == null) {
            GoDuplicatesSearch.$$$reportNull$$$0(16);
        }
        if (processor2 == null) {
            GoDuplicatesSearch.$$$reportNull$$$0(17);
        }
        for (GoNamedElement goNamedElement : elements) {
            if (exportedOnly && !goNamedElement.isPublic() || processor2.process((Object)goNamedElement.getName(), (Object)new Duplicate(goNamedElement))) continue;
            return false;
        }
        return true;
    }

    private static void processTypeParameters(@Nullable GoTypeParameters typeParameters, @NotNull PairProcessor<? super String, ? super Duplicate> processor2) {
        if (processor2 == null) {
            GoDuplicatesSearch.$$$reportNull$$$0(18);
        }
        if (typeParameters == null) {
            return;
        }
        for (GoTypeParameterDeclaration decl : typeParameters.getTypeParameterDeclarationList()) {
            for (GoTypeParamDefinition parameter : decl.getTypeParamDefinitionList()) {
                if (processor2.process((Object)parameter.getName(), (Object)new Duplicate(parameter))) continue;
                return;
            }
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/goide/inspections/GoDuplicatesSearch";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "title";
                break;
            }
            case 2: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 3: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 4: 
            case 8: 
            case 9: 
            case 12: 
            case 15: 
            case 17: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processor";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "container";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "contextFile";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "aPackage";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "contextPackageName";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elements";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getTitle";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "com/goide/inspections/GoDuplicatesSearch";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "processDuplicates";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getContainer";
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "processElementsWithName";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "processAllElements";
                break;
            }
            case 10: 
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "processPackage";
                break;
            }
            case 13: 
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "processImports";
                break;
            }
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "processNamedElements";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "processTypeParameters";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18 -> new IllegalArgumentException(string);
        };
    }

    public static class StatementsHolderScopeSearch
    extends GoDuplicatesSearch<GoStatementsHolder> {
        public StatementsHolderScopeSearch() {
            super("switch case, select case or block");
        }

        @Override
        protected void processElements(@NotNull GoStatementsHolder statementsHolder, @NotNull PairProcessor<? super String, ? super Duplicate> processor2) {
            if (statementsHolder == null) {
                StatementsHolderScopeSearch.$$$reportNull$$$0(0);
            }
            if (processor2 == null) {
                StatementsHolderScopeSearch.$$$reportNull$$$0(1);
            }
            for (GoStatement statement : statementsHolder.getStatementList()) {
                if (GoPsiUtil.processDefinitions(statement, (Processor<? super GoNamedElement>)((Processor)element -> processor2.process((Object)element.getName(), (Object)new Duplicate((GoNamedElement)element))))) continue;
                return;
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "statementsHolder";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "processor";
                    break;
                }
            }
            objectArray[1] = "com/goide/inspections/GoDuplicatesSearch$StatementsHolderScopeSearch";
            objectArray[2] = "processElements";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    public static class StructScopeSearch
    extends GoDuplicatesSearch<GoStructType> {
        public StructScopeSearch() {
            super("struct");
        }

        @Override
        protected void processElements(@NotNull GoStructType structType, @NotNull PairProcessor<? super String, ? super Duplicate> processor2) {
            if (structType == null) {
                StructScopeSearch.$$$reportNull$$$0(0);
            }
            if (processor2 == null) {
                StructScopeSearch.$$$reportNull$$$0(1);
            }
            GoDuplicatesSearch.processNamedElements(structType.getFieldDefinitions(), false, processor2);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "structType";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "processor";
                    break;
                }
            }
            objectArray[1] = "com/goide/inspections/GoDuplicatesSearch$StructScopeSearch";
            objectArray[2] = "processElements";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    public static class InterfaceScopeSearch
    extends GoDuplicatesSearch<GoInterfaceType> {
        public InterfaceScopeSearch() {
            super("interface");
        }

        @Override
        protected void processElements(@NotNull GoInterfaceType container, @NotNull PairProcessor<? super String, ? super Duplicate> processor2) {
            if (container == null) {
                InterfaceScopeSearch.$$$reportNull$$$0(0);
            }
            if (processor2 == null) {
                InterfaceScopeSearch.$$$reportNull$$$0(1);
            }
            GoDuplicatesSearch.processNamedElements(container.getMethods(), false, processor2);
            for (GoTypeReferenceExpression reference : container.getBaseTypesReferences()) {
                List<Object> typeArgs;
                PsiElement resolve2 = reference == null ? null : reference.resolve();
                if (!(resolve2 instanceof GoTypeSpec)) continue;
                GoMethodSpec method = (GoMethodSpec)PsiTreeUtil.getStubOrPsiParentOfType((PsiElement)reference, GoMethodSpec.class);
                GoTypeArguments typeArgumentsElem = method != null ? method.getTypeArguments() : null;
                List<Object> list = typeArgs = typeArgumentsElem != null ? typeArgumentsElem.getTypes() : Collections.emptyList();
                GoSpecType specType = ((GoTypeSpec)resolve2).getSpecType();
                GoType innerInterface = specType.getUnderlyingType(reference);
                if (!(innerInterface instanceof GoInterfaceType)) continue;
                GoType instantiatedSpecType = GoTypeInstantiationKt.getInstantiatedSpecType(specType, typeArgs);
                List<GoElementWithSubst<GoMethodSpec>> methodSpecs = GoPsiImplUtil.calcAllMethodsWithSubstitutionSource((GoInterfaceType)innerInterface, instantiatedSpecType, (PsiElement)container);
                for (GoElementWithSubst<GoMethodSpec> spec : methodSpecs) {
                    if (!processor2.process((Object)spec.getElement().getName(), (Object)new Duplicate(spec.getElement(), reference, spec.getSubstitutionSource()))) break;
                }
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "container";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "processor";
                    break;
                }
            }
            objectArray[1] = "com/goide/inspections/GoDuplicatesSearch$InterfaceScopeSearch";
            objectArray[2] = "processElements";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    public static class LabelScopeSearch
    extends GoDuplicatesSearch<GoSignatureOwner> {
        public LabelScopeSearch() {
            super("label");
        }

        @Override
        protected void processElements(@NotNull GoSignatureOwner signatureOwner, final @NotNull PairProcessor<? super String, ? super Duplicate> processor2) {
            if (signatureOwner == null) {
                LabelScopeSearch.$$$reportNull$$$0(0);
            }
            if (processor2 == null) {
                LabelScopeSearch.$$$reportNull$$$0(1);
            }
            signatureOwner.acceptChildren(new GoRecursiveVisitor(){

                @Override
                public void visitFunctionLit(@NotNull GoFunctionLit o) {
                    if (o == null) {
                        1.$$$reportNull$$$0(0);
                    }
                }

                @Override
                public void visitLabelDefinition(@NotNull GoLabelDefinition o) {
                    if (o == null) {
                        1.$$$reportNull$$$0(1);
                    }
                    super.visitLabelDefinition(o);
                    processor2.process((Object)o.getName(), (Object)new Duplicate(o));
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    Object[] objectArray;
                    Object[] objectArray2 = new Object[3];
                    objectArray2[0] = "o";
                    objectArray2[1] = "com/goide/inspections/GoDuplicatesSearch$LabelScopeSearch$1";
                    switch (n) {
                        default: {
                            objectArray = objectArray2;
                            objectArray2[2] = "visitFunctionLit";
                            break;
                        }
                        case 1: {
                            objectArray = objectArray2;
                            objectArray2[2] = "visitLabelDefinition";
                            break;
                        }
                    }
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
                }
            });
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "signatureOwner";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "processor";
                    break;
                }
            }
            objectArray[1] = "com/goide/inspections/GoDuplicatesSearch$LabelScopeSearch";
            objectArray[2] = "processElements";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    public static class SignatureOwnerScopeSearch
    extends GoDuplicatesSearch<GoSignatureOwner> {
        public SignatureOwnerScopeSearch() {
            super("function or method");
        }

        @Override
        protected void processElements(@NotNull GoSignatureOwner signatureOwner, @NotNull PairProcessor<? super String, ? super Duplicate> processor2) {
            if (signatureOwner == null) {
                SignatureOwnerScopeSearch.$$$reportNull$$$0(0);
            }
            if (processor2 == null) {
                SignatureOwnerScopeSearch.$$$reportNull$$$0(1);
            }
            new SignatureScopeSearch().processElements(signatureOwner, processor2);
            GoBlock block = signatureOwner.getBlockIfExists();
            if (block != null) {
                new StatementsHolderScopeSearch().processElements(block, processor2);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "signatureOwner";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "processor";
                    break;
                }
            }
            objectArray[1] = "com/goide/inspections/GoDuplicatesSearch$SignatureOwnerScopeSearch";
            objectArray[2] = "processElements";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    public static class SignatureScopeSearch
    extends GoDuplicatesSearch<GoSignatureOwner> {
        public SignatureScopeSearch() {
            super("function or method signature");
        }

        @Override
        protected void processElements(@NotNull GoSignatureOwner signatureOwner, @NotNull PairProcessor<? super String, ? super Duplicate> processor2) {
            GoParameters parameters;
            GoReceiver receiver;
            if (signatureOwner == null) {
                SignatureScopeSearch.$$$reportNull$$$0(0);
            }
            if (processor2 == null) {
                SignatureScopeSearch.$$$reportNull$$$0(1);
            }
            if (signatureOwner instanceof GoMethodDeclaration && (receiver = ((GoMethodDeclaration)signatureOwner).getReceiver()) != null && !processor2.process((Object)receiver.getName(), (Object)new Duplicate(receiver))) {
                return;
            }
            GoSignature signature = signatureOwner.getSignature();
            if (signature == null) {
                return;
            }
            GoDuplicatesSearch.processTypeParameters(signature.getTypeParameters(), processor2);
            SignatureScopeSearch.processParameters(signature.getParameters(), processor2);
            GoResult result = signature.getResult();
            GoParameters goParameters = parameters = result != null ? result.getParameters() : null;
            if (parameters != null) {
                SignatureScopeSearch.processParameters(parameters, processor2);
            }
        }

        private static void processParameters(@NotNull GoParameters parameters, @NotNull PairProcessor<? super String, ? super Duplicate> processor2) {
            if (parameters == null) {
                SignatureScopeSearch.$$$reportNull$$$0(2);
            }
            if (processor2 == null) {
                SignatureScopeSearch.$$$reportNull$$$0(3);
            }
            for (GoParameterDeclaration fp : parameters.getParameterDeclarationList()) {
                for (GoParamDefinition parameter : fp.getParamDefinitionList()) {
                    if (processor2.process((Object)parameter.getName(), (Object)new Duplicate(parameter))) continue;
                    return;
                }
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "signatureOwner";
                    break;
                }
                case 1: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "processor";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "parameters";
                    break;
                }
            }
            objectArray2[1] = "com/goide/inspections/GoDuplicatesSearch$SignatureScopeSearch";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "processElements";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "processParameters";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    public static class TypeSpecScopeSearch
    extends GoDuplicatesSearch<GoTypeSpec> {
        public TypeSpecScopeSearch() {
            super("type spec");
        }

        @Override
        protected void processElements(@NotNull GoTypeSpec typeSpec, @NotNull PairProcessor<? super String, ? super Duplicate> processor2) {
            if (typeSpec == null) {
                TypeSpecScopeSearch.$$$reportNull$$$0(0);
            }
            if (processor2 == null) {
                TypeSpecScopeSearch.$$$reportNull$$$0(1);
            }
            GoType underlyingType = typeSpec.getSpecType().getContextlessUnderlyingType();
            GoFile file = typeSpec.getContainingFile();
            Module module = GoUtil.module((PsiElement)file);
            for (GoMethodDeclaration method : typeSpec.getMethods()) {
                if (!method.isValid() || !GoPsiImplUtil.allowed((PsiFile)method.getContainingFile(), (PsiFile)file, module) || processor2.process((Object)method.getName(), (Object)new Duplicate(method))) continue;
                return;
            }
            if (underlyingType instanceof GoStructType) {
                new StructScopeSearch().processElements((GoStructType)underlyingType, processor2);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "typeSpec";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "processor";
                    break;
                }
            }
            objectArray[1] = "com/goide/inspections/GoDuplicatesSearch$TypeSpecScopeSearch";
            objectArray[2] = "processElements";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    public static class TopLevelScopeSearch
    extends GoDuplicatesSearch<GoFile> {
        public TopLevelScopeSearch() {
            super("package");
        }

        @Override
        public void processElements(@NotNull GoFile file, @NotNull PairProcessor<? super String, ? super Duplicate> processor2) {
            if (file == null) {
                TopLevelScopeSearch.$$$reportNull$$$0(0);
            }
            if (processor2 == null) {
                TopLevelScopeSearch.$$$reportNull$$$0(1);
            }
            Module module = GoUtil.module((PsiElement)file);
            String packageName = file.getPackageName();
            if (packageName == null) {
                return;
            }
            GoPackage contextPackage = GoPackage.of(file);
            if (contextPackage != null && !GoDuplicatesSearch.processPackage(file, contextPackage, module, (Condition<GoFile>)((Condition)f -> StringUtil.equals((CharSequence)f.getPackageName(), (CharSequence)packageName)), false, processor2)) {
                return;
            }
            GoDuplicatesSearch.processImports(file, contextPackage, packageName, module, processor2);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "file";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "processor";
                    break;
                }
            }
            objectArray[1] = "com/goide/inspections/GoDuplicatesSearch$TopLevelScopeSearch";
            objectArray[2] = "processElements";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    public static final class Duplicate {
        public final GoNamedElement duplicatedElement;
        public final PsiElement sourceElement;
        public final GoType substitutionSource;

        private Duplicate(@NotNull GoNamedElement duplicatedElement) {
            if (duplicatedElement == null) {
                Duplicate.$$$reportNull$$$0(0);
            }
            this(duplicatedElement, duplicatedElement);
        }

        private Duplicate(@NotNull GoNamedElement duplicatedElement, @NotNull PsiElement sourceElement) {
            if (duplicatedElement == null) {
                Duplicate.$$$reportNull$$$0(1);
            }
            if (sourceElement == null) {
                Duplicate.$$$reportNull$$$0(2);
            }
            this(duplicatedElement, sourceElement, null);
        }

        private Duplicate(@NotNull GoNamedElement duplicatedElement, @NotNull PsiElement sourceElement, @Nullable GoType substitutionSource) {
            if (duplicatedElement == null) {
                Duplicate.$$$reportNull$$$0(3);
            }
            if (sourceElement == null) {
                Duplicate.$$$reportNull$$$0(4);
            }
            this.duplicatedElement = duplicatedElement;
            this.sourceElement = sourceElement;
            this.substitutionSource = substitutionSource;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof Duplicate)) {
                return false;
            }
            Duplicate duplicate = (Duplicate)o;
            return Objects.equals(this.duplicatedElement, duplicate.duplicatedElement) && Objects.equals(this.sourceElement, duplicate.sourceElement) && Objects.equals(this.substitutionSource, duplicate.substitutionSource);
        }

        public int hashCode() {
            return Objects.hash(this.duplicatedElement, this.sourceElement, this.substitutionSource);
        }

        @NotNull
        public GoElementWithSubst<GoNamedElement> getSubstElement() {
            GoElementWithSubst<GoNamedElement> goElementWithSubst = GoElementWithSubst.create(this.duplicatedElement, this.substitutionSource);
            if (goElementWithSubst == null) {
                Duplicate.$$$reportNull$$$0(5);
            }
            return goElementWithSubst;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 5 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "duplicatedElement";
                    break;
                }
                case 2: 
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "sourceElement";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/goide/inspections/GoDuplicatesSearch$Duplicate";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/goide/inspections/GoDuplicatesSearch$Duplicate";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getSubstElement";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 5: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 5 -> new IllegalStateException(string);
            };
        }
    }

    public static class TypeSpecTypeParametersScopeSearch
    extends GoDuplicatesSearch<GoTypeParameters> {
        public TypeSpecTypeParametersScopeSearch() {
            super("type parameter");
        }

        @Override
        protected void processElements(@NotNull GoTypeParameters container, @NotNull PairProcessor<? super String, ? super Duplicate> processor2) {
            if (container == null) {
                TypeSpecTypeParametersScopeSearch.$$$reportNull$$$0(0);
            }
            if (processor2 == null) {
                TypeSpecTypeParametersScopeSearch.$$$reportNull$$$0(1);
            }
            GoDuplicatesSearch.processTypeParameters(container, processor2);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "container";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "processor";
                    break;
                }
            }
            objectArray[1] = "com/goide/inspections/GoDuplicatesSearch$TypeSpecTypeParametersScopeSearch";
            objectArray[2] = "processElements";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

