/*
 * Decompiled with CFR 0.152.
 */
package com.goide.inspections;

import com.goide.GoCommentsConverter;
import com.goide.GoConstants;
import com.goide.GoLanguage;
import com.goide.directiveComment.GoDirectiveComment;
import com.goide.documentation.GoDocumentationProvider;
import com.goide.execution.testing.GoTestFinder;
import com.goide.formatter.GoLineCommentBlock;
import com.goide.formatter.settings.GoCodeStyleSettings;
import com.goide.i18n.GoBundle;
import com.goide.inspections.core.GoInspectionBase;
import com.goide.inspections.core.GoProblemsHolder;
import com.goide.psi.GoFile;
import com.goide.psi.GoMethodDeclaration;
import com.goide.psi.GoNamedElement;
import com.goide.psi.GoPackageClause;
import com.goide.psi.GoTypeDeclaration;
import com.goide.psi.GoTypeSpec;
import com.goide.psi.GoVarOrConstDeclaration;
import com.goide.psi.GoVarOrConstDefinition;
import com.goide.psi.GoVarOrConstSpec;
import com.goide.psi.GoVisitor;
import com.goide.psi.impl.GoPsiUtil;
import com.goide.quickfix.GoDeleteQuickFix;
import com.intellij.application.options.CodeStyle;
import com.intellij.codeInspection.LocalInspectionToolSession;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.LocalQuickFixAndIntentionActionOnPsiElement;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.openapi.editor.CaretModel;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiParserFacade;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class GoCommentStartInspection
extends GoInspectionBase {
    private static final Set<String> COMMON_METHOD_NAMES = Set.of("Error", "Read", "ServeHTTP", "String", "Write");

    @Override
    @NotNull
    protected PsiElementVisitor buildVisitor(final @NotNull GoProblemsHolder holder, @NotNull LocalInspectionToolSession session) {
        if (holder == null) {
            GoCommentStartInspection.$$$reportNull$$$0(0);
        }
        if (session == null) {
            GoCommentStartInspection.$$$reportNull$$$0(1);
        }
        return new GoVisitor(){

            @Override
            public void visitPackageClause(@NotNull GoPackageClause o) {
                Pair<PsiElement, PsiElement> boundaries;
                if (o == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (GoCommentStartInspection.isElementFromTestOrMainPackage(o)) {
                    return;
                }
                List<PsiComment> comments = GoDocumentationProvider.getCommentsForElement(o);
                String packageName = o.getName();
                String commentText = 1.getCommentsText(comments);
                if (1.isDirectiveComment(commentText)) {
                    return;
                }
                GoCodeStyleSettings settings = (GoCodeStyleSettings)CodeStyle.getCustomSettings((PsiFile)o.getContainingFile(), GoCodeStyleSettings.class);
                if (!comments.isEmpty() && !GoCommentStartInspection.isCorrectPackageComment(commentText, packageName, settings) && (boundaries = GoCommentStartInspection.getFirstAndLastPhysicalComments(comments)) != null) {
                    AddPrefixToCommentQuickFix fix = new AddPrefixToCommentQuickFix((PsiElement)boundaries.first, "Package " + packageName);
                    holder.registerProblem((PsiElement)boundaries.first, (PsiElement)boundaries.second, GoCommentStartInspection.message("go.inspection.comment.should.have.package.prefix.message", new Object[]{packageName}), ProblemHighlightType.GENERIC_ERROR_OR_WARNING, holder.isOnTheFly(), new LocalQuickFix[]{fix});
                }
            }

            @Override
            public void visitNamedElement(@NotNull GoNamedElement o) {
                if (o == null) {
                    1.$$$reportNull$$$0(1);
                }
                super.visitNamedElement(o);
                if (GoCommentStartInspection.isElementFromTestPackage(o) || !o.isPublic()) {
                    return;
                }
                List comments = ContainerUtil.filter(1.getComments(o), c -> !GoDirectiveComment.isDirectiveComment(c));
                String commentText = 1.getCommentsText(comments);
                String elementName = o.getName();
                if (1.isDirectiveComment(commentText)) {
                    return;
                }
                if (elementName != null && !comments.isEmpty()) {
                    GoCodeStyleSettings settings = (GoCodeStyleSettings)CodeStyle.getCustomSettings((PsiFile)o.getContainingFile(), GoCodeStyleSettings.class);
                    if (GoCommentStartInspection.isCommonMethod(o)) {
                        return;
                    }
                    if (!GoCommentStartInspection.isCorrectComment(commentText, elementName, settings)) {
                        Pair<PsiElement, PsiElement> boundaries = GoCommentStartInspection.getFirstAndLastPhysicalComments(comments);
                        if (boundaries != null) {
                            AddPrefixToCommentQuickFix fix = new AddPrefixToCommentQuickFix((PsiElement)boundaries.first, elementName);
                            holder.registerProblem((PsiElement)boundaries.first, (PsiElement)boundaries.second, GoCommentStartInspection.message("go.inspection.comment.should.be.without.article.message", new Object[]{elementName}), ProblemHighlightType.GENERIC_ERROR_OR_WARNING, holder.isOnTheFly(), new LocalQuickFix[]{fix});
                        }
                    } else if (commentText.length() <= elementName.length() + 1) {
                        for (PsiComment comment : comments) {
                            if (!comment.isPhysical()) continue;
                            holder.registerProblem((PsiElement)comment, GoCommentStartInspection.message("go.inspection.comment.should.be.meaningful.message"), GoDeleteQuickFix.Fixes.DELETE_COMMENT_FIX);
                        }
                    }
                }
            }

            private static boolean isDirectiveComment(String commentText) {
                return Arrays.stream(GoConstants.COMPILER_FLAGS).anyMatch(directive -> GoPsiUtil.isFlaggedComment(commentText.trim(), directive));
            }

            @NotNull
            private static String getCommentsText(@NotNull List<PsiComment> comments) {
                if (comments == null) {
                    1.$$$reportNull$$$0(2);
                }
                List<String> lines = GoCommentsConverter.toStringList(comments, false);
                String string = lines.stream().filter(StringUtil::isNotEmpty).collect(Collectors.joining("\n"));
                if (string == null) {
                    1.$$$reportNull$$$0(3);
                }
                return string;
            }

            @NotNull
            private static List<PsiComment> getComments(@NotNull GoNamedElement o) {
                PsiElement parent;
                List<PsiComment> comments;
                if (o == null) {
                    1.$$$reportNull$$$0(4);
                }
                if (!(comments = GoDocumentationProvider.getUpperComments(o)).isEmpty()) {
                    List<PsiComment> list = comments;
                    if (list == null) {
                        1.$$$reportNull$$$0(5);
                    }
                    return list;
                }
                if (o instanceof GoVarOrConstDefinition) {
                    PsiElement parent2 = o.getParent();
                    if (parent2 instanceof GoVarOrConstSpec && ((GoVarOrConstSpec)parent2).getDefinitionList().size() == 1) {
                        comments = GoDocumentationProvider.getUpperComments(parent2);
                        if (!comments.isEmpty()) {
                            List<PsiComment> list = comments;
                            if (list == null) {
                                1.$$$reportNull$$$0(6);
                            }
                            return list;
                        }
                        PsiElement grandParent = parent2.getParent();
                        if (grandParent instanceof GoVarOrConstDeclaration && ((GoVarOrConstDeclaration)grandParent).getSpecList().size() == 1) {
                            List<PsiComment> list = GoDocumentationProvider.getUpperComments(grandParent);
                            if (list == null) {
                                1.$$$reportNull$$$0(7);
                            }
                            return list;
                        }
                    }
                } else if (o instanceof GoTypeSpec && (parent = o.getParent()) instanceof GoTypeDeclaration && ((GoTypeDeclaration)parent).getTypeSpecList().size() == 1) {
                    List<PsiComment> list = GoDocumentationProvider.getUpperComments(parent);
                    if (list == null) {
                        1.$$$reportNull$$$0(8);
                    }
                    return list;
                }
                List<PsiComment> list = Collections.emptyList();
                if (list == null) {
                    1.$$$reportNull$$$0(9);
                }
                return list;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[switch (n) {
                    default -> 3;
                    case 3, 5, 6, 7, 8, 9 -> 2;
                }];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "o";
                        break;
                    }
                    case 2: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "comments";
                        break;
                    }
                    case 3: 
                    case 5: 
                    case 6: 
                    case 7: 
                    case 8: 
                    case 9: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/goide/inspections/GoCommentStartInspection$1";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/goide/inspections/GoCommentStartInspection$1";
                        break;
                    }
                    case 3: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getCommentsText";
                        break;
                    }
                    case 5: 
                    case 6: 
                    case 7: 
                    case 8: 
                    case 9: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getComments";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray;
                        objectArray[2] = "visitPackageClause";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray;
                        objectArray[2] = "visitNamedElement";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray;
                        objectArray[2] = "getCommentsText";
                        break;
                    }
                    case 3: 
                    case 5: 
                    case 6: 
                    case 7: 
                    case 8: 
                    case 9: {
                        break;
                    }
                    case 4: {
                        objectArray = objectArray;
                        objectArray[2] = "getComments";
                        break;
                    }
                }
                String string = String.format(v0, objectArray);
                throw switch (n) {
                    default -> new IllegalArgumentException(string);
                    case 3, 5, 6, 7, 8, 9 -> new IllegalStateException(string);
                };
            }
        };
    }

    public static boolean isCommonMethod(@NotNull GoNamedElement o) {
        if (o == null) {
            GoCommentStartInspection.$$$reportNull$$$0(2);
        }
        String name = o.getName();
        return o instanceof GoMethodDeclaration && name != null && COMMON_METHOD_NAMES.contains(name);
    }

    private static boolean isElementFromTestOrMainPackage(@NotNull PsiElement o) {
        GoFile file;
        if (o == null) {
            GoCommentStartInspection.$$$reportNull$$$0(3);
        }
        return (file = (GoFile)((Object)ObjectUtils.tryCast((Object)o.getContainingFile(), GoFile.class))) != null && (GoCommentStartInspection.isElementFromTestPackage(o) || "main".equals(file.getPackageName()));
    }

    private static boolean isElementFromTestPackage(@NotNull PsiElement o) {
        if (o == null) {
            GoCommentStartInspection.$$$reportNull$$$0(4);
        }
        return GoTestFinder.isTestFile((PsiFile)ObjectUtils.tryCast((Object)o.getContainingFile(), GoFile.class));
    }

    @Nullable
    private static Pair<PsiElement, PsiElement> getFirstAndLastPhysicalComments(@NotNull List<PsiComment> comments) {
        if (comments == null) {
            GoCommentStartInspection.$$$reportNull$$$0(5);
        }
        PsiComment first = (PsiComment)ContainerUtil.find(comments, PsiElement::isPhysical);
        PsiComment last = (PsiComment)ContainerUtil.findLast(comments, PsiElement::isPhysical);
        return first == null ? null : Pair.create((Object)first, (Object)last);
    }

    private static boolean isCorrectPackageComment(@NotNull String commentText, @Nullable String packageName, @NotNull GoCodeStyleSettings settings) {
        if (commentText == null) {
            GoCommentStartInspection.$$$reportNull$$$0(6);
        }
        if (settings == null) {
            GoCommentStartInspection.$$$reportNull$$$0(7);
        }
        return packageName == null || commentText.startsWith("Package " + packageName) || GoCommentStartInspection.isDeprecationComment(commentText) || !GoLineCommentBlock.canBeFormatted(commentText, settings);
    }

    private static boolean isCorrectComment(@NotNull String commentText, @NotNull String elementName, @NotNull GoCodeStyleSettings settings) {
        if (commentText == null) {
            GoCommentStartInspection.$$$reportNull$$$0(8);
        }
        if (elementName == null) {
            GoCommentStartInspection.$$$reportNull$$$0(9);
        }
        if (settings == null) {
            GoCommentStartInspection.$$$reportNull$$$0(10);
        }
        return GoCommentStartInspection.startsWithSentence(commentText, elementName) || GoCommentStartInspection.startsWithSentence(commentText, "A " + elementName) || GoCommentStartInspection.startsWithSentence(commentText, "An " + elementName) || GoCommentStartInspection.startsWithSentence(commentText, "The " + elementName) || GoCommentStartInspection.isDeprecationComment(commentText) || !GoLineCommentBlock.canBeFormatted(commentText, settings);
    }

    private static boolean startsWithSentence(@NotNull String str, @NotNull String sentence) {
        if (str == null) {
            GoCommentStartInspection.$$$reportNull$$$0(11);
        }
        if (sentence == null) {
            GoCommentStartInspection.$$$reportNull$$$0(12);
        }
        return str.equals(sentence) || str.length() > sentence.length() && str.startsWith(sentence) && Character.isWhitespace(str.charAt(sentence.length()));
    }

    private static boolean isDeprecationComment(@NotNull String commentText) {
        if (commentText == null) {
            GoCommentStartInspection.$$$reportNull$$$0(13);
        }
        return commentText.startsWith("Deprecated:");
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "session";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "o";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "comments";
                break;
            }
            case 6: 
            case 8: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "commentText";
                break;
            }
            case 7: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "settings";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elementName";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "str";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sentence";
                break;
            }
        }
        objectArray2[1] = "com/goide/inspections/GoCommentStartInspection";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "buildVisitor";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "isCommonMethod";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "isElementFromTestOrMainPackage";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "isElementFromTestPackage";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "getFirstAndLastPhysicalComments";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "isCorrectPackageComment";
                break;
            }
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[2] = "isCorrectComment";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray2;
                objectArray2[2] = "startsWithSentence";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[2] = "isDeprecationComment";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static final class AddPrefixToCommentQuickFix
    extends LocalQuickFixAndIntentionActionOnPsiElement {
        private final String myPrefix;

        private AddPrefixToCommentQuickFix(@NotNull PsiElement element, @NotNull String prefix) {
            if (element == null) {
                AddPrefixToCommentQuickFix.$$$reportNull$$$0(0);
            }
            if (prefix == null) {
                AddPrefixToCommentQuickFix.$$$reportNull$$$0(1);
            }
            super(element);
            this.myPrefix = prefix;
        }

        public void invoke(@NotNull Project project, @NotNull PsiFile file, @Nullable Editor editor, @NotNull PsiElement startElement, @NotNull PsiElement endElement) {
            if (project == null) {
                AddPrefixToCommentQuickFix.$$$reportNull$$$0(2);
            }
            if (file == null) {
                AddPrefixToCommentQuickFix.$$$reportNull$$$0(3);
            }
            if (startElement == null) {
                AddPrefixToCommentQuickFix.$$$reportNull$$$0(4);
            }
            if (endElement == null) {
                AddPrefixToCommentQuickFix.$$$reportNull$$$0(5);
            }
            if (startElement instanceof PsiComment && startElement.isValid()) {
                String newText = " " + this.myPrefix + " " + StringUtil.trimLeading((String)StringUtil.trimLeading((String)startElement.getText().replaceFirst("//", "")));
                PsiComment newComment = PsiParserFacade.getInstance((Project)project).createLineCommentFromText(GoLanguage.INSTANCE, newText);
                PsiElement inserted = startElement.replace((PsiElement)newComment);
                if (editor != null) {
                    CaretModel caretModel = editor.getCaretModel();
                    int offset = ("// " + this.myPrefix + " ").length();
                    caretModel.moveToOffset(inserted.getTextRange().getStartOffset() + offset);
                }
            }
        }

        @Nls
        @NotNull
        public String getFamilyName() {
            String string = GoBundle.message((String)"go.fix.add.prefix.to.comment.name", (Object[])new Object[]{this.myPrefix});
            if (string == null) {
                AddPrefixToCommentQuickFix.$$$reportNull$$$0(6);
            }
            return string;
        }

        @NotNull
        public String getText() {
            String string = this.getFamilyName();
            if (string == null) {
                AddPrefixToCommentQuickFix.$$$reportNull$$$0(7);
            }
            return string;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 6, 7 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "element";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "prefix";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "file";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "startElement";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "endElement";
                    break;
                }
                case 6: 
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/goide/inspections/GoCommentStartInspection$AddPrefixToCommentQuickFix";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/goide/inspections/GoCommentStartInspection$AddPrefixToCommentQuickFix";
                    break;
                }
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
                case 7: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getText";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: 
                case 3: 
                case 4: 
                case 5: {
                    objectArray = objectArray;
                    objectArray[2] = "invoke";
                    break;
                }
                case 6: 
                case 7: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 6, 7 -> new IllegalStateException(string);
            };
        }
    }
}

