/*
 * Decompiled with CFR 0.152.
 */
package com.goide.highlighting.legacyErrorInspections;

import com.goide.highlighting.legacyErrorInspections.GoInvalidExpressionConversionInspection;
import com.goide.highlighting.legacyErrorInspections.GoTypeCheckingUtil;
import com.goide.i18n.GoBundle;
import com.goide.inspections.core.GoInspectionMessage;
import com.goide.inspections.core.GoInspectionProblemUtil;
import com.goide.inspections.core.GoProblemsHolder;
import com.goide.psi.GoArrayOrSliceType;
import com.goide.psi.GoExpression;
import com.goide.psi.GoIndexOrSliceExpr;
import com.goide.psi.GoMapType;
import com.goide.psi.GoType;
import com.goide.psi.GoTypeOwner;
import com.goide.psi.GoVisitor;
import com.goide.psi.impl.GoCType;
import com.goide.psi.impl.GoExpressionUtil;
import com.goide.psi.impl.GoLightType;
import com.goide.psi.impl.GoPsiImplUtil;
import com.goide.psi.impl.GoPsiUtil;
import com.goide.psi.impl.GoReferenceBase;
import com.goide.psi.impl.GoTypeUtil;
import com.goide.psi.impl.typesCompatibility.GoTypeCheckResult;
import com.goide.psi.impl.typesCompatibility.GoTypesNotCompatible;
import com.goide.util.Value;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.Trinity;
import com.intellij.psi.PsiElement;
import com.intellij.usageView.UsageViewUtil;
import com.intellij.util.ThreeState;
import com.intellij.util.containers.ContainerUtil;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GoInvalidIndexOrSliceExpressionInspection
extends GoVisitor {
    @NotNull
    private final GoProblemsHolder myHolder;

    public GoInvalidIndexOrSliceExpressionInspection(@NotNull GoProblemsHolder holder) {
        if (holder == null) {
            GoInvalidIndexOrSliceExpressionInspection.$$$reportNull$$$0(0);
        }
        this.myHolder = holder;
    }

    @Override
    public void visitIndexOrSliceExpr(@NotNull GoIndexOrSliceExpr o) {
        GoType type2;
        if (o == null) {
            GoInvalidIndexOrSliceExpressionInspection.$$$reportNull$$$0(1);
        }
        super.visitIndexOrSliceExpr(o);
        if (o.getType() != null || GoPsiUtil.isCallOrConversionWithTypeInstantiation(o)) {
            return;
        }
        GoExpression expr = o.getExpression();
        GoType goType = type2 = expr != null ? expr.getGoType(null) : null;
        if (type2 == null) {
            return;
        }
        PsiElement context = GoReferenceBase.getSubstitutionContextOrSelf(expr);
        GoType underlyingType = type2.getUnderlyingType(context);
        this.doCheck(o, expr, type2, underlyingType, context);
    }

    private void doCheck(@NotNull GoIndexOrSliceExpr o, GoExpression expr, GoType type2, GoType underlyingType, @NotNull PsiElement context) {
        GoType mapKeyType;
        boolean operandIsOk;
        if (o == null) {
            GoInvalidIndexOrSliceExpressionInspection.$$$reportNull$$$0(2);
        }
        if (context == null) {
            GoInvalidIndexOrSliceExpressionInspection.$$$reportNull$$$0(3);
        }
        if (underlyingType instanceof GoCType) {
            return;
        }
        boolean slice = !o.isIndexExpression();
        boolean bl = operandIsOk = slice ? GoInvalidIndexOrSliceExpressionInspection.isValidSliceExpressionOperand(expr, underlyingType, context) : GoTypeUtil.isIterableAndIndexed(underlyingType, context);
        if (!operandIsOk) {
            GoInspectionMessage message = slice ? GoInspectionProblemUtil.message("go.inspection.problem.cannot.slice", GoInspectionProblemUtil.code(expr), GoInspectionProblemUtil.code(type2.getPresentationText())) : GoInspectionProblemUtil.message("go.inspection.problem.type.does.not.support.indexing", GoInspectionProblemUtil.code(o), GoInspectionProblemUtil.code(type2.getPresentationText()));
            this.myHolder.registerProblem((PsiElement)expr, message, new LocalQuickFix[0]);
            return;
        }
        Trinity<GoExpression, GoExpression, GoExpression> indices = o.getIndices();
        if (indices.first == null && indices.second == null) {
            return;
        }
        if (indices.first != null && (mapKeyType = GoTypeUtil.getMapKeyType(underlyingType, context)) != null) {
            GoTypeCheckResult result = GoTypeUtil.checkAssignable(mapKeyType, (GoTypeOwner)indices.first, false);
            if (result instanceof GoTypesNotCompatible) {
                GoInspectionMessage message = GoTypeCheckingUtil.commonErrorDescription((GoExpression)indices.first, mapKeyType, result);
                GoTypeCheckingUtil.registerProblem(this.myHolder, (GoExpression)indices.first, message, mapKeyType, result);
            }
            return;
        }
        GoType iterableType = GoPsiImplUtil.unwrapPointerIfNeeded(type2);
        if (iterableType == null) {
            return;
        }
        String iterableTypeDescription = UsageViewUtil.getType((PsiElement)iterableType);
        GoType iterableUnderlyingType = iterableType.getUnderlyingType(context);
        int length = GoInvalidIndexOrSliceExpressionInspection.getLength(iterableUnderlyingType, expr, context);
        boolean constantLength = !GoTypeUtil.isString(iterableUnderlyingType, context) || expr.isConstant();
        this.checkIndex((GoExpression)indices.first, context, iterableTypeDescription, length, slice, constantLength);
        this.checkIndex((GoExpression)indices.second, context, iterableTypeDescription, length, slice, constantLength);
        this.checkIndex((GoExpression)indices.third, context, iterableTypeDescription, length, slice, constantLength);
        if (!GoInvalidIndexOrSliceExpressionInspection.isCorrectOrder(indices)) {
            this.myHolder.registerProblem((PsiElement)o, indices.third == null ? GoInspectionProblemUtil.message("go.inspection.problem.invalid.low.high.indices") : GoInspectionProblemUtil.message("go.inspection.problem.invalid.low.high.max.indices"), new LocalQuickFix[0]);
        }
    }

    private static boolean isValidSliceExpressionOperand(@NotNull GoExpression operand, @Nullable GoType underlyingType, @NotNull PsiElement context) {
        if (operand == null) {
            GoInvalidIndexOrSliceExpressionInspection.$$$reportNull$$$0(4);
        }
        if (context == null) {
            GoInvalidIndexOrSliceExpressionInspection.$$$reportNull$$$0(5);
        }
        if (underlyingType instanceof GoMapType) {
            return false;
        }
        if (GoTypeUtil.isArray(underlyingType, operand)) {
            return GoExpressionUtil.isAddressable(operand, context);
        }
        return GoTypeUtil.isIterableAndIndexed(underlyingType, GoReferenceBase.getSubstitutionContextOrSelf(operand));
    }

    private void checkIndex(@Nullable GoExpression expr, @NotNull PsiElement context, @NotNull String iterableTypeText, int length, boolean slice, boolean constantLength) {
        int high;
        Long index;
        GoType type2;
        if (context == null) {
            GoInvalidIndexOrSliceExpressionInspection.$$$reportNull$$$0(6);
        }
        if (iterableTypeText == null) {
            GoInvalidIndexOrSliceExpressionInspection.$$$reportNull$$$0(7);
        }
        GoType goType = type2 = expr != null ? expr.getGoType(null) : null;
        if (type2 == null) {
            return;
        }
        if (type2 instanceof GoLightType.LightUntypedType && expr.isConstant()) {
            Value value = expr.getValue();
            if (value != null && ThreeState.NO == GoInvalidExpressionConversionInspection.isRepresentable(value, type2, GoLightType.getIntType(expr), false, context)) {
                this.myHolder.registerProblem((PsiElement)expr, GoInvalidIndexOrSliceExpressionInspection.invalidIndexMessage(expr, iterableTypeText, slice, GoBundle.message((String)"go.inspection.problem.must.be.representable.by.int", (Object[])new Object[0])), new LocalQuickFix[0]);
                return;
            }
        } else {
            GoType underlyingType = type2.getUnderlyingType(context);
            if (!(underlyingType instanceof GoCType) && !GoTypeUtil.isIntegerType(underlyingType, context)) {
                this.myHolder.registerProblem((PsiElement)expr, GoInvalidIndexOrSliceExpressionInspection.invalidIndexMessage(expr, iterableTypeText, slice, GoBundle.message((String)"go.inspection.problem.must.be.of.integer.type", (Object[])new Object[0])), new LocalQuickFix[0]);
                return;
            }
        }
        if ((index = GoInvalidIndexOrSliceExpressionInspection.getIntegerValue(expr)) == null) {
            return;
        }
        if (index < 0L) {
            GoInspectionMessage message = GoInvalidIndexOrSliceExpressionInspection.invalidIndexMessage(expr, iterableTypeText, slice, GoBundle.message((String)"go.inspection.problem.must.be.non.negative", (Object[])new Object[0]));
            this.myHolder.registerProblem((PsiElement)expr, message, GoInvalidIndexOrSliceExpressionInspection.getSeverity(expr, constantLength), new LocalQuickFix[0]);
            return;
        }
        int n = high = slice ? length + 1 : length;
        if (length >= 0 && index >= (long)high) {
            if ("string".equals(iterableTypeText)) {
                GoInspectionMessage message = GoInvalidIndexOrSliceExpressionInspection.invalidIndexMessage(expr, iterableTypeText, slice, GoBundle.message((String)"go.inspection.problem.out.of.bounds.for.string", (Object[])new Object[]{length}));
                this.myHolder.registerProblem((PsiElement)expr, message, GoInvalidIndexOrSliceExpressionInspection.getSeverity(expr, constantLength), new LocalQuickFix[0]);
                return;
            }
            GoInspectionMessage message = GoInvalidIndexOrSliceExpressionInspection.invalidIndexMessage(expr, iterableTypeText, slice, GoBundle.message((String)"go.inspection.problem.out.of.bounds.for.array", (Object[])new Object[]{length}));
            this.myHolder.registerProblem((PsiElement)expr, message, GoInvalidIndexOrSliceExpressionInspection.getSeverity(expr, constantLength), new LocalQuickFix[0]);
        }
    }

    private static boolean isCorrectOrder(@NotNull Trinity<GoExpression, GoExpression, GoExpression> indices) {
        if (indices == null) {
            GoInvalidIndexOrSliceExpressionInspection.$$$reportNull$$$0(8);
        }
        ArrayList indexValues = new ArrayList(3);
        ContainerUtil.addIfNotNull(indexValues, (Object)GoInvalidIndexOrSliceExpressionInspection.getIntegerValue((GoExpression)indices.first));
        ContainerUtil.addIfNotNull(indexValues, (Object)GoInvalidIndexOrSliceExpressionInspection.getIntegerValue((GoExpression)indices.second));
        ContainerUtil.addIfNotNull(indexValues, (Object)GoInvalidIndexOrSliceExpressionInspection.getIntegerValue((GoExpression)indices.third));
        if (indexValues.size() == 2) {
            return GoInvalidIndexOrSliceExpressionInspection.isLessOrEqual((Long)indexValues.get(0), (Long)indexValues.get(1));
        }
        if (indexValues.size() == 3) {
            return GoInvalidIndexOrSliceExpressionInspection.isLessOrEqual((Long)indexValues.get(0), (Long)indexValues.get(1)) && GoInvalidIndexOrSliceExpressionInspection.isLessOrEqual((Long)indexValues.get(1), (Long)indexValues.get(2));
        }
        return true;
    }

    @Nullable
    private static Long getIntegerValue(@Nullable GoExpression expr) {
        Value value = expr != null ? expr.getValue() : null;
        return value != null ? value.getInteger() : null;
    }

    private static boolean isLessOrEqual(@Nullable Long a, @Nullable Long b) {
        return a == null || b == null || a <= b;
    }

    @NotNull
    private static GoInspectionMessage invalidIndexMessage(@NotNull GoExpression index, @NotNull @NlsSafe String iterableTypeText, boolean slice, @NotNull @NlsSafe String details) {
        if (index == null) {
            GoInvalidIndexOrSliceExpressionInspection.$$$reportNull$$$0(9);
        }
        if (iterableTypeText == null) {
            GoInvalidIndexOrSliceExpressionInspection.$$$reportNull$$$0(10);
        }
        if (details == null) {
            GoInvalidIndexOrSliceExpressionInspection.$$$reportNull$$$0(11);
        }
        GoInspectionMessage goInspectionMessage = slice ? GoInspectionProblemUtil.message("go.inspection.problem.invalid.slice.index", GoInspectionProblemUtil.code(index), details) : GoInspectionProblemUtil.message("go.inspection.problem.invalid.iterable.index", iterableTypeText, GoInspectionProblemUtil.code(index), details);
        if (goInspectionMessage == null) {
            GoInvalidIndexOrSliceExpressionInspection.$$$reportNull$$$0(12);
        }
        return goInspectionMessage;
    }

    @NotNull
    private static ProblemHighlightType getSeverity(@NotNull GoExpression expr, boolean constantLength) {
        if (expr == null) {
            GoInvalidIndexOrSliceExpressionInspection.$$$reportNull$$$0(13);
        }
        ProblemHighlightType problemHighlightType = constantLength && expr.isConstant() ? ProblemHighlightType.GENERIC_ERROR_OR_WARNING : ProblemHighlightType.WEAK_WARNING;
        if (problemHighlightType == null) {
            GoInvalidIndexOrSliceExpressionInspection.$$$reportNull$$$0(14);
        }
        return problemHighlightType;
    }

    private static int getLength(@Nullable GoType type2, @NotNull GoExpression expr, @NotNull PsiElement context) {
        if (expr == null) {
            GoInvalidIndexOrSliceExpressionInspection.$$$reportNull$$$0(15);
        }
        if (context == null) {
            GoInvalidIndexOrSliceExpressionInspection.$$$reportNull$$$0(16);
        }
        if (type2 instanceof GoArrayOrSliceType) {
            return ((GoArrayOrSliceType)type2).getLength();
        }
        if (GoTypeUtil.isString(type2, context)) {
            Value value = expr.getValue();
            String stringValue = value != null ? value.getString() : null;
            return stringValue != null ? stringValue.getBytes(StandardCharsets.UTF_8).length : -1;
        }
        return -1;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 12, 14 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "o";
                break;
            }
            case 3: 
            case 5: 
            case 6: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "operand";
                break;
            }
            case 7: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "iterableTypeText";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "indices";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "index";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "details";
                break;
            }
            case 12: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/goide/highlighting/legacyErrorInspections/GoInvalidIndexOrSliceExpressionInspection";
                break;
            }
            case 13: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expr";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/goide/highlighting/legacyErrorInspections/GoInvalidIndexOrSliceExpressionInspection";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "invalidIndexMessage";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "getSeverity";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "visitIndexOrSliceExpr";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "doCheck";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "isValidSliceExpressionOperand";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "checkIndex";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "isCorrectOrder";
                break;
            }
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "invalidIndexMessage";
                break;
            }
            case 12: 
            case 14: {
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "getSeverity";
                break;
            }
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "getLength";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 12, 14 -> new IllegalStateException(string);
        };
    }
}

