/*
 * Decompiled with CFR 0.152.
 */
package com.goide.highlighting.legacyErrorInspections;

import com.goide.inspections.core.GoInspectionProblemUtil;
import com.goide.inspections.core.GoProblemsHolder;
import com.goide.psi.GoExpression;
import com.goide.psi.GoInterfaceType;
import com.goide.psi.GoType;
import com.goide.psi.GoTypeAssertionExpr;
import com.goide.psi.GoTypeCaseClause;
import com.goide.psi.GoTypeSwitchStatement;
import com.goide.psi.GoVisitor;
import com.goide.psi.impl.GoExpressionUtil;
import com.goide.psi.impl.GoReferenceBase;
import com.goide.psi.impl.GoTypeUtil;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.psi.PsiElement;
import com.intellij.util.ObjectUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GoImpossibleTypeAssertionInspection
extends GoVisitor {
    @NotNull
    private final GoProblemsHolder myHolder;

    public GoImpossibleTypeAssertionInspection(@NotNull GoProblemsHolder holder) {
        if (holder == null) {
            GoImpossibleTypeAssertionInspection.$$$reportNull$$$0(0);
        }
        this.myHolder = holder;
    }

    @Override
    public void visitTypeAssertionExpr(@NotNull GoTypeAssertionExpr o) {
        PsiElement context;
        if (o == null) {
            GoImpossibleTypeAssertionInspection.$$$reportNull$$$0(1);
        }
        if (o.getType_() != null) {
            return;
        }
        GoExpression expression = o.getExpression();
        GoType expressionType = expression.getGoType(null);
        GoType underlyingType = (GoType)ObjectUtils.doIfNotNull((Object)expressionType, arg_0 -> GoImpossibleTypeAssertionInspection.lambda$visitTypeAssertionExpr$0(context = GoReferenceBase.getSubstitutionContextOrSelf(expression), arg_0));
        if (!(underlyingType instanceof GoInterfaceType)) {
            return;
        }
        GoType type2 = o.getType();
        if (type2 == null) {
            return;
        }
        if (GoImpossibleTypeAssertionInspection.cannotImplement(underlyingType, type2, context)) {
            this.myHolder.registerProblem((PsiElement)type2, GoInspectionProblemUtil.message("go.inspection.problem.impossible.type.assertion", GoInspectionProblemUtil.code(type2.getPresentationText()), GoInspectionProblemUtil.code(expressionType.getPresentationText())), new LocalQuickFix[0]);
        }
    }

    @Override
    public void visitTypeSwitchStatement(@NotNull GoTypeSwitchStatement typeSwitchStatement) {
        if (typeSwitchStatement == null) {
            GoImpossibleTypeAssertionInspection.$$$reportNull$$$0(2);
        }
        super.visitTypeSwitchStatement(typeSwitchStatement);
        GoExpression goExpression = typeSwitchStatement.getTypeSwitchGuard().getExpression();
        if (!(goExpression instanceof GoTypeAssertionExpr)) {
            return;
        }
        GoTypeAssertionExpr typeAssertionExpr = (GoTypeAssertionExpr)goExpression;
        GoExpression expression = typeAssertionExpr.getExpression();
        PsiElement context = GoReferenceBase.getSubstitutionContextOrSelf(expression);
        GoType expressionType = expression.getGoType(null);
        GoType underlyingType = (GoType)ObjectUtils.doIfNotNull((Object)expressionType, it -> it.getUnderlyingType(context));
        if (!(underlyingType instanceof GoInterfaceType)) {
            return;
        }
        for (GoTypeCaseClause caseClause : typeSwitchStatement.getTypeCaseClauseList()) {
            for (GoType type2 : GoTypeUtil.getListOfTypesFromTypeList(caseClause.getType())) {
                if (GoExpressionUtil.isNil(type2.resolve(context)) || !GoImpossibleTypeAssertionInspection.cannotImplement(underlyingType, type2, context)) continue;
                this.myHolder.registerProblem((PsiElement)type2, GoInspectionProblemUtil.message("go.inspection.problem.impossible.type.switch.case", GoInspectionProblemUtil.code(type2.getPresentationText()), GoInspectionProblemUtil.code(expressionType.getPresentationText())), new LocalQuickFix[0]);
            }
        }
    }

    private static boolean cannotImplement(@NotNull GoType expressionUnderlyingType, @NotNull GoType assertedType, @Nullable PsiElement context) {
        if (expressionUnderlyingType == null) {
            GoImpossibleTypeAssertionInspection.$$$reportNull$$$0(3);
        }
        if (assertedType == null) {
            GoImpossibleTypeAssertionInspection.$$$reportNull$$$0(4);
        }
        return !(assertedType.getUnderlyingType(context) instanceof GoInterfaceType) && !GoTypeUtil.isImplementsInterface(expressionUnderlyingType, assertedType, false, context);
    }

    private static /* synthetic */ GoType lambda$visitTypeAssertionExpr$0(PsiElement context, GoType it) {
        return it.getUnderlyingType(context);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "o";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "typeSwitchStatement";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expressionUnderlyingType";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "assertedType";
                break;
            }
        }
        objectArray2[1] = "com/goide/highlighting/legacyErrorInspections/GoImpossibleTypeAssertionInspection";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "visitTypeAssertionExpr";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "visitTypeSwitchStatement";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "cannotImplement";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

