/*
 * Decompiled with CFR 0.152.
 */
package com.goide.highlighting.legacyErrorInspections;

import com.goide.inspections.GoInspectionUtil;
import com.goide.inspections.core.GoInspectionMessage;
import com.goide.inspections.core.GoInspectionProblemUtil;
import com.goide.inspections.core.GoProblemsHolder;
import com.goide.psi.GoCallExpr;
import com.goide.psi.GoExpression;
import com.goide.psi.GoIndexOrSliceExpr;
import com.goide.psi.GoReferenceExpression;
import com.goide.psi.GoSignature;
import com.goide.psi.GoSpecType;
import com.goide.psi.GoType;
import com.goide.psi.GoTypeParameter;
import com.goide.psi.GoTypeSpec;
import com.goide.psi.GoVisitor;
import com.goide.psi.impl.GoPsiUtil;
import com.goide.quickfix.GoChangeParametersQuickFix;
import com.goide.quickfix.GoChangeResultParametersInCallQuickFix;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.psi.PsiElement;
import com.intellij.util.SmartList;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class GoFunctionCallInspection
extends GoVisitor {
    @NotNull
    private final GoProblemsHolder myHolder;

    public GoFunctionCallInspection(@NotNull GoProblemsHolder holder) {
        if (holder == null) {
            GoFunctionCallInspection.$$$reportNull$$$0(0);
        }
        this.myHolder = holder;
    }

    @Override
    public void visitCallExpr(@NotNull GoCallExpr o) {
        if (o == null) {
            GoFunctionCallInspection.$$$reportNull$$$0(1);
        }
        super.visitCallExpr(o);
        if (o.getArgumentList().getRparen() == null) {
            return;
        }
        GoExpression expression = o.getExpression();
        int actualSize = o.getArgumentList().getArgumentCount();
        if (actualSize == -1) {
            return;
        }
        GoType type2 = expression.getGoType(null);
        if ((type2 instanceof GoSpecType || type2 instanceof GoTypeParameter || GoFunctionCallInspection.isConversionToInstantiatedType(expression)) && actualSize != 1) {
            GoInspectionMessage message = actualSize == 0 ? GoInspectionProblemUtil.message("go.inspection.problem.missing.argument.to.conversion", GoInspectionProblemUtil.code(expression), o.getText()) : GoInspectionProblemUtil.message("go.inspection.problem.too.many.arguments.to.conversion", GoInspectionProblemUtil.code(expression), o.getText());
            this.myHolder.registerProblem((PsiElement)o, message, new LocalQuickFix[0]);
            return;
        }
        if (GoPsiUtil.isConversionExpression(o)) {
            return;
        }
        GoSignature signature = o.resolveSignature();
        if (signature == null) {
            return;
        }
        if (GoInspectionUtil.areAllArgumentsSpecified(o, signature, false)) {
            return;
        }
        GoInspectionMessage message = actualSize > signature.getParameters().getParameterCount() ? GoInspectionProblemUtil.message("go.inspection.problem.too.many.arguments.in.call", GoInspectionProblemUtil.code(expression)) : GoInspectionProblemUtil.message("go.inspection.problem.not.enough.arguments.in.call", GoInspectionProblemUtil.code(expression));
        this.myHolder.registerProblem((PsiElement)o.getArgumentList(), message, GoFunctionCallInspection.getFixes(o));
    }

    private static boolean isConversionToInstantiatedType(@NotNull GoExpression expression) {
        GoIndexOrSliceExpr indexOrSliceExpr;
        GoExpression goExpression;
        if (expression == null) {
            GoFunctionCallInspection.$$$reportNull$$$0(2);
        }
        if (expression instanceof GoIndexOrSliceExpr && (goExpression = (indexOrSliceExpr = (GoIndexOrSliceExpr)expression).getExpression()) instanceof GoReferenceExpression) {
            GoReferenceExpression referenceExpression = (GoReferenceExpression)goExpression;
            PsiElement resolve2 = referenceExpression.resolve();
            return resolve2 instanceof GoTypeSpec;
        }
        return false;
    }

    private static LocalQuickFix @NotNull [] getFixes(@NotNull GoCallExpr call) {
        if (call == null) {
            GoFunctionCallInspection.$$$reportNull$$$0(3);
        }
        SmartList fixes = new SmartList();
        new GoChangeParametersQuickFix(call).addIfAvailable((List)fixes);
        new GoChangeResultParametersInCallQuickFix(call).addIfAvailable((List)fixes);
        LocalQuickFix[] localQuickFixArray = fixes.toArray(LocalQuickFix.EMPTY_ARRAY);
        if (localQuickFixArray == null) {
            GoFunctionCallInspection.$$$reportNull$$$0(4);
        }
        return localQuickFixArray;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 4 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "o";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expression";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "call";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/goide/highlighting/legacyErrorInspections/GoFunctionCallInspection";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/goide/highlighting/legacyErrorInspections/GoFunctionCallInspection";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getFixes";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "visitCallExpr";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "isConversionToInstantiatedType";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getFixes";
                break;
            }
            case 4: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 4 -> new IllegalStateException(string);
        };
    }
}

