/*
 * Decompiled with CFR 0.152.
 */
package com.goide.highlighting.errors;

import com.goide.highlighting.GoAnnotationHolder;
import com.goide.highlighting.errors.GoSpecCheckerBase;
import com.goide.inspections.GoInspectionUtil;
import com.goide.inspections.core.GoInspectionMessage;
import com.goide.inspections.core.GoInspectionMessageWithI18n;
import com.goide.psi.GoCallExpr;
import com.goide.psi.GoCompositeElement;
import com.goide.psi.GoExpression;
import com.goide.psi.GoIndexOrSliceExpr;
import com.goide.psi.GoNamedSignatureOwner;
import com.goide.psi.GoReferenceExpression;
import com.goide.psi.GoSignature;
import com.goide.psi.GoTypeParamDefinition;
import com.goide.psi.GoTypeParameters;
import com.goide.psi.impl.GoPsiImplUtil;
import com.goide.psi.impl.GoPsiUtil;
import com.goide.psi.impl.GoReferenceBase;
import com.goide.psi.impl.generics.GoReverseTypeInferenceContext;
import com.goide.psi.impl.generics.GoTypeInferenceKt;
import com.goide.psi.impl.generics.GoTypeInferenceResult;
import com.goide.psi.impl.generics.GoTypeInstantiationKt;
import com.intellij.psi.PsiElement;
import com.intellij.psi.ResolveState;
import java.util.List;
import java.util.NoSuchElementException;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0018\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0002J\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016J\u0010\u0010\u000f\u001a\u00020\f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J\u000e\u0010\u0012\u001a\u0004\u0018\u00010\u0013*\u00020\u0014H\u0002\u00a8\u0006\u0015"}, d2={"Lcom/goide/highlighting/errors/GoTypeInferenceSpecChecker;", "Lcom/goide/highlighting/errors/GoSpecCheckerBase;", "holder", "Lcom/goide/highlighting/GoAnnotationHolder;", "(Lcom/goide/highlighting/GoAnnotationHolder;)V", "getCannotInferErrorMessage", "Lcom/goide/inspections/core/GoInspectionMessageWithI18n;", "typeParameters", "Lcom/goide/psi/GoTypeParameters;", "inferenceResult", "Lcom/goide/psi/impl/generics/GoTypeInferenceResult;", "visitCallExpr", "", "callExpr", "Lcom/goide/psi/GoCallExpr;", "visitIndexOrSliceExpr", "indexOrSliceExpr", "Lcom/goide/psi/GoIndexOrSliceExpr;", "resolveSignature", "Lcom/goide/psi/GoSignature;", "Lcom/goide/psi/GoExpression;", "intellij.go.impl"})
@SourceDebugExtension(value={"SMAP\nGoTypeInferenceSpecChecker.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GoTypeInferenceSpecChecker.kt\ncom/goide/highlighting/errors/GoTypeInferenceSpecChecker\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 KtUtils.kt\ncom/intellij/util/KotlinUtils\n*L\n1#1,64:1\n223#2,2:65\n14#3:67\n*S KotlinDebug\n*F\n+ 1 GoTypeInferenceSpecChecker.kt\ncom/goide/highlighting/errors/GoTypeInferenceSpecChecker\n*L\n58#1:65,2\n63#1:67\n*E\n"})
public final class GoTypeInferenceSpecChecker
extends GoSpecCheckerBase {
    public GoTypeInferenceSpecChecker(@NotNull GoAnnotationHolder holder) {
        Intrinsics.checkNotNullParameter((Object)holder, (String)"holder");
        super(holder);
    }

    @Override
    public void visitCallExpr(@NotNull GoCallExpr callExpr) {
        Intrinsics.checkNotNullParameter((Object)callExpr, (String)"callExpr");
        super.visitCallExpr(callExpr);
        GoCompositeElement goCompositeElement = GoPsiUtil.getCallReference(callExpr);
        if (goCompositeElement == null || (goCompositeElement = this.resolveSignature((GoExpression)goCompositeElement)) == null) {
            return;
        }
        GoCompositeElement signature = goCompositeElement;
        GoTypeParameters goTypeParameters = signature.getTypeParameters();
        if (goTypeParameters == null) {
            return;
        }
        GoTypeParameters typeParameters = goTypeParameters;
        if (!GoInspectionUtil.areAllArgumentsSpecified(callExpr, (GoSignature)signature, true)) {
            return;
        }
        PsiElement psiElement = GoReferenceBase.getSubstitutionContextOrSelf(callExpr);
        Intrinsics.checkNotNullExpressionValue((Object)psiElement, (String)"getSubstitutionContextOrSelf(...)");
        PsiElement context = psiElement;
        ResolveState resolveState = GoPsiImplUtil.createContextOnElement(context);
        Intrinsics.checkNotNullExpressionValue((Object)resolveState, (String)"createContextOnElement(...)");
        ResolveState state = resolveState;
        GoTypeInferenceResult goTypeInferenceResult = GoTypeInstantiationKt.inferTypeArguments(callExpr, (GoSignature)signature, state);
        if (goTypeInferenceResult == null) {
            return;
        }
        GoTypeInferenceResult inferenceResult = goTypeInferenceResult;
        if (inferenceResult.getOk()) {
            return;
        }
        this.myHolder.newErrorAnnotation(callExpr, (GoInspectionMessage)this.getCannotInferErrorMessage(typeParameters, inferenceResult)).create();
    }

    @Override
    public void visitIndexOrSliceExpr(@NotNull GoIndexOrSliceExpr indexOrSliceExpr) {
        GoTypeInferenceResult inferenceResult;
        Intrinsics.checkNotNullParameter((Object)indexOrSliceExpr, (String)"indexOrSliceExpr");
        super.visitIndexOrSliceExpr(indexOrSliceExpr);
        if (indexOrSliceExpr.getParent() instanceof GoCallExpr) {
            return;
        }
        if (!GoPsiUtil.isCallOrConversionWithTypeInstantiation(indexOrSliceExpr)) {
            return;
        }
        GoCompositeElement goCompositeElement = indexOrSliceExpr.getExpression();
        if (goCompositeElement == null || (goCompositeElement = this.resolveSignature((GoExpression)goCompositeElement)) == null) {
            return;
        }
        GoCompositeElement signature = goCompositeElement;
        GoTypeParameters goTypeParameters = signature.getTypeParameters();
        if (goTypeParameters == null) {
            return;
        }
        GoTypeParameters typeParameters = goTypeParameters;
        PsiElement psiElement = GoReferenceBase.getSubstitutionContextOrSelf(indexOrSliceExpr);
        Intrinsics.checkNotNullExpressionValue((Object)psiElement, (String)"getSubstitutionContextOrSelf(...)");
        PsiElement context = psiElement;
        ResolveState resolveState = GoPsiImplUtil.createContextOnElement(context);
        Intrinsics.checkNotNullExpressionValue((Object)resolveState, (String)"createContextOnElement(...)");
        ResolveState state = resolveState;
        GoReverseTypeInferenceContext typeInferenceContext = GoTypeInferenceKt.isReverseTypeInferenceEnabled(indexOrSliceExpr) ? GoTypeInstantiationKt.getReverseTypeInferenceContext(indexOrSliceExpr) : null;
        GoTypeInferenceResult goTypeInferenceResult = inferenceResult = typeInferenceContext != null ? GoTypeInstantiationKt.inferTypeArguments((GoExpression)indexOrSliceExpr, typeInferenceContext, state) : GoTypeInstantiationKt.inferTypeArguments(indexOrSliceExpr, (GoSignature)signature, state);
        if (inferenceResult == null) {
            return;
        }
        if (inferenceResult.getOk()) {
            return;
        }
        this.myHolder.newErrorAnnotation(indexOrSliceExpr, (GoInspectionMessage)this.getCannotInferErrorMessage(typeParameters, inferenceResult)).create();
    }

    private final GoInspectionMessageWithI18n getCannotInferErrorMessage(GoTypeParameters typeParameters, GoTypeInferenceResult inferenceResult) {
        Object element$iv2;
        block1: {
            List<GoTypeParamDefinition> list = GoPsiImplUtil.getTypeParamDefinitions(typeParameters);
            Intrinsics.checkNotNullExpressionValue(list, (String)"getTypeParamDefinitions(...)");
            List<GoTypeParamDefinition> typeParamDefinitions = list;
            Iterable $this$first$iv = typeParamDefinitions;
            boolean $i$f$first = false;
            for (Object element$iv2 : $this$first$iv) {
                GoTypeParamDefinition it = (GoTypeParamDefinition)element$iv2;
                boolean bl = false;
                boolean bl2 = !inferenceResult.getSubstitution().containsKey(it);
                if (!bl2) continue;
                break block1;
            }
            throw new NoSuchElementException("Collection contains no element matching the predicate.");
        }
        GoTypeParamDefinition firstNotInferred = (GoTypeParamDefinition)element$iv2;
        Object[] objectArray = new Object[]{firstNotInferred.getName()};
        GoInspectionMessageWithI18n goInspectionMessageWithI18n = GoInspectionMessageWithI18n.message("go.error.annotator.cannot.infer.types", objectArray);
        Intrinsics.checkNotNullExpressionValue((Object)goInspectionMessageWithI18n, (String)"message(...)");
        return goInspectionMessageWithI18n;
    }

    private final GoSignature resolveSignature(GoExpression $this$resolveSignature) {
        GoExpression $this$asSafely$iv = $this$resolveSignature;
        boolean $i$f$asSafely = false;
        GoExpression goExpression = $this$asSafely$iv;
        if (!(goExpression instanceof GoReferenceExpression)) {
            goExpression = null;
        }
        GoReferenceExpression goReferenceExpression = (GoReferenceExpression)goExpression;
        PsiElement $this$asSafely$iv2 = goReferenceExpression != null ? goReferenceExpression.resolve() : null;
        boolean $i$f$asSafely2 = false;
        PsiElement psiElement = $this$asSafely$iv2;
        if (!(psiElement instanceof GoNamedSignatureOwner)) {
            psiElement = null;
        }
        GoNamedSignatureOwner goNamedSignatureOwner = (GoNamedSignatureOwner)psiElement;
        return goNamedSignatureOwner != null ? goNamedSignatureOwner.getSignature() : null;
    }
}

