/*
 * Decompiled with CFR 0.152.
 */
package com.goide.highlighting.errors;

import com.goide.highlighting.GoAnnotationHolder;
import com.goide.highlighting.errors.GoSpecCheckerBase;
import com.goide.inspections.core.GoInspectionMessage;
import com.goide.inspections.core.GoInspectionMessageWithI18n;
import com.goide.psi.GoAnonymousFieldDefinition;
import com.goide.psi.GoFieldDeclaration;
import com.goide.psi.GoInterfaceType;
import com.goide.psi.GoPointerType;
import com.goide.psi.GoStructType;
import com.goide.psi.GoType;
import com.goide.psi.GoTypeParamDefinition;
import com.goide.psi.GoTypeReferenceExpression;
import com.goide.psi.impl.GoReferenceBase;
import com.goide.psi.impl.GoTypeUtil;
import com.goide.quickfix.GoCreateWrapperTypeQuickFix;
import com.goide.quickfix.GoDeletePointerQuickFix;
import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.lang.annotation.AnnotationBuilder;
import com.intellij.psi.PsiElement;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GoStructTypeSpecChecker
extends GoSpecCheckerBase {
    public GoStructTypeSpecChecker(@NotNull GoAnnotationHolder holder) {
        if (holder == null) {
            GoStructTypeSpecChecker.$$$reportNull$$$0(0);
        }
        super(holder);
    }

    @Override
    public void visitStructType(@NotNull GoStructType structType) {
        if (structType == null) {
            GoStructTypeSpecChecker.$$$reportNull$$$0(1);
        }
        for (GoFieldDeclaration declaration : structType.getFieldDeclarationList()) {
            GoAnonymousFieldDefinition anonymous = declaration.getAnonymousFieldDefinition();
            if (anonymous == null) continue;
            PsiElement context = GoReferenceBase.getSubstitutionContextOrSelf(anonymous);
            this.checkEmbeddedType(anonymous, context);
        }
    }

    private void checkEmbeddedType(@NotNull GoAnonymousFieldDefinition anonymous, @NotNull PsiElement context) {
        GoType underlyingType;
        GoTypeReferenceExpression typeRef;
        if (anonymous == null) {
            GoStructTypeSpecChecker.$$$reportNull$$$0(2);
        }
        if (context == null) {
            GoStructTypeSpecChecker.$$$reportNull$$$0(3);
        }
        if ((typeRef = anonymous.getTypeReferenceExpression()) == null) {
            GoType rawType = anonymous.getRawType();
            String typeText = rawType.getPresentationText();
            GoInspectionMessageWithI18n message = GoInspectionMessageWithI18n.message("go.error.annotator.invalid.embedded.type", typeText);
            AnnotationBuilder annotation = this.myHolder.newErrorAnnotation(anonymous, (GoInspectionMessage)message);
            if (!this.myHolder.getOriginalHolder().isBatchMode()) {
                annotation = annotation.withFix((IntentionAction)new GoCreateWrapperTypeQuickFix(rawType));
            }
            annotation.create();
            return;
        }
        PsiElement resolve2 = typeRef.resolve();
        if (resolve2 instanceof GoTypeParamDefinition) {
            GoType type2 = anonymous.getType();
            GoInspectionMessageWithI18n message = type2 instanceof GoPointerType ? GoInspectionMessageWithI18n.message("go.error.annotator.embedded.type.cannot.be.a.pointer.to.a.type.parameter") : GoInspectionMessageWithI18n.message("go.error.annotator.embedded.type.cannot.be.a.type.parameter");
            this.myHolder.newErrorAnnotation(type2, (GoInspectionMessage)message).create();
            return;
        }
        GoType type3 = GoStructTypeSpecChecker.getTypeUnwrappingAlias(anonymous, context);
        boolean isPointer = type3 instanceof GoPointerType;
        GoType unwrapped = isPointer ? ((GoPointerType)type3).getType() : type3;
        GoType goType = underlyingType = unwrapped != null ? unwrapped.getUnderlyingType(context) : null;
        if (underlyingType instanceof GoPointerType) {
            GoType problemElement = anonymous.getType();
            GoInspectionMessageWithI18n message = GoInspectionMessageWithI18n.message("go.error.annotator.embedded.type.cannot.be.a.pointer");
            GoStructTypeSpecChecker.withQuickFix(this.myHolder.newErrorAnnotation(problemElement, (GoInspectionMessage)message), new GoDeletePointerQuickFix(), problemElement, message).create();
            return;
        }
        if (isPointer && underlyingType instanceof GoInterfaceType) {
            GoType problemElement = anonymous.getType();
            GoInspectionMessageWithI18n message = GoInspectionMessageWithI18n.message("go.error.annotator.embedded.type.cannot.be.a.pointer.to.interface");
            GoStructTypeSpecChecker.withQuickFix(this.myHolder.newErrorAnnotation(problemElement, (GoInspectionMessage)message), new GoDeletePointerQuickFix(), problemElement, message).create();
        }
    }

    @Nullable
    private static GoType getTypeUnwrappingAlias(@NotNull GoAnonymousFieldDefinition anonymous, @NotNull PsiElement context) {
        GoType type2;
        if (anonymous == null) {
            GoStructTypeSpecChecker.$$$reportNull$$$0(4);
        }
        if (context == null) {
            GoStructTypeSpecChecker.$$$reportNull$$$0(5);
        }
        return (type2 = anonymous.getType()) instanceof GoPointerType ? type2 : GoTypeUtil.unwrapAliasIfNamed(type2, context);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "structType";
                break;
            }
            case 2: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "anonymous";
                break;
            }
            case 3: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
        }
        objectArray2[1] = "com/goide/highlighting/errors/GoStructTypeSpecChecker";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "visitStructType";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "checkEmbeddedType";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "getTypeUnwrappingAlias";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

