/*
 * Decompiled with CFR 0.152.
 */
package com.goide.highlighting.errors;

import com.goide.highlighting.GoStringLiteralLexer;
import com.goide.highlighting.errors.GoStringLiteralToken;
import com.goide.inspections.GoDecodedStringLiteralRangeConverter;
import com.goide.psi.GoStringLiteral;
import com.intellij.lang.injection.InjectedLanguageManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.tree.IElementType;
import java.util.Iterator;
import java.util.NoSuchElementException;
import org.jetbrains.annotations.NotNull;

public class GoStringLiteralLexerAdapter
extends GoStringLiteralLexer
implements Iterable<GoStringLiteralToken> {
    @NotNull
    private final GoStringLiteral myLiteral;
    private final boolean myNeedRangeConversion;
    @NotNull
    private final GoDecodedStringLiteralRangeConverter myConverter;

    public GoStringLiteralLexerAdapter(@NotNull GoStringLiteral literal) {
        String unescapedInjectedText;
        if (literal == null) {
            GoStringLiteralLexerAdapter.$$$reportNull$$$0(0);
        }
        if (literal.getRawString() != null) {
            throw new IllegalArgumentException("GoStringLiteralLexer doesn't support raw string literals");
        }
        this.myLiteral = literal;
        String text = literal.getText();
        InjectedLanguageManager injectionManager = InjectedLanguageManager.getInstance((Project)literal.getProject());
        String string = unescapedInjectedText = injectionManager.isInjectedFragment(literal.getContainingFile()) ? injectionManager.getUnescapedText((PsiElement)literal) : null;
        if (unescapedInjectedText != null && !unescapedInjectedText.equals(text)) {
            this.start(unescapedInjectedText);
            this.myNeedRangeConversion = true;
        } else {
            this.start(text);
            this.myNeedRangeConversion = false;
        }
        this.myConverter = new GoDecodedStringLiteralRangeConverter(literal, false);
    }

    @NotNull
    public TextRange getTokenRange() {
        if (this.myNeedRangeConversion) {
            TextRange range = this.myConverter.computeRange(this.getTokenStart(), this.getTokenEnd());
            if (range == null) {
                throw new IllegalStateException("Failed to compute escape sequence range");
            }
            TextRange textRange = range;
            if (textRange == null) {
                GoStringLiteralLexerAdapter.$$$reportNull$$$0(1);
            }
            return textRange;
        }
        TextRange textRange = super.getTokenRange();
        if (textRange == null) {
            GoStringLiteralLexerAdapter.$$$reportNull$$$0(2);
        }
        return textRange;
    }

    @Override
    @NotNull
    public Iterator<GoStringLiteralToken> iterator() {
        return new Iterator<GoStringLiteralToken>(){

            @Override
            public boolean hasNext() {
                return GoStringLiteralLexerAdapter.this.getTokenType() != null;
            }

            @Override
            public GoStringLiteralToken next() {
                IElementType type2 = GoStringLiteralLexerAdapter.this.getTokenType();
                if (type2 == null) {
                    throw new NoSuchElementException();
                }
                String text = GoStringLiteralLexerAdapter.this.getTokenText();
                TextRange range = this.getTokenRange();
                TextRange absoluteRange = range.shiftRight(GoStringLiteralLexerAdapter.this.myLiteral.getTextOffset());
                GoStringLiteralToken next = new GoStringLiteralToken(type2, text, range, absoluteRange);
                GoStringLiteralLexerAdapter.this.advance();
                return next;
            }

            @NotNull
            private TextRange getTokenRange() {
                if (GoStringLiteralLexerAdapter.this.myNeedRangeConversion) {
                    TextRange range = GoStringLiteralLexerAdapter.this.myConverter.computeRange(GoStringLiteralLexerAdapter.this.getTokenStart(), GoStringLiteralLexerAdapter.this.getTokenEnd());
                    if (range == null) {
                        throw new IllegalStateException("Failed to compute escape sequence range");
                    }
                    TextRange textRange = range;
                    if (textRange == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    return textRange;
                }
                TextRange textRange = GoStringLiteralLexerAdapter.super.getTokenRange();
                if (textRange == null) {
                    1.$$$reportNull$$$0(1);
                }
                return textRange;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/goide/highlighting/errors/GoStringLiteralLexerAdapter$1", "getTokenRange"));
            }
        };
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 2 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "literal";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/goide/highlighting/errors/GoStringLiteralLexerAdapter";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/goide/highlighting/errors/GoStringLiteralLexerAdapter";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getTokenRange";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 2 -> new IllegalStateException(string);
        };
    }
}

