/*
 * Decompiled with CFR 0.152.
 */
package com.goide.highlighting.errors;

import com.goide.highlighting.GoAnnotationHolder;
import com.goide.highlighting.errors.GoSpecCheckerBase;
import com.goide.highlighting.errors.GoSpecCheckerUtil;
import com.goide.inspections.GoInspectionUtil;
import com.goide.inspections.core.GoInspectionMessage;
import com.goide.inspections.core.GoInspectionMessageWithI18n;
import com.goide.psi.GoConstDefinition;
import com.goide.psi.GoExpression;
import com.goide.psi.GoShortVarDeclaration;
import com.goide.psi.GoVarDefinition;
import com.goide.psi.GoVarSpec;
import com.goide.psi.impl.GoPsiImplUtil;
import com.goide.psi.impl.GoReferenceBase;
import com.goide.quickfix.GoReplaceWithAssignmentStatementQuickFix;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.ResolveState;
import com.intellij.util.containers.ContainerUtil;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GoShortVariableDeclarationSpecChecker
extends GoSpecCheckerBase {
    public GoShortVariableDeclarationSpecChecker(@NotNull GoAnnotationHolder holder) {
        if (holder == null) {
            GoShortVariableDeclarationSpecChecker.$$$reportNull$$$0(0);
        }
        super(holder);
    }

    @Override
    public void visitShortVarDeclaration(@NotNull GoShortVarDeclaration shortVarDeclaration) {
        if (shortVarDeclaration == null) {
            GoShortVariableDeclarationSpecChecker.$$$reportNull$$$0(1);
        }
        PsiElement context = GoReferenceBase.getSubstitutionContextOrSelf(shortVarDeclaration);
        ResolveState state = GoPsiImplUtil.createContextOnElement(context);
        GoShortVariableDeclarationSpecChecker.checkVarSpec(shortVarDeclaration, shortVarDeclaration.getDefinitionList(), shortVarDeclaration.getExpressionList(), this.myHolder, state);
        this.checkReassignmentOfConstant(shortVarDeclaration);
    }

    public static void checkVarSpec(@NotNull GoVarSpec varSpec, @NotNull List<GoVarDefinition> left, @NotNull List<GoExpression> right, @NotNull GoAnnotationHolder holder, @Nullable ResolveState state) {
        if (varSpec == null) {
            GoShortVariableDeclarationSpecChecker.$$$reportNull$$$0(2);
        }
        if (left == null) {
            GoShortVariableDeclarationSpecChecker.$$$reportNull$$$0(3);
        }
        if (right == null) {
            GoShortVariableDeclarationSpecChecker.$$$reportNull$$$0(4);
        }
        if (holder == null) {
            GoShortVariableDeclarationSpecChecker.$$$reportNull$$$0(5);
        }
        GoSpecCheckerUtil.checkAssignmentCountMismatch(varSpec, left, right, holder, state);
        GoShortVariableDeclarationSpecChecker.checkNoNewVarsInShortVarDeclaration(varSpec, holder);
    }

    private void checkReassignmentOfConstant(@NotNull GoShortVarDeclaration shortVarDeclaration) {
        if (shortVarDeclaration == null) {
            GoShortVariableDeclarationSpecChecker.$$$reportNull$$$0(6);
        }
        shortVarDeclaration.getVarDefinitionList().forEach(varDefinition -> {
            PsiElement resolve2;
            PsiReference reference = varDefinition.getReference();
            PsiElement psiElement = resolve2 = reference != null ? reference.resolve() : null;
            if (resolve2 instanceof GoConstDefinition) {
                this.myHolder.newErrorAnnotation((PsiElement)varDefinition, (GoInspectionMessage)GoInspectionMessageWithI18n.message("go.error.annotator.cannot.reassign.a.constant")).create();
            }
        });
    }

    public static void checkNoNewVarsInShortVarDeclaration(@NotNull GoVarSpec o, @NotNull GoAnnotationHolder holder) {
        if (o == null) {
            GoShortVariableDeclarationSpecChecker.$$$reportNull$$$0(7);
        }
        if (holder == null) {
            GoShortVariableDeclarationSpecChecker.$$$reportNull$$$0(8);
        }
        List<GoVarDefinition> list = o.getVarDefinitionList();
        GoVarDefinition first = (GoVarDefinition)ContainerUtil.getFirstItem(list);
        GoVarDefinition last = (GoVarDefinition)ContainerUtil.getLastItem(list);
        if (first == null || last == null) {
            return;
        }
        if (GoInspectionUtil.hasNoNewVariables(list)) {
            TextRange range = TextRange.create((int)first.getTextOffset(), (int)(last.getTextOffset() + last.getTextLength()));
            GoInspectionMessageWithI18n message = GoInspectionMessageWithI18n.message("go.error.annotator.no.new.variables");
            GoShortVariableDeclarationSpecChecker.withQuickFix(holder.newErrorAnnotation(range, (GoInspectionMessage)message), new GoReplaceWithAssignmentStatementQuickFix(), o, range, message).create();
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 1: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "shortVarDeclaration";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "varSpec";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "left";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "right";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "o";
                break;
            }
        }
        objectArray2[1] = "com/goide/highlighting/errors/GoShortVariableDeclarationSpecChecker";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "visitShortVarDeclaration";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "checkVarSpec";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "checkReassignmentOfConstant";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[2] = "checkNoNewVarsInShortVarDeclaration";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

