/*
 * Decompiled with CFR 0.152.
 */
package com.goide.highlighting.errors;

import com.goide.highlighting.GoAnnotationHolder;
import com.goide.highlighting.errors.GoSpecCheckerBase;
import com.goide.inspections.core.GoInspectionMessage;
import com.goide.inspections.core.GoInspectionMessageWithI18n;
import com.goide.psi.GoBuiltinCallExpr;
import com.goide.psi.GoCallExpr;
import com.goide.psi.GoExpression;
import com.goide.psi.GoFunctionLit;
import com.goide.psi.GoFunctionOrMethodDeclaration;
import com.goide.psi.GoMethodSpec;
import com.goide.psi.GoReferenceExpression;
import com.goide.psi.GoUnaryExpr;
import com.goide.psi.impl.GoPsiImplUtil;
import com.goide.psi.impl.GoPsiUtil;
import com.goide.quickfix.GoAddLocalVarForExpressionQuickFix;
import com.goide.quickfix.GoFinishCallQuickFix;
import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.lang.annotation.AnnotationBuilder;
import com.intellij.psi.PsiElement;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public class GoExpressionStatementSpecChecker
extends GoSpecCheckerBase {
    private static final Set<String> NOT_PERMITTED_AS_STATEMENT_BUILTIN_FUNCTIONS = Set.of("append", "cap", "complex", "imag", "len", "real", "min", "max");
    private static final Set<String> NOT_PERMITTED_AS_STATEMENT_UNSAFE_FUNCTIONS = Set.of("Alignof", "Sizeof", "Offsetof");

    public GoExpressionStatementSpecChecker(@NotNull GoAnnotationHolder holder) {
        if (holder == null) {
            GoExpressionStatementSpecChecker.$$$reportNull$$$0(0);
        }
        super(holder);
    }

    @Override
    public void visitExpression(@NotNull GoExpression statement) {
        GoExpression expression;
        PsiElement resolve2;
        if (statement == null) {
            GoExpressionStatementSpecChecker.$$$reportNull$$$0(1);
        }
        PsiElement psiElement = resolve2 = (expression = statement.unwrapParentheses()) instanceof GoReferenceExpression ? ((GoReferenceExpression)expression).resolve() : null;
        if ((expression instanceof GoCallExpr || expression instanceof GoBuiltinCallExpr) && !GoPsiUtil.isConversionExpression(expression) && GoExpressionStatementSpecChecker.isPermittedAsStatement(expression) || expression instanceof GoReferenceExpression && resolve2 == null || expression instanceof GoUnaryExpr && ((GoUnaryExpr)expression).getArrow() != null) {
            return;
        }
        GoInspectionMessageWithI18n message = GoInspectionMessageWithI18n.message("go.error.annotator.evaluated.but.not.used", statement instanceof GoFunctionLit ? "func literal" : statement.getText());
        AnnotationBuilder annotation = this.myHolder.newErrorAnnotation(statement, (GoInspectionMessage)message);
        if (resolve2 instanceof GoFunctionOrMethodDeclaration || resolve2 instanceof GoMethodSpec || expression instanceof GoFunctionLit) {
            annotation = annotation.withFix((IntentionAction)new GoAddLocalVarForExpressionQuickFix(statement));
            annotation = annotation.withFix((IntentionAction)new GoFinishCallQuickFix(statement));
        } else if (!(expression instanceof GoCallExpr)) {
            annotation = annotation.withFix((IntentionAction)new GoAddLocalVarForExpressionQuickFix(statement));
        }
        annotation.create();
    }

    public static boolean isPermittedAsStatement(@NotNull GoExpression call) {
        if (call == null) {
            GoExpressionStatementSpecChecker.$$$reportNull$$$0(2);
        }
        assert (call instanceof GoCallExpr || call instanceof GoBuiltinCallExpr);
        if (call instanceof GoBuiltinCallExpr) {
            return !((GoBuiltinCallExpr)call).isTrulyBuiltin();
        }
        GoExpression expression = ((GoCallExpr)call).getExpression().unwrapParentheses();
        if (!(expression instanceof GoReferenceExpression)) {
            return true;
        }
        GoReferenceExpression referenceExpression = (GoReferenceExpression)expression;
        String name = referenceExpression.getIdentifier().getText();
        if (!NOT_PERMITTED_AS_STATEMENT_BUILTIN_FUNCTIONS.contains(name) && !NOT_PERMITTED_AS_STATEMENT_UNSAFE_FUNCTIONS.contains(name)) {
            return true;
        }
        PsiElement resolve2 = referenceExpression.resolve();
        return !GoPsiImplUtil.builtin(resolve2) && (resolve2 == null || !GoPsiImplUtil.isUnsafeFile(resolve2.getContainingFile()));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "statement";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "call";
                break;
            }
        }
        objectArray2[1] = "com/goide/highlighting/errors/GoExpressionStatementSpecChecker";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "visitExpression";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "isPermittedAsStatement";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

