/*
 * Decompiled with CFR 0.152.
 */
package com.goide.highlighting.errors;

import com.goide.directiveComment.GoDirectiveComment;
import com.goide.directiveComment.GoDirectiveCommentArgument;
import com.goide.directiveComment.GoEmbedComment;
import com.goide.documentation.GoDocumentationProvider;
import com.goide.highlighting.GoAnnotationHolder;
import com.goide.highlighting.errors.GoSpecCheckerBase;
import com.goide.i18n.GoBundle;
import com.goide.inspections.core.GoInspectionMessage;
import com.goide.inspections.core.GoInspectionMessageWithI18n;
import com.goide.psi.GoFile;
import com.goide.psi.GoImportSpec;
import com.goide.psi.GoType;
import com.goide.psi.GoVarDeclaration;
import com.goide.psi.GoVarDefinition;
import com.goide.psi.GoVarSpec;
import com.goide.psi.impl.GoPsiUtil;
import com.goide.psi.impl.GoTypeUtil;
import com.goide.quickfix.GoShowSdkConfigurableFix;
import com.goide.sdk.GoSdkUtil;
import com.goide.sdk.GoSdkVersion;
import com.goide.util.GoStdlibUtil;
import com.goide.vgo.mod.quickfix.VgoAddOrUpdateGoVersionFix;
import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.codeInspection.LocalQuickFixAndIntentionActionOnPsiElement;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.util.IntentionName;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileSystemItem;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.FileReference;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.MultiMap;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GoEmbedDirectiveSpecChecker
extends GoSpecCheckerBase {
    public GoEmbedDirectiveSpecChecker(@NotNull GoAnnotationHolder holder) {
        if (holder == null) {
            GoEmbedDirectiveSpecChecker.$$$reportNull$$$0(0);
        }
        super(holder);
    }

    public void visitComment(@NotNull PsiComment comment) {
        boolean isStringOrByteSlice;
        if (comment == null) {
            GoEmbedDirectiveSpecChecker.$$$reportNull$$$0(1);
        }
        super.visitComment(comment);
        GoEmbedComment embedComment = GoEmbedComment.embedCommentFrom(comment);
        if (embedComment == null) {
            GoDirectiveCommentArgument argument;
            GoDirectiveComment directiveComment = GoDirectiveComment.directiveCommentFrom(comment);
            if (directiveComment != null && "embed".equals(directiveComment.getName()) && (argument = (GoDirectiveCommentArgument)ContainerUtil.getOnlyItem(directiveComment.getArguments())) != null) {
                this.myHolder.newErrorAnnotation(argument.getRange(comment), (GoInspectionMessage)GoInspectionMessageWithI18n.message("go.error.go.embed.invalid.syntax.of.paths")).create();
            }
            return;
        }
        TextRange nameRange = embedComment.getPrefixAndNameRange(comment);
        GoSdkUtil.FeatureSupported supported = GoSdkUtil.featureSupported((PsiElement)comment, false, GoSdkVersion::supportsGoEmbedDirective);
        if (supported == GoSdkUtil.FeatureSupported.NO) {
            GoInspectionMessageWithI18n message = GoInspectionMessageWithI18n.message("go.error.go.embed.not.supported");
            GoEmbedDirectiveSpecChecker.withQuickFix(this.myHolder.newWarningAnnotation(nameRange, message), new GoShowSdkConfigurableFix(), (PsiElement)comment, nameRange, message).create();
            return;
        }
        if (supported == GoSdkUtil.FeatureSupported.NEED_VERSION_UPDATE) {
            this.myHolder.newErrorAnnotation(nameRange, (GoInspectionMessage)GoInspectionMessageWithI18n.message("go.error.go.embed.not.supported")).withFix((IntentionAction)new VgoAddOrUpdateGoVersionFix(GoSdkVersion.GO_1_16)).create();
            return;
        }
        PsiElement commentedElement = GoDocumentationProvider.findCommentedElementBelow(comment, true);
        GoVarSpec varSpec = (GoVarSpec)ObjectUtils.tryCast((Object)commentedElement, GoVarSpec.class);
        if (varSpec == null) {
            GoVarDeclaration varDeclaration = (GoVarDeclaration)ObjectUtils.tryCast((Object)commentedElement, GoVarDeclaration.class);
            GoVarSpec goVarSpec = varSpec = varDeclaration != null ? (GoVarSpec)ContainerUtil.getOnlyItem(varDeclaration.getSpecList()) : null;
        }
        if (varSpec == null || !GoPsiUtil.isTopLevelDeclaration(varSpec)) {
            this.myHolder.newErrorAnnotation(nameRange, (GoInspectionMessage)GoInspectionMessageWithI18n.message("go.error.go.embed.must.be.above.var.declaration")).create();
            return;
        }
        GoVarDefinition definition = (GoVarDefinition)ContainerUtil.getOnlyItem(varSpec.getDefinitionList());
        if (definition == null) {
            this.myHolder.newErrorAnnotation(nameRange, (GoInspectionMessage)GoInspectionMessageWithI18n.message("go.error.go.embed.must.be.above.var.declaration")).create();
            return;
        }
        GoType varType = definition.getGoType(null);
        if (varType == null || GoTypeUtil.isNamedUnresolved(varType, (PsiElement)comment)) {
            return;
        }
        boolean bl = isStringOrByteSlice = GoTypeUtil.isString(varType, (PsiElement)comment) || GoTypeUtil.isByteSlice(varType.getUnderlyingType((PsiElement)comment), (PsiElement)comment);
        if (!isStringOrByteSlice && !GoStdlibUtil.isStdLibType(GoTypeUtil.unwrapAlias(varType, (PsiElement)comment), (PsiElement)comment, "embed", "FS", false)) {
            this.myHolder.newErrorAnnotation(nameRange, (GoInspectionMessage)GoInspectionMessageWithI18n.message("go.error.go.embed.var.has.wrong.type")).create();
            return;
        }
        List<GoDirectiveCommentArgument> arguments = embedComment.getArguments();
        if (arguments.isEmpty()) {
            TextRange nameOnlyRange = embedComment.getNameRange(comment);
            TextRange fromNameToCommentEndRange = TextRange.create((int)nameOnlyRange.getStartOffset(), (int)comment.getTextRange().getEndOffset());
            this.myHolder.newErrorAnnotation(fromNameToCommentEndRange, (GoInspectionMessage)GoInspectionMessageWithI18n.message("go.error.go.embed.no.path.arguments")).afterEndOfLine().create();
            return;
        }
        if (isStringOrByteSlice && arguments.size() > 1) {
            this.myHolder.newErrorAnnotation(nameRange, (GoInspectionMessage)GoInspectionMessageWithI18n.message("go.error.go.embed.single.path.expected")).create();
            return;
        }
        arguments.forEach(a -> this.checkPath((GoDirectiveCommentArgument)a, comment, isStringOrByteSlice));
        if (isStringOrByteSlice && !GoEmbedDirectiveSpecChecker.importsEmbedPackage((GoFile)comment.getContainingFile())) {
            this.myHolder.newErrorAnnotation(nameRange, (GoInspectionMessage)GoInspectionMessageWithI18n.message("go.error.go.embed.file.must.import.embed")).withFix((IntentionAction)new MyImportEmbedPackageFix(comment)).create();
        }
    }

    private void checkPath(@NotNull GoDirectiveCommentArgument argument, @NotNull PsiComment comment, boolean isStringOrByteSlice) {
        if (argument == null) {
            GoEmbedDirectiveSpecChecker.$$$reportNull$$$0(2);
        }
        if (comment == null) {
            GoEmbedDirectiveSpecChecker.$$$reportNull$$$0(3);
        }
        if (GoEmbedComment.hasAllPrefix(argument) && GoSdkUtil.featureSupported((PsiElement)comment, false, GoSdkVersion::supportsGoEmbedAllPatternPrefix) == GoSdkUtil.FeatureSupported.NO) {
            TextRange range = argument.getRange(comment);
            GoInspectionMessageWithI18n message = GoInspectionMessageWithI18n.message("go.error.go.embed.all.prefix.not.supported");
            GoEmbedDirectiveSpecChecker.withQuickFix(this.myHolder.newErrorAnnotation(range, (GoInspectionMessage)message), new GoShowSdkConfigurableFix(), (PsiElement)comment, range, message).create();
            return;
        }
        if (GoEmbedComment.hasWildcards(argument)) {
            return;
        }
        if (GoEmbedComment.dropAllPrefix(GoEmbedComment.unquote(argument)).getText().isEmpty()) {
            this.myHolder.newErrorAnnotation(argument.getRange(comment), (GoInspectionMessage)GoInspectionMessageWithI18n.message("go.error.go.embed.invalid.path.pattern")).create();
            return;
        }
        if (GoEmbedDirectiveSpecChecker.hasInvalidParts(argument)) {
            this.myHolder.newErrorAnnotation(argument.getRange(comment), (GoInspectionMessage)GoInspectionMessageWithI18n.message("go.error.go.embed.invalid.path.elements")).create();
            return;
        }
        List references = ContainerUtil.filter(GoEmbedComment.getReferences(comment, argument), r -> !r.getText().isEmpty());
        if (references.isEmpty()) {
            return;
        }
        List unresolved = ContainerUtil.filter((Collection)references, reference -> reference.resolve() == null);
        if (!unresolved.isEmpty()) {
            for (FileReference reference2 : unresolved) {
                this.myHolder.newErrorAnnotation(reference2.getAbsoluteRange(), (GoInspectionMessage)GoInspectionMessageWithI18n.message("go.error.go.embed.unresolved.path")).highlightType(ProblemHighlightType.ERROR).create();
            }
            return;
        }
        FileReference reference3 = (FileReference)ContainerUtil.getLastItem((List)references);
        if (reference3 != null) {
            PsiFileSystemItem resolve2 = reference3.resolve();
            if (resolve2 instanceof PsiDirectory && resolve2.getChildren().length == 0) {
                this.myHolder.newErrorAnnotation(reference3.getAbsoluteRange(), (GoInspectionMessage)GoInspectionMessageWithI18n.message("go.error.go.embed.empty.directory")).create();
                return;
            }
            if (isStringOrByteSlice && !(resolve2 instanceof PsiFile)) {
                this.myHolder.newErrorAnnotation(reference3.getAbsoluteRange(), (GoInspectionMessage)GoInspectionMessageWithI18n.message("go.error.go.embed.path.must.resolve.to.file")).create();
            }
        }
    }

    private static boolean hasInvalidParts(@NotNull GoDirectiveCommentArgument argument) {
        if (argument == null) {
            GoEmbedDirectiveSpecChecker.$$$reportNull$$$0(4);
        }
        return StringUtil.startsWithChar((CharSequence)argument.getText(), (char)'/') || argument.getText().equals(".") || argument.getText().equals("..") || argument.getText().startsWith("./") || argument.getText().startsWith("../") || argument.getText().contains("/./") || argument.getText().contains("/../") || argument.getText().endsWith("/.") || argument.getText().endsWith("/..");
    }

    private static boolean importsEmbedPackage(@NotNull GoFile file) {
        MultiMap<String, GoImportSpec> importMap;
        if (file == null) {
            GoEmbedDirectiveSpecChecker.$$$reportNull$$$0(5);
        }
        return (importMap = file.getImportMap()).containsKey((Object)"embed") || ContainerUtil.exists((Iterable)importMap.get((Object)"_"), i -> "embed".equals(i.getPath())) || ContainerUtil.exists((Iterable)importMap.get((Object)"."), i -> "embed".equals(i.getPath()));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "comment";
                break;
            }
            case 2: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "argument";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
        }
        objectArray2[1] = "com/goide/highlighting/errors/GoEmbedDirectiveSpecChecker";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "visitComment";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "checkPath";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "hasInvalidParts";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "importsEmbedPackage";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    static class MyImportEmbedPackageFix
    extends LocalQuickFixAndIntentionActionOnPsiElement {
        private MyImportEmbedPackageFix(@NotNull PsiComment comment) {
            if (comment == null) {
                MyImportEmbedPackageFix.$$$reportNull$$$0(0);
            }
            super((PsiElement)comment);
        }

        public void invoke(@NotNull Project project, @NotNull PsiFile psiFile, @Nullable Editor editor, @NotNull PsiElement startElement, @NotNull PsiElement endElement) {
            GoFile file;
            if (project == null) {
                MyImportEmbedPackageFix.$$$reportNull$$$0(1);
            }
            if (psiFile == null) {
                MyImportEmbedPackageFix.$$$reportNull$$$0(2);
            }
            if (startElement == null) {
                MyImportEmbedPackageFix.$$$reportNull$$$0(3);
            }
            if (endElement == null) {
                MyImportEmbedPackageFix.$$$reportNull$$$0(4);
            }
            if (!GoEmbedDirectiveSpecChecker.importsEmbedPackage(file = (GoFile)psiFile)) {
                file.addImport("embed", "_");
            }
        }

        @NotNull
        public String getText() {
            return MyImportEmbedPackageFix.name();
        }

        @NotNull
        public String getFamilyName() {
            return MyImportEmbedPackageFix.name();
        }

        @NotNull
        @IntentionName
        static String name() {
            String string = GoBundle.message((String)"go.fix.import.embed.package", (Object[])new Object[0]);
            if (string == null) {
                MyImportEmbedPackageFix.$$$reportNull$$$0(5);
            }
            return string;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 5 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "comment";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "psiFile";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "startElement";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "endElement";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/goide/highlighting/errors/GoEmbedDirectiveSpecChecker$MyImportEmbedPackageFix";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/goide/highlighting/errors/GoEmbedDirectiveSpecChecker$MyImportEmbedPackageFix";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "name";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "invoke";
                    break;
                }
                case 5: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 5 -> new IllegalStateException(string);
            };
        }
    }
}

