/*
 * Decompiled with CFR 0.152.
 */
package com.goide.highlighting.errors;

import com.goide.highlighting.GoAnnotationHolder;
import com.goide.highlighting.errors.GoSpecCheckerBase;
import com.goide.inspections.core.GoInspectionMessage;
import com.goide.inspections.core.GoInspectionMessageWithI18n;
import com.goide.psi.GoExpression;
import com.goide.psi.GoIndexOrSliceExpr;
import com.goide.psi.GoReferenceExpression;
import com.goide.psi.GoType;
import com.goide.psi.GoTypeParamDefinition;
import com.goide.psi.GoTypeSpec;
import com.goide.psi.GoUnaryExpr;
import com.goide.psi.impl.GoCType;
import com.goide.psi.impl.GoExpressionUtil;
import com.goide.psi.impl.GoPsiImplUtil;
import com.goide.psi.impl.GoPsiUtil;
import com.goide.psi.impl.GoReferenceBase;
import com.goide.psi.impl.GoTypeUtil;
import com.intellij.psi.PsiElement;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GoAddressOperatorsSpecChecker
extends GoSpecCheckerBase {
    public GoAddressOperatorsSpecChecker(@NotNull GoAnnotationHolder holder) {
        if (holder == null) {
            GoAddressOperatorsSpecChecker.$$$reportNull$$$0(0);
        }
        super(holder);
    }

    @Override
    public void visitUnaryExpr(@NotNull GoUnaryExpr unaryExpr) {
        if (unaryExpr == null) {
            GoAddressOperatorsSpecChecker.$$$reportNull$$$0(1);
        }
        PsiElement context = GoReferenceBase.getSubstitutionContextOrSelf(unaryExpr);
        if (unaryExpr.getBitAnd() != null) {
            GoExpression operand = GoPsiImplUtil.unwrapParentheses(unaryExpr.getExpression());
            if (operand != null && !GoExpressionUtil.canTakeAddressOf(operand, context)) {
                String operandText = operand.getText();
                if (!operandText.isEmpty()) {
                    this.myHolder.newErrorAnnotation(unaryExpr, (GoInspectionMessage)GoInspectionMessageWithI18n.message("go.inspection.problem.cannot.take.address", GoAddressOperatorsSpecChecker.code(operandText))).create();
                } else {
                    this.myHolder.newErrorAnnotation(unaryExpr, (GoInspectionMessage)GoInspectionMessageWithI18n.message("go.inspection.problem.cannot.take.address.of.non.addressable.operand")).create();
                }
            }
        } else if (unaryExpr.getMul() != null) {
            GoType underlyingType;
            GoExpression expr = unaryExpr.getExpression();
            GoType type2 = expr != null ? expr.getGoType(null) : null;
            GoType goType = underlyingType = type2 != null ? type2.getUnderlyingType(context) : null;
            if (underlyingType == null || underlyingType instanceof GoCType) {
                return;
            }
            if (!GoTypeUtil.isPointer(underlyingType, context)) {
                GoExpression unwrapped = GoPsiImplUtil.unwrapMulOrPar(expr);
                if (GoAddressOperatorsSpecChecker.isTypeReferenceParsedAsExpression(unwrapped) || unwrapped instanceof GoIndexOrSliceExpr && GoPsiUtil.resolveInstantiatedDeclaration((GoIndexOrSliceExpr)unwrapped) instanceof GoTypeSpec) {
                    return;
                }
                this.myHolder.newErrorAnnotation(unaryExpr, (GoInspectionMessage)GoInspectionMessageWithI18n.message("go.inspection.problem.invalid.indirect", GoAddressOperatorsSpecChecker.code(expr), GoAddressOperatorsSpecChecker.code(type2.getPresentationText()))).create();
            }
        }
    }

    private static boolean isTypeReferenceParsedAsExpression(@Nullable GoExpression ref) {
        if (ref instanceof GoReferenceExpression) {
            PsiElement resolve2 = ((GoReferenceExpression)ref).resolve();
            return resolve2 instanceof GoTypeSpec || resolve2 instanceof GoTypeParamDefinition;
        }
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "unaryExpr";
                break;
            }
        }
        objectArray2[1] = "com/goide/highlighting/errors/GoAddressOperatorsSpecChecker";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "visitUnaryExpr";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

