/*
 * Decompiled with CFR 0.152.
 */
package com.goide.highlighting;

import com.goide.GoTypes;
import com.goide.highlighting.GoSyntaxHighlightingColors;
import com.goide.psi.GoBlock;
import com.goide.psi.GoBuiltinCallExpr;
import com.goide.psi.GoCallExpr;
import com.goide.psi.GoConstDefinition;
import com.goide.psi.GoFile;
import com.goide.psi.GoFunctionLit;
import com.goide.psi.GoFunctionOrMethodDeclaration;
import com.goide.psi.GoNamedElement;
import com.goide.psi.GoParamDefinition;
import com.goide.psi.GoReceiver;
import com.goide.psi.GoReferenceExpression;
import com.goide.psi.GoResolvable;
import com.goide.psi.GoVarDefinition;
import com.goide.psi.impl.GoExpressionUtil;
import com.goide.psi.impl.GoPsiUtil;
import com.intellij.codeInsight.daemon.RainbowVisitor;
import com.intellij.codeInsight.daemon.impl.HighlightInfo;
import com.intellij.codeInsight.daemon.impl.HighlightVisitor;
import com.intellij.openapi.editor.colors.TextAttributesKey;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.impl.source.tree.LeafPsiElement;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.ObjectUtils;
import it.unimi.dsi.fastutil.ints.Int2IntMap;
import it.unimi.dsi.fastutil.ints.Int2IntOpenHashMap;
import java.util.HashMap;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

final class GoRainbowVisitor
extends RainbowVisitor {
    GoRainbowVisitor() {
    }

    public boolean suitableForFile(@NotNull PsiFile file) {
        if (file == null) {
            GoRainbowVisitor.$$$reportNull$$$0(0);
        }
        return file instanceof GoFile;
    }

    public void visit(@NotNull PsiElement o) {
        PsiElement context;
        if (o == null) {
            GoRainbowVisitor.$$$reportNull$$$0(1);
        }
        if ((o instanceof GoVarDefinition || o instanceof GoParamDefinition || o instanceof GoReceiver || GoRainbowVisitor.isStandaloneReference(o)) && (context = PsiTreeUtil.getParentOfType((PsiElement)o, (Class[])new Class[]{GoFunctionOrMethodDeclaration.class, GoFunctionLit.class})) != null) {
            PsiElement resolved = o instanceof GoResolvable ? (PsiElement)ObjectUtils.notNull((Object)((GoResolvable)o).resolve(), (Object)o) : o;
            PsiElement rainbow = o instanceof GoNamedElement ? ((GoNamedElement)o).getNameIdentifier() : o;
            this.addInfo(this.getRainbowSymbolKey(context, rainbow, resolved));
        }
    }

    private static boolean isStandaloneReference(@NotNull PsiElement o) {
        PsiElement prev;
        if (o == null) {
            GoRainbowVisitor.$$$reportNull$$$0(2);
        }
        if (!(o instanceof GoReferenceExpression)) {
            return false;
        }
        if (((GoReferenceExpression)o).getQualifier() != null) {
            return false;
        }
        PsiElement parent = GoPsiUtil.skipParens(o);
        if (parent instanceof GoBuiltinCallExpr) {
            return false;
        }
        if (parent instanceof GoReferenceExpression && (prev = PsiTreeUtil.prevLeaf((PsiElement)parent, (boolean)true)) instanceof LeafPsiElement && ((LeafPsiElement)prev).getElementType() == GoTypes.DOT) {
            return false;
        }
        PsiElement resolve2 = ((GoReferenceExpression)o).resolve();
        if (resolve2 instanceof GoConstDefinition) {
            return false;
        }
        if (GoExpressionUtil.isNil(o)) {
            return false;
        }
        if (GoExpressionUtil.isBooleanLiteral(o)) {
            return false;
        }
        if (resolve2 instanceof GoVarDefinition) {
            return !(PsiTreeUtil.getParentOfType((PsiElement)resolve2, (Class[])new Class[]{GoBlock.class, GoFile.class}) instanceof GoFile);
        }
        if (resolve2 instanceof GoParamDefinition) {
            return true;
        }
        return !(parent instanceof GoCallExpr);
    }

    private HighlightInfo getRainbowSymbolKey(@NotNull PsiElement context, PsiElement rainbow, PsiElement resolved) {
        String name;
        if (context == null) {
            GoRainbowVisitor.$$$reportNull$$$0(3);
        }
        if (rainbow == null || resolved == null) {
            return null;
        }
        if (resolved instanceof GoNamedElement && (name = ((GoNamedElement)resolved).getName()) != null) {
            int varIndex = GoRainbowVisitor.getIndex(name, context, resolved);
            return this.getInfo(context, rainbow, name + (String)(varIndex >= 0 ? "_" + varIndex : ""), GoRainbowVisitor.getKey(resolved));
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static int getIndex(@NotNull String name, @NotNull PsiElement context, @NotNull PsiElement definition) {
        if (name == null) {
            GoRainbowVisitor.$$$reportNull$$$0(4);
        }
        if (context == null) {
            GoRainbowVisitor.$$$reportNull$$$0(5);
        }
        if (definition == null) {
            GoRainbowVisitor.$$$reportNull$$$0(6);
        }
        if (!(definition instanceof GoVarDefinition)) {
            return -1;
        }
        PsiElement psiElement = context;
        synchronized (psiElement) {
            Map indices = (Map)CachedValuesManager.getCachedValue((PsiElement)context, () -> CachedValueProvider.Result.create(new HashMap(), (Object[])new Object[]{context}));
            Int2IntMap map = (Int2IntMap)indices.computeIfAbsent(name, s -> new Int2IntOpenHashMap());
            int startOffset = definition.getTextRange().getStartOffset();
            if (map.containsKey(startOffset)) {
                return map.get(startOffset);
            }
            int newValue = map.size();
            map.put(startOffset, newValue);
            return newValue;
        }
    }

    private static TextAttributesKey getKey(PsiElement resolved) {
        if (resolved instanceof GoParamDefinition) {
            return GoSyntaxHighlightingColors.FUNCTION_PARAMETER;
        }
        if (resolved instanceof GoReceiver) {
            return GoSyntaxHighlightingColors.METHOD_RECEIVER;
        }
        return GoSyntaxHighlightingColors.LOCAL_VARIABLE;
    }

    @NotNull
    public HighlightVisitor clone() {
        return new GoRainbowVisitor();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "o";
                break;
            }
            case 3: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "definition";
                break;
            }
        }
        objectArray2[1] = "com/goide/highlighting/GoRainbowVisitor";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "suitableForFile";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "visit";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "isStandaloneReference";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "getRainbowSymbolKey";
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "getIndex";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

