/*
 * Decompiled with CFR 0.152.
 */
package com.goide.highlighting;

import com.goide.GoParserDefinition;
import com.goide.GoTypes;
import com.goide.highlighting.GoAnnotationHolder;
import com.goide.highlighting.GoAnnotationHolderAdapter;
import com.goide.highlighting.GoAnnotationHolderBase;
import com.goide.highlighting.GoErrorAnnotatorSuppressor;
import com.goide.highlighting.errors.GoAddressOperatorsSpecChecker;
import com.goide.highlighting.errors.GoAssignmentStatementSpecChecker;
import com.goide.highlighting.errors.GoBuildDirectiveSpecChecker;
import com.goide.highlighting.errors.GoCallExpressionSpecChecker;
import com.goide.highlighting.errors.GoConstDeclarationSpecChecker;
import com.goide.highlighting.errors.GoConstraintTermSpecChecker;
import com.goide.highlighting.errors.GoDeferGoStatementSpecChecker;
import com.goide.highlighting.errors.GoEmbedDirectiveSpecChecker;
import com.goide.highlighting.errors.GoErrorsChecker;
import com.goide.highlighting.errors.GoExpressionStatementSpecChecker;
import com.goide.highlighting.errors.GoExpressionSwitchStatementSpecChecker;
import com.goide.highlighting.errors.GoForStatementSpecChecker;
import com.goide.highlighting.errors.GoFunctionDeclarationSpecChecker;
import com.goide.highlighting.errors.GoFunctionTypeSpecChecker;
import com.goide.highlighting.errors.GoIncDecStatementSpecChecker;
import com.goide.highlighting.errors.GoInstantiationSpecChecker;
import com.goide.highlighting.errors.GoInterfaceTypeSpecChecker;
import com.goide.highlighting.errors.GoLabelScopesSpecChecker;
import com.goide.highlighting.errors.GoNumericLiteralSpecChecker;
import com.goide.highlighting.errors.GoRuneLiteralSpecChecker;
import com.goide.highlighting.errors.GoSelectStatementSpecChecker;
import com.goide.highlighting.errors.GoShortVariableDeclarationSpecChecker;
import com.goide.highlighting.errors.GoStringLiteralSpecChecker;
import com.goide.highlighting.errors.GoStructTypeSpecChecker;
import com.goide.highlighting.errors.GoTypeDeclarationsSpecChecker;
import com.goide.highlighting.errors.GoTypeInferenceSpecChecker;
import com.goide.highlighting.errors.GoTypeParametersSpecChecker;
import com.goide.highlighting.errors.GoTypeSwitchStatementSpecChecker;
import com.goide.highlighting.errors.GoVariableDeclarationSpecChecker;
import com.goide.highlighting.legacyErrorInspections.GoAssignmentNilWithoutExplicitTypeInspection;
import com.goide.highlighting.legacyErrorInspections.GoBinaryAndUnaryExpressionTypesCompatibilityInspection;
import com.goide.highlighting.legacyErrorInspections.GoCgoInTestInspection;
import com.goide.highlighting.legacyErrorInspections.GoDuplicateCaseInspection;
import com.goide.highlighting.legacyErrorInspections.GoDuplicateInspection;
import com.goide.highlighting.legacyErrorInspections.GoExplicitDereferenceRequiredInspection;
import com.goide.highlighting.legacyErrorInspections.GoExtendedMethodExprSyntaxInspection;
import com.goide.highlighting.legacyErrorInspections.GoFunctionCallInspection;
import com.goide.highlighting.legacyErrorInspections.GoImpossibleTypeAssertionInspection;
import com.goide.highlighting.legacyErrorInspections.GoInvalidCompositeLiteralInspection;
import com.goide.highlighting.legacyErrorInspections.GoInvalidExpressionConversionInspection;
import com.goide.highlighting.legacyErrorInspections.GoInvalidIndexOrSliceExpressionInspection;
import com.goide.highlighting.legacyErrorInspections.GoInvalidPackageImportInspection;
import com.goide.highlighting.legacyErrorInspections.GoInvalidReceiverTypeInspection;
import com.goide.highlighting.legacyErrorInspections.GoInvalidTildeInspection;
import com.goide.highlighting.legacyErrorInspections.GoInvalidVarAssignInVarOrConstSpecInspection;
import com.goide.highlighting.legacyErrorInspections.GoJumpOverDeclarationInspection;
import com.goide.highlighting.legacyErrorInspections.GoMultiplePackagesInspection;
import com.goide.highlighting.legacyErrorInspections.GoNonFunctionCallInspection;
import com.goide.highlighting.legacyErrorInspections.GoRecursiveTypeInspection;
import com.goide.highlighting.legacyErrorInspections.GoSelfImportInspection;
import com.goide.highlighting.legacyErrorInspections.GoStringAndByteTypeMismatchInspection;
import com.goide.highlighting.legacyErrorInspections.GoTestSignaturesInspection;
import com.goide.highlighting.legacyErrorInspections.GoTypesCompatibilityInspection;
import com.goide.highlighting.legacyErrorInspections.GoUnderscoreUsedAsValueInspection;
import com.goide.highlighting.legacyErrorInspections.GoUnresolvedReferenceInspection;
import com.goide.highlighting.legacyErrorInspections.GoUnusedImportInspection;
import com.goide.highlighting.legacyErrorInspections.GoUnusedVariableInspection;
import com.goide.highlighting.legacyErrorInspections.GoUsedAsValueInCondition;
import com.goide.i18n.GoBundle;
import com.goide.inspections.GoInspectionUtil;
import com.goide.inspections.core.GoInspectionBase;
import com.goide.inspections.core.GoInspectionMessage;
import com.goide.inspections.core.GoInspectionMessageWithI18n;
import com.goide.inspections.core.GoProblemsHolder;
import com.goide.inspections.unresolved.GoExportQuickFix;
import com.goide.psi.GoArrayOrSliceType;
import com.goide.psi.GoAssignmentStatement;
import com.goide.psi.GoBreakStatement;
import com.goide.psi.GoBuiltinArgumentList;
import com.goide.psi.GoBuiltinCallExpr;
import com.goide.psi.GoCallExpr;
import com.goide.psi.GoCaseClause;
import com.goide.psi.GoChannelType;
import com.goide.psi.GoCodeFragment;
import com.goide.psi.GoCompositeLit;
import com.goide.psi.GoContinueStatement;
import com.goide.psi.GoDeferStatement;
import com.goide.psi.GoElement;
import com.goide.psi.GoElseStatement;
import com.goide.psi.GoExprCaseClause;
import com.goide.psi.GoExprSwitchStatement;
import com.goide.psi.GoExpression;
import com.goide.psi.GoFallthroughStatement;
import com.goide.psi.GoFieldName;
import com.goide.psi.GoFile;
import com.goide.psi.GoFunctionDeclaration;
import com.goide.psi.GoFunctionLit;
import com.goide.psi.GoFunctionOrMethodDeclaration;
import com.goide.psi.GoGoStatement;
import com.goide.psi.GoIfStatement;
import com.goide.psi.GoIndexOrSliceExpr;
import com.goide.psi.GoInterfaceType;
import com.goide.psi.GoLabeledStatement;
import com.goide.psi.GoLeftHandExprList;
import com.goide.psi.GoLiteralValue;
import com.goide.psi.GoMapType;
import com.goide.psi.GoMethodDeclaration;
import com.goide.psi.GoNamedElement;
import com.goide.psi.GoPackageClause;
import com.goide.psi.GoParType;
import com.goide.psi.GoParameters;
import com.goide.psi.GoParenthesesExpr;
import com.goide.psi.GoReceiver;
import com.goide.psi.GoReferenceExpression;
import com.goide.psi.GoReferenceExpressionBase;
import com.goide.psi.GoResult;
import com.goide.psi.GoSignature;
import com.goide.psi.GoSimpleStatement;
import com.goide.psi.GoStatement;
import com.goide.psi.GoStatementsHolder;
import com.goide.psi.GoType;
import com.goide.psi.GoTypeArguments;
import com.goide.psi.GoTypeAssertionExpr;
import com.goide.psi.GoTypeCaseClause;
import com.goide.psi.GoTypeDeclaration;
import com.goide.psi.GoTypeList;
import com.goide.psi.GoTypeParamDefinition;
import com.goide.psi.GoTypeParameters;
import com.goide.psi.GoTypeReferenceExpression;
import com.goide.psi.GoTypeSpec;
import com.goide.psi.GoTypeSwitchGuard;
import com.goide.psi.GoUnaryExpr;
import com.goide.psi.GoVarOrConstDeclaration;
import com.goide.psi.GoVarOrConstDefinition;
import com.goide.psi.GoVarOrConstSpec;
import com.goide.psi.GoVisitor;
import com.goide.psi.impl.GoCType;
import com.goide.psi.impl.GoExpressionUtil;
import com.goide.psi.impl.GoLightType;
import com.goide.psi.impl.GoPsiImplUtil;
import com.goide.psi.impl.GoPsiUtil;
import com.goide.psi.impl.GoReferenceBase;
import com.goide.psi.impl.GoTypeUtil;
import com.goide.quickfix.GoDeleteRangeQuickFix;
import com.goide.quickfix.GoEmptySignatureQuickFix;
import com.goide.quickfix.GoRenameQuickFix;
import com.goide.quickfix.GoReplaceWithReturnStatementQuickFix;
import com.goide.sdk.GoSdk;
import com.goide.sdk.GoSdkService;
import com.goide.sdk.GoSdkVersion;
import com.goide.sdk.GoTargetSdkVersionProvider;
import com.goide.util.GoUtil;
import com.goide.util.Value;
import com.goide.vgo.mod.quickfix.VgoAddOrUpdateGoVersionFix;
import com.intellij.codeInsight.daemon.impl.HighlightRangeExtension;
import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.lang.ASTNode;
import com.intellij.lang.annotation.AnnotationBuilder;
import com.intellij.lang.annotation.AnnotationHolder;
import com.intellij.lang.annotation.Annotator;
import com.intellij.lang.annotation.HighlightSeverity;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.ResolveState;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.testFramework.TestModeFlags;
import com.intellij.ultimate.PluginVerifier;
import com.intellij.usageView.UsageViewUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.Processor;
import com.intellij.util.ThreeState;
import com.intellij.util.containers.ContainerUtil;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

public final class GoAnnotator
implements Annotator,
HighlightRangeExtension {
    private static final Key<Boolean> DISABLE_BASIC_CHECKS = Key.create((String)"GoAnnotatorDisableBasicChecks");
    @TestOnly
    private static final Key<Boolean> USE_ALL_AVAILABLE_CHECKS = Key.create((String)"GoAnnotatorUseAllAvailableChecks");
    @TestOnly
    private static final Key<List<InspectionVisitorConstructor>> ENABLED_CHECKS = Key.create((String)"GoAnnotatorEnabledChecks");
    private final List<GoErrorAnnotatorSuppressor> mySuppressors;

    public GoAnnotator() {
        this(Collections.emptyList());
    }

    @ApiStatus.Experimental
    public GoAnnotator(List<GoErrorAnnotatorSuppressor> suppressors) {
        this.mySuppressors = suppressors;
        PluginVerifier.verifyUltimatePlugin();
    }

    public void annotate(@NotNull PsiElement element, @NotNull AnnotationHolder holder) {
        if (element == null) {
            GoAnnotator.$$$reportNull$$$0(0);
        }
        if (holder == null) {
            GoAnnotator.$$$reportNull$$$0(1);
        }
        if (!element.isValid()) {
            return;
        }
        GoFile file = (GoFile)((Object)ObjectUtils.tryCast((Object)element.getContainingFile().getOriginalFile(), GoFile.class));
        if (file == null || !GoInspectionBase.shouldProcessFile(file)) {
            return;
        }
        List<GoVisitor> errorCheckers = GoAnnotator.buildErrorCheckers(new GoAnnotationHolder(holder));
        List<GoVisitor> legacyVisitors = GoAnnotator.buildVisitors(new GoAnnotationHolderAdapter(holder), file);
        List visitors = ContainerUtil.concat(errorCheckers, legacyVisitors);
        List suppressors = GoErrorAnnotatorSuppressor.EP_NAME.getExtensionList();
        for (GoVisitor visitor2 : visitors) {
            if (ContainerUtil.exists((Iterable)ContainerUtil.concat((List)suppressors, this.mySuppressors), s -> s.isSuppressed(((Object)((Object)visitor2)).getClass()))) continue;
            element.accept((PsiElementVisitor)visitor2);
        }
    }

    public boolean isForceHighlightParents(@NotNull PsiFile file) {
        if (file == null) {
            GoAnnotator.$$$reportNull$$$0(2);
        }
        return file instanceof GoFile;
    }

    private static boolean isInQualifierOfRefExpression(@NotNull PsiElement element, @Nullable PsiElement refExpression) {
        if (element == null) {
            GoAnnotator.$$$reportNull$$$0(3);
        }
        return refExpression instanceof GoReferenceExpression && PsiTreeUtil.isAncestor((PsiElement)((GoReferenceExpression)refExpression).getQualifier(), (PsiElement)element, (boolean)false);
    }

    @NotNull
    private static GoInspectionMessage useOfPackageNameWithoutSelectorMessage(@NotNull PsiElement ref) {
        if (ref == null) {
            GoAnnotator.$$$reportNull$$$0(4);
        }
        GoInspectionMessageWithI18n goInspectionMessageWithI18n = GoInspectionMessageWithI18n.message("go.error.annotator.use.of.package.without.selector", StringUtil.defaultIfEmpty((String)ref.getText(), (String)"name"));
        if (goInspectionMessageWithI18n == null) {
            GoAnnotator.$$$reportNull$$$0(5);
        }
        return goInspectionMessageWithI18n;
    }

    @NotNull
    private static List<GoVisitor> buildErrorCheckers(@NotNull GoAnnotationHolder holder) {
        if (holder == null) {
            GoAnnotator.$$$reportNull$$$0(6);
        }
        if (ApplicationManager.getApplication().isUnitTestMode() && TestModeFlags.is(DISABLE_BASIC_CHECKS)) {
            List<GoVisitor> list = Collections.emptyList();
            if (list == null) {
                GoAnnotator.$$$reportNull$$$0(7);
            }
            return list;
        }
        List<GoVisitor> list = Arrays.asList(new GoVisitor[]{new BasicErrorsChecker(holder), new GoAddressOperatorsSpecChecker(holder), new GoAssignmentStatementSpecChecker(holder), new GoCallExpressionSpecChecker(holder), new GoConstDeclarationSpecChecker(holder), new GoDeferGoStatementSpecChecker(holder), new GoExpressionSwitchStatementSpecChecker(holder), new GoForStatementSpecChecker(holder), new GoFunctionDeclarationSpecChecker(holder), new GoFunctionTypeSpecChecker(holder), new GoIncDecStatementSpecChecker(holder), new GoInterfaceTypeSpecChecker(holder), new GoLabelScopesSpecChecker(holder), new GoNumericLiteralSpecChecker(holder), new GoRuneLiteralSpecChecker(holder), new GoSelectStatementSpecChecker(holder), new GoShortVariableDeclarationSpecChecker(holder), new GoStringLiteralSpecChecker(holder), new GoStructTypeSpecChecker(holder), new GoTypeSwitchStatementSpecChecker(holder), new GoVariableDeclarationSpecChecker(holder), new GoEmbedDirectiveSpecChecker(holder), new GoBuildDirectiveSpecChecker(holder), new GoTypeParametersSpecChecker(holder), new GoConstraintTermSpecChecker(holder), new GoInstantiationSpecChecker(holder), new GoTypeDeclarationsSpecChecker(holder), new GoTypeInferenceSpecChecker(holder)});
        if (list == null) {
            GoAnnotator.$$$reportNull$$$0(8);
        }
        return list;
    }

    @NotNull
    private static List<GoVisitor> buildVisitors(@NotNull GoProblemsHolder holder, @NotNull GoFile file) {
        if (holder == null) {
            GoAnnotator.$$$reportNull$$$0(9);
        }
        if (file == null) {
            GoAnnotator.$$$reportNull$$$0(10);
        }
        if (ApplicationManager.getApplication().isUnitTestMode() && !TestModeFlags.is(USE_ALL_AVAILABLE_CHECKS)) {
            List<GoVisitor> testVisitors;
            List<GoVisitor> list = testVisitors = GoAnnotator.buildTestVisitors(holder);
            if (list == null) {
                GoAnnotator.$$$reportNull$$$0(11);
            }
            return list;
        }
        List visitors = GoAnnotator.buildCommonVisitors(holder);
        if (!(file instanceof GoCodeFragment)) {
            visitors = ContainerUtil.concat(visitors, GoAnnotator.buildNonCodeFragmentVisitors(holder));
        }
        List list = visitors;
        if (list == null) {
            GoAnnotator.$$$reportNull$$$0(12);
        }
        return list;
    }

    @NotNull
    private static List<GoVisitor> buildCommonVisitors(@NotNull GoProblemsHolder holder) {
        if (holder == null) {
            GoAnnotator.$$$reportNull$$$0(13);
        }
        List<GoVisitor> list = Arrays.asList(new GoVisitor[]{new GoUsedAsValueInCondition(holder), new GoAssignmentNilWithoutExplicitTypeInspection(holder), new GoFunctionCallInspection(holder), new GoMultiplePackagesInspection(holder), new GoCgoInTestInspection(holder), new GoTestSignaturesInspection(holder), new GoSelfImportInspection(holder), new GoUnderscoreUsedAsValueInspection(holder), new GoRecursiveTypeInspection(holder), new GoStringAndByteTypeMismatchInspection(holder), new GoInvalidVarAssignInVarOrConstSpecInspection(holder), new GoInvalidTildeInspection(holder), new GoInvalidReceiverTypeInspection(holder), new GoImpossibleTypeAssertionInspection(holder), new GoJumpOverDeclarationInspection(holder), new GoNonFunctionCallInspection(holder), new GoExtendedMethodExprSyntaxInspection(holder), new GoExplicitDereferenceRequiredInspection(holder), new GoUnresolvedReferenceInspection(holder), new GoTypesCompatibilityInspection(holder), new GoBinaryAndUnaryExpressionTypesCompatibilityInspection(holder), new GoInvalidCompositeLiteralInspection(holder), new GoInvalidExpressionConversionInspection(holder), new GoInvalidIndexOrSliceExpressionInspection(holder), new GoDuplicateCaseInspection(holder), new GoUnusedVariableInspection(holder)});
        if (list == null) {
            GoAnnotator.$$$reportNull$$$0(14);
        }
        return list;
    }

    @NotNull
    private static List<GoVisitor> buildNonCodeFragmentVisitors(@NotNull GoProblemsHolder holder) {
        if (holder == null) {
            GoAnnotator.$$$reportNull$$$0(15);
        }
        List<GoVisitor> list = Arrays.asList(new GoVisitor[]{new GoInvalidPackageImportInspection(holder), new GoUnusedImportInspection(holder), new GoDuplicateInspection(holder)});
        if (list == null) {
            GoAnnotator.$$$reportNull$$$0(16);
        }
        return list;
    }

    @TestOnly
    @NotNull
    private static List<GoVisitor> buildTestVisitors(@NotNull GoProblemsHolder holder) {
        List enabledChecks;
        if (holder == null) {
            GoAnnotator.$$$reportNull$$$0(17);
        }
        List list = (enabledChecks = (List)TestModeFlags.get(ENABLED_CHECKS)) != null ? ContainerUtil.map((Collection)enabledChecks, c -> (GoVisitor)((Object)((Object)c.apply(holder)))) : Collections.emptyList();
        if (list == null) {
            GoAnnotator.$$$reportNull$$$0(18);
        }
        return list;
    }

    @TestOnly
    public static void disableBasicChecks(@NotNull Disposable disposable) {
        if (disposable == null) {
            GoAnnotator.$$$reportNull$$$0(19);
        }
        TestModeFlags.set(DISABLE_BASIC_CHECKS, (Object)true, (Disposable)disposable);
    }

    @TestOnly
    public static void enableAllChecks(@NotNull Disposable disposable, boolean enable) {
        if (disposable == null) {
            GoAnnotator.$$$reportNull$$$0(20);
        }
        TestModeFlags.set(USE_ALL_AVAILABLE_CHECKS, (Object)enable, (Disposable)disposable);
    }

    @TestOnly
    public static void enableChecks(@NotNull Disposable disposable, InspectionVisitorConstructor ... constructors) {
        if (disposable == null) {
            GoAnnotator.$$$reportNull$$$0(21);
        }
        if (constructors == null) {
            GoAnnotator.$$$reportNull$$$0(22);
        }
        TestModeFlags.set(ENABLED_CHECKS, Arrays.asList(constructors), (Disposable)disposable);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 5, 7, 8, 11, 12, 14, 16, 18 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 1: 
            case 6: 
            case 9: 
            case 13: 
            case 15: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 2: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ref";
                break;
            }
            case 5: 
            case 7: 
            case 8: 
            case 11: 
            case 12: 
            case 14: 
            case 16: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/goide/highlighting/GoAnnotator";
                break;
            }
            case 19: 
            case 20: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "disposable";
                break;
            }
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "constructors";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/goide/highlighting/GoAnnotator";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "useOfPackageNameWithoutSelectorMessage";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "buildErrorCheckers";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "buildVisitors";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "buildCommonVisitors";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "buildNonCodeFragmentVisitors";
                break;
            }
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "buildTestVisitors";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "annotate";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "isForceHighlightParents";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "isInQualifierOfRefExpression";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "useOfPackageNameWithoutSelectorMessage";
                break;
            }
            case 5: 
            case 7: 
            case 8: 
            case 11: 
            case 12: 
            case 14: 
            case 16: 
            case 18: {
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "buildErrorCheckers";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "buildVisitors";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "buildCommonVisitors";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "buildNonCodeFragmentVisitors";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "buildTestVisitors";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "disableBasicChecks";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "enableAllChecks";
                break;
            }
            case 21: 
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "enableChecks";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 5, 7, 8, 11, 12, 14, 16, 18 -> new IllegalStateException(string);
        };
    }

    private static final class BasicErrorsChecker
    extends GoErrorsChecker {
        private BasicErrorsChecker(@NotNull GoAnnotationHolder holder) {
            if (holder == null) {
                BasicErrorsChecker.$$$reportNull$$$0(0);
            }
            super(holder);
        }

        @Override
        public void visitPackageClause(@NotNull GoPackageClause element) {
            PsiElement identifier;
            if (element == null) {
                BasicErrorsChecker.$$$reportNull$$$0(1);
            }
            if ((identifier = element.getIdentifier()) != null && identifier.textMatches((CharSequence)"_")) {
                this.myHolder.newErrorAnnotation(identifier, (GoInspectionMessage)GoInspectionMessageWithI18n.message("go.error.annotator.invalid.package.name")).create();
            }
        }

        @Override
        public void visitContinueStatement(@NotNull GoContinueStatement o) {
            if (o == null) {
                BasicErrorsChecker.$$$reportNull$$$0(2);
            }
            if (GoPsiUtil.getContinueStatementOwner(o) == null) {
                GoInspectionMessageWithI18n message = GoInspectionMessageWithI18n.message("go.error.annotator.continue.statement.not.inside.a.for.loop");
                this.myHolder.newErrorAnnotation(o, (GoInspectionMessage)message).withFix((IntentionAction)new GoReplaceWithReturnStatementQuickFix(o)).create();
            }
        }

        @Override
        public void visitBreakStatement(@NotNull GoBreakStatement o) {
            if (o == null) {
                BasicErrorsChecker.$$$reportNull$$$0(3);
            }
            if (GoPsiUtil.getBreakStatementOwner(o) == null) {
                GoInspectionMessageWithI18n message = GoInspectionMessageWithI18n.message("go.error.annotator.break.statement.not.inside.a.for.loop.select.or.switch");
                this.myHolder.newErrorAnnotation(o, (GoInspectionMessage)message).withFix((IntentionAction)new GoReplaceWithReturnStatementQuickFix(o)).create();
            }
        }

        @Override
        public void visitFieldName(@NotNull GoFieldName field) {
            PsiElement resolve2;
            if (field == null) {
                BasicErrorsChecker.$$$reportNull$$$0(4);
            }
            if (!this.checkUnexportedReferenceUsage(field, resolve2 = field.resolve())) {
                return;
            }
            if (!this.checkInvalidPackageReferenceUsage(field, resolve2)) {
                return;
            }
            this.checkIllegalTypeReference(field, resolve2);
        }

        @Override
        public void visitReferenceExpression(@NotNull GoReferenceExpression ref) {
            PsiElement resolve2;
            if (ref == null) {
                BasicErrorsChecker.$$$reportNull$$$0(5);
            }
            if (!this.checkUnexportedReferenceUsage(ref, resolve2 = ref.resolve())) {
                return;
            }
            if (!this.checkInvalidPackageReferenceUsage(ref, resolve2)) {
                return;
            }
            if (!this.checkIllegalTypeReference(ref, resolve2)) {
                return;
            }
            if (resolve2 instanceof GoVarOrConstDefinition) {
                GoExpression value;
                GoVarOrConstDefinition varOrConstDefinition = (GoVarOrConstDefinition)resolve2;
                if (resolve2.getContainingFile() == ref.getContainingFile() && resolve2.getParent() instanceof GoVarOrConstSpec && PsiTreeUtil.getParentOfType((PsiElement)ref, GoVarOrConstDeclaration.class) != null && (value = varOrConstDefinition.findExpression()) != null && value.equals(GoPsiImplUtil.getNonStrictTopmostParentOfType(ref, GoExpression.class))) {
                    this.myHolder.newErrorAnnotation(ref, (GoInspectionMessage)GoInspectionMessageWithI18n.message("go.error.annotator.cyclic.definition.detected")).create();
                }
            }
        }

        @Contract(value="_, null -> true")
        private boolean checkUnexportedReferenceUsage(@NotNull GoReferenceExpressionBase ref, @Nullable PsiElement resolve2) {
            if (ref == null) {
                BasicErrorsChecker.$$$reportNull$$$0(6);
            }
            if (resolve2 instanceof GoNamedElement) {
                GoNamedElement namedElement = (GoNamedElement)resolve2;
                if (GoPsiUtil.isUnexportedAndFromOtherPackage(resolve2, ref) && !BasicErrorsChecker.isUnexportedAllowed(ref, resolve2)) {
                    this.createUnexportedReferenceUsageError(ref, namedElement);
                    return false;
                }
            }
            return true;
        }

        private void createUnexportedReferenceUsageError(@NotNull GoReferenceExpressionBase ref, @NotNull GoNamedElement namedElement) {
            if (ref == null) {
                BasicErrorsChecker.$$$reportNull$$$0(7);
            }
            if (namedElement == null) {
                BasicErrorsChecker.$$$reportNull$$$0(8);
            }
            PsiElement id = ref.getIdentifier();
            String refType = UsageViewUtil.getType((PsiElement)namedElement);
            GoInspectionMessageWithI18n message = GoInspectionMessageWithI18n.message("go.error.annotator.unexported.reference.usage", refType, id.getText());
            AnnotationBuilder annotation = this.myHolder.newErrorAnnotation(id, (GoInspectionMessage)message);
            if (GoPsiUtil.isExportable(ref.getProject(), namedElement)) {
                annotation = StringUtil.canBeCapitalized((String)namedElement.getName()) ? annotation.withFix((IntentionAction)new GoExportQuickFix(ref, refType)) : annotation.newLocalQuickFix((LocalQuickFix)new GoRenameQuickFix(namedElement), GoAnnotationHolderBase.createDescriptor(ref, message)).registerFix();
            }
            annotation.create();
        }

        private static boolean isUnexportedAllowed(@NotNull PsiElement usage, @NotNull PsiElement resolve2) {
            GoCodeFragment fragment;
            if (usage == null) {
                BasicErrorsChecker.$$$reportNull$$$0(9);
            }
            if (resolve2 == null) {
                BasicErrorsChecker.$$$reportNull$$$0(10);
            }
            return (fragment = (GoCodeFragment)((Object)ObjectUtils.tryCast((Object)usage.getContainingFile(), GoCodeFragment.class))) != null && fragment.isIgnoreVisibilityRules() && (GoPsiImplUtil.isFieldDefinition(resolve2) || resolve2 instanceof GoVarOrConstDefinition);
        }

        private boolean checkInvalidPackageReferenceUsage(@NotNull GoReferenceExpressionBase ref, @Nullable PsiElement resolve2) {
            if (ref == null) {
                BasicErrorsChecker.$$$reportNull$$$0(11);
            }
            if (GoPsiUtil.isImportSpecOrPackage(resolve2) && !(ref.getParent() instanceof GoReferenceExpression) && PsiTreeUtil.getParentOfType((PsiElement)ref, GoPackageClause.class) == null) {
                this.myHolder.newErrorAnnotation(ref, GoAnnotator.useOfPackageNameWithoutSelectorMessage(ref)).create();
                return false;
            }
            return true;
        }

        private boolean checkIllegalTypeReference(@NotNull GoReferenceExpressionBase ref, @Nullable PsiElement resolve2) {
            if (ref == null) {
                BasicErrorsChecker.$$$reportNull$$$0(12);
            }
            if ((resolve2 instanceof GoTypeSpec || resolve2 instanceof GoTypeParamDefinition) && BasicErrorsChecker.isIllegalUseOfTypeAsExpression(ref)) {
                this.myHolder.newErrorAnnotation(ref, (GoInspectionMessage)GoInspectionMessageWithI18n.message("go.error.annotator.type.is.not.an.expression", ref.getText())).create();
                return false;
            }
            return true;
        }

        @Override
        public void visitTypeReferenceExpression(@NotNull GoTypeReferenceExpression ref) {
            GoBuiltinCallExpr builtinCallExpr;
            GoBuiltinArgumentList builtinArgumentList;
            PsiElement psiElement;
            PsiElement parent;
            if (ref == null) {
                BasicErrorsChecker.$$$reportNull$$$0(13);
            }
            super.visitTypeReferenceExpression(ref);
            PsiElement type2 = ref.resolve();
            if (type2 instanceof GoNamedElement) {
                GoNamedElement namedElement = (GoNamedElement)type2;
                if (GoPsiUtil.isUnexportedAndFromOtherPackage(type2, ref)) {
                    this.createUnexportedReferenceUsageError(ref, namedElement);
                }
            }
            if ((parent = ref.getParent()) instanceof GoType && (psiElement = parent.getParent()) instanceof GoBuiltinArgumentList && (psiElement = (builtinArgumentList = (GoBuiltinArgumentList)psiElement).getParent()) instanceof GoBuiltinCallExpr && !(builtinCallExpr = (GoBuiltinCallExpr)psiElement).isTrulyBuiltin()) {
                return;
            }
            boolean isQualifier = parent instanceof GoTypeReferenceExpression;
            if (type2 == null || isQualifier) {
                return;
            }
            if (GoPsiUtil.isImportSpecOrPackage(type2)) {
                this.myHolder.newErrorAnnotation(ref, GoAnnotator.useOfPackageNameWithoutSelectorMessage(ref)).create();
            } else if (!(type2 instanceof GoTypeSpec || type2 instanceof GoTypeReferenceExpression || type2 instanceof GoTypeParamDefinition || BasicErrorsChecker.isNilCaseOfTypeSwitch(ref, type2))) {
                this.myHolder.newErrorAnnotation(ref, (GoInspectionMessage)GoInspectionMessageWithI18n.message("go.error.annotator.reference.is.not.a.type", ref.getIdentifier().getText())).create();
            }
        }

        private static boolean isNilCaseOfTypeSwitch(@NotNull GoTypeReferenceExpression ref, @NotNull PsiElement resolve2) {
            PsiElement parent;
            if (ref == null) {
                BasicErrorsChecker.$$$reportNull$$$0(14);
            }
            if (resolve2 == null) {
                BasicErrorsChecker.$$$reportNull$$$0(15);
            }
            return (parent = ref.getParent()) instanceof GoType && PsiTreeUtil.skipParentsOfType((PsiElement)parent, (Class[])new Class[]{GoParType.class, GoTypeList.class}) instanceof GoTypeCaseClause && GoExpressionUtil.isNil(resolve2);
        }

        @Override
        public void visitCompositeLit(@NotNull GoCompositeLit o) {
            if (o == null) {
                BasicErrorsChecker.$$$reportNull$$$0(16);
            }
            if (!(o.getType() instanceof GoMapType)) {
                return;
            }
            GoLiteralValue literalValue = o.getLiteralValue();
            if (literalValue == null) {
                return;
            }
            for (GoElement literalElement : literalValue.getElementList()) {
                if (literalElement.getKey() != null) continue;
                this.myHolder.newErrorAnnotation(literalElement, (GoInspectionMessage)GoInspectionMessageWithI18n.message("go.error.annotator.missing.key.in.map.literal")).create();
            }
        }

        @Override
        public void visitTypeAssertionExpr(@NotNull GoTypeAssertionExpr o) {
            if (o == null) {
                BasicErrorsChecker.$$$reportNull$$$0(17);
            }
            if (o.getRparen() == null) {
                return;
            }
            if (o.getType_() != null) {
                PsiElement parent = o.getParent();
                if (!(parent instanceof GoTypeSwitchGuard)) {
                    this.myHolder.newErrorAnnotation(o, (GoInspectionMessage)GoInspectionMessageWithI18n.message("go.error.annotator.use.of.type.outside.type.switch")).create();
                    return;
                }
                this.checkTypeAssertionExpression(o.getExpression(), o, parent);
                return;
            }
            this.checkTypeAssertionExpression(o.getExpression(), o, o);
        }

        private void checkTypeAssertionExpression(@NotNull GoExpression expression, @NotNull GoTypeAssertionExpr typeAssertionExpr, @NotNull PsiElement typeAssertionOrGuard) {
            GoType type2;
            if (expression == null) {
                BasicErrorsChecker.$$$reportNull$$$0(18);
            }
            if (typeAssertionExpr == null) {
                BasicErrorsChecker.$$$reportNull$$$0(19);
            }
            if (typeAssertionOrGuard == null) {
                BasicErrorsChecker.$$$reportNull$$$0(20);
            }
            if ((type2 = expression.getGoType(null)) == null) {
                return;
            }
            PsiElement context = GoReferenceBase.getSubstitutionContextOrSelf(expression);
            if (GoTypeUtil.isTypeParameter(type2, context)) {
                GoInspectionMessageWithI18n message = typeAssertionOrGuard instanceof GoTypeAssertionExpr ? GoInspectionMessageWithI18n.message("go.error.annotator.cannot.use.type.assertion.on.type.parameter", expression.getText()) : GoInspectionMessageWithI18n.message("go.error.annotator.cannot.use.type.switch.on.type.parameter", expression.getText());
                TextRange range = TextRange.create((int)typeAssertionExpr.getLparen().getTextRange().getStartOffset(), (int)typeAssertionExpr.getTextRange().getEndOffset());
                this.myHolder.newErrorAnnotation(range, (GoInspectionMessage)message).create();
                return;
            }
            GoType underlyingType = type2.getUnderlyingType(context);
            if (underlyingType instanceof GoInterfaceType || underlyingType instanceof GoCType) {
                return;
            }
            GoInspectionMessageWithI18n message = typeAssertionOrGuard instanceof GoTypeAssertionExpr ? GoInspectionMessageWithI18n.message("go.error.annotator.invalid.type.assertion", typeAssertionOrGuard.getText(), type2.getPresentationText()) : GoInspectionMessageWithI18n.message("go.error.annotator.invalid.type.switch.guard", typeAssertionOrGuard.getText(), type2.getPresentationText());
            this.myHolder.newErrorAnnotation(expression, (GoInspectionMessage)message).create();
        }

        @Override
        public void visitMapType(@NotNull GoMapType o) {
            if (o == null) {
                BasicErrorsChecker.$$$reportNull$$$0(21);
            }
            super.visitMapType(o);
            GoType keyType = o.getKeyType();
            if (keyType != null && !GoTypeUtil.isComparable(keyType, null, false)) {
                this.myHolder.newErrorAnnotation(keyType, (GoInspectionMessage)GoInspectionMessageWithI18n.message("go.error.annotator.map.key.type.is.not.comparable")).create();
            }
        }

        @Override
        public void visitBuiltinCallExpr(@NotNull GoBuiltinCallExpr o) {
            if (o == null) {
                BasicErrorsChecker.$$$reportNull$$$0(22);
            }
            if (o.isTrulyBuiltin()) {
                if (o.getExpression().textMatches("make")) {
                    this.checkMakeCall(o);
                } else if (o.getExpression().textMatches("new")) {
                    this.checkNewCall(o);
                }
            }
        }

        @Override
        public void visitCallExpr(@NotNull GoCallExpr o) {
            int resultCount;
            if (o == null) {
                BasicErrorsChecker.$$$reportNull$$$0(23);
            }
            if ((resultCount = GoInspectionUtil.getExpressionResultCount(o)) == 0) {
                boolean inDeferOrGo;
                PsiElement parent = GoPsiUtil.skipParens(o).getParent();
                boolean simpleStatement = parent instanceof GoLeftHandExprList && parent.getParent() instanceof GoSimpleStatement;
                boolean bl = inDeferOrGo = parent instanceof GoDeferStatement || parent instanceof GoGoStatement;
                if (!simpleStatement && !inDeferOrGo) {
                    this.myHolder.newErrorAnnotation(o, (GoInspectionMessage)GoInspectionMessageWithI18n.message("go.error.annotator.call.used.as.value.but.it.returns.nothing", o.getText())).create();
                }
            }
            if (resultCount > 1 && BasicErrorsChecker.isMultipleValueInSingleValueContext(o)) {
                this.myHolder.newErrorAnnotation(o, BasicErrorsChecker.multipleValueInSingleValueContextMessage(o)).create();
            }
            PsiElement context = GoReferenceBase.getSubstitutionContextOrSelf(o);
            if (GoPsiUtil.isBuiltinFunctionCall(o, "cap", "len")) {
                this.checkCapOrLenCall(o, context);
            } else if (GoPsiUtil.isBuiltinFunctionCall(o, "min", "max", "clear")) {
                this.checkMinMaxClearCall(o);
            }
        }

        private static boolean isMultipleValueInSingleValueContext(@NotNull GoCallExpr callExpression) {
            PsiElement parent;
            GoExprSwitchStatement switchStatement;
            if (callExpression == null) {
                BasicErrorsChecker.$$$reportNull$$$0(24);
            }
            if ((switchStatement = (GoExprSwitchStatement)ObjectUtils.tryCast((Object)(parent = PsiTreeUtil.getParentOfType((PsiElement)callExpression, (Class[])new Class[]{GoExprSwitchStatement.class, GoStatementsHolder.class, GoFunctionLit.class})), GoExprSwitchStatement.class)) != null) {
                GoExpression condition = switchStatement.getCondition();
                return condition != null && condition.unwrapParentheses() == callExpression;
            }
            GoCallExpr parentCall = GoInspectionUtil.findCallFromArgument(callExpression);
            return parentCall != null && parentCall.getArgumentList().getExpressionList().size() != 1;
        }

        @NotNull
        public static GoInspectionMessage multipleValueInSingleValueContextMessage(@NotNull GoCallExpr call) {
            if (call == null) {
                BasicErrorsChecker.$$$reportNull$$$0(25);
            }
            String callExpressionText = call.getExpression().getText();
            String callText = call.getArgumentList().getExpressionList().isEmpty() ? callExpressionText + "()" : callExpressionText + "(...)";
            GoType type2 = call.getGoType(null);
            String typeText = type2 != null ? type2.getPresentationText() : "";
            String text = typeText.isEmpty() ? callText : callText + " " + typeText;
            GoInspectionMessageWithI18n goInspectionMessageWithI18n = GoInspectionMessageWithI18n.message("go.error.annotator.multiple.value.in.single.value.context", text);
            if (goInspectionMessageWithI18n == null) {
                BasicErrorsChecker.$$$reportNull$$$0(26);
            }
            return goInspectionMessageWithI18n;
        }

        @Override
        public void visitTypeDeclaration(@NotNull GoTypeDeclaration o) {
            if (o == null) {
                BasicErrorsChecker.$$$reportNull$$$0(27);
            }
            if (!(o.getParent() instanceof GoFile)) {
                GoSdk sdk = GoSdkService.getInstance(o.getProject()).getSdk(GoUtil.module(o));
                if (!sdk.supportsTypeDeclarationInGenerics()) {
                    GoFunctionOrMethodDeclaration funcOrMethod = (GoFunctionOrMethodDeclaration)PsiTreeUtil.getTopmostParentOfType((PsiElement)o, GoFunctionOrMethodDeclaration.class);
                    if (funcOrMethod instanceof GoMethodDeclaration) {
                        GoTypeArguments typeArgs;
                        GoMethodDeclaration method = (GoMethodDeclaration)funcOrMethod;
                        GoReceiver receiver = method.getReceiver();
                        GoType receiverType = receiver != null ? receiver.getType() : null;
                        GoTypeArguments goTypeArguments = typeArgs = receiverType != null ? receiverType.getTypeArguments() : null;
                        if (typeArgs != null) {
                            this.myHolder.newErrorAnnotation(o, (GoInspectionMessage)GoInspectionMessageWithI18n.message("go.error.annotator.type.cannot.be.declared.in.generic.method", new Object[]{sdk.getMajorVersion()})).create();
                        }
                    } else if (funcOrMethod instanceof GoFunctionDeclaration) {
                        GoTypeParameters typeParams;
                        GoSignature signature = funcOrMethod.getSignature();
                        GoTypeParameters goTypeParameters = typeParams = signature != null ? signature.getTypeParameters() : null;
                        if (typeParams != null) {
                            this.myHolder.newErrorAnnotation(o, (GoInspectionMessage)GoInspectionMessageWithI18n.message("go.error.annotator.type.cannot.be.declared.in.generic.function", new Object[]{sdk.getMajorVersion()})).create();
                        }
                    }
                }
                return;
            }
            Module module = GoUtil.module(o);
            for (GoTypeSpec spec : o.getTypeSpecList()) {
                this.checkInitTextMatches(spec, spec);
                if (module == null || !spec.isTypeAlias()) continue;
                if (!GoSdkService.getInstance(module.getProject()).getSdk(module).supportsTypeAliases()) {
                    this.myHolder.newErrorAnnotation(spec.getSpecType(), (GoInspectionMessage)GoInspectionMessageWithI18n.message("go.error.annotator.type.aliases.are.available.since.go.1.9")).create();
                }
                if (spec.getSpecType().getTypeParameters() == null) continue;
                this.myHolder.newErrorAnnotation(spec.getSpecType(), (GoInspectionMessage)GoInspectionMessageWithI18n.message("go.error.annotator.generic.type.cannot.be.alias")).create();
            }
        }

        @Override
        public void visitVarOrConstDeclaration(@NotNull GoVarOrConstDeclaration o) {
            if (o == null) {
                BasicErrorsChecker.$$$reportNull$$$0(28);
            }
            if (!(o.getParent() instanceof GoFile)) {
                return;
            }
            GoPsiUtil.processDefinitions(o, (Processor<GoNamedElement>)((Processor)def -> {
                this.checkInitTextMatches(def.getParent(), (GoNamedElement)def);
                return true;
            }));
        }

        @Override
        public void visitFunctionDeclaration(@NotNull GoFunctionDeclaration o) {
            GoParameters parameters;
            if (o == null) {
                BasicErrorsChecker.$$$reportNull$$$0(29);
            }
            super.visitFunctionDeclaration(o);
            if (!(o.getParent() instanceof GoFile) || !GoPsiUtil.isMainOrInitFunction(o)) {
                return;
            }
            GoSignature signature = o.getSignature();
            if (signature == null) {
                return;
            }
            GoInspectionMessageWithI18n message = GoInspectionMessageWithI18n.message("go.error.annotator.main.or.init.has.invalid.signature", o.getName());
            GoEmptySignatureQuickFix action = new GoEmptySignatureQuickFix(o);
            GoResult result = signature.getResult();
            if (result != null && !result.isVoid()) {
                this.myHolder.newErrorAnnotation(result, (GoInspectionMessage)message).withFix((IntentionAction)action).create();
            }
            if (!(parameters = signature.getParameters()).getParameterDeclarationList().isEmpty()) {
                this.myHolder.newErrorAnnotation(parameters, (GoInspectionMessage)message).withFix((IntentionAction)action).create();
            }
        }

        @Override
        public void visitIndexOrSliceExpr(@NotNull GoIndexOrSliceExpr o) {
            if (o == null) {
                BasicErrorsChecker.$$$reportNull$$$0(30);
            }
            GoExpression expr = o.getExpression();
            GoExpression thirdIndex = (GoExpression)o.getIndices().third;
            PsiElement context = GoReferenceBase.getSubstitutionContextOrSelf(o);
            if (expr == null || thirdIndex == null || !GoTypeUtil.isString(expr.getGoType(null), context)) {
                return;
            }
            ASTNode[] colons = o.getNode().getChildren(TokenSet.create((IElementType[])new IElementType[]{GoTypes.COLON}));
            if (colons.length != 2) {
                return;
            }
            PsiElement secondColon = colons[1].getPsi();
            TextRange range = TextRange.create((int)secondColon.getTextRange().getStartOffset(), (int)thirdIndex.getTextRange().getEndOffset());
            this.myHolder.newErrorAnnotation(range, (GoInspectionMessage)GoInspectionMessageWithI18n.message("go.error.annotator.invalid.index.or.slice.operation", o.getText())).withFix((IntentionAction)new GoDeleteRangeQuickFix(secondColon, thirdIndex, GoBundle.message((String)"go.fix.delete.third.index.name", (Object[])new Object[0]))).create();
        }

        @Override
        public void visitLeftHandExprList(@NotNull GoLeftHandExprList leftHandExprList) {
            GoIfStatement ifStatement;
            GoExprSwitchStatement switchStatement;
            PsiElement parent;
            if (leftHandExprList == null) {
                BasicErrorsChecker.$$$reportNull$$$0(31);
            }
            if ((parent = leftHandExprList.getParent()) instanceof GoAssignmentStatement) {
                return;
            }
            PsiElement grand = parent.getParent();
            boolean checkSyntaxOnly = grand instanceof GoExprSwitchStatement && (switchStatement = (GoExprSwitchStatement)grand).getExpression() == null && switchStatement.getSemicolon() == null || grand instanceof GoIfStatement && (ifStatement = (GoIfStatement)grand).getExpression() == null;
            List<GoExpression> list = leftHandExprList.getExpressionList();
            GoExpression last = (GoExpression)ContainerUtil.getLastItem(list);
            if (last == null) {
                return;
            }
            if (list.size() > 1) {
                GoInspectionMessageWithI18n message = GoInspectionMessageWithI18n.message("go.error.annotator.unexpected.end.of.statement");
                this.myHolder.newErrorAnnotation(last.getTextRange(), (GoInspectionMessage)message).create();
                return;
            }
            if (checkSyntaxOnly) {
                return;
            }
            new GoExpressionStatementSpecChecker(this.myHolder).visitExpression(last);
        }

        @Override
        public void visitIfStatement(@NotNull GoIfStatement o) {
            boolean hasSeparator;
            if (o == null) {
                BasicErrorsChecker.$$$reportNull$$$0(32);
            }
            GoExpression expression = o.getExpression();
            GoStatement statement = o.getStatement();
            PsiElement semicolon = o.getSemicolon();
            boolean hasNewLineAfterStatement = GoPsiUtil.hasNewLineAfter(statement);
            boolean bl = hasSeparator = semicolon != null || hasNewLineAfterStatement;
            if (expression == null && statement != null && hasSeparator || statement == null || statement instanceof GoElseStatement) {
                if (hasNewLineAfterStatement && !(statement instanceof GoElseStatement)) {
                    PsiElement anchor = (PsiElement)ObjectUtils.notNull((Object)statement, (Object)o.getIf());
                    PsiElement leafAfterAnchor = PsiTreeUtil.nextLeaf((PsiElement)anchor, (boolean)true);
                    PsiElement elementToReport = leafAfterAnchor != null && PsiTreeUtil.isAncestor((PsiElement)o, (PsiElement)leafAfterAnchor, (boolean)true) ? leafAfterAnchor : anchor;
                    GoInspectionMessageWithI18n message = GoInspectionMessageWithI18n.message("go.error.annotator.unexpected.newline.after.if");
                    if (elementToReport.textMatches((CharSequence)"\n")) {
                        this.myHolder.newErrorAnnotation(elementToReport, (GoInspectionMessage)message).afterEndOfLine().create();
                    } else {
                        this.myHolder.newErrorAnnotation(elementToReport, (GoInspectionMessage)message).create();
                    }
                } else {
                    this.myHolder.newErrorAnnotation(o.getIf(), (GoInspectionMessage)GoInspectionMessageWithI18n.message("go.error.annotator.missing.condition.in.if.statement")).create();
                }
            }
            if (statement != null && expression != null && !hasSeparator) {
                TextRange range = TextRange.create((int)statement.getTextRange().getEndOffset(), (int)expression.getTextRange().getStartOffset());
                this.myHolder.newErrorAnnotation(range, (GoInspectionMessage)GoInspectionMessageWithI18n.message("go.error.annotator.semicolon.is.missing")).create();
            }
        }

        @Override
        public void visitFallthroughStatement(@NotNull GoFallthroughStatement o) {
            GoCaseClause caseClause;
            if (o == null) {
                BasicErrorsChecker.$$$reportNull$$$0(33);
            }
            super.visitFallthroughStatement(o);
            PsiElement parent = o.getParent();
            if (parent instanceof GoLabeledStatement) {
                parent = parent.getParent();
            }
            if ((caseClause = (GoCaseClause)ObjectUtils.tryCast((Object)parent, GoCaseClause.class)) instanceof GoExprCaseClause) {
                GoExprCaseClause lastCase;
                GoStatement lastStatement = (GoStatement)ContainerUtil.getLastItem(caseClause.getStatementList());
                if (lastStatement instanceof GoLabeledStatement) {
                    lastStatement = ((GoLabeledStatement)lastStatement).getStatement();
                }
                if (lastStatement != null && !lastStatement.equals(o)) {
                    this.myHolder.newErrorAnnotation(o, (GoInspectionMessage)GoInspectionMessageWithI18n.message("go.error.annotator.fallthrough.statement.out.of.place")).create();
                    return;
                }
                GoExprSwitchStatement switchStatement = (GoExprSwitchStatement)PsiTreeUtil.getParentOfType((PsiElement)caseClause, GoExprSwitchStatement.class);
                if (switchStatement != null && caseClause.equals(lastCase = (GoExprCaseClause)ContainerUtil.getLastItem(switchStatement.getExprCaseClauseList()))) {
                    this.myHolder.newErrorAnnotation(o, (GoInspectionMessage)GoInspectionMessageWithI18n.message("go.error.annotator.cannot.fallthrough.final.case.in.switch")).create();
                }
            } else if (caseClause instanceof GoTypeCaseClause) {
                this.myHolder.newErrorAnnotation(o, (GoInspectionMessage)GoInspectionMessageWithI18n.message("go.error.annotator.cannot.fallthrough.in.type.switch")).create();
            } else {
                this.myHolder.newErrorAnnotation(o, (GoInspectionMessage)GoInspectionMessageWithI18n.message("go.error.annotator.fallthrough.statement.out.of.place")).create();
            }
        }

        public void visitComment(@NotNull PsiComment comment) {
            if (comment == null) {
                BasicErrorsChecker.$$$reportNull$$$0(34);
            }
            super.visitComment(comment);
            if (comment.getTokenType() == GoParserDefinition.Lazy.MULTILINE_COMMENT && !comment.getText().endsWith("*/")) {
                int errorStart = StringUtil.trimTrailing((String)comment.getText(), (char)'\n').length() - 1;
                TextRange errorRange = TextRange.from((int)(errorStart + comment.getTextRange().getStartOffset()), (int)1);
                this.myHolder.newErrorAnnotation(errorRange, (GoInspectionMessage)GoInspectionMessageWithI18n.message("go.error.annotator.end.of.file.in.comment")).create();
            }
        }

        @Override
        public void visitArrayOrSliceType(@NotNull GoArrayOrSliceType arrayOrSliceType) {
            if (arrayOrSliceType == null) {
                BasicErrorsChecker.$$$reportNull$$$0(35);
            }
            super.visitArrayOrSliceType(arrayOrSliceType);
            if (!arrayOrSliceType.isArray()) {
                return;
            }
            GoExpression arrayLengthExpression = arrayOrSliceType.getExpression();
            if (arrayLengthExpression == null) {
                return;
            }
            if (!arrayLengthExpression.isConstant()) {
                GoInspectionMessageWithI18n message = GoInspectionMessageWithI18n.message("go.error.annotator.array.bound.must.be.a.constant.expression", arrayLengthExpression.getText());
                this.myHolder.newErrorAnnotation(arrayLengthExpression, (GoInspectionMessage)message).create();
                return;
            }
            Value value = arrayLengthExpression.getValue();
            if (value == null) {
                return;
            }
            Long integerValue = value.getInteger();
            if (integerValue != null && integerValue < 0L) {
                GoInspectionMessageWithI18n message = GoInspectionMessageWithI18n.message("go.error.annotator.array.bound.must.be.non.negative", arrayLengthExpression.getText());
                this.myHolder.newErrorAnnotation(arrayLengthExpression, (GoInspectionMessage)message).create();
                return;
            }
            GoType type2 = arrayLengthExpression.getGoType(null);
            PsiElement context = GoReferenceBase.getSubstitutionContextOrSelf(arrayLengthExpression);
            if (type2 != null && ThreeState.NO == GoInvalidExpressionConversionInspection.isRepresentable(value, type2, GoLightType.getIntType(arrayOrSliceType), false, context)) {
                GoInspectionMessageWithI18n message = GoInspectionMessageWithI18n.message("go.error.annotator.array.bound.must.be.representable.by.int.type", arrayLengthExpression.getText());
                this.myHolder.newErrorAnnotation(arrayLengthExpression, (GoInspectionMessage)message).create();
            }
        }

        private void checkCapOrLenCall(@NotNull GoCallExpr call, @Nullable PsiElement context) {
            List<GoExpression> exprs;
            if (call == null) {
                BasicErrorsChecker.$$$reportNull$$$0(36);
            }
            if ((exprs = call.getArgumentList().getExpressionList()).size() != 1) {
                return;
            }
            @NotNull GoExpression first = (GoExpression)ContainerUtil.getFirstItem(exprs);
            GoType exprType = first.getGoType(null);
            if (exprType == null) {
                return;
            }
            boolean isLen = call.getExpression().textMatches("len");
            GoType baseType = exprType.getUnderlyingType(context);
            if (baseType instanceof GoCType) {
                return;
            }
            if (GoTypeUtil.isLenCapAvailableTo(baseType, isLen, context)) {
                return;
            }
            GoInspectionMessageWithI18n message = isLen ? GoInspectionMessageWithI18n.message("go.error.annotator.invalid.argument.for.len") : GoInspectionMessageWithI18n.message("go.error.annotator.invalid.argument.for.cap");
            this.myHolder.newErrorAnnotation(first, (GoInspectionMessage)message).create();
        }

        private void checkMinMaxClearCall(@NotNull GoCallExpr call) {
            GoSdkVersion sdkVersion;
            if (call == null) {
                BasicErrorsChecker.$$$reportNull$$$0(37);
            }
            if ((sdkVersion = GoTargetSdkVersionProvider.getTargetGoSdkVersion(call)) == null) {
                return;
            }
            if (!sdkVersion.supportsMinMaxClearBuiltinFunctions()) {
                String funcName;
                GoReferenceExpression refExpr = (GoReferenceExpression)ObjectUtils.tryCast((Object)call.getExpression(), GoReferenceExpression.class);
                String string = funcName = refExpr != null ? refExpr.getIdentifier().getText() : null;
                if (funcName == null) {
                    return;
                }
                this.myHolder.newErrorAnnotation(call, (GoInspectionMessage)GoInspectionMessageWithI18n.message("go.error.annotator.min.max.clear.call.requires.go.1.21", funcName)).withFix((IntentionAction)new VgoAddOrUpdateGoVersionFix(GoSdkVersion.GO_1_21)).create();
            }
        }

        private void checkInitTextMatches(@NotNull PsiElement spec, @NotNull GoNamedElement definition) {
            if (spec == null) {
                BasicErrorsChecker.$$$reportNull$$$0(38);
            }
            if (definition == null) {
                BasicErrorsChecker.$$$reportNull$$$0(39);
            }
            if ("init".equals(definition.getName())) {
                this.myHolder.newErrorAnnotation(spec, (GoInspectionMessage)GoInspectionMessageWithI18n.message("go.error.annotator.cannot.declare.init.must.be.a.function")).create();
            }
        }

        private void checkNewCall(@NotNull GoBuiltinCallExpr call) {
            GoBuiltinArgumentList args;
            GoType type2;
            if (call == null) {
                BasicErrorsChecker.$$$reportNull$$$0(40);
            }
            if ((type2 = (args = call.getBuiltinArgumentList()).getType()) == null) {
                this.reportMissingBuiltinCallType(call);
                return;
            }
            if (!args.getExpressionList().isEmpty()) {
                this.myHolder.newErrorAnnotation(args, (GoInspectionMessage)GoInspectionMessageWithI18n.message("go.error.annotator.too.many.arguments.to.new")).create();
            }
        }

        private void checkMakeCall(@NotNull GoBuiltinCallExpr call) {
            GoBuiltinArgumentList args;
            GoType type2;
            if (call == null) {
                BasicErrorsChecker.$$$reportNull$$$0(41);
            }
            if ((type2 = (args = call.getBuiltinArgumentList()).getType()) == null) {
                this.reportMissingBuiltinCallType(call);
                return;
            }
            PsiElement context = GoReferenceBase.getSubstitutionContextOrSelf(call);
            GoType coreType = GoTypeUtil.getCoreType(type2, context);
            GoInspectionMessageWithI18n error = BasicErrorsChecker.getCannotMakeTypeError(type2, coreType);
            if (error != null) {
                this.myHolder.newErrorAnnotation(type2, (GoInspectionMessage)error).create();
            } else {
                this.checkMakeArguments(call, args.getExpressionList(), coreType, context);
            }
        }

        private void reportMissingBuiltinCallType(@NotNull GoBuiltinCallExpr call) {
            GoBuiltinArgumentList args;
            GoExpression first;
            if (call == null) {
                BasicErrorsChecker.$$$reportNull$$$0(42);
            }
            if ((first = (GoExpression)ContainerUtil.getFirstItem((args = call.getBuiltinArgumentList()).getExpressionList())) != null) {
                this.myHolder.newErrorAnnotation(first, (GoInspectionMessage)GoInspectionMessageWithI18n.message("go.error.annotator.argument.is.not.a.type", first.getText())).create();
            } else {
                this.myHolder.newErrorAnnotation(args, (GoInspectionMessage)GoInspectionMessageWithI18n.message("go.error.annotator.missing.argument.to.make")).create();
            }
        }

        @Nullable
        private static GoInspectionMessageWithI18n getCannotMakeTypeError(@NotNull GoType type2, @Nullable GoType coreType) {
            if (type2 == null) {
                BasicErrorsChecker.$$$reportNull$$$0(43);
            }
            if (coreType == null) {
                return GoInspectionMessageWithI18n.message("go.error.annotator.cannot.make.type.no.single.underlying.type", type2.getPresentationText());
            }
            if (coreType instanceof GoArrayOrSliceType) {
                return ((GoArrayOrSliceType)coreType).getExpression() != null ? GoInspectionMessageWithI18n.message("go.error.annotator.cannot.make.type", type2.getPresentationText()) : null;
            }
            if (coreType instanceof GoChannelType || coreType instanceof GoMapType) {
                return null;
            }
            return GoInspectionMessageWithI18n.message("go.error.annotator.cannot.make.type", type2.getPresentationText());
        }

        private void checkMakeArguments(@NotNull GoBuiltinCallExpr call, @NotNull List<GoExpression> argumentList, @Nullable GoType coreType, @NotNull PsiElement context) {
            boolean capacityIsValid;
            if (call == null) {
                BasicErrorsChecker.$$$reportNull$$$0(44);
            }
            if (argumentList == null) {
                BasicErrorsChecker.$$$reportNull$$$0(45);
            }
            if (context == null) {
                BasicErrorsChecker.$$$reportNull$$$0(46);
            }
            if (!this.processMakeArgumentsCount(call, argumentList, coreType) || argumentList.isEmpty()) {
                return;
            }
            GoExpression sizeExpression = argumentList.get(0);
            GoExpression capacityExpression = (GoExpression)ContainerUtil.getOrElse(argumentList, (int)1, null);
            boolean sizeIsValid = this.checkMakeArgumentType(sizeExpression, true, context) && this.checkMakeArgumentIsNotNegative(sizeExpression, true);
            boolean bl = capacityIsValid = capacityExpression != null && this.checkMakeArgumentType(capacityExpression, false, context) && this.checkMakeArgumentIsNotNegative(capacityExpression, false);
            if (capacityExpression == null && sizeIsValid) {
                this.checkMakeRedundantSize(sizeExpression, coreType);
            }
            if (capacityExpression != null && sizeIsValid && capacityIsValid) {
                this.checkMakeCapacityLessOrEqualSize(sizeExpression, capacityExpression, context);
            }
        }

        private void checkMakeCapacityLessOrEqualSize(@NotNull GoExpression sizeExpression, @NotNull GoExpression capacityExpression, @Nullable PsiElement context) {
            if (sizeExpression == null) {
                BasicErrorsChecker.$$$reportNull$$$0(47);
            }
            if (capacityExpression == null) {
                BasicErrorsChecker.$$$reportNull$$$0(48);
            }
            Long size = (Long)ObjectUtils.doIfNotNull((Object)sizeExpression.getValue(), v -> v.getInteger());
            Long capacity = (Long)ObjectUtils.doIfNotNull((Object)capacityExpression.getValue(), v -> v.getInteger());
            if (size != null && size.equals(capacity) || GoExpressionUtil.identical(sizeExpression, capacityExpression, context) && !GoExpressionUtil.hasSideEffects(sizeExpression)) {
                PsiElement previousComma = PsiTreeUtil.skipWhitespacesAndCommentsBackward((PsiElement)capacityExpression);
                if (GoTypes.COMMA != PsiUtilCore.getElementType((PsiElement)previousComma)) {
                    return;
                }
                this.myHolder.newWeakWarningAnnotation(capacityExpression, GoInspectionMessageWithI18n.message("go.error.annotator.problem.redundant.capacity.hint.to.make")).withFix((IntentionAction)new GoDeleteRangeQuickFix(previousComma, capacityExpression, GoBundle.message((String)"go.fix.delete.redundant.capacity.hint.to.make", (Object[])new Object[0]))).create();
            } else if (size != null && capacity != null && size > capacity) {
                HighlightSeverity severity = sizeExpression.isConstant() && capacityExpression.isConstant() ? HighlightSeverity.ERROR : HighlightSeverity.WARNING;
                this.myHolder.newAnnotation(severity, capacityExpression, GoInspectionMessageWithI18n.message("go.error.annotator.problem.capacity.less.than.size.to.make")).create();
            }
        }

        private void checkMakeRedundantSize(@NotNull GoExpression sizeExpression, @Nullable GoType coreType) {
            if (sizeExpression == null) {
                BasicErrorsChecker.$$$reportNull$$$0(49);
            }
            if (coreType instanceof GoArrayOrSliceType) {
                return;
            }
            Long size = (Long)ObjectUtils.doIfNotNull((Object)sizeExpression.getValue(), v -> v.getInteger());
            if (Objects.equals(size, 0L)) {
                PsiElement previousComma = PsiTreeUtil.skipWhitespacesAndCommentsBackward((PsiElement)sizeExpression);
                if (GoTypes.COMMA != PsiUtilCore.getElementType((PsiElement)previousComma)) {
                    return;
                }
                this.myHolder.newWeakWarningAnnotation(sizeExpression, GoInspectionMessageWithI18n.message("go.error.annotator.problem.redundant.size.hint.to.make")).withFix((IntentionAction)new GoDeleteRangeQuickFix(previousComma, sizeExpression, GoBundle.message((String)"go.fix.delete.redundant.size.hint.to.make", (Object[])new Object[0]))).create();
            }
        }

        private boolean checkMakeArgumentType(@NotNull GoExpression expression, boolean isSizeArgument, @NotNull PsiElement context) {
            if (expression == null) {
                BasicErrorsChecker.$$$reportNull$$$0(50);
            }
            if (context == null) {
                BasicErrorsChecker.$$$reportNull$$$0(51);
            }
            ResolveState state = GoPsiImplUtil.createContextOnElement(context);
            GoType type2 = expression.getGoUnderlyingType(state);
            GoType int64 = GoPsiImplUtil.getBuiltinType("int64", context);
            if (int64 == null || type2 == null || GoTypeUtil.isUnresolvedType(type2, state)) {
                return false;
            }
            if (GoTypeUtil.isIntegerType(type2, context) || GoTypeUtil.isCType(type2, context) || GoTypeUtil.isUntypedNumericType(type2) && ThreeState.NO != GoInvalidExpressionConversionInspection.isRepresentable(expression, type2, int64, false, context)) {
                return true;
            }
            GoInspectionMessageWithI18n message = isSizeArgument ? GoInspectionMessageWithI18n.message("go.error.annotator.non.integer.size.argument.to.make") : GoInspectionMessageWithI18n.message("go.error.annotator.non.integer.capacity.argument.to.make");
            this.myHolder.newErrorAnnotation(expression, (GoInspectionMessage)message).create();
            return false;
        }

        private boolean checkMakeArgumentIsNotNegative(@NotNull GoExpression expression, boolean isSizeArgument) {
            Long value;
            if (expression == null) {
                BasicErrorsChecker.$$$reportNull$$$0(52);
            }
            if ((value = (Long)ObjectUtils.doIfNotNull((Object)expression.getValue(), v -> v.getInteger())) == null || value >= 0L) {
                return true;
            }
            GoInspectionMessageWithI18n message = isSizeArgument ? GoInspectionMessageWithI18n.message("go.error.annotator.problem.negative.size.to.make") : GoInspectionMessageWithI18n.message("go.error.annotator.problem.negative.capacity.to.make");
            HighlightSeverity severity = expression.isConstant() ? HighlightSeverity.ERROR : HighlightSeverity.WARNING;
            this.myHolder.newAnnotation(severity, expression, message).create();
            return false;
        }

        @Contract(value="_, _, null -> true")
        private boolean processMakeArgumentsCount(@NotNull GoBuiltinCallExpr call, @NotNull List<GoExpression> list, @Nullable GoType coreType) {
            if (call == null) {
                BasicErrorsChecker.$$$reportNull$$$0(53);
            }
            if (list == null) {
                BasicErrorsChecker.$$$reportNull$$$0(54);
            }
            if (coreType instanceof GoArrayOrSliceType) {
                if (list.isEmpty()) {
                    this.myHolder.newErrorAnnotation(call, (GoInspectionMessage)GoInspectionMessageWithI18n.message("go.error.annotator.missing.len.argument.to.make")).create();
                    return false;
                }
                if (list.size() > 2) {
                    this.myHolder.newErrorAnnotation(call, (GoInspectionMessage)GoInspectionMessageWithI18n.message("go.error.annotator.too.many.arguments.to.make")).create();
                    return false;
                }
            }
            if ((coreType instanceof GoChannelType || coreType instanceof GoMapType) && list.size() > 1) {
                this.myHolder.newErrorAnnotation(call, (GoInspectionMessage)GoInspectionMessageWithI18n.message("go.error.annotator.too.many.arguments.to.make")).create();
                return false;
            }
            return true;
        }

        private static boolean isIllegalUseOfTypeAsExpression(@NotNull PsiElement e) {
            PsiElement parent;
            if (e == null) {
                BasicErrorsChecker.$$$reportNull$$$0(55);
            }
            if ((parent = PsiTreeUtil.skipParentsOfType((PsiElement)e, (Class[])new Class[]{GoParenthesesExpr.class, GoUnaryExpr.class})) instanceof GoReferenceExpression) {
                return false;
            }
            if (parent instanceof GoIndexOrSliceExpr) {
                GoNamedElement decl = GoPsiUtil.resolveInstantiatedDeclaration((GoIndexOrSliceExpr)parent);
                PsiElement grandParent = PsiTreeUtil.skipParentsOfType((PsiElement)parent, (Class[])new Class[]{GoParenthesesExpr.class, GoUnaryExpr.class});
                return decl == null || decl instanceof GoTypeSpec && PsiTreeUtil.isAncestor((PsiElement)((GoIndexOrSliceExpr)parent).getExpression(), (PsiElement)e, (boolean)false) && !(grandParent instanceof GoCallExpr) && !(grandParent instanceof GoIndexOrSliceExpr) && !GoAnnotator.isInQualifierOfRefExpression(parent, grandParent);
            }
            return !(parent instanceof GoCallExpr) && !(parent instanceof GoBuiltinCallExpr);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 26 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "holder";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "element";
                    break;
                }
                case 2: 
                case 3: 
                case 16: 
                case 17: 
                case 21: 
                case 22: 
                case 23: 
                case 27: 
                case 28: 
                case 29: 
                case 30: 
                case 32: 
                case 33: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "o";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "field";
                    break;
                }
                case 5: 
                case 6: 
                case 7: 
                case 11: 
                case 12: 
                case 13: 
                case 14: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "ref";
                    break;
                }
                case 8: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "namedElement";
                    break;
                }
                case 9: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "usage";
                    break;
                }
                case 10: 
                case 15: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "resolve";
                    break;
                }
                case 18: 
                case 50: 
                case 52: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "expression";
                    break;
                }
                case 19: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "typeAssertionExpr";
                    break;
                }
                case 20: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "typeAssertionOrGuard";
                    break;
                }
                case 24: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "callExpression";
                    break;
                }
                case 25: 
                case 36: 
                case 37: 
                case 40: 
                case 41: 
                case 42: 
                case 44: 
                case 53: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "call";
                    break;
                }
                case 26: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/goide/highlighting/GoAnnotator$BasicErrorsChecker";
                    break;
                }
                case 31: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "leftHandExprList";
                    break;
                }
                case 34: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "comment";
                    break;
                }
                case 35: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "arrayOrSliceType";
                    break;
                }
                case 38: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "spec";
                    break;
                }
                case 39: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "definition";
                    break;
                }
                case 43: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "type";
                    break;
                }
                case 45: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "argumentList";
                    break;
                }
                case 46: 
                case 51: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "context";
                    break;
                }
                case 47: 
                case 49: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "sizeExpression";
                    break;
                }
                case 48: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "capacityExpression";
                    break;
                }
                case 54: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "list";
                    break;
                }
                case 55: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "e";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/goide/highlighting/GoAnnotator$BasicErrorsChecker";
                    break;
                }
                case 26: {
                    objectArray = objectArray2;
                    objectArray2[1] = "multipleValueInSingleValueContextMessage";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "visitPackageClause";
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "visitContinueStatement";
                    break;
                }
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "visitBreakStatement";
                    break;
                }
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "visitFieldName";
                    break;
                }
                case 5: {
                    objectArray = objectArray;
                    objectArray[2] = "visitReferenceExpression";
                    break;
                }
                case 6: {
                    objectArray = objectArray;
                    objectArray[2] = "checkUnexportedReferenceUsage";
                    break;
                }
                case 7: 
                case 8: {
                    objectArray = objectArray;
                    objectArray[2] = "createUnexportedReferenceUsageError";
                    break;
                }
                case 9: 
                case 10: {
                    objectArray = objectArray;
                    objectArray[2] = "isUnexportedAllowed";
                    break;
                }
                case 11: {
                    objectArray = objectArray;
                    objectArray[2] = "checkInvalidPackageReferenceUsage";
                    break;
                }
                case 12: {
                    objectArray = objectArray;
                    objectArray[2] = "checkIllegalTypeReference";
                    break;
                }
                case 13: {
                    objectArray = objectArray;
                    objectArray[2] = "visitTypeReferenceExpression";
                    break;
                }
                case 14: 
                case 15: {
                    objectArray = objectArray;
                    objectArray[2] = "isNilCaseOfTypeSwitch";
                    break;
                }
                case 16: {
                    objectArray = objectArray;
                    objectArray[2] = "visitCompositeLit";
                    break;
                }
                case 17: {
                    objectArray = objectArray;
                    objectArray[2] = "visitTypeAssertionExpr";
                    break;
                }
                case 18: 
                case 19: 
                case 20: {
                    objectArray = objectArray;
                    objectArray[2] = "checkTypeAssertionExpression";
                    break;
                }
                case 21: {
                    objectArray = objectArray;
                    objectArray[2] = "visitMapType";
                    break;
                }
                case 22: {
                    objectArray = objectArray;
                    objectArray[2] = "visitBuiltinCallExpr";
                    break;
                }
                case 23: {
                    objectArray = objectArray;
                    objectArray[2] = "visitCallExpr";
                    break;
                }
                case 24: {
                    objectArray = objectArray;
                    objectArray[2] = "isMultipleValueInSingleValueContext";
                    break;
                }
                case 25: {
                    objectArray = objectArray;
                    objectArray[2] = "multipleValueInSingleValueContextMessage";
                    break;
                }
                case 26: {
                    break;
                }
                case 27: {
                    objectArray = objectArray;
                    objectArray[2] = "visitTypeDeclaration";
                    break;
                }
                case 28: {
                    objectArray = objectArray;
                    objectArray[2] = "visitVarOrConstDeclaration";
                    break;
                }
                case 29: {
                    objectArray = objectArray;
                    objectArray[2] = "visitFunctionDeclaration";
                    break;
                }
                case 30: {
                    objectArray = objectArray;
                    objectArray[2] = "visitIndexOrSliceExpr";
                    break;
                }
                case 31: {
                    objectArray = objectArray;
                    objectArray[2] = "visitLeftHandExprList";
                    break;
                }
                case 32: {
                    objectArray = objectArray;
                    objectArray[2] = "visitIfStatement";
                    break;
                }
                case 33: {
                    objectArray = objectArray;
                    objectArray[2] = "visitFallthroughStatement";
                    break;
                }
                case 34: {
                    objectArray = objectArray;
                    objectArray[2] = "visitComment";
                    break;
                }
                case 35: {
                    objectArray = objectArray;
                    objectArray[2] = "visitArrayOrSliceType";
                    break;
                }
                case 36: {
                    objectArray = objectArray;
                    objectArray[2] = "checkCapOrLenCall";
                    break;
                }
                case 37: {
                    objectArray = objectArray;
                    objectArray[2] = "checkMinMaxClearCall";
                    break;
                }
                case 38: 
                case 39: {
                    objectArray = objectArray;
                    objectArray[2] = "checkInitTextMatches";
                    break;
                }
                case 40: {
                    objectArray = objectArray;
                    objectArray[2] = "checkNewCall";
                    break;
                }
                case 41: {
                    objectArray = objectArray;
                    objectArray[2] = "checkMakeCall";
                    break;
                }
                case 42: {
                    objectArray = objectArray;
                    objectArray[2] = "reportMissingBuiltinCallType";
                    break;
                }
                case 43: {
                    objectArray = objectArray;
                    objectArray[2] = "getCannotMakeTypeError";
                    break;
                }
                case 44: 
                case 45: 
                case 46: {
                    objectArray = objectArray;
                    objectArray[2] = "checkMakeArguments";
                    break;
                }
                case 47: 
                case 48: {
                    objectArray = objectArray;
                    objectArray[2] = "checkMakeCapacityLessOrEqualSize";
                    break;
                }
                case 49: {
                    objectArray = objectArray;
                    objectArray[2] = "checkMakeRedundantSize";
                    break;
                }
                case 50: 
                case 51: {
                    objectArray = objectArray;
                    objectArray[2] = "checkMakeArgumentType";
                    break;
                }
                case 52: {
                    objectArray = objectArray;
                    objectArray[2] = "checkMakeArgumentIsNotNegative";
                    break;
                }
                case 53: 
                case 54: {
                    objectArray = objectArray;
                    objectArray[2] = "processMakeArgumentsCount";
                    break;
                }
                case 55: {
                    objectArray = objectArray;
                    objectArray[2] = "isIllegalUseOfTypeAsExpression";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 26 -> new IllegalStateException(string);
            };
        }
    }

    @TestOnly
    public static interface InspectionVisitorConstructor
    extends Function<GoProblemsHolder, GoVisitor> {
    }
}

