/*
 * Decompiled with CFR 0.152.
 */
package com.goide.formatter;

import com.goide.GoTypes;
import com.goide.formatter.GoFormattingBlock;
import com.goide.formatter.GoFormattingContext;
import com.goide.formatter.GoFormattingRules;
import com.goide.psi.GoAssignmentStatement;
import com.goide.psi.GoBinaryExpr;
import com.goide.psi.GoBlock;
import com.goide.psi.GoBuiltinCallExpr;
import com.goide.psi.GoCallExpr;
import com.goide.psi.GoCompositeElement;
import com.goide.psi.GoCompositeLit;
import com.goide.psi.GoConstSpec;
import com.goide.psi.GoElement;
import com.goide.psi.GoExprSwitchStatement;
import com.goide.psi.GoExpression;
import com.goide.psi.GoFieldDeclaration;
import com.goide.psi.GoFunctionOrMethodDeclaration;
import com.goide.psi.GoIncDecStatement;
import com.goide.psi.GoIndexOrSliceExpr;
import com.goide.psi.GoInterfaceType;
import com.goide.psi.GoLiteral;
import com.goide.psi.GoMethodSpec;
import com.goide.psi.GoParenthesesExpr;
import com.goide.psi.GoPsiTreeUtil;
import com.goide.psi.GoRecursiveVisitor;
import com.goide.psi.GoShortVarDeclaration;
import com.goide.psi.GoSignature;
import com.goide.psi.GoSignatureOwner;
import com.goide.psi.GoStatement;
import com.goide.psi.GoStructType;
import com.goide.psi.GoTopLevelDeclaration;
import com.goide.psi.GoType;
import com.goide.psi.GoTypeSwitchStatement;
import com.goide.psi.GoUnaryExpr;
import com.goide.psi.GoVarSpec;
import com.goide.psi.GoVisitor;
import com.intellij.formatting.Block;
import com.intellij.lang.ASTNode;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.SmartPointerManager;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.psi.SyntaxTraverser;
import com.intellij.psi.TokenType;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.psi.impl.source.tree.LeafElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.TreeTraversal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Function;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class GoFormatterUtil {
    private static int countParents(@NotNull PsiElement o, @NotNull PsiElement ancestor, @NotNull Condition<PsiElement> condition) {
        if (o == null) {
            GoFormatterUtil.$$$reportNull$$$0(0);
        }
        if (ancestor == null) {
            GoFormatterUtil.$$$reportNull$$$0(1);
        }
        if (condition == null) {
            GoFormatterUtil.$$$reportNull$$$0(2);
        }
        return GoPsiTreeUtil.goTraverser().api.parents((Object)o).takeWhile(e -> e != ancestor).append((Object)ancestor).filter(condition).size();
    }

    public static boolean consistsOfCommentsAndWhitespaces(@NotNull PsiElement e) {
        if (e == null) {
            GoFormatterUtil.$$$reportNull$$$0(3);
        }
        return (Boolean)CachedValuesManager.getCachedValue((PsiElement)e, () -> {
            for (PsiElement element : e.getChildren()) {
                if (element instanceof PsiWhiteSpace || element instanceof PsiComment) continue;
                return CachedValueProvider.Result.create((Object)false, (Object[])new Object[]{e});
            }
            return CachedValueProvider.Result.create((Object)true, (Object[])new Object[]{e});
        });
    }

    private static int countEssentialChildren(@Nullable PsiElement o) {
        return o instanceof GoInterfaceType ? ((GoInterfaceType)o).getMethodSpecList().size() : (o instanceof GoStructType ? ((GoStructType)o).getFieldDeclarationList().size() : (o instanceof GoBlock ? ((GoBlock)o).getStatementList().size() : -1));
    }

    private static boolean isMultilineHeavy(@NotNull PsiElement element, @NotNull GoFormattingRules formattingRules) {
        if (element == null) {
            GoFormatterUtil.$$$reportNull$$$0(4);
        }
        if (formattingRules == null) {
            GoFormatterUtil.$$$reportNull$$$0(5);
        }
        MultilineChecker checker = new MultilineChecker(element, formattingRules);
        element.accept((PsiElementVisitor)checker);
        return checker.isMultiline;
    }

    static int countNewLinesBetween(@NotNull PsiElement firstSibling, @NotNull PsiElement secondSibling) {
        PsiElement parent;
        if (firstSibling == null) {
            GoFormatterUtil.$$$reportNull$$$0(6);
        }
        if (secondSibling == null) {
            GoFormatterUtil.$$$reportNull$$$0(7);
        }
        if ((parent = firstSibling.getParent()) == null || !parent.equals(secondSibling.getParent())) {
            return 0;
        }
        int i = 0;
        for (PsiElement e = firstSibling.getNextSibling(); e != secondSibling; e = e.getNextSibling()) {
            if (e == null) {
                return 0;
            }
            if (!(e instanceof PsiWhiteSpace) && !(e instanceof PsiComment)) continue;
            i += StringUtil.countNewLines((CharSequence)e.getText());
        }
        return i;
    }

    static int countNewLinesBetweenLeafs(@NotNull PsiElement element1, @NotNull PsiElement element2) {
        if (element1 == null) {
            GoFormatterUtil.$$$reportNull$$$0(8);
        }
        if (element2 == null) {
            GoFormatterUtil.$$$reportNull$$$0(9);
        }
        if (element1 == element2) {
            return 0;
        }
        int newLineCount = 0;
        PsiElement element = PsiTreeUtil.nextLeaf((PsiElement)element1);
        while (element != null && element != element2) {
            if (element instanceof PsiWhiteSpace || element instanceof PsiComment) {
                newLineCount += StringUtil.countNewLines((CharSequence)element.getText());
            }
            element = PsiTreeUtil.nextLeaf((PsiElement)element);
        }
        return newLineCount;
    }

    static boolean isMultiline(@Nullable PsiElement e, @NotNull GoFormattingRules formattingRules) {
        if (formattingRules == null) {
            GoFormatterUtil.$$$reportNull$$$0(10);
        }
        if (e == null) {
            return false;
        }
        for (ASTNode node : SyntaxTraverser.astTraverser((ASTNode)e.getNode()).traverse(TreeTraversal.LEAVES_BFS)) {
            if (!(node instanceof LeafElement) || !node.textContains('\n')) continue;
            return true;
        }
        return GoFormatterUtil.isMultilineHeavy(e, formattingRules);
    }

    public static boolean isFirstElementOnLine(@Nullable PsiElement element) {
        if (element == null) {
            return false;
        }
        while ((element = PsiTreeUtil.prevLeaf((PsiElement)element, (boolean)true)) != null) {
            if (!(element instanceof PsiWhiteSpace)) {
                return false;
            }
            if (!element.textContains('\n')) continue;
            return true;
        }
        return true;
    }

    public static boolean isLastElementOnLine(@Nullable PsiElement element) {
        if (element == null) {
            return false;
        }
        while ((element = PsiTreeUtil.nextLeaf((PsiElement)element, (boolean)true)) != null) {
            if (!(element instanceof PsiWhiteSpace)) {
                return false;
            }
            if (!element.textContains('\n')) continue;
            return true;
        }
        return true;
    }

    static boolean isLongOneLineFunctionBlock(@Nullable PsiElement element) {
        GoBlock block = (GoBlock)ObjectUtils.tryCast((Object)element, GoBlock.class);
        PsiElement parent = block != null ? block.getParent() : null;
        GoFunctionOrMethodDeclaration declaration = (GoFunctionOrMethodDeclaration)ObjectUtils.tryCast((Object)parent, GoFunctionOrMethodDeclaration.class);
        if (declaration == null) {
            return false;
        }
        String blockText = block.getText();
        if (StringUtil.containsLineBreak((CharSequence)blockText)) {
            return false;
        }
        List<GoStatement> children = block.getStatementList();
        if (children.size() > 5) {
            return true;
        }
        String header = TextRange.create((int)0, (int)block.getStartOffsetInParent()).substring(declaration.getText());
        int headerSize = header.trim().length();
        int blockSize = 0;
        for (int i = 0; i < children.size(); ++i) {
            PsiElement child = children.get(i);
            if (i > 0) {
                blockSize += 2;
            }
            blockSize += child.getText().length();
        }
        return headerSize + blockSize > 100;
    }

    static void addSubBlocks(@NotNull GoFormattingBlock parent, ASTNode start, @NotNull ASTNode stop, @NotNull List<Block> blocks) {
        if (parent == null) {
            GoFormatterUtil.$$$reportNull$$$0(11);
        }
        if (stop == null) {
            GoFormatterUtil.$$$reportNull$$$0(12);
        }
        if (blocks == null) {
            GoFormatterUtil.$$$reportNull$$$0(13);
        }
        for (ASTNode node = start; node != null && node != stop; node = node.getTreeNext()) {
            if (GoFormatterUtil.isEmptyOrWhitespace(node)) continue;
            blocks.add((Block)new GoFormattingBlock(parent, node, null, null, null, null));
        }
    }

    static boolean isEmptyOrWhitespace(@NotNull ASTNode node) {
        if (node == null) {
            GoFormatterUtil.$$$reportNull$$$0(14);
        }
        return node.getTextLength() == 0 || node.getElementType() == TokenType.WHITE_SPACE;
    }

    static int getChildExprDepth(@NotNull GoFormattingBlock block, @NotNull PsiElement childElement) {
        GoElement elementExpr;
        if (block == null) {
            GoFormatterUtil.$$$reportNull$$$0(15);
        }
        if (childElement == null) {
            GoFormatterUtil.$$$reportNull$$$0(16);
        }
        PsiElement psi = block.getNode().getPsi();
        int parentDepth = block.getExprDepth();
        GoBinaryExpr binaryExpr = (GoBinaryExpr)ObjectUtils.tryCast((Object)psi, GoBinaryExpr.class);
        if (binaryExpr != null) {
            if (childElement == binaryExpr.getLeft()) {
                PsiElement operator = binaryExpr.getOperator();
                int diff = operator != null ? GoFormatterUtil.diffPrecedence(binaryExpr.getLeft(), GoFormatterUtil.getPrecedence(operator.getNode().getElementType())) : 0;
                return parentDepth + diff;
            }
            if (childElement == binaryExpr.getRight()) {
                return parentDepth + 1;
            }
        }
        if ((elementExpr = (GoElement)ObjectUtils.tryCast((Object)psi, GoElement.class)) != null && (childElement == elementExpr.getKey() || childElement == elementExpr.getValue())) {
            return 1;
        }
        GoUnaryExpr unaryExpr = (GoUnaryExpr)ObjectUtils.tryCast((Object)psi, GoUnaryExpr.class);
        if (unaryExpr != null) {
            if (unaryExpr.getMul() != null) {
                return 1;
            }
            return parentDepth;
        }
        if (psi instanceof GoLiteral) {
            return 1;
        }
        if (psi instanceof GoParenthesesExpr) {
            return GoFormatterUtil.reduceDepth(parentDepth);
        }
        GoIndexOrSliceExpr indexExpr = (GoIndexOrSliceExpr)ObjectUtils.tryCast((Object)psi, GoIndexOrSliceExpr.class);
        if (indexExpr != null) {
            if (childElement == indexExpr.getExpression()) {
                return 1;
            }
            return parentDepth + 1;
        }
        GoCallExpr callExpr = (GoCallExpr)ObjectUtils.tryCast((Object)psi, GoCallExpr.class);
        if (callExpr != null) {
            return callExpr.getArgumentList().getExpressionList().size() > 1 ? parentDepth + 1 : parentDepth;
        }
        GoBuiltinCallExpr builtinCallExpr = (GoBuiltinCallExpr)ObjectUtils.tryCast((Object)psi, GoBuiltinCallExpr.class);
        if (builtinCallExpr != null) {
            int argCount = builtinCallExpr.getBuiltinArgumentList().getExpressionList().size();
            if (builtinCallExpr.getBuiltinArgumentList().getType() != null) {
                ++argCount;
            }
            return argCount > 1 ? parentDepth + 1 : parentDepth;
        }
        GoCompositeLit compositeLit = (GoCompositeLit)ObjectUtils.tryCast((Object)psi, GoCompositeLit.class);
        if (compositeLit != null) {
            return childElement == compositeLit.getType() ? parentDepth : 1;
        }
        if (psi instanceof GoType) {
            return 1;
        }
        if (psi instanceof GoAssignmentStatement) {
            GoAssignmentStatement assignment = (GoAssignmentStatement)psi;
            return assignment.getLeftHandExprList().getExpressionList().size() > 1 && assignment.getExpressionList().size() > 1 ? 2 : 1;
        }
        if (psi instanceof GoShortVarDeclaration) {
            GoShortVarDeclaration declaration = (GoShortVarDeclaration)psi;
            return declaration.getDefinitionList().size() > 1 && declaration.getRightExpressionsList().size() > 1 ? 2 : 1;
        }
        if (psi instanceof GoConstSpec || psi instanceof GoVarSpec) {
            return 1;
        }
        if (psi instanceof GoIncDecStatement) {
            return 2;
        }
        if (psi instanceof GoStatement) {
            return 1;
        }
        return parentDepth;
    }

    private static int reduceDepth(int depth) {
        return Math.max(depth - 1, 1);
    }

    static int diffPrecedence(@NotNull GoExpression expr, int precedence) {
        GoBinaryExpr binaryExpr;
        if (expr == null) {
            GoFormatterUtil.$$$reportNull$$$0(17);
        }
        PsiElement operator = (binaryExpr = (GoBinaryExpr)ObjectUtils.tryCast((Object)expr, GoBinaryExpr.class)) != null ? binaryExpr.getOperator() : null;
        return binaryExpr == null || operator != null && GoFormatterUtil.getPrecedence(operator.getNode().getElementType()) != precedence ? 1 : 0;
    }

    static int cutoff(@NotNull GoFormattingContext context, @NotNull GoBinaryExpr expr, int depth) {
        if (context == null) {
            GoFormatterUtil.$$$reportNull$$$0(18);
        }
        if (expr == null) {
            GoFormatterUtil.$$$reportNull$$$0(19);
        }
        WalkBinaryResult walk = GoFormatterUtil.walkBinary(context, expr);
        if (walk.maxProblem > 0) {
            return walk.maxProblem + 1;
        }
        if (walk.has4 && walk.has5) {
            return depth == 1 ? 5 : 4;
        }
        return depth == 1 ? 6 : 4;
    }

    @NotNull
    private static WalkBinaryResult walkBinary(@NotNull GoFormattingContext context, @NotNull GoBinaryExpr expr) {
        GoExpression right;
        WalkBinaryResult result;
        if (context == null) {
            GoFormatterUtil.$$$reportNull$$$0(20);
        }
        if (expr == null) {
            GoFormatterUtil.$$$reportNull$$$0(21);
        }
        if ((result = context.getCachedWalkBinaryResult(expr)) != null) {
            WalkBinaryResult walkBinaryResult = result;
            if (walkBinaryResult == null) {
                GoFormatterUtil.$$$reportNull$$$0(22);
            }
            return walkBinaryResult;
        }
        boolean has4 = false;
        boolean has5 = false;
        int maxProblem = 0;
        PsiElement operator = expr.getOperator();
        if (operator != null) {
            int precedence = GoFormatterUtil.getPrecedence(operator.getNode().getElementType());
            has4 = precedence == 4;
            boolean bl = has5 = precedence == 5;
        }
        if (expr.getLeft() instanceof GoBinaryExpr) {
            WalkBinaryResult leftWalk = GoFormatterUtil.walkBinary(context, (GoBinaryExpr)expr.getLeft());
            has4 = has4 || leftWalk.has4;
            has5 = has5 || leftWalk.has5;
            maxProblem = Math.max(maxProblem, leftWalk.maxProblem);
        }
        if ((right = expr.getRight()) instanceof GoBinaryExpr) {
            WalkBinaryResult rightWalk = GoFormatterUtil.walkBinary(context, (GoBinaryExpr)right);
            has4 = has4 || rightWalk.has4;
            has5 = has5 || rightWalk.has5;
            maxProblem = Math.max(maxProblem, rightWalk.maxProblem);
        }
        if (right instanceof GoUnaryExpr) {
            PsiElement unaryOperator = ((GoUnaryExpr)right).getOperator();
            if (operator != null && unaryOperator != null) {
                String concat;
                maxProblem = switch (concat = operator.getText() + unaryOperator.getText()) {
                    case "/*", "&&", "&^" -> 5;
                    case "++", "--" -> Math.max(maxProblem, 4);
                    default -> maxProblem;
                };
            }
        }
        result = new WalkBinaryResult(has4, has5, maxProblem);
        context.setCachedWalkBinaryResult(expr, result);
        WalkBinaryResult walkBinaryResult = result;
        if (walkBinaryResult == null) {
            GoFormatterUtil.$$$reportNull$$$0(23);
        }
        return walkBinaryResult;
    }

    static int getPrecedence(@NotNull IElementType token) {
        if (token == null) {
            GoFormatterUtil.$$$reportNull$$$0(24);
        }
        if (token == GoTypes.COND_OR) {
            return 1;
        }
        if (token == GoTypes.COND_AND) {
            return 2;
        }
        if (token == GoTypes.EQ || token == GoTypes.NOT_EQ || token == GoTypes.LESS || token == GoTypes.LESS_OR_EQUAL || token == GoTypes.GREATER || token == GoTypes.GREATER_OR_EQUAL) {
            return 3;
        }
        if (token == GoTypes.PLUS || token == GoTypes.MINUS || token == GoTypes.BIT_OR || token == GoTypes.BIT_XOR) {
            return 4;
        }
        if (token == GoTypes.MUL || token == GoTypes.QUOTIENT || token == GoTypes.REMAINDER || token == GoTypes.SHIFT_LEFT || token == GoTypes.SHIFT_RIGHT || token == GoTypes.BIT_AND || token == GoTypes.BIT_CLEAR) {
            return 5;
        }
        return 0;
    }

    public static void reformat(@Nullable PsiElement element) {
        PsiFile file;
        PsiFile psiFile = file = element != null ? element.getContainingFile() : null;
        if (file != null) {
            GoFormatterUtil.reformat(file, Collections.singletonList(element));
        }
    }

    public static void reformat(@NotNull PsiFile file, @NotNull Collection<? extends PsiElement> elements) {
        if (file == null) {
            GoFormatterUtil.$$$reportNull$$$0(25);
        }
        if (elements == null) {
            GoFormatterUtil.$$$reportNull$$$0(26);
        }
        List pointers = ContainerUtil.map(elements, it -> SmartPointerManager.createPointer((PsiElement)it));
        GoFormatterUtil.prepareFormatter(file);
        ArrayList<TextRange> ranges = new ArrayList<TextRange>();
        for (SmartPsiElementPointer pointer : pointers) {
            PsiElement element = pointer.getElement();
            if (element == null || !element.isValid()) continue;
            ranges.add(element.getTextRange());
        }
        CodeStyleManager.getInstance((Project)file.getProject()).reformatText(file, ranges);
    }

    private static void prepareFormatter(@NotNull PsiFile file) {
        Document document;
        if (file == null) {
            GoFormatterUtil.$$$reportNull$$$0(27);
        }
        if ((document = file.getViewProvider().getDocument()) != null) {
            PsiDocumentManager.getInstance((Project)file.getProject()).commitDocument(document);
            PsiDocumentManager.getInstance((Project)file.getProject()).doPostponedOperationsAndUnblockDocument(document);
        }
    }

    @NotNull
    public static List<PsiElement> collectProblems(@NotNull Function<Consumer<PsiElement>, GoVisitor> visitorFactory, @NotNull PsiElement root, @NotNull TextRange range) {
        if (visitorFactory == null) {
            GoFormatterUtil.$$$reportNull$$$0(28);
        }
        if (root == null) {
            GoFormatterUtil.$$$reportNull$$$0(29);
        }
        if (range == null) {
            GoFormatterUtil.$$$reportNull$$$0(30);
        }
        ArrayList problemElements = new ArrayList();
        final GoVisitor visitor2 = visitorFactory.apply(problemElements::add);
        GoRecursiveVisitor recursiveVisitor = new GoRecursiveVisitor(){

            public void visitElement(@NotNull PsiElement element) {
                if (element == null) {
                    1.$$$reportNull$$$0(0);
                }
                element.accept((PsiElementVisitor)visitor2);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/goide/formatter/GoFormatterUtil$1", "visitElement"));
            }
        };
        root.accept((PsiElementVisitor)recursiveVisitor);
        List list = ContainerUtil.filter(problemElements, element -> range.contains(element.getTextRange()));
        if (list == null) {
            GoFormatterUtil.$$$reportNull$$$0(31);
        }
        return list;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 22, 23, 31 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "o";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ancestor";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "condition";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 5: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "formattingRules";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "firstSibling";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "secondSibling";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element1";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element2";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parent";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "stop";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "blocks";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "block";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "childElement";
                break;
            }
            case 17: 
            case 19: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expr";
                break;
            }
            case 18: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 22: 
            case 23: 
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/goide/formatter/GoFormatterUtil";
                break;
            }
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "token";
                break;
            }
            case 25: 
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elements";
                break;
            }
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "visitorFactory";
                break;
            }
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "root";
                break;
            }
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "range";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/goide/formatter/GoFormatterUtil";
                break;
            }
            case 22: 
            case 23: {
                objectArray = objectArray2;
                objectArray2[1] = "walkBinary";
                break;
            }
            case 31: {
                objectArray = objectArray2;
                objectArray2[1] = "collectProblems";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "countParents";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "consistsOfCommentsAndWhitespaces";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "isMultilineHeavy";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "countNewLinesBetween";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "countNewLinesBetweenLeafs";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "isMultiline";
                break;
            }
            case 11: 
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "addSubBlocks";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "isEmptyOrWhitespace";
                break;
            }
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "getChildExprDepth";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "diffPrecedence";
                break;
            }
            case 18: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "cutoff";
                break;
            }
            case 20: 
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "walkBinary";
                break;
            }
            case 22: 
            case 23: 
            case 31: {
                break;
            }
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "getPrecedence";
                break;
            }
            case 25: 
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "reformat";
                break;
            }
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "prepareFormatter";
                break;
            }
            case 28: 
            case 29: 
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "collectProblems";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 22, 23, 31 -> new IllegalStateException(string);
        };
    }

    private static final class MultilineChecker
    extends GoRecursiveVisitor {
        private static final TokenSet MULTILINE_STATEMENTS = TokenSet.create((IElementType[])new IElementType[]{GoTypes.BLOCK, GoTypes.SWITCH, GoTypes.IF_STATEMENT, GoTypes.LABELED_STATEMENT, GoTypes.FOR_STATEMENT});
        private static final int ONE_LINE_FUNC_DEPTH = 6;
        private static final int ONE_LINE_BLOCK_WIDTH = 5;
        private boolean isMultiline;
        private final PsiElement myAncestor;
        @NotNull
        private final GoFormattingRules myFormattingRules;

        private MultilineChecker(@NotNull PsiElement element, @NotNull GoFormattingRules formattingRules) {
            if (element == null) {
                MultilineChecker.$$$reportNull$$$0(0);
            }
            if (formattingRules == null) {
                MultilineChecker.$$$reportNull$$$0(1);
            }
            this.myAncestor = element;
            this.myFormattingRules = formattingRules;
        }

        @Override
        public void visitCompositeElement(@NotNull GoCompositeElement o) {
            IElementType type2;
            if (o == null) {
                MultilineChecker.$$$reportNull$$$0(2);
            }
            if (this.isMultiline) {
                return;
            }
            super.visitCompositeElement(o);
            ASTNode node = o.getNode();
            IElementType iElementType = type2 = node == null ? null : node.getElementType();
            if (MULTILINE_STATEMENTS.contains(type2) && !(o.getParent() instanceof GoSignatureOwner)) {
                this.isMultiline = true;
            }
        }

        @Override
        public void visitInterfaceType(@NotNull GoInterfaceType o) {
            if (o == null) {
                MultilineChecker.$$$reportNull$$$0(3);
            }
            super.visitInterfaceType(o);
            this.checkForMultiline(o, this.myFormattingRules.allowOnelineInterfaces() ? 1 : 0);
        }

        @Override
        public void visitStructType(@NotNull GoStructType o) {
            if (o == null) {
                MultilineChecker.$$$reportNull$$$0(4);
            }
            super.visitStructType(o);
            this.checkForMultiline(o, 1);
        }

        private void checkForMultiline(@NotNull GoType o, int allowedChildrenCount) {
            if (o == null) {
                MultilineChecker.$$$reportNull$$$0(5);
            }
            if (GoFormatterUtil.countEssentialChildren(o) > allowedChildrenCount) {
                this.isMultiline = true;
            } else {
                GoFieldDeclaration field;
                int maxSize = 30;
                if (o instanceof GoStructType && (field = (GoFieldDeclaration)ContainerUtil.getOnlyItem(((GoStructType)o).getFieldDeclarationList())) != null) {
                    int namesSize = field.getFieldDefinitionList().isEmpty() ? 0 : 1;
                    GoType type2 = field.getType();
                    if (field.getTag() != null || PsiTreeUtil.getChildOfType((PsiElement)o, PsiComment.class) != null || type2 != null && namesSize + type2.getTextLength() > maxSize) {
                        this.isMultiline = true;
                    }
                }
                if (o instanceof GoInterfaceType) {
                    GoSignature signature;
                    GoMethodSpec method = (GoMethodSpec)ContainerUtil.getOnlyItem(((GoInterfaceType)o).getMethodSpecList());
                    GoSignature goSignature = signature = method != null ? method.getSignature() : null;
                    if (PsiTreeUtil.getChildOfType((PsiElement)o, PsiComment.class) != null || signature != null && 5 + signature.getTextLength() > maxSize) {
                        this.isMultiline = true;
                    }
                }
            }
        }

        @Override
        public void visitSignature(@NotNull GoSignature o) {
            if (o == null) {
                MultilineChecker.$$$reportNull$$$0(6);
            }
            super.visitSignature(o);
            PsiElement parent = o.getParent();
            if (parent instanceof GoSignatureOwner) {
                this.visitSignatureOwner((GoSignatureOwner)parent);
            }
        }

        @Override
        public void visitTopLevelDeclaration(@NotNull GoTopLevelDeclaration o) {
            if (o == null) {
                MultilineChecker.$$$reportNull$$$0(7);
            }
            super.visitTopLevelDeclaration(o);
            if (o instanceof GoFunctionOrMethodDeclaration) {
                return;
            }
            ASTNode node = o.getNode();
            if (node == null) {
                return;
            }
            ASTNode[] parens = node.getChildren(TokenSet.create((IElementType[])new IElementType[]{GoTypes.LPAREN, GoTypes.RPAREN}));
            if (parens.length == 2 && o.getChildren().length != 0) {
                this.isMultiline = true;
            }
        }

        private void visitSignatureOwner(@NotNull GoSignatureOwner o) {
            block5: {
                block4: {
                    if (o == null) {
                        MultilineChecker.$$$reportNull$$$0(8);
                    }
                    if (GoFormatterUtil.countEssentialChildren(o.getBlockIfExists()) > 5) break block4;
                    if (GoFormatterUtil.countParents(o, this.myAncestor, (Condition<PsiElement>)((Condition)GoSignatureOwner.class::isInstance)) <= 6) break block5;
                }
                this.isMultiline = true;
            }
        }

        @Override
        public void visitExprSwitchStatement(@NotNull GoExprSwitchStatement o) {
            if (o == null) {
                MultilineChecker.$$$reportNull$$$0(9);
            }
            this.isMultiline = true;
        }

        @Override
        public void visitTypeSwitchStatement(@NotNull GoTypeSwitchStatement o) {
            if (o == null) {
                MultilineChecker.$$$reportNull$$$0(10);
            }
            this.isMultiline = true;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "element";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "formattingRules";
                    break;
                }
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 8: 
                case 9: 
                case 10: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "o";
                    break;
                }
            }
            objectArray2[1] = "com/goide/formatter/GoFormatterUtil$MultilineChecker";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitCompositeElement";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitInterfaceType";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitStructType";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[2] = "checkForMultiline";
                    break;
                }
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitSignature";
                    break;
                }
                case 7: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitTopLevelDeclaration";
                    break;
                }
                case 8: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitSignatureOwner";
                    break;
                }
                case 9: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitExprSwitchStatement";
                    break;
                }
                case 10: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitTypeSwitchStatement";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    static class WalkBinaryResult {
        final boolean has4;
        final boolean has5;
        final int maxProblem;

        WalkBinaryResult(boolean has4, boolean has5, int maxProblem) {
            this.has4 = has4;
            this.has5 = has5;
            this.maxProblem = maxProblem;
        }
    }
}

