/*
 * Decompiled with CFR 0.152.
 */
package com.goide.execution.ui;

import com.goide.execution.GoBuildingRunConfiguration;
import com.goide.execution.GoRunUtil;
import com.goide.execution.application.GoApplicationConfiguration;
import com.goide.execution.testing.ui.GoPackageFieldCompletionProvider;
import com.goide.execution.ui.GoCommonSettingsPanel;
import com.intellij.DynamicBundle;
import com.intellij.execution.impl.SingleConfigurationConfigurable;
import com.intellij.execution.process.ElevationService;
import com.intellij.ide.DataManager;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.options.SettingsEditor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.TextFieldWithBrowseButton;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.EditorTextField;
import com.intellij.ui.SimpleListCellRenderer;
import com.intellij.ui.components.JBCheckBox;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import com.intellij.util.NotNullProducer;
import com.intellij.util.containers.ContainerUtil;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.util.Collection;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.ListCellRenderer;
import org.jetbrains.annotations.NotNull;

public class GoApplicationConfigurationEditorForm
extends SettingsEditor<GoApplicationConfiguration> {
    @NotNull
    private final Project myProject;
    private JPanel myComponent;
    private TextFieldWithBrowseButton myFileField;
    private TextFieldWithBrowseButton myDirectoryField;
    private GoCommonSettingsPanel myCommonSettingsPanel;
    private EditorTextField myPackageField;
    private JComboBox<GoBuildingRunConfiguration.Kind> myRunKindComboBox;
    private JLabel myPackageLabel;
    private JLabel myFileLabel;
    private TextFieldWithBrowseButton myOutputFilePathField;
    private JLabel myDirectoryLabel;
    private JBCheckBox myRunAfterBuildCheckBox;
    private JBCheckBox myBuildOnRemoteTargetCheckBox;
    private JLabel myOutputDirectoryLabel;
    private JBCheckBox myRedirectInputCheckBox;
    private TextFieldWithBrowseButton myInputFileField;

    public GoApplicationConfigurationEditorForm(@NotNull Project project) {
        if (project == null) {
            GoApplicationConfigurationEditorForm.$$$reportNull$$$0(0);
        }
        super(null);
        this.myProject = project;
        this.$$$setupUI$$$();
        this.myCommonSettingsPanel.init(project);
        this.installRunKindComboBox();
        GoRunUtil.installDirectoryChooser(this.myProject, this.myDirectoryField);
        GoRunUtil.installDirectoryChooser(this.myProject, this.myOutputFilePathField);
        this.myRedirectInputCheckBox.addItemListener(e -> this.myInputFileField.setEnabled(this.myRedirectInputCheckBox.isSelected()));
        GoRunUtil.installFileChooser(project, this.myInputFileField);
    }

    private void onRunKindChanged() {
        GoBuildingRunConfiguration.Kind selectedKind = (GoBuildingRunConfiguration.Kind)((Object)this.myRunKindComboBox.getSelectedItem());
        if (selectedKind == null) {
            selectedKind = GoBuildingRunConfiguration.Kind.PACKAGE;
        }
        boolean thePackage = selectedKind == GoBuildingRunConfiguration.Kind.PACKAGE;
        boolean file = selectedKind == GoBuildingRunConfiguration.Kind.FILE;
        boolean directory = selectedKind == GoBuildingRunConfiguration.Kind.DIRECTORY;
        this.myPackageField.setVisible(thePackage);
        this.myPackageLabel.setVisible(thePackage);
        this.myFileField.setVisible(file);
        this.myFileLabel.setVisible(file);
        this.myDirectoryField.setVisible(directory);
        this.myDirectoryLabel.setVisible(directory);
    }

    protected void resetEditorFrom(@NotNull GoApplicationConfiguration configuration) {
        if (configuration == null) {
            GoApplicationConfigurationEditorForm.$$$reportNull$$$0(1);
        }
        this.myFileField.setText(configuration.getFilePathsString());
        this.myDirectoryField.setText(configuration.getDirectoryPath());
        this.myPackageField.setText(configuration.getPackage());
        this.myRunKindComboBox.setSelectedItem((Object)configuration.getKind());
        this.myOutputFilePathField.setText(StringUtil.notNullize((String)configuration.getOutputDirectory()));
        this.myRunAfterBuildCheckBox.setSelected(configuration.isRunAfterBuild());
        this.myBuildOnRemoteTargetCheckBox.setSelected(configuration.isBuildOnRemoteTarget());
        this.myCommonSettingsPanel.resetEditorFrom(configuration);
        this.myRedirectInputCheckBox.setSelected(configuration.isRedirectInput());
        this.myInputFileField.setText(configuration.getRedirectInputPath());
    }

    protected void applyEditorTo(@NotNull GoApplicationConfiguration configuration) {
        if (configuration == null) {
            GoApplicationConfigurationEditorForm.$$$reportNull$$$0(2);
        }
        configuration.setFilePathsString(this.myFileField.getText());
        configuration.setDirectoryPath(this.myDirectoryField.getText());
        configuration.setPackage(this.myPackageField.getText());
        configuration.setKind((GoBuildingRunConfiguration.Kind)((Object)this.myRunKindComboBox.getSelectedItem()));
        configuration.setOutputDirectory(StringUtil.nullize((String)this.myOutputFilePathField.getText()));
        configuration.setRunAfterBuild(this.myRunAfterBuildCheckBox.isSelected());
        configuration.setBuildOnRemoteTarget(this.myBuildOnRemoteTargetCheckBox.isSelected());
        this.myCommonSettingsPanel.applyEditorTo(configuration);
        configuration.setRedirectInput(this.myRedirectInputCheckBox.isSelected());
        configuration.setRedirectInputPath(StringUtil.nullize((String)this.myInputFileField.getText()));
        this.hideUnsupportedFieldsIfNeeded();
    }

    private void hideUnsupportedFieldsIfNeeded() {
        if (!ApplicationManager.getApplication().isDispatchThread()) {
            return;
        }
        boolean localTarget = DataManager.getInstance().getDataContext((Component)this.myComponent).getData(SingleConfigurationConfigurable.RUN_ON_TARGET_NAME_KEY) == null;
        boolean isElevationServiceAvailable = ElevationService.getInstance().isAvailable();
        this.myBuildOnRemoteTargetCheckBox.setVisible(!localTarget);
        boolean showOutputField = localTarget || !this.myBuildOnRemoteTargetCheckBox.isSelected();
        this.myOutputFilePathField.setVisible(showOutputField);
        this.myOutputDirectoryLabel.setVisible(showOutputField);
        this.myCommonSettingsPanel.hideUnsupportedFieldsIfNeeded(localTarget, isElevationServiceAvailable);
    }

    private void createUIComponents() {
        this.myPackageField = new GoPackageFieldCompletionProvider((NotNullProducer<? extends Collection<Module>>)((NotNullProducer)() -> ContainerUtil.createMaybeSingletonList(this.myCommonSettingsPanel != null ? this.myCommonSettingsPanel.getSelectedModule() : null)), true, false).createEditor(this.myProject);
        this.myFileField = GoRunUtil.createMultipleFileField(this.myProject, ".go");
    }

    private void installRunKindComboBox() {
        this.myRunKindComboBox.removeAllItems();
        this.myRunKindComboBox.setRenderer((ListCellRenderer<GoBuildingRunConfiguration.Kind>)SimpleListCellRenderer.create((String)"", k -> k.getUiName()));
        for (GoBuildingRunConfiguration.Kind kind : GoBuildingRunConfiguration.Kind.values()) {
            this.myRunKindComboBox.addItem(kind);
        }
        this.myRunKindComboBox.addActionListener(e -> this.onRunKindChanged());
    }

    @NotNull
    protected JComponent createEditor() {
        JPanel jPanel = this.myComponent;
        if (jPanel == null) {
            GoApplicationConfigurationEditorForm.$$$reportNull$$$0(3);
        }
        return jPanel;
    }

    protected void disposeEditor() {
        this.myComponent.setVisible(false);
        Disposer.dispose((Disposable)this.myCommonSettingsPanel);
        Disposer.dispose((Disposable)this.myFileField);
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JBCheckBox jBCheckBox;
        TextFieldWithBrowseButton textFieldWithBrowseButton;
        JBCheckBox jBCheckBox2;
        JBCheckBox jBCheckBox3;
        GoCommonSettingsPanel goCommonSettingsPanel;
        JLabel jLabel;
        TextFieldWithBrowseButton textFieldWithBrowseButton2;
        TextFieldWithBrowseButton textFieldWithBrowseButton3;
        JLabel jLabel2;
        JLabel jLabel3;
        JLabel jLabel4;
        JPanel jPanel;
        this.createUIComponents();
        this.myComponent = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(6, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout((LayoutManager)new GridLayoutManager(5, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel.add((Component)jPanel2, new GridConstraints(0, 0, 1, 2, 0, 3, 3, 3, null, null, null, 0, true));
        JLabel jLabel5 = new JLabel();
        this.$$$loadLabelText$$$(jLabel5, DynamicBundle.getBundle((String)"messages/GoBundle", GoApplicationConfigurationEditorForm.class).getString("go.run.configuration.run.kind.label"));
        jPanel2.add((Component)jLabel5, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myPackageLabel = jLabel4 = new JLabel();
        this.$$$loadLabelText$$$(jLabel4, DynamicBundle.getBundle((String)"messages/GoBundle", GoApplicationConfigurationEditorForm.class).getString("go.run.configuration.target.package.label"));
        jPanel2.add((Component)jLabel4, new GridConstraints(1, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        EditorTextField editorTextField = this.myPackageField;
        editorTextField.setVisible(true);
        jPanel2.add((Component)editorTextField, new GridConstraints(1, 1, 1, 1, 8, 1, 6, 0, null, new Dimension(150, -1), null));
        TextFieldWithBrowseButton textFieldWithBrowseButton4 = this.myFileField;
        textFieldWithBrowseButton4.setVisible(true);
        jPanel2.add((Component)textFieldWithBrowseButton4, new GridConstraints(2, 1, 1, 1, 0, 1, 7, 3, null, null, null));
        this.myFileLabel = jLabel3 = new JLabel();
        this.$$$loadLabelText$$$(jLabel3, DynamicBundle.getBundle((String)"messages/GoBundle", GoApplicationConfigurationEditorForm.class).getString("go.run.configuration.target.files.label"));
        jPanel2.add((Component)jLabel3, new GridConstraints(2, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myOutputDirectoryLabel = jLabel2 = new JLabel();
        this.$$$loadLabelText$$$(jLabel2, DynamicBundle.getBundle((String)"messages/GoBundle", GoApplicationConfigurationEditorForm.class).getString("go.run.configuration.output.directory.label"));
        jPanel2.add((Component)jLabel2, new GridConstraints(4, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myOutputFilePathField = textFieldWithBrowseButton3 = new TextFieldWithBrowseButton();
        jPanel2.add((Component)textFieldWithBrowseButton3, new GridConstraints(4, 1, 1, 1, 0, 1, 3, 3, null, null, null));
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout((LayoutManager)new GridLayoutManager(1, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel2.add((Component)jPanel3, new GridConstraints(0, 1, 1, 1, 0, 3, 3, 3, null, null, null));
        JComboBox jComboBox = new JComboBox();
        this.myRunKindComboBox = jComboBox;
        DefaultComboBoxModel defaultComboBoxModel = new DefaultComboBoxModel();
        jComboBox.setModel(defaultComboBoxModel);
        jPanel3.add(jComboBox, new GridConstraints(0, 0, 1, 1, 8, 0, 2, 0, null, new Dimension(123, 26), null));
        Spacer spacer = new Spacer();
        jPanel3.add((Component)spacer, new GridConstraints(0, 1, 1, 1, 0, 1, 6, 1, null, null, null));
        this.myDirectoryField = textFieldWithBrowseButton2 = new TextFieldWithBrowseButton();
        textFieldWithBrowseButton2.setVisible(true);
        jPanel2.add((Component)textFieldWithBrowseButton2, new GridConstraints(3, 1, 1, 1, 0, 1, 7, 3, null, null, null));
        this.myDirectoryLabel = jLabel = new JLabel();
        this.$$$loadLabelText$$$(jLabel, DynamicBundle.getBundle((String)"messages/GoBundle", GoApplicationConfigurationEditorForm.class).getString("go.run.configuration.target.directory.label"));
        jPanel2.add((Component)jLabel, new GridConstraints(3, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        Spacer spacer2 = new Spacer();
        jPanel.add((Component)spacer2, new GridConstraints(5, 0, 1, 2, 0, 2, 1, 6, null, null, null));
        this.myCommonSettingsPanel = goCommonSettingsPanel = new GoCommonSettingsPanel();
        JComponent jComponent = goCommonSettingsPanel.$$$getRootComponent$$$();
        jPanel.add((Component)jComponent, new GridConstraints(4, 0, 1, 2, 1, 1, 3, 3, null, null, null, 0, true));
        this.myRunAfterBuildCheckBox = jBCheckBox3 = new JBCheckBox();
        jBCheckBox3.setSelected(true);
        this.$$$loadButtonText$$$((AbstractButton)jBCheckBox3, DynamicBundle.getBundle((String)"messages/GoBundle", GoApplicationConfigurationEditorForm.class).getString("go.run.configuration.run.after.build.checkbox"));
        jPanel.add((Component)jBCheckBox3, new GridConstraints(2, 1, 1, 1, 8, 0, 3, 3, null, null, null));
        this.myBuildOnRemoteTargetCheckBox = jBCheckBox2 = new JBCheckBox();
        jBCheckBox2.setSelected(true);
        this.$$$loadButtonText$$$((AbstractButton)jBCheckBox2, DynamicBundle.getBundle((String)"messages/GoBundle", GoApplicationConfigurationEditorForm.class).getString("go.run.configuration.build.on.remote.target.checkbox"));
        jPanel.add((Component)jBCheckBox2, new GridConstraints(1, 1, 1, 1, 8, 0, 3, 3, null, null, null));
        this.myInputFileField = textFieldWithBrowseButton = new TextFieldWithBrowseButton();
        textFieldWithBrowseButton.setEnabled(false);
        jPanel.add((Component)textFieldWithBrowseButton, new GridConstraints(3, 1, 1, 1, 0, 1, 3, 3, null, null, null));
        this.myRedirectInputCheckBox = jBCheckBox = new JBCheckBox();
        this.$$$loadButtonText$$$((AbstractButton)jBCheckBox, DynamicBundle.getBundle((String)"messages/ExecutionBundle", GoApplicationConfigurationEditorForm.class).getString("redirect.input.from"));
        jPanel.add((Component)jBCheckBox, new GridConstraints(3, 0, 1, 1, 0, 0, 0, 0, null, null, null));
        jLabel5.setLabelFor(jComboBox);
        jLabel4.setLabelFor((Component)editorTextField);
        jLabel3.setLabelFor((Component)textFieldWithBrowseButton4);
        jLabel2.setLabelFor((Component)textFieldWithBrowseButton3);
        jLabel.setLabelFor((Component)textFieldWithBrowseButton2);
        ButtonGroup buttonGroup = new ButtonGroup();
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myComponent;
    }

    private /* synthetic */ void $$$loadLabelText$$$(JLabel jLabel, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        jLabel.setText(stringBuffer.toString());
        if (bl) {
            jLabel.setDisplayedMnemonic(c);
            jLabel.setDisplayedMnemonicIndex(n);
        }
    }

    private /* synthetic */ void $$$loadButtonText$$$(AbstractButton abstractButton, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        abstractButton.setText(stringBuffer.toString());
        if (bl) {
            abstractButton.setMnemonic(c);
            abstractButton.setDisplayedMnemonicIndex(n);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 3 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configuration";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/goide/execution/ui/GoApplicationConfigurationEditorForm";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/goide/execution/ui/GoApplicationConfigurationEditorForm";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "createEditor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "resetEditorFrom";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "applyEditorTo";
                break;
            }
            case 3: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 3 -> new IllegalStateException(string);
        };
    }
}

