/*
 * Decompiled with CFR 0.152.
 */
package com.goide.execution.testing.frameworks.gocheck;

import com.goide.execution.testing.GoTestEventsConverterBase;
import com.intellij.execution.process.ProcessOutputTypes;
import com.intellij.execution.testframework.TestConsoleProperties;
import com.intellij.execution.testframework.sm.ServiceMessageBuilder;
import com.intellij.execution.testframework.sm.runner.OutputToGeneralTestEventsConverter;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import jetbrains.buildServer.messages.serviceMessages.ServiceMessageVisitor;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GocheckEventsConverter
extends OutputToGeneralTestEventsConverter
implements GoTestEventsConverterBase {
    @NonNls
    private static final String FRAMEWORK_NAME = "gocheck";
    public static final Map<String, String> EMPTY_FAIL_ATTRIBUTES = Collections.singletonMap("message", "");
    @NotNull
    private final String myDefaultImportPath;
    private static final Pattern SUITE_START = Pattern.compile("=== RUN (.+)\\s*$");
    private static final Pattern SUITE_END = Pattern.compile("((PASS)|(FAIL))\\s*$");
    private static final Pattern TEST_START = Pattern.compile("(.*)START: [^:]+:\\d+: ([^\\s]+)\\s*$");
    private static final Pattern TEST_PASSED = Pattern.compile("(.*)PASS: [^:]+:\\d+: ([^\\s]+)\\t[^\\s]+\\s*$");
    private static final Pattern TEST_FAILED = Pattern.compile("(.*)FAIL: [^:]+:\\d+: ([^\\s]+)\\s*$");
    private static final Pattern TEST_PANICKED = Pattern.compile("(.*)PANIC: [^:]+:\\d+: ([^\\s]+)\\s*$");
    private static final Pattern TEST_MISSED = Pattern.compile("(.*)MISS: [^:]+:\\d+: ([^\\s]+)\\s*$");
    private static final Pattern TEST_SKIPPED = Pattern.compile("(.*)SKIP: [^:]+:\\d+: ([^\\s]+)( \\(.*\\))?\\s*$");
    private static final Pattern ERROR_LOCATION = Pattern.compile("(.*:\\d+):\\s*$");
    private static final Pattern ERROR_ACTUAL = Pattern.compile("\\.\\.\\. ((obtained)|(value)) (.*?)( \\+)?\\s*$");
    private static final Pattern ERROR_EXPECTED = Pattern.compile("\\.\\.\\. ((expected)|(regex)) (.*?)( \\+)?\\s*$");
    private static final Pattern ERROR_CONTINUATION = Pattern.compile("\\.\\.\\. {5}(.*?)( +\\+)?\\s*$");
    private static final Pattern PANIC_VALUE = Pattern.compile("(.*)\\.\\.\\. (Panic: .* \\(.*\\)\\s*)$");
    private Scope myScope;
    private String mySuiteName;
    @NonNls
    private String myTestName;
    private long myCurrentTestStart;
    private TestResult myFixtureFailure;
    private final List<Pair<String, Key<?>>> myStdOut;
    private boolean populateStdOut;

    public GocheckEventsConverter(@NotNull String defaultImportPath, @NotNull TestConsoleProperties consoleProperties) {
        if (defaultImportPath == null) {
            GocheckEventsConverter.$$$reportNull$$$0(0);
        }
        if (consoleProperties == null) {
            GocheckEventsConverter.$$$reportNull$$$0(1);
        }
        super(FRAMEWORK_NAME, consoleProperties);
        this.myScope = Scope.GLOBAL;
        this.myStdOut = new ArrayList();
        this.myDefaultImportPath = defaultImportPath;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean processServiceMessages(@NotNull String text, @NotNull Key<?> outputType, @NotNull ServiceMessageVisitor visitor2) throws ParseException {
        if (text == null) {
            GocheckEventsConverter.$$$reportNull$$$0(2);
        }
        if (outputType == null) {
            GocheckEventsConverter.$$$reportNull$$$0(3);
        }
        if (visitor2 == null) {
            GocheckEventsConverter.$$$reportNull$$$0(4);
        }
        switch (this.myScope) {
            case GLOBAL: {
                if (!SUITE_START.matcher(text).matches()) break;
                this.myScope = Scope.SUITE;
                return true;
            }
            case SUITE: {
                Matcher matcher = TEST_START.matcher(text);
                if (matcher.matches()) {
                    List<Pair<String, Key<?>>> list = this.myStdOut;
                    synchronized (list) {
                        this.populateStdOut = true;
                        this.myStdOut.clear();
                    }
                    this.myTestName = matcher.group(2);
                    this.processTestSectionStart(this.myTestName, outputType, visitor2);
                    if (this.myTestName.endsWith(".SetUpSuite")) {
                        this.myScope = Scope.SUITE_SETUP;
                        return true;
                    }
                    if (this.myTestName.endsWith(".TearDownSuite")) {
                        this.myScope = Scope.SUITE_TEARDOWN;
                        return true;
                    }
                    this.myScope = Scope.TEST;
                    return this.processTestStarted(this.myTestName, outputType, visitor2);
                }
                if (!SUITE_END.matcher(text).matches()) break;
                this.myScope = Scope.GLOBAL;
                if (this.mySuiteName != null) {
                    String suiteFinishedMsg = ServiceMessageBuilder.testSuiteFinished((String)this.mySuiteName).toString();
                    super.processServiceMessages(suiteFinishedMsg, outputType, visitor2);
                    this.processStdOut("SuiteTearDown", visitor2);
                }
                return true;
            }
            case SUITE_SETUP: {
                TestResult suiteSetUpResult = this.detectTestResult(text, true, outputType);
                if (suiteSetUpResult == null) break;
                this.myScope = Scope.SUITE;
                if (suiteSetUpResult.getStatus() != Status.PASSED) {
                    this.myFixtureFailure = suiteSetUpResult;
                }
                return true;
            }
            case SUITE_TEARDOWN: {
                if (this.detectTestResult(text, false, outputType) == null) break;
                this.myScope = Scope.SUITE;
                return true;
            }
            case TEST: {
                TestResult testResult;
                Matcher matcher = TEST_START.matcher(text);
                if (matcher.matches()) {
                    String testName;
                    String stdOutLeftover = matcher.group(1);
                    if (!StringUtil.isEmptyOrSpaces((String)stdOutLeftover)) {
                        List<Pair<String, Key<?>>> list = this.myStdOut;
                        synchronized (list) {
                            this.addStdOut(stdOutLeftover, outputType);
                        }
                    }
                    if ((testName = matcher.group(2)).endsWith(".SetUpTest")) {
                        this.myScope = Scope.TEST_SETUP;
                        return true;
                    }
                    if (testName.endsWith(".TearDownTest")) {
                        this.myScope = Scope.TEST_TEARDOWN;
                        return true;
                    }
                }
                if ((testResult = this.detectTestResult(text, true, outputType)) == null) break;
                this.myScope = Scope.SUITE;
                if (StringUtil.notNullize((String)testResult.myAttributes.get("details")).contains("Fixture has panicked") || (testResult.getStatus() == Status.MISSED || testResult.getStatus() == Status.SKIPPED) && this.myFixtureFailure != null) {
                    testResult = this.myFixtureFailure;
                }
                this.myFixtureFailure = null;
                this.processTestResult(testResult, outputType, visitor2);
                return true;
            }
            case TEST_SETUP: {
                TestResult testSetUpResult = this.detectTestResult(text, true, outputType);
                if (testSetUpResult == null) break;
                this.myScope = Scope.TEST;
                if (testSetUpResult.getStatus() != Status.PASSED) {
                    this.myFixtureFailure = testSetUpResult;
                }
                return true;
            }
            case TEST_TEARDOWN: {
                boolean isSetUpFailed = this.myFixtureFailure != null;
                TestResult testTearDownResult = this.detectTestResult(text, !isSetUpFailed, outputType);
                if (testTearDownResult == null) break;
                this.myScope = Scope.TEST;
                if (!isSetUpFailed && testTearDownResult.getStatus() != Status.PASSED) {
                    this.myFixtureFailure = testTearDownResult;
                }
                return true;
            }
        }
        List<Pair<String, Key<?>>> list = this.myStdOut;
        synchronized (list) {
            if (this.populateStdOut) {
                this.addStdOut(text, outputType);
                return true;
            }
            if (StringUtil.isEmptyOrSpaces((String)text)) {
                return true;
            }
        }
        return super.processServiceMessages(text, outputType, visitor2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    private TestResult detectTestResult(String text, boolean parseDetails, Key<?> outputType) {
        Matcher matcher = TEST_PASSED.matcher(text);
        if (matcher.matches()) {
            List<Pair<String, Key<?>>> list = this.myStdOut;
            synchronized (list) {
                this.addStdOut(StringUtil.notNullize((String)matcher.group(1)).trim(), outputType);
            }
            return new TestResult(Status.PASSED);
        }
        matcher = TEST_MISSED.matcher(text);
        if (matcher.matches()) {
            List<Pair<String, Key<?>>> list = this.myStdOut;
            synchronized (list) {
                this.addStdOut(StringUtil.notNullize((String)matcher.group(1)).trim(), outputType);
            }
            return new TestResult(Status.MISSED);
        }
        matcher = TEST_SKIPPED.matcher(text);
        if (matcher.matches()) {
            List<Pair<String, Key<?>>> list = this.myStdOut;
            synchronized (list) {
                this.addStdOut(StringUtil.notNullize((String)matcher.group(1)).trim(), outputType);
            }
            return new TestResult(Status.SKIPPED);
        }
        matcher = TEST_FAILED.matcher(text);
        if (matcher.matches()) {
            List<Pair<String, Key<?>>> list = this.myStdOut;
            synchronized (list) {
                this.addStdOut(StringUtil.notNullize((String)matcher.group(1)).trim(), outputType);
                if (parseDetails) {
                    return new TestResult(Status.FAILED, GocheckEventsConverter.parseFailureAttributes(this.myStdOut));
                }
            }
            return new TestResult(Status.FAILED);
        }
        matcher = TEST_PANICKED.matcher(text);
        if (matcher.matches()) {
            List<Pair<String, Key<?>>> list = this.myStdOut;
            synchronized (list) {
                this.addStdOut(StringUtil.notNullize((String)matcher.group(1)).trim(), outputType);
                if (parseDetails) {
                    return new TestResult(Status.PANICKED, GocheckEventsConverter.parsePanickedAttributes(this.myStdOut));
                }
            }
            return new TestResult(Status.FAILED);
        }
        return null;
    }

    private boolean processTestStarted(@NotNull String testName, Key<?> outputType, ServiceMessageVisitor visitor2) throws ParseException {
        if (testName == null) {
            GocheckEventsConverter.$$$reportNull$$$0(5);
        }
        String testStartedMsg = ServiceMessageBuilder.testStarted((String)testName).addAttribute("locationHint", this.testUrl(testName)).toString();
        return super.processServiceMessages(testStartedMsg, outputType, visitor2);
    }

    private void processTestResult(@NotNull TestResult testResult, Key<?> outputType, ServiceMessageVisitor visitor2) throws ParseException {
        if (testResult == null) {
            GocheckEventsConverter.$$$reportNull$$$0(6);
        }
        this.processStdOut(this.myTestName, visitor2);
        switch (testResult.getStatus()) {
            case PASSED: {
                break;
            }
            case MISSED: 
            case SKIPPED: {
                String testIgnoredStr = ServiceMessageBuilder.testIgnored((String)this.myTestName).toString();
                super.processServiceMessages(testIgnoredStr, outputType, visitor2);
                break;
            }
            case FAILED: 
            case PANICKED: {
                ServiceMessageBuilder testError = ServiceMessageBuilder.testFailed((String)this.myTestName);
                testResult.addAttributesTo(testError);
                super.processServiceMessages(testError.toString(), outputType, visitor2);
                break;
            }
            default: {
                throw new RuntimeException("Unexpected test result: " + testResult);
            }
        }
        long duration = System.currentTimeMillis() - this.myCurrentTestStart;
        String testFinishedMsg = ServiceMessageBuilder.testFinished((String)this.myTestName).addAttribute("duration", Long.toString(duration)).toString();
        super.processServiceMessages(testFinishedMsg, outputType, visitor2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processStdOut(@NotNull @NonNls String testName, ServiceMessageVisitor visitor2) throws ParseException {
        if (testName == null) {
            GocheckEventsConverter.$$$reportNull$$$0(7);
        }
        List<Pair<String, Key<?>>> list = this.myStdOut;
        synchronized (list) {
            this.populateStdOut = false;
            for (Pair<String, Key<?>> pair : this.myStdOut) {
                if (StringUtil.isEmptyOrSpaces((String)((String)pair.first))) continue;
                ServiceMessageBuilder messageBuilder = pair.second == ProcessOutputTypes.STDERR ? ServiceMessageBuilder.testStdErr((String)testName) : ServiceMessageBuilder.testStdOut((String)testName);
                super.processServiceMessages(messageBuilder.addAttribute("out", (String)pair.first).toString(), (Key)pair.second, visitor2);
            }
            this.myStdOut.clear();
        }
    }

    private void addStdOut(String text, Key<?> outputType) {
        this.myStdOut.add(Pair.create((Object)text, outputType));
    }

    private void processTestSectionStart(@NotNull String testName, Key<?> outputType, ServiceMessageVisitor visitor2) throws ParseException {
        if (testName == null) {
            GocheckEventsConverter.$$$reportNull$$$0(8);
        }
        String suiteName = testName.substring(0, testName.indexOf("."));
        this.myTestName = testName;
        this.myCurrentTestStart = System.currentTimeMillis();
        if (!suiteName.equals(this.mySuiteName)) {
            if (this.mySuiteName != null) {
                String suiteFinishedMsg = ServiceMessageBuilder.testSuiteFinished((String)this.mySuiteName).toString();
                super.processServiceMessages(suiteFinishedMsg, outputType, visitor2);
            }
            this.mySuiteName = suiteName;
            String suiteStartedMsg = ServiceMessageBuilder.testSuiteStarted((String)suiteName).addAttribute("locationHint", this.suiteUrl(suiteName)).toString();
            super.processServiceMessages(suiteStartedMsg, outputType, visitor2);
        }
    }

    @NotNull
    private static Map<String, String> parseFailureAttributes(@NotNull List<Pair<String, Key<?>>> stdOut) {
        int lineNumber;
        if (stdOut == null) {
            GocheckEventsConverter.$$$reportNull$$$0(9);
        }
        if (stdOut.isEmpty()) {
            Map<String, String> map = EMPTY_FAIL_ATTRIBUTES;
            if (map == null) {
                GocheckEventsConverter.$$$reportNull$$$0(10);
            }
            return map;
        }
        StringBuilder expectedMessage = new StringBuilder();
        StringBuilder actualMessage = new StringBuilder();
        StringBuilder errorMessage = new StringBuilder();
        String details = "";
        for (lineNumber = stdOut.size() - 1; lineNumber >= 0 && !StringUtil.startsWith((CharSequence)((CharSequence)stdOut.get((int)lineNumber).first), (CharSequence)"..."); --lineNumber) {
        }
        int endLine = lineNumber + 1;
        lineNumber = GocheckEventsConverter.collectErrorMessage(stdOut, lineNumber, ERROR_EXPECTED, expectedMessage);
        for (lineNumber = GocheckEventsConverter.collectErrorMessage(stdOut, lineNumber, ERROR_ACTUAL, actualMessage); lineNumber >= 0; --lineNumber) {
            String line = (String)stdOut.get((int)lineNumber).first;
            Matcher matcher = ERROR_LOCATION.matcher(line);
            if (matcher.matches()) {
                details = matcher.group(1);
                break;
            }
            errorMessage.insert(0, line);
        }
        String expected = expectedMessage.toString().trim();
        String actual = actualMessage.toString().trim();
        if (expected.isEmpty() && actual.isEmpty()) {
            Map<String, String> map = EMPTY_FAIL_ATTRIBUTES;
            if (map == null) {
                GocheckEventsConverter.$$$reportNull$$$0(11);
            }
            return map;
        }
        GocheckEventsConverter.removeRange(stdOut, lineNumber, endLine);
        Map<String, String> map = Map.of("expected", expected, "actual", actual, "type", "comparisonFailure", "message", errorMessage.toString().trim(), "details", details);
        if (map == null) {
            GocheckEventsConverter.$$$reportNull$$$0(12);
        }
        return map;
    }

    private static int collectErrorMessage(List<Pair<String, Key<?>>> lines, int currentLine, Pattern messagePattern, StringBuilder result) {
        while (currentLine >= 0) {
            String line = (String)lines.get((int)currentLine).first;
            Matcher continuationMatcher = ERROR_CONTINUATION.matcher(line);
            if (continuationMatcher.matches()) {
                result.insert(0, '\n').insert(0, continuationMatcher.group(1));
                --currentLine;
                continue;
            }
            Matcher messageMatcher = messagePattern.matcher(line);
            if (!messageMatcher.matches()) break;
            result.insert(0, '\n').insert(0, messageMatcher.group(4));
            --currentLine;
            break;
        }
        return currentLine;
    }

    @NotNull
    private static Map<String, String> parsePanickedAttributes(@NotNull List<Pair<String, Key<?>>> stdOut) {
        Matcher matcher;
        int lineNumber;
        if (stdOut == null) {
            GocheckEventsConverter.$$$reportNull$$$0(13);
        }
        if (stdOut.isEmpty()) {
            Map<String, String> map = EMPTY_FAIL_ATTRIBUTES;
            if (map == null) {
                GocheckEventsConverter.$$$reportNull$$$0(14);
            }
            return map;
        }
        for (lineNumber = stdOut.size() - 1; lineNumber >= 0 && StringUtil.isEmptyOrSpaces((String)((String)stdOut.get((int)lineNumber).first)); --lineNumber) {
        }
        StringBuilder detailsMessage = new StringBuilder();
        while (lineNumber >= 0 && !StringUtil.isEmptyOrSpaces((String)((String)stdOut.get((int)lineNumber).first))) {
            detailsMessage.insert(0, (String)stdOut.get((int)lineNumber).first);
            --lineNumber;
        }
        String errorMessage = "";
        if (--lineNumber >= 0 && (matcher = PANIC_VALUE.matcher((CharSequence)stdOut.get((int)lineNumber).first)).matches()) {
            String stdoutLeftover = matcher.group(1);
            if (!StringUtil.isEmptyOrSpaces((String)stdoutLeftover)) {
                stdOut.set(lineNumber, Pair.create((Object)stdoutLeftover, (Object)((Key)stdOut.get((int)lineNumber).second)));
                ++lineNumber;
            }
            errorMessage = matcher.group(2);
        }
        GocheckEventsConverter.removeRange(stdOut, lineNumber, stdOut.size());
        Map<String, String> map = Map.of("details", detailsMessage.toString(), "message", errorMessage);
        if (map == null) {
            GocheckEventsConverter.$$$reportNull$$$0(15);
        }
        return map;
    }

    private static void removeRange(List<Pair<String, Key<?>>> stdOut, int startLine, int endLine) {
        int size = Math.min(stdOut.size(), endLine + 1);
        if (0 < startLine && startLine <= size - 1) {
            if (size > startLine) {
                stdOut.subList(startLine, size).clear();
            }
            return;
        }
        stdOut.clear();
    }

    @NotNull
    private String suiteUrl(@NotNull String suiteName) {
        if (suiteName == null) {
            GocheckEventsConverter.$$$reportNull$$$0(16);
        }
        String string = "gosuite://" + this.myDefaultImportPath + "#" + suiteName;
        if (string == null) {
            GocheckEventsConverter.$$$reportNull$$$0(17);
        }
        return string;
    }

    @NotNull
    private String testUrl(@NotNull String testName) {
        if (testName == null) {
            GocheckEventsConverter.$$$reportNull$$$0(18);
        }
        String string = "gotest://" + this.myDefaultImportPath + "#" + testName;
        if (string == null) {
            GocheckEventsConverter.$$$reportNull$$$0(19);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 10, 11, 12, 14, 15, 17, 19 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "defaultImportPath";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "consoleProperties";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "outputType";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "visitor";
                break;
            }
            case 5: 
            case 7: 
            case 8: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "testName";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "testResult";
                break;
            }
            case 9: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "stdOut";
                break;
            }
            case 10: 
            case 11: 
            case 12: 
            case 14: 
            case 15: 
            case 17: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/goide/execution/testing/frameworks/gocheck/GocheckEventsConverter";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "suiteName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/goide/execution/testing/frameworks/gocheck/GocheckEventsConverter";
                break;
            }
            case 10: 
            case 11: 
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "parseFailureAttributes";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "parsePanickedAttributes";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "suiteUrl";
                break;
            }
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "testUrl";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "processServiceMessages";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "processTestStarted";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "processTestResult";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "processStdOut";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "processTestSectionStart";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "parseFailureAttributes";
                break;
            }
            case 10: 
            case 11: 
            case 12: 
            case 14: 
            case 15: 
            case 17: 
            case 19: {
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "parsePanickedAttributes";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "suiteUrl";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "testUrl";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 10, 11, 12, 14, 15, 17, 19 -> new IllegalStateException(string);
        };
    }

    private static enum Scope {
        GLOBAL,
        SUITE,
        SUITE_SETUP,
        SUITE_TEARDOWN,
        TEST,
        TEST_SETUP,
        TEST_TEARDOWN;

    }

    private static final class TestResult {
        private final Status myStatus;
        private final Map<String, String> myAttributes;

        TestResult(@NotNull Status status) {
            if (status == null) {
                TestResult.$$$reportNull$$$0(0);
            }
            this(status, Collections.emptyMap());
        }

        TestResult(@NotNull Status status, @NotNull Map<String, String> attributes) {
            if (status == null) {
                TestResult.$$$reportNull$$$0(1);
            }
            if (attributes == null) {
                TestResult.$$$reportNull$$$0(2);
            }
            this.myAttributes = new HashMap<String, String>();
            this.myStatus = status;
            this.myAttributes.putAll(attributes);
        }

        @NotNull
        public Status getStatus() {
            Status status = this.myStatus;
            if (status == null) {
                TestResult.$$$reportNull$$$0(3);
            }
            return status;
        }

        public void addAttributesTo(@NotNull ServiceMessageBuilder serviceMessageBuilder) {
            if (serviceMessageBuilder == null) {
                TestResult.$$$reportNull$$$0(4);
            }
            for (Map.Entry<String, String> entry : this.myAttributes.entrySet()) {
                serviceMessageBuilder.addAttribute(entry.getKey(), entry.getValue());
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 3 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "status";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "attributes";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/goide/execution/testing/frameworks/gocheck/GocheckEventsConverter$TestResult";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "serviceMessageBuilder";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/goide/execution/testing/frameworks/gocheck/GocheckEventsConverter$TestResult";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getStatus";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 3: {
                    break;
                }
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "addAttributesTo";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 3 -> new IllegalStateException(string);
            };
        }
    }

    private static enum Status {
        PASSED,
        FAILED,
        PANICKED,
        MISSED,
        SKIPPED;

    }
}

