/*
 * Decompiled with CFR 0.152.
 */
package com.goide.execution.testing;

import com.goide.execution.GoRunUtil;
import com.goide.execution.testing.frameworks.testify.GoTestifySupport;
import com.goide.execution.testing.table.GoTableTestFunctionInfo;
import com.goide.execution.testing.table.GoTableTestUtil;
import com.goide.psi.GoCallExpr;
import com.goide.psi.GoFunctionDeclaration;
import com.goide.psi.GoFunctionOrMethodDeclaration;
import com.goide.psi.GoMethodDeclaration;
import com.goide.psi.GoTypeSpec;
import com.goide.psi.impl.GoPackage;
import com.goide.sdk.GoPackageUtil;
import com.goide.stubs.index.GoFunctionIndex;
import com.goide.stubs.index.GoIdFilter;
import com.goide.stubs.index.GoMethodFingerprintIndex;
import com.goide.stubs.index.GoTypesIndex;
import com.intellij.execution.Location;
import com.intellij.execution.PsiLocation;
import com.intellij.execution.testframework.sm.runner.SMTestLocator;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiManager;
import com.intellij.psi.ResolveState;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.GlobalSearchScopesCore;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.indexing.IdFilter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GoTestLocator
implements SMTestLocator {
    @NonNls
    public static final String SUITE_PROTOCOL = "gosuite";
    @Nullable
    private final Module myModule;

    public GoTestLocator(@Nullable Module module) {
        this.myModule = module;
    }

    @NotNull
    public List<Location> getLocation(@NotNull String protocolId, @NotNull String path, @NotNull Project project, @NotNull GlobalSearchScope testingScope) {
        if (protocolId == null) {
            GoTestLocator.$$$reportNull$$$0(0);
        }
        if (path == null) {
            GoTestLocator.$$$reportNull$$$0(1);
        }
        if (project == null) {
            GoTestLocator.$$$reportNull$$$0(2);
        }
        if (testingScope == null) {
            GoTestLocator.$$$reportNull$$$0(3);
        }
        if (!GoTestLocator.isMyProtocol(protocolId) || DumbService.isDumb((Project)project)) {
            List<Location> list = Collections.emptyList();
            if (list == null) {
                GoTestLocator.$$$reportNull$$$0(4);
            }
            return list;
        }
        String[] split = path.split("#", 2);
        if (split.length != 2) {
            List<Location> list = Collections.emptyList();
            if (list == null) {
                GoTestLocator.$$$reportNull$$$0(5);
            }
            return list;
        }
        String basePath = split[0];
        String testName = split[1];
        if (testName.isEmpty()) {
            List<Location> list = !basePath.isEmpty() ? this.getLocationsForBasePath(basePath, project) : Collections.emptyList();
            if (list == null) {
                GoTestLocator.$$$reportNull$$$0(6);
            }
            return list;
        }
        GlobalSearchScope declarationScope = this.getDeclarationScope(basePath, testingScope, project);
        if (declarationScope != null) {
            if ("gotest".equals(protocolId)) {
                return GoTestLocator.getLocationsForTest(testName, project, declarationScope);
            }
            if (SUITE_PROTOCOL.equals(protocolId)) {
                return GoTestLocator.getLocationForType(path, project, declarationScope);
            }
        }
        List<Location> list = Collections.emptyList();
        if (list == null) {
            GoTestLocator.$$$reportNull$$$0(7);
        }
        return list;
    }

    private static boolean isMyProtocol(@NotNull String protocolId) {
        if (protocolId == null) {
            GoTestLocator.$$$reportNull$$$0(8);
        }
        return "gotest".equals(protocolId) || SUITE_PROTOCOL.equals(protocolId);
    }

    @NotNull
    private List<Location> getLocationsForBasePath(@NotNull String basePath, @NotNull Project project) {
        Collection<GoPackage> packages2;
        if (basePath == null) {
            GoTestLocator.$$$reportNull$$$0(9);
        }
        if (project == null) {
            GoTestLocator.$$$reportNull$$$0(10);
        }
        if (!(packages2 = GoPackageUtil.findByImportPath(basePath, project, this.myModule, ResolveState.initial())).isEmpty()) {
            List list = ContainerUtil.skipNulls((Collection)ContainerUtil.map2Set(packages2, p -> PsiLocation.fromPsiElement((PsiElement)p.getNavigableElement())));
            if (list == null) {
                GoTestLocator.$$$reportNull$$$0(11);
            }
            return list;
        }
        VirtualFile fileByUrl = VirtualFileManager.getInstance().findFileByUrl(VfsUtilCore.pathToUrl((String)basePath));
        if (fileByUrl != null) {
            PsiDirectory fileSystemItem = fileByUrl.isDirectory() ? PsiManager.getInstance((Project)project).findDirectory(fileByUrl) : PsiManager.getInstance((Project)project).findFile(fileByUrl);
            List list = ContainerUtil.createMaybeSingletonList((Object)PsiLocation.fromPsiElement((PsiElement)fileSystemItem));
            if (list == null) {
                GoTestLocator.$$$reportNull$$$0(12);
            }
            return list;
        }
        List<Location> list = Collections.emptyList();
        if (list == null) {
            GoTestLocator.$$$reportNull$$$0(13);
        }
        return list;
    }

    @Nullable
    private GlobalSearchScope getDeclarationScope(@NotNull String basePath, @NotNull GlobalSearchScope baseScope, @NotNull Project project) {
        if (basePath == null) {
            GoTestLocator.$$$reportNull$$$0(14);
        }
        if (baseScope == null) {
            GoTestLocator.$$$reportNull$$$0(15);
        }
        if (project == null) {
            GoTestLocator.$$$reportNull$$$0(16);
        }
        if (basePath.isEmpty()) {
            return baseScope;
        }
        Collection<GoPackage> packages2 = GoPackageUtil.findByImportPath(basePath, project, this.myModule, ResolveState.initial());
        if (!packages2.isEmpty()) {
            return baseScope.intersectWith(GoPackageUtil.packagesScope(packages2));
        }
        VirtualFile fileByUrl = VirtualFileManager.getInstance().findFileByUrl(VfsUtilCore.pathToUrl((String)basePath));
        if (fileByUrl != null) {
            return baseScope.intersectWith(fileByUrl.isDirectory() ? GlobalSearchScopesCore.directoryScope((Project)project, (VirtualFile)fileByUrl, (boolean)true) : GlobalSearchScopesCore.directoryScope((Project)project, (VirtualFile)fileByUrl.getParent(), (boolean)false));
        }
        return null;
    }

    @NotNull
    private static List<Location> getLocationForType(@NotNull String suiteName, @NotNull Project project, @NotNull GlobalSearchScope testingScope) {
        if (suiteName == null) {
            GoTestLocator.$$$reportNull$$$0(17);
        }
        if (project == null) {
            GoTestLocator.$$$reportNull$$$0(18);
        }
        if (testingScope == null) {
            GoTestLocator.$$$reportNull$$$0(19);
        }
        IdFilter idFilter = GoIdFilter.getTestsFilter(project);
        List list = ContainerUtil.mapNotNull(GoTypesIndex.find(suiteName, project, testingScope, idFilter), spec -> PsiLocation.fromPsiElement((Project)project, (PsiElement)spec));
        if (list == null) {
            GoTestLocator.$$$reportNull$$$0(20);
        }
        return list;
    }

    @NotNull
    private static List<Location> getLocationsForTest(@NotNull String path, @NotNull Project project, @NotNull GlobalSearchScope scope) {
        List parts;
        if (path == null) {
            GoTestLocator.$$$reportNull$$$0(21);
        }
        if (project == null) {
            GoTestLocator.$$$reportNull$$$0(22);
        }
        if (scope == null) {
            GoTestLocator.$$$reportNull$$$0(23);
        }
        IdFilter idFilter = GoIdFilter.getTestsFilter(project);
        List locationDataItems = StringUtil.split((String)path, (String)".");
        if (locationDataItems.size() == 2) {
            ArrayList<Location> locations = new ArrayList<Location>();
            for (GoTypeSpec typeSpec : GoTypesIndex.find((String)locationDataItems.get(0), project, scope, idFilter)) {
                for (GoMethodDeclaration method2 : typeSpec.getMethods()) {
                    if (!((String)locationDataItems.get(1)).equals(method2.getName())) continue;
                    ContainerUtil.addIfNotNull(locations, (Object)PsiLocation.fromPsiElement((PsiElement)method2));
                }
            }
            if (!locations.isEmpty()) {
                ArrayList<Location> arrayList = locations;
                if (arrayList == null) {
                    GoTestLocator.$$$reportNull$$$0(24);
                }
                return arrayList;
            }
        }
        if ((parts = StringUtil.split((String)path, (String)"/", (boolean)true, (boolean)false)).isEmpty()) {
            List<Location> list = Collections.emptyList();
            if (list == null) {
                GoTestLocator.$$$reportNull$$$0(25);
            }
            return list;
        }
        String testFuncName = (String)parts.get(0);
        Collection<GoFunctionDeclaration> testFunctions = GoFunctionIndex.find(testFuncName, project, scope, idFilter);
        if (parts.size() == 1) {
            List list = ContainerUtil.map(testFunctions, it -> PsiLocation.fromPsiElement((Project)project, (PsiElement)it));
            if (list == null) {
                GoTestLocator.$$$reportNull$$$0(26);
            }
            return list;
        }
        if (testFunctions.isEmpty()) {
            List<Location> list = Collections.emptyList();
            if (list == null) {
                GoTestLocator.$$$reportNull$$$0(27);
            }
            return list;
        }
        List regularSubtests = ContainerUtil.mapNotNull(testFunctions, it -> GoTestLocator.findSubTest(path, it));
        if (!regularSubtests.isEmpty()) {
            List list = regularSubtests;
            if (list == null) {
                GoTestLocator.$$$reportNull$$$0(28);
            }
            return list;
        }
        String testifyMethodName = (String)parts.get(1);
        List testifyMethods = ContainerUtil.filter(GoMethodFingerprintIndex.find(testifyMethodName + "/0", project, scope, idFilter), method -> {
            GoTypeSpec spec = GoTestifySupport.getTestifySuiteTypeSpec(method);
            if (spec != null) {
                for (GoFunctionDeclaration function : testFunctions) {
                    if (!GoTestifySupport.isUsesTestifySuite(function, spec)) continue;
                    return true;
                }
            }
            return false;
        });
        if (parts.size() == 2 && !testifyMethods.isEmpty()) {
            List list = ContainerUtil.map((Collection)testifyMethods, it -> PsiLocation.fromPsiElement((Project)project, (PsiElement)it));
            if (list == null) {
                GoTestLocator.$$$reportNull$$$0(29);
            }
            return list;
        }
        List testifyMethodParts = parts.subList(1, parts.size());
        List testifySubtests = ContainerUtil.mapNotNull((Collection)testifyMethods, it -> GoTestLocator.findSubTest(String.join((CharSequence)"/", testifyMethodParts), it));
        if (!testifySubtests.isEmpty()) {
            List list = testifySubtests;
            if (list == null) {
                GoTestLocator.$$$reportNull$$$0(30);
            }
            return list;
        }
        List list = !testifyMethods.isEmpty() ? ContainerUtil.map((Collection)testifyMethods, it -> PsiLocation.fromPsiElement((Project)project, (PsiElement)it)) : ContainerUtil.map(testFunctions, it -> PsiLocation.fromPsiElement((Project)project, (PsiElement)it));
        if (list == null) {
            GoTestLocator.$$$reportNull$$$0(31);
        }
        return list;
    }

    @Nullable
    private static Location<PsiElement> findSubTest(@NotNull String subTestPath, @NotNull GoFunctionOrMethodDeclaration declaration) {
        if (subTestPath == null) {
            GoTestLocator.$$$reportNull$$$0(32);
        }
        if (declaration == null) {
            GoTestLocator.$$$reportNull$$$0(33);
        }
        Map<GoCallExpr, String> tests = GoRunUtil.getSubTests(declaration);
        for (Map.Entry<GoCallExpr, String> entry : tests.entrySet()) {
            if (!entry.getValue().equals(subTestPath)) continue;
            return PsiLocation.fromPsiElement((PsiElement)entry.getKey());
        }
        GoTableTestFunctionInfo info = GoTableTestUtil.getTableTestInfo(declaration);
        PsiElement element = info.getTestDataElementByFullTestName(subTestPath);
        if (element != null) {
            return PsiLocation.fromPsiElement((PsiElement)element);
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 4, 5, 6, 7, 11, 12, 13, 20, 24, 25, 26, 27, 28, 29, 30, 31 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "protocolId";
                break;
            }
            case 1: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 2: 
            case 10: 
            case 16: 
            case 18: 
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 3: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "testingScope";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 11: 
            case 12: 
            case 13: 
            case 20: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/goide/execution/testing/GoTestLocator";
                break;
            }
            case 9: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "basePath";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "baseScope";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "suiteName";
                break;
            }
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scope";
                break;
            }
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "subTestPath";
                break;
            }
            case 33: {
                objectArray2 = objectArray3;
                objectArray3[0] = "declaration";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/goide/execution/testing/GoTestLocator";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getLocation";
                break;
            }
            case 11: 
            case 12: 
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getLocationsForBasePath";
                break;
            }
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "getLocationForType";
                break;
            }
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: {
                objectArray = objectArray2;
                objectArray2[1] = "getLocationsForTest";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getLocation";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 11: 
            case 12: 
            case 13: 
            case 20: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: {
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "isMyProtocol";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "getLocationsForBasePath";
                break;
            }
            case 14: 
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "getDeclarationScope";
                break;
            }
            case 17: 
            case 18: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "getLocationForType";
                break;
            }
            case 21: 
            case 22: 
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "getLocationsForTest";
                break;
            }
            case 32: 
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "findSubTest";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 4, 5, 6, 7, 11, 12, 13, 20, 24, 25, 26, 27, 28, 29, 30, 31 -> new IllegalStateException(string);
        };
    }
}

