/*
 * Decompiled with CFR 0.152.
 */
package com.goide.execution.application;

import com.goide.execution.GoBuildingRunConfiguration;
import com.goide.execution.GoModuleBasedConfiguration;
import com.goide.execution.GoPathProximityComparator;
import com.goide.execution.GoRunUtil;
import com.goide.execution.application.GoApplicationRunningState;
import com.goide.execution.ui.GoApplicationConfigurationEditorForm;
import com.goide.i18n.GoBundle;
import com.goide.psi.GoFile;
import com.goide.psi.impl.GoPackage;
import com.goide.sdk.GoPackageUtil;
import com.goide.stubs.index.GoFunctionIndex;
import com.goide.stubs.index.GoIdFilter;
import com.goide.util.GoUtil;
import com.intellij.execution.ExecutionBundle;
import com.intellij.execution.InputRedirectAware;
import com.intellij.execution.configurations.ConfigurationType;
import com.intellij.execution.configurations.RunProfile;
import com.intellij.execution.configurations.RuntimeConfigurationError;
import com.intellij.execution.configurations.RuntimeConfigurationException;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.execution.target.RunTargetsEnabled;
import com.intellij.execution.target.TargetEnvironmentConfiguration;
import com.intellij.execution.target.TargetEnvironmentConfigurations;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.options.SettingsEditor;
import com.intellij.openapi.options.SettingsEditorGroup;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.util.JDOMExternalizerUtil;
import com.intellij.openapi.util.WriteExternalException;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.util.PathUtil;
import com.intellij.util.indexing.DumbModeAccessType;
import com.intellij.util.indexing.IdFilter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.SortedMap;
import java.util.TreeMap;
import one.util.streamex.StreamEx;
import org.jdom.Element;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GoApplicationConfiguration
extends GoBuildingRunConfiguration<GoApplicationRunningState>
implements InputRedirectAware.InputRedirectOptions,
DumbAware {
    @NonNls
    private static final String RUN_ATTRIBUTE_NAME = "run";
    @NonNls
    private static final String REDIRECT_INPUT_NAME = "redirect_input";
    @NonNls
    private static final String INPUT_FILE_NAME = "input_file";
    private static final String MY_RUN_AFTER_BUILD_DEFAULT = "true";
    private boolean myRunAfterBuild;
    private boolean myRedirectInput;
    @Nullable
    private String myInputFile;

    public GoApplicationConfiguration(@NotNull Project project, @NotNull String name, @NotNull ConfigurationType configurationType) {
        if (project == null) {
            GoApplicationConfiguration.$$$reportNull$$$0(0);
        }
        if (name == null) {
            GoApplicationConfiguration.$$$reportNull$$$0(1);
        }
        if (configurationType == null) {
            GoApplicationConfiguration.$$$reportNull$$$0(2);
        }
        super(project, name, configurationType);
        this.myRunAfterBuild = true;
    }

    @Override
    public void readExternal(@NotNull Element element) throws InvalidDataException {
        if (element == null) {
            GoApplicationConfiguration.$$$reportNull$$$0(3);
        }
        super.readExternal(element);
        this.myRunAfterBuild = Boolean.parseBoolean(JDOMExternalizerUtil.readField((Element)element, (String)RUN_ATTRIBUTE_NAME, (String)MY_RUN_AFTER_BUILD_DEFAULT));
        this.myRedirectInput = Boolean.parseBoolean(JDOMExternalizerUtil.readCustomField((Element)element, (String)REDIRECT_INPUT_NAME));
        this.myInputFile = GoApplicationConfiguration.readPathField(element, INPUT_FILE_NAME);
    }

    @Override
    public void writeExternal(@NotNull Element element) throws WriteExternalException {
        if (element == null) {
            GoApplicationConfiguration.$$$reportNull$$$0(4);
        }
        super.writeExternal(element);
        JDOMExternalizerUtil.writeField((Element)element, (String)RUN_ATTRIBUTE_NAME, (String)String.valueOf(this.myRunAfterBuild), (String)MY_RUN_AFTER_BUILD_DEFAULT);
        if (this.myRedirectInput) {
            JDOMExternalizerUtil.writeCustomField((Element)element, (String)REDIRECT_INPUT_NAME, (String)MY_RUN_AFTER_BUILD_DEFAULT);
        }
        GoApplicationConfiguration.writeNonEmptyPathField(element, INPUT_FILE_NAME, this.myInputFile);
    }

    @Override
    @NotNull
    protected GoBuildingRunConfiguration.Kind getDefaultKind() {
        GoBuildingRunConfiguration.Kind kind = StringUtil.isNotEmpty((String)this.getPackage()) ? GoBuildingRunConfiguration.Kind.PACKAGE : GoBuildingRunConfiguration.Kind.FILE;
        if (kind == null) {
            GoApplicationConfiguration.$$$reportNull$$$0(5);
        }
        return kind;
    }

    @Override
    public SettingsEditorGroup<GoApplicationConfiguration> createSettingsEditorGroup() {
        SettingsEditorGroup group = new SettingsEditorGroup();
        group.addEditor(ExecutionBundle.message((String)"run.configuration.configuration.tab.title", (Object[])new Object[0]), (SettingsEditor)new GoApplicationConfigurationEditorForm(this.getProject()));
        return group;
    }

    @Override
    @NotNull
    protected GoApplicationRunningState newRunningState(@NotNull ExecutionEnvironment env, @NotNull Module module) {
        if (env == null) {
            GoApplicationConfiguration.$$$reportNull$$$0(6);
        }
        if (module == null) {
            GoApplicationConfiguration.$$$reportNull$$$0(7);
        }
        return new GoApplicationRunningState(env, module, this);
    }

    @Override
    public void checkConfiguration() throws RuntimeConfigurationException {
        String userDefinedPlatform;
        super.checkConfiguration();
        switch (this.getKind()) {
            case PACKAGE: {
                Module module = ((GoModuleBasedConfiguration)this.getConfigurationModule()).getModule();
                assert (module != null);
                String myPackage = this.getPackage();
                if (StringUtil.isEmptyOrSpaces((String)myPackage)) {
                    throw new RuntimeConfigurationError(GoBundle.message((String)"go.execution.package.is.not.specified.error", (Object[])new Object[0]));
                }
                Project project = module.getProject();
                Collection<GoPackage> packages2 = this.getContextPackages();
                if (packages2.isEmpty()) {
                    throw new RuntimeConfigurationError(GoBundle.message((String)"go.execution.cannot.find.package.error", (Object[])new Object[]{myPackage}));
                }
                SortedMap functions = (SortedMap)DumbModeAccessType.RELIABLE_DATA_ONLY.ignoreDumbMode(() -> {
                    GlobalSearchScope scope = GoPackageUtil.packagesScope(packages2);
                    IdFilter filter = GoIdFilter.getProductionFilter(project);
                    return (TreeMap)((StreamEx)StreamEx.of(GoFunctionIndex.find("main", project, scope, filter)).filter(f -> {
                        GoFile file = f.getContainingFile();
                        return !GoUtil.fileToIgnore(file.getName()) && GoUtil.matchedForModuleBuildTarget((PsiFile)file, module);
                    })).groupingTo(f -> f.getContainingFile().getVirtualFile().getParent(), () -> new TreeMap(new GoPathProximityComparator(this.getWorkingDirectory())), ArrayList::new);
                });
                if (functions.isEmpty() || ((Collection)functions.get(functions.firstKey())).size() <= 1) break;
                throw new RuntimeConfigurationError(GoBundle.message((String)"go.execution.package.contains.several.mains.error", (Object[])new Object[]{myPackage}), () -> {
                    this.setKind(GoBuildingRunConfiguration.Kind.FILE);
                    if (this.isGeneratedName()) {
                        this.setGeneratedName();
                    }
                });
            }
            case FILE: {
                this.checkFileConfiguration();
                break;
            }
            case DIRECTORY: {
                if (StringUtil.isEmptyOrSpaces((String)this.myDirectoryPath)) {
                    throw new RuntimeConfigurationError(GoBundle.message((String)"go.execution.directory.is.not.specified.error", (Object[])new Object[0]));
                }
                VirtualFile directory = LocalFileSystem.getInstance().findFileByPath(this.myDirectoryPath);
                if (directory != null && directory.isDirectory()) break;
                throw new RuntimeConfigurationError(GoBundle.message((String)"go.execution.cannot.find.directory.error", (Object[])new Object[]{this.myDirectoryPath}));
            }
        }
        if (this.isRunAfterBuild() && (userDefinedPlatform = GoRunUtil.getRunConfigurationGOOS(this)) != null) {
            TargetEnvironmentConfiguration config;
            String targetPlatform = GoRunUtil.getLocalTargetPlatform();
            if (RunTargetsEnabled.get() && (config = TargetEnvironmentConfigurations.getEffectiveConfiguration((RunProfile)this, (Project)this.getProject())) != null) {
                targetPlatform = GoRunUtil.getTargetPlatform(config.createEnvironmentRequest(this.getProject()));
            }
            if (targetPlatform != null && !userDefinedPlatform.equals(targetPlatform)) {
                throw new RuntimeConfigurationError(GoBundle.message((String)"go.execution.run.after.build.is.not.possible.incompatible.os.error", (Object[])new Object[0]), () -> this.setRunAfterBuild(false));
            }
        }
        if (this.isRedirectInput()) {
            if (StringUtil.isEmptyOrSpaces((String)this.myInputFile)) {
                throw new RuntimeConfigurationError(GoBundle.message((String)"go.execution.input.file.is.not.specified.error", (Object[])new Object[0]));
            }
            VirtualFile inputFile = LocalFileSystem.getInstance().findFileByPath(this.myInputFile);
            if (inputFile == null || inputFile.isDirectory()) {
                throw new RuntimeConfigurationError(GoBundle.message((String)"go.execution.cannot.find.input.file.error", (Object[])new Object[]{this.myInputFile}));
            }
        }
    }

    private void checkFileConfiguration() throws RuntimeConfigurationException {
        boolean hasMainFile = false;
        VirtualFile parent = null;
        if (StringUtil.isEmptyOrSpaces((String)this.myFilePaths)) {
            throw new RuntimeConfigurationError(GoBundle.message((String)"go.execution.file.is.not.specified.error", (Object[])new Object[0]));
        }
        List<String> filePaths = this.getFilePaths();
        if (filePaths.isEmpty()) {
            throw new RuntimeConfigurationError(GoBundle.message((String)"go.execution.file.is.not.specified.error", (Object[])new Object[0]));
        }
        HashSet<VirtualFile> files = new HashSet<VirtualFile>();
        for (String filePath : filePaths) {
            VirtualFile file = this.findFile(filePath);
            if (file == null) {
                throw new RuntimeConfigurationError(GoBundle.message((String)"go.execution.file.not.found.error", (Object[])new Object[]{filePath}));
            }
            if (parent != null && !parent.equals(file.getParent())) {
                throw new RuntimeConfigurationError(GoBundle.message((String)"go.execution.files.must.be.in.one.directory.error", (Object[])new Object[0]));
            }
            parent = file.getParent();
            PsiFile psiFile = PsiManager.getInstance((Project)this.getProject()).findFile(file);
            if (!(psiFile instanceof GoFile)) {
                throw new RuntimeConfigurationError(GoBundle.message((String)"go.execution.not.go.file.error", (Object[])new Object[]{filePath}));
            }
            hasMainFile |= GoRunUtil.isMainGoFile(psiFile);
            if (files.add(file)) continue;
            throw new RuntimeConfigurationError(GoBundle.message((String)"go.execution.duplicate.file.error", (Object[])new Object[]{filePath}));
        }
        if (this.isRunAfterBuild() && !hasMainFile) {
            if (filePaths.size() == 1) {
                throw new RuntimeConfigurationError(GoBundle.message((String)"go.execution.run.after.build.is.not.possible.main.not.found.single.file.error", (Object[])new Object[0]));
            }
            throw new RuntimeConfigurationError(GoBundle.message((String)"go.execution.run.after.build.is.not.possible.main.not.found.many.files.error", (Object[])new Object[0]));
        }
    }

    public boolean isRunAfterBuild() {
        return this.myRunAfterBuild;
    }

    public void setRunAfterBuild(boolean runAfterBuild) {
        this.myRunAfterBuild = runAfterBuild;
    }

    @Override
    public boolean isRunnable() {
        return this.myRunAfterBuild;
    }

    @Nullable
    public String suggestedName() {
        return switch (this.getKind()) {
            default -> throw new IncompatibleClassChangeError();
            case GoBuildingRunConfiguration.Kind.PACKAGE -> "go build " + this.getPackage();
            case GoBuildingRunConfiguration.Kind.FILE -> "go build " + StringUtil.join(this.getFilePaths(), PathUtil::getFileName, (String)" ");
            case GoBuildingRunConfiguration.Kind.DIRECTORY -> {
                VirtualFile directory = LocalFileSystem.getInstance().findFileByPath(this.getDirectoryPath());
                Module module = ((GoModuleBasedConfiguration)this.getConfigurationModule()).getModule();
                PsiDirectory psiDirectory = directory != null ? PsiManager.getInstance((Project)this.getProject()).findDirectory(directory) : null;
                for (GoPackage aPackage : GoPackage.in(psiDirectory, module)) {
                    String dirImportPath = aPackage.getImportPath(false);
                    if (dirImportPath == null) continue;
                    yield "go build " + dirImportPath;
                }
                yield "go build " + PathUtil.getFileName((String)this.getDirectoryPath()) + "/";
            }
        };
    }

    public boolean isRedirectInput() {
        return this.myRedirectInput;
    }

    public void setRedirectInput(boolean redirectInput) {
        this.myRedirectInput = redirectInput;
    }

    @Nullable
    public String getRedirectInputPath() {
        return this.myInputFile;
    }

    public void setRedirectInputPath(@Nullable String inputFile) {
        this.myInputFile = inputFile;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 5 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configurationType";
                break;
            }
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/goide/execution/application/GoApplicationConfiguration";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "env";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/goide/execution/application/GoApplicationConfiguration";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getDefaultKind";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "readExternal";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "writeExternal";
                break;
            }
            case 5: {
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "newRunningState";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 5 -> new IllegalStateException(string);
        };
    }
}

