/*
 * Decompiled with CFR 0.152.
 */
package com.goide.editor.template;

import com.goide.codeInsight.imports.GoImportOptimizer;
import com.goide.editor.template.GoLiveTemplateContextType;
import com.goide.psi.GoFile;
import com.goide.psi.GoImportSpec;
import com.goide.psi.impl.GoPackage;
import com.goide.psi.impl.GoPsiImplUtil;
import com.goide.sdk.GoPackageUtil;
import com.goide.util.GoUtil;
import com.goide.vendor.GoVendoringUtil;
import com.intellij.codeInsight.template.Expression;
import com.intellij.codeInsight.template.ExpressionContext;
import com.intellij.codeInsight.template.RecalculatableResult;
import com.intellij.codeInsight.template.Result;
import com.intellij.codeInsight.template.Template;
import com.intellij.codeInsight.template.TemplateContextType;
import com.intellij.codeInsight.template.TemplateEditingAdapter;
import com.intellij.codeInsight.template.TemplateEditingListener;
import com.intellij.codeInsight.template.TextResult;
import com.intellij.codeInsight.template.impl.TemplateManagerImpl;
import com.intellij.codeInsight.template.impl.TemplateState;
import com.intellij.codeInsight.template.macro.MacroBase;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.ResolveState;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.text.UniqueNameGenerator;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class GoLocalNameMacro
extends MacroBase {
    private static final String LISTENER_ADDED = "GoLocalNameMacroOptimizeImportsListenerAdded";

    public GoLocalNameMacro() {
        super("localName", "localName(importPath, name)");
    }

    public boolean isAcceptableInContext(TemplateContextType context) {
        return context instanceof GoLiveTemplateContextType;
    }

    @Nullable
    protected Result calculateResult(Expression @NotNull [] params, ExpressionContext context, boolean quick) {
        PsiElement element;
        if (params == null) {
            GoLocalNameMacro.$$$reportNull$$$0(0);
        }
        if ((element = context.getPsiElementAtStartOffset()) == null) {
            return null;
        }
        GoFile file = (GoFile)((Object)ObjectUtils.tryCast((Object)element.getContainingFile(), GoFile.class));
        if (file == null) {
            return null;
        }
        String importPath = GoLocalNameMacro.getImportPath(params, context);
        String name = GoLocalNameMacro.getName(params, context);
        if (StringUtil.isEmpty((String)importPath) || StringUtil.isEmpty((String)name)) {
            return null;
        }
        String currentFileImportPath = file.getImportPath(GoVendoringUtil.isVendoringEnabled((PsiElement)file));
        GoImportSpec existingSpec = file.getImportedPackagesMap().get(importPath);
        if (existingSpec != null || importPath.equals(currentFileImportPath)) {
            String qualifier = (String)ContainerUtil.getFirstItem(GoPsiImplUtil.getImportQualifiersToUseInFile(existingSpec));
            return new TextResult((String)(StringUtil.isEmpty((String)qualifier) ? name : qualifier + "." + name));
        }
        GoLocalNameMacro.registerOptimizeImportsListener(context, (PsiFile)file);
        return new AddImportResult(file, importPath, name);
    }

    private static void registerOptimizeImportsListener(ExpressionContext context, final @NotNull PsiFile file) {
        Editor editor;
        TemplateState state;
        if (file == null) {
            GoLocalNameMacro.$$$reportNull$$$0(1);
        }
        TemplateState templateState = state = (editor = context.getEditor()) != null ? TemplateManagerImpl.getTemplateState((Editor)editor) : null;
        if (state != null && state.getProperties().putIfAbsent(LISTENER_ADDED, true) != Boolean.TRUE) {
            state.addTemplateStateListener((TemplateEditingListener)new TemplateEditingAdapter(){

                public void beforeTemplateFinished(@NotNull TemplateState state, Template template) {
                    if (state == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    CommandProcessor.getInstance().runUndoTransparentAction(() -> ApplicationManager.getApplication().runWriteAction(new GoImportOptimizer().processFile(file)));
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "state", "com/goide/editor/template/GoLocalNameMacro$1", "beforeTemplateFinished"));
                }
            });
        }
    }

    @NotNull
    private static String getPackageName(@NotNull String importPath, @NotNull Project project, @NotNull PsiElement element) {
        if (importPath == null) {
            GoLocalNameMacro.$$$reportNull$$$0(2);
        }
        if (project == null) {
            GoLocalNameMacro.$$$reportNull$$$0(3);
        }
        if (element == null) {
            GoLocalNameMacro.$$$reportNull$$$0(4);
        }
        ResolveState resolveState = GoPsiImplUtil.createContextOnElement(element);
        Collection<GoPackage> packages2 = GoPackageUtil.findByImportPath(importPath, project, GoUtil.module(element), resolveState);
        String string = Objects.requireNonNull((String)ContainerUtil.getFirstItem(GoPsiImplUtil.getImportQualifiersToUseInFile(packages2, importPath)));
        if (string == null) {
            GoLocalNameMacro.$$$reportNull$$$0(5);
        }
        return string;
    }

    @Nullable
    private static String getImportPath(Expression @NotNull [] params, @NotNull ExpressionContext context) {
        if (context == null) {
            GoLocalNameMacro.$$$reportNull$$$0(6);
        }
        if (params == null) {
            GoLocalNameMacro.$$$reportNull$$$0(7);
        }
        return GoLocalNameMacro.getResult(context, GoLocalNameMacro.getNth(params, 0));
    }

    @Nullable
    private static String getName(Expression @NotNull [] params, @NotNull ExpressionContext context) {
        if (context == null) {
            GoLocalNameMacro.$$$reportNull$$$0(8);
        }
        if (params == null) {
            GoLocalNameMacro.$$$reportNull$$$0(9);
        }
        return GoLocalNameMacro.getResult(context, GoLocalNameMacro.getNth(params, 1));
    }

    @Nullable
    private static String getResult(@NotNull ExpressionContext context, @Nullable Expression expression) {
        if (context == null) {
            GoLocalNameMacro.$$$reportNull$$$0(10);
        }
        if (expression == null) {
            return null;
        }
        return GoLocalNameMacro.getTextResult((Expression[])new Expression[]{expression}, (ExpressionContext)context);
    }

    @Nullable
    private static <T> T getNth(T @NotNull [] params, int n) {
        if (params == null) {
            GoLocalNameMacro.$$$reportNull$$$0(11);
        }
        return n >= 0 && n < params.length ? (T)params[n] : null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 5 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "params";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "importPath";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/goide/editor/template/GoLocalNameMacro";
                break;
            }
            case 6: 
            case 8: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/goide/editor/template/GoLocalNameMacro";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getPackageName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "calculateResult";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "registerOptimizeImportsListener";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getPackageName";
                break;
            }
            case 5: {
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getImportPath";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getName";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "getResult";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "getNth";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 5 -> new IllegalStateException(string);
        };
    }

    private static final class AddImportResult
    implements RecalculatableResult {
        private final GoFile myFile;
        private final String myImportPath;
        private final String myName;
        private String myText;
        private String myImportAlias;

        private AddImportResult(@NotNull GoFile file, @NotNull String importPath, @NotNull String name) {
            if (file == null) {
                AddImportResult.$$$reportNull$$$0(0);
            }
            if (importPath == null) {
                AddImportResult.$$$reportNull$$$0(1);
            }
            if (name == null) {
                AddImportResult.$$$reportNull$$$0(2);
            }
            this.myFile = file;
            this.myImportPath = importPath;
            this.myName = name;
        }

        public boolean equalsToText(String text, PsiElement context) {
            return text.equals(this.toString());
        }

        public String toString() {
            this.computeIfNeeded();
            return this.myText;
        }

        public void handleRecalc(PsiFile psiFile, Document document, int segmentStart, int segmentEnd) {
            Map<Object, Object> imports;
            this.computeIfNeeded();
            GoFile file = (GoFile)((Object)ObjectUtils.tryCast((Object)psiFile, GoFile.class));
            Map<Object, Object> map = imports = file != null ? file.getImportedPackagesMap() : Collections.emptyMap();
            if (file != null && !imports.containsKey(this.myImportPath) && this.myImportAlias != null) {
                new GoImportOptimizer().processFile((PsiFile)file).run();
                file.addImport(this.myImportPath, StringUtil.nullize((String)this.myImportAlias));
                PsiDocumentManager.getInstance((Project)file.getProject()).doPostponedOperationsAndUnblockDocument(document);
            }
        }

        private void computeIfNeeded() {
            if (this.myText == null) {
                GoImportSpec existingSpec = this.myFile.getImportedPackagesMap().get(this.myImportPath);
                if (existingSpec != null) {
                    String qualifier = (String)ContainerUtil.getFirstItem(GoPsiImplUtil.getImportQualifiersToUseInFile(existingSpec));
                    this.myText = StringUtil.isEmpty((String)qualifier) ? this.myName : qualifier + "." + this.myName;
                    this.myImportAlias = null;
                } else {
                    String packageName = GoLocalNameMacro.getPackageName(this.myImportPath, this.myFile.getProject(), (PsiElement)this.myFile);
                    String alias = UniqueNameGenerator.generateUniqueName((String)packageName, (Collection)this.myFile.getImportMap().keySet());
                    this.myText = alias + "." + this.myName;
                    this.myImportAlias = alias.equals(packageName) ? "" : alias;
                }
            }
        }

        public void handleFocused(PsiFile psiFile, Document document, int segmentStart, int segmentEnd) {
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "file";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "importPath";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[0] = "name";
                    break;
                }
            }
            objectArray[1] = "com/goide/editor/template/GoLocalNameMacro$AddImportResult";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

