/*
 * Decompiled with CFR 0.152.
 */
package com.goide.editor.template;

import com.goide.editor.template.GoLiveTemplateContextType;
import com.goide.psi.GoExpression;
import com.goide.psi.GoType;
import com.goide.psi.impl.GoElementFactory;
import com.goide.psi.impl.GoTypeUtil;
import com.intellij.codeInsight.template.Expression;
import com.intellij.codeInsight.template.ExpressionContext;
import com.intellij.codeInsight.template.Result;
import com.intellij.codeInsight.template.TemplateContextType;
import com.intellij.codeInsight.template.TextResult;
import com.intellij.codeInsight.template.macro.MacroBase;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.util.ArrayUtil;
import com.intellij.util.IntPair;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class GoErrorVariableDefinitionMacro
extends MacroBase {
    public GoErrorVariableDefinitionMacro() {
        super("errorVariableDefinition", "errorVariableDefinition(expressionWithErrorResult)");
    }

    @Nullable
    protected Result calculateResult(Expression @NotNull [] params, ExpressionContext context, boolean quick) {
        String paramText;
        Expression param;
        if (params == null) {
            GoErrorVariableDefinitionMacro.$$$reportNull$$$0(0);
        }
        Result paramResult = (param = (Expression)ArrayUtil.getFirstElement((Object[])params)) != null ? param.calculateResult(context) : null;
        String string = paramText = paramResult != null ? paramResult.toString() : null;
        if (paramText == null) {
            return null;
        }
        PsiElement contextElement = context.getPsiElementAtStartOffset();
        if (contextElement == null) {
            return null;
        }
        GoExpression expression = GoElementFactory.createElement(contextElement.getProject(), String.format("package fake; var _ = %s", paramText), GoExpression.class, contextElement);
        IntPair pair = GoErrorVariableDefinitionMacro.getResultsCountAndErrorIndex(expression);
        return pair != null ? new TextResult(GoErrorVariableDefinitionMacro.getBlankAndErrorVariableDefinitions(pair.first, pair.second, "err")) : null;
    }

    @Nullable
    public static IntPair getResultsCountAndErrorIndex(@Nullable GoExpression expression) {
        if (expression == null) {
            return null;
        }
        List<GoType> returnTypes = GoTypeUtil.getListOfTypesFromTypeList(expression.getGoType(null));
        int errorResultIndex = ContainerUtil.indexOf(returnTypes, t -> GoTypeUtil.isError(t, expression));
        if (errorResultIndex < 0) {
            return null;
        }
        return new IntPair(returnTypes.size(), errorResultIndex);
    }

    @NotNull
    public static String getBlankAndErrorVariableDefinitions(int variablesCount, int errorVariableIndex, @NotNull String errorVariableName) {
        if (errorVariableName == null) {
            GoErrorVariableDefinitionMacro.$$$reportNull$$$0(1);
        }
        assert (variablesCount > errorVariableIndex);
        ArrayList<String> defs = new ArrayList<String>(Collections.nCopies(variablesCount, "_"));
        defs.set(errorVariableIndex, errorVariableName);
        String string = StringUtil.join(defs, (String)", ");
        if (string == null) {
            GoErrorVariableDefinitionMacro.$$$reportNull$$$0(2);
        }
        return string;
    }

    public boolean isAcceptableInContext(TemplateContextType context) {
        return context instanceof GoLiveTemplateContextType;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "params";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "errorVariableName";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/goide/editor/template/GoErrorVariableDefinitionMacro";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/goide/editor/template/GoErrorVariableDefinitionMacro";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getBlankAndErrorVariableDefinitions";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "calculateResult";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getBlankAndErrorVariableDefinitions";
                break;
            }
            case 2: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2 -> new IllegalStateException(string);
        };
    }
}

