/*
 * Decompiled with CFR 0.152.
 */
package com.goide.editor.template;

import com.goide.GoPluginDisposable;
import com.goide.psi.GoType;
import com.goide.refactor.util.GoRefactoringUtil;
import com.intellij.codeInsight.hint.HintManager;
import com.intellij.codeInsight.hint.HintManagerImpl;
import com.intellij.codeInsight.hint.HintUtil;
import com.intellij.codeInsight.intention.preview.IntentionPreviewUtils;
import com.intellij.codeInsight.lookup.Lookup;
import com.intellij.codeInsight.lookup.LookupManager;
import com.intellij.codeInsight.template.Expression;
import com.intellij.codeInsight.template.ExpressionContext;
import com.intellij.codeInsight.template.Result;
import com.intellij.codeInsight.template.Template;
import com.intellij.codeInsight.template.TemplateEditingAdapter;
import com.intellij.codeInsight.template.TemplateEditingListener;
import com.intellij.codeInsight.template.impl.TemplateManagerImpl;
import com.intellij.codeInsight.template.impl.TemplateState;
import com.intellij.codeInsight.template.macro.CompleteMacro;
import com.intellij.codeInsight.template.macro.MacroBase;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.VisualPosition;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Key;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.ui.HintHint;
import com.intellij.ui.LightweightHint;
import com.intellij.util.ObjectUtils;
import java.awt.Point;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GoCompleteWithExpectedTypeMacro
extends MacroBase {
    private static final Key<GoType> EXPECTED_TYPE = Key.create((String)"go_expected_type");
    private static final ConcurrentMap<Project, Boolean> ourLookupListeners = new ConcurrentHashMap<Project, Boolean>();
    private final GoExpectedTypeInfo myExpectedTypeInfo;
    private final CompleteMacro myCompleteHandler;

    public GoCompleteWithExpectedTypeMacro(@NotNull GoType type2, @NotNull GoRefactoringUtil.TypeTextWithImports typeText, @NotNull String varName) {
        if (type2 == null) {
            GoCompleteWithExpectedTypeMacro.$$$reportNull$$$0(0);
        }
        if (typeText == null) {
            GoCompleteWithExpectedTypeMacro.$$$reportNull$$$0(1);
        }
        if (varName == null) {
            GoCompleteWithExpectedTypeMacro.$$$reportNull$$$0(2);
        }
        super("", "");
        this.myCompleteHandler = new CompleteMacro();
        this.myExpectedTypeInfo = new GoExpectedTypeInfo(type2, typeText, varName);
    }

    @Nullable
    protected Result calculateResult(Expression @NotNull [] params, ExpressionContext context, boolean quick) {
        Editor editor;
        TemplateState state;
        if (params == null) {
            GoCompleteWithExpectedTypeMacro.$$$reportNull$$$0(3);
        }
        TemplateState templateState = state = (editor = context.getEditor()) != null ? TemplateManagerImpl.getTemplateState((Editor)editor) : null;
        if (state != null) {
            final LightweightHint hint = new LightweightHint(HintUtil.createInformationLabel((String)this.myExpectedTypeInfo.getTypeText().typeText));
            GoCompleteWithExpectedTypeMacro.setExpectedType(state, this.myExpectedTypeInfo, hint);
            GoCompleteWithExpectedTypeMacro.registerCleanupListeners(context.getProject(), editor, state);
            final Result completionResult = this.myCompleteHandler.calculateResult(params, context);
            return new Result(){

                public boolean equalsToText(String text, PsiElement context) {
                    return completionResult.equalsToText(text, context);
                }

                public void handleFocused(PsiFile psiFile, Document document, int segmentStart, int segmentEnd) {
                    GoCompleteWithExpectedTypeMacro.this.showHint(editor, hint);
                    completionResult.handleFocused(psiFile, document, segmentStart, segmentEnd);
                }
            };
        }
        return this.myCompleteHandler.calculateResult(params, context);
    }

    private void showHint(@NotNull Editor editor, @NotNull LightweightHint hint) {
        if (editor == null) {
            GoCompleteWithExpectedTypeMacro.$$$reportNull$$$0(4);
        }
        if (hint == null) {
            GoCompleteWithExpectedTypeMacro.$$$reportNull$$$0(5);
        }
        if (IntentionPreviewUtils.isIntentionPreviewActive()) {
            return;
        }
        HintManager hintManager = HintManager.getInstance();
        HintManagerImpl hintManagerImpl = (HintManagerImpl)ObjectUtils.tryCast((Object)hintManager, HintManagerImpl.class);
        if (hintManagerImpl != null) {
            int flags = 1;
            int offset = editor.getCaretModel().getOffset();
            Point point = HintManagerImpl.getHintPosition((LightweightHint)hint, (Editor)editor, (VisualPosition)editor.offsetToVisualPosition(offset), (short)1);
            HintHint hintHint = HintManagerImpl.createHintHint((Editor)editor, (Point)point, (LightweightHint)hint, (short)1).setExplicitClose(true);
            hintManagerImpl.showEditorHint(hint, editor, point, flags, 0, false, hintHint);
        } else {
            hintManager.showInformationHint(editor, this.myExpectedTypeInfo.getTypeText().typeText);
        }
    }

    @Nullable
    public static GoExpectedTypeInfo getExpectedType(@NotNull TemplateState state) {
        if (state == null) {
            GoCompleteWithExpectedTypeMacro.$$$reportNull$$$0(6);
        }
        return (GoExpectedTypeInfo)ObjectUtils.tryCast(state.getProperties().get(EXPECTED_TYPE), GoExpectedTypeInfo.class);
    }

    private static void setExpectedType(@NotNull TemplateState state, @NotNull GoExpectedTypeInfo expectedTypeInfo, @NotNull LightweightHint hint) {
        if (state == null) {
            GoCompleteWithExpectedTypeMacro.$$$reportNull$$$0(7);
        }
        if (expectedTypeInfo == null) {
            GoCompleteWithExpectedTypeMacro.$$$reportNull$$$0(8);
        }
        if (hint == null) {
            GoCompleteWithExpectedTypeMacro.$$$reportNull$$$0(9);
        }
        state.getProperties().put(EXPECTED_TYPE, expectedTypeInfo);
        if (HintManager.getInstance() instanceof HintManagerImpl) {
            state.getProperties().put(GoCompleteWithExpectedTypeMacro.class, hint);
        }
    }

    private static void resetExpectedType(@NotNull Editor editor) {
        TemplateState state;
        if (editor == null) {
            GoCompleteWithExpectedTypeMacro.$$$reportNull$$$0(10);
        }
        if ((state = TemplateManagerImpl.getTemplateState((Editor)editor)) != null) {
            state.getProperties().remove(EXPECTED_TYPE);
            LightweightHint hint = (LightweightHint)ObjectUtils.tryCast(state.getProperties().remove(GoCompleteWithExpectedTypeMacro.class), LightweightHint.class);
            if (hint != null) {
                hint.hide();
            }
        }
    }

    private static void registerCleanupListeners(@NotNull Project project, final @NotNull Editor editor, @NotNull TemplateState state) {
        if (project == null) {
            GoCompleteWithExpectedTypeMacro.$$$reportNull$$$0(11);
        }
        if (editor == null) {
            GoCompleteWithExpectedTypeMacro.$$$reportNull$$$0(12);
        }
        if (state == null) {
            GoCompleteWithExpectedTypeMacro.$$$reportNull$$$0(13);
        }
        if (ourLookupListeners.putIfAbsent(project, true) == null) {
            LookupManager.getInstance((Project)project).addPropertyChangeListener(e -> {
                if ("activeLookup".equals(e.getPropertyName()) && e.getOldValue() != null && e.getNewValue() == null) {
                    Lookup lookup = (Lookup)e.getOldValue();
                    GoCompleteWithExpectedTypeMacro.resetExpectedType(lookup.getEditor());
                }
            }, GoPluginDisposable.getInstance(project));
            Disposer.register((Disposable)GoPluginDisposable.getInstance(project), () -> ourLookupListeners.remove(project));
        }
        state.addTemplateStateListener((TemplateEditingListener)new TemplateEditingAdapter(){

            public void templateFinished(@NotNull Template template, boolean brokenOff) {
                if (template == null) {
                    2.$$$reportNull$$$0(0);
                }
                GoCompleteWithExpectedTypeMacro.resetExpectedType(editor);
            }

            public void templateCancelled(Template template) {
                GoCompleteWithExpectedTypeMacro.resetExpectedType(editor);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "template", "com/goide/editor/template/GoCompleteWithExpectedTypeMacro$2", "templateFinished"));
            }
        });
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "typeText";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "varName";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "params";
                break;
            }
            case 4: 
            case 10: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 5: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "hint";
                break;
            }
            case 6: 
            case 7: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expectedTypeInfo";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
        }
        objectArray2[1] = "com/goide/editor/template/GoCompleteWithExpectedTypeMacro";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "calculateResult";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "showHint";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "getExpectedType";
                break;
            }
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[2] = "setExpectedType";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[2] = "resetExpectedType";
                break;
            }
            case 11: 
            case 12: 
            case 13: {
                objectArray = objectArray2;
                objectArray2[2] = "registerCleanupListeners";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    public static class GoExpectedTypeInfo {
        private final GoType myType;
        private final GoRefactoringUtil.TypeTextWithImports myTypeText;
        private final String myVarName;

        public GoExpectedTypeInfo(@NotNull GoType type2, @NotNull GoRefactoringUtil.TypeTextWithImports typeTextWithImports, @NotNull String varName) {
            if (type2 == null) {
                GoExpectedTypeInfo.$$$reportNull$$$0(0);
            }
            if (typeTextWithImports == null) {
                GoExpectedTypeInfo.$$$reportNull$$$0(1);
            }
            if (varName == null) {
                GoExpectedTypeInfo.$$$reportNull$$$0(2);
            }
            this.myType = type2;
            this.myTypeText = typeTextWithImports;
            this.myVarName = varName;
        }

        @NotNull
        public GoType getType() {
            GoType goType = this.myType;
            if (goType == null) {
                GoExpectedTypeInfo.$$$reportNull$$$0(3);
            }
            return goType;
        }

        @NotNull
        public String getVarName() {
            String string = this.myVarName;
            if (string == null) {
                GoExpectedTypeInfo.$$$reportNull$$$0(4);
            }
            return string;
        }

        @NotNull
        public GoRefactoringUtil.TypeTextWithImports getTypeText() {
            GoRefactoringUtil.TypeTextWithImports typeTextWithImports = this.myTypeText;
            if (typeTextWithImports == null) {
                GoExpectedTypeInfo.$$$reportNull$$$0(5);
            }
            return typeTextWithImports;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 3, 4, 5 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "type";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "typeTextWithImports";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "varName";
                    break;
                }
                case 3: 
                case 4: 
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/goide/editor/template/GoCompleteWithExpectedTypeMacro$GoExpectedTypeInfo";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/goide/editor/template/GoCompleteWithExpectedTypeMacro$GoExpectedTypeInfo";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getType";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getVarName";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getTypeText";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 3: 
                case 4: 
                case 5: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 3, 4, 5 -> new IllegalStateException(string);
            };
        }
    }
}

