/*
 * Decompiled with CFR 0.152.
 */
package com.goide.editor;

import com.goide.GoParserDefinition;
import com.goide.GoTypes;
import com.goide.directiveComment.GoEmbedComment;
import com.goide.psi.GoImportSpec;
import com.goide.psi.GoStringLiteral;
import com.intellij.codeInsight.editorActions.JavaLikeQuoteHandler;
import com.intellij.codeInsight.editorActions.SimpleTokenSetQuoteHandler;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.highlighter.HighlighterIterator;
import com.intellij.psi.PsiElement;
import com.intellij.psi.StringEscapesTokenTypes;
import com.intellij.psi.TokenType;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import com.intellij.psi.util.PsiUtilCore;
import org.jetbrains.annotations.NotNull;

public final class GoQuoteHandler
extends SimpleTokenSetQuoteHandler
implements JavaLikeQuoteHandler {
    private static final TokenSet SINGLE_LINE_LITERALS = TokenSet.create((IElementType[])new IElementType[]{GoTypes.STRING});

    public GoQuoteHandler() {
        super(new IElementType[]{GoTypes.STRING, GoTypes.RAW_STRING, GoTypes.CHAR, TokenType.BAD_CHARACTER});
    }

    public boolean isOpeningQuote(HighlighterIterator iterator, int offset) {
        return GoQuoteHandler.isQuoteInRawString(iterator, offset) || super.isOpeningQuote(iterator, offset) && !GoQuoteHandler.prevIsEscapeSequence(iterator) || GoQuoteHandler.isQuoteInGoEmbedComment(iterator, offset);
    }

    public boolean isClosingQuote(HighlighterIterator iterator, int offset) {
        return GoQuoteHandler.isQuoteInRawString(iterator, offset) || super.isClosingQuote(iterator, offset) || GoQuoteHandler.isQuoteInGoEmbedComment(iterator, offset);
    }

    public boolean hasNonClosedLiteral(Editor editor, HighlighterIterator iterator, int offset) {
        return super.hasNonClosedLiteral(editor, iterator, offset) || GoQuoteHandler.isGoEmbedComment(iterator);
    }

    private static boolean isQuoteInRawString(HighlighterIterator iterator, int offset) {
        Document document;
        if (iterator.getTokenType() == GoTypes.RAW_STRING && (document = iterator.getDocument()) != null) {
            char c = document.getCharsSequence().charAt(offset);
            return c == '\"' || c == '\'';
        }
        return false;
    }

    private static boolean prevIsEscapeSequence(HighlighterIterator iterator) {
        if (!iterator.atEnd()) {
            iterator.retreat();
            boolean prevIsEscape = false;
            if (!iterator.atEnd() && StringEscapesTokenTypes.STRING_LITERAL_ESCAPES.contains(iterator.getTokenType())) {
                prevIsEscape = true;
            }
            iterator.advance();
            return prevIsEscape;
        }
        return false;
    }

    private static boolean isQuoteInGoEmbedComment(HighlighterIterator iterator, int offset) {
        Document document = iterator.getDocument();
        if (document == null) {
            return false;
        }
        char c = document.getCharsSequence().charAt(offset);
        return (c == '\"' || c == '`') && GoQuoteHandler.isGoEmbedComment(iterator);
    }

    private static boolean isGoEmbedComment(HighlighterIterator iterator) {
        if (iterator.getTokenType() != GoParserDefinition.Lazy.LINE_COMMENT) {
            return false;
        }
        Document document = iterator.getDocument();
        return document != null && GoEmbedComment.isEmbedComment(document.getCharsSequence().subSequence(iterator.getStart(), iterator.getEnd()));
    }

    @NotNull
    public TokenSet getConcatenatableStringTokenTypes() {
        TokenSet tokenSet = SINGLE_LINE_LITERALS;
        if (tokenSet == null) {
            GoQuoteHandler.$$$reportNull$$$0(0);
        }
        return tokenSet;
    }

    public boolean canBeConcatenated(@NotNull PsiElement element) {
        IElementType type2;
        if (element == null) {
            GoQuoteHandler.$$$reportNull$$$0(1);
        }
        if ((type2 = PsiUtilCore.getElementType((PsiElement)element)) != GoTypes.STRING) {
            return false;
        }
        PsiElement parent = element.getParent();
        return parent instanceof GoStringLiteral && !(parent.getParent() instanceof GoImportSpec);
    }

    public String getStringConcatenationOperatorRepresentation() {
        return "+";
    }

    public TokenSet getStringTokenTypes() {
        return SINGLE_LINE_LITERALS;
    }

    public boolean isAppropriateElementTypeForLiteral(@NotNull IElementType tokenType) {
        if (tokenType == null) {
            GoQuoteHandler.$$$reportNull$$$0(2);
        }
        return true;
    }

    public boolean needParenthesesAroundConcatenation(PsiElement element) {
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 1, 2 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/goide/editor/GoQuoteHandler";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tokenType";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getConcatenatableStringTokenTypes";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "com/goide/editor/GoQuoteHandler";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "canBeConcatenated";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "isAppropriateElementTypeForLiteral";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 1, 2 -> new IllegalArgumentException(string);
        };
    }
}

