/*
 * Decompiled with CFR 0.152.
 */
package com.goide.editor;

import com.goide.GoTypes;
import com.goide.psi.GoFile;
import com.goide.utils.GoStringUtil;
import com.intellij.codeInsight.editorActions.CopyPastePreProcessor;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.RawText;
import com.intellij.openapi.editor.SelectionModel;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class GoCopyPasteProcessor
implements CopyPastePreProcessor {
    @Nullable
    public String preprocessOnCopy(PsiFile file, int[] startOffsets, int[] endOffsets, String text) {
        if (!GoCopyPasteProcessor.isSupportedFile(file)) {
            return null;
        }
        int currentOffset = 0;
        String[] selections = new String[startOffsets.length];
        for (int i = 0; i < startOffsets.length; ++i) {
            int selectionLength = endOffsets[i] - startOffsets[i];
            int endIndex = currentOffset + selectionLength;
            if (endIndex > text.length()) {
                return null;
            }
            String selectionText = text.substring(currentOffset, endIndex);
            currentOffset += selectionLength + 1;
            if (!GoCopyPasteProcessor.checkSelectionInsideStringOrChar(file, startOffsets[i], endOffsets[i])) {
                selections[i] = selectionText;
                continue;
            }
            GoStringUtil.GoDecodedString decodedString = GoStringUtil.decode(selectionText);
            selections[i] = decodedString.correct ? decodedString.unescapedString : text;
        }
        return StringUtil.join((String[])selections, (String)"\n");
    }

    @NotNull
    public String preprocessOnPaste(Project project, PsiFile file, Editor editor, String text, RawText rawText) {
        if (!GoCopyPasteProcessor.isSupportedFile(file)) {
            String string = text;
            if (string == null) {
                GoCopyPasteProcessor.$$$reportNull$$$0(0);
            }
            return string;
        }
        SelectionModel selectionModel = editor.getSelectionModel();
        String string = GoCopyPasteProcessor.checkSelectionInsideStringOrChar(file, selectionModel.getSelectionStart(), selectionModel.getSelectionEnd()) ? GoStringUtil.escapeString(text) : text;
        if (string == null) {
            GoCopyPasteProcessor.$$$reportNull$$$0(1);
        }
        return string;
    }

    private static boolean isSupportedFile(PsiFile file) {
        return file instanceof GoFile;
    }

    private static boolean checkSelectionInsideStringOrChar(@NotNull PsiFile file, int selectionStart, int selectionEnd) {
        PsiElement element;
        if (file == null) {
            GoCopyPasteProcessor.$$$reportNull$$$0(2);
        }
        if ((element = file.findElementAt(selectionStart)) == null || element.getNode().getElementType() != GoTypes.STRING) {
            return false;
        }
        TextRange textRange = element.getTextRange();
        return textRange.getStartOffset() < selectionStart && selectionEnd < textRange.getEndOffset();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 2 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/goide/editor/GoCopyPasteProcessor";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "preprocessOnPaste";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "com/goide/editor/GoCopyPasteProcessor";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "checkSelectionInsideStringOrChar";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 2 -> new IllegalArgumentException(string);
        };
    }
}

