/*
 * Decompiled with CFR 0.152.
 */
package com.goide.dlv;

import com.goide.dlv.DlvXValue;
import com.goide.dlv.GoFmtSprintfArgument;
import com.goide.dlv.GoFmtSprintfArgumentDynamic;
import com.goide.dlv.protocol.DlvApi;
import com.goide.i18n.GoBundle;
import com.goide.inspections.fmtstring.parser.GoFmtStringParser;
import com.goide.inspections.fmtstring.parser.tokens.GoFmtStringBadPlaceholder;
import com.goide.inspections.fmtstring.parser.tokens.GoFmtStringEscapedPercent;
import com.goide.inspections.fmtstring.parser.tokens.GoFmtStringPlaceholder;
import com.goide.inspections.fmtstring.parser.tokens.GoFmtStringTextParsed;
import com.goide.inspections.fmtstring.parser.tokens.GoFmtStringToken;
import com.goide.util.Value;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.ObjectUtils;
import java.math.BigInteger;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.concurrency.Promise;
import org.jetbrains.concurrency.Promises;

class GoFmtSprintfEvaluator {
    private final String myFormat;
    private final List<GoFmtSprintfArgument> myArgs;
    private final boolean myPrintDiagnostics;

    GoFmtSprintfEvaluator(@NotNull String format, @NotNull List<GoFmtSprintfArgument> args, boolean printDiagnostics) {
        if (format == null) {
            GoFmtSprintfEvaluator.$$$reportNull$$$0(0);
        }
        if (args == null) {
            GoFmtSprintfEvaluator.$$$reportNull$$$0(1);
        }
        this.myFormat = format;
        this.myArgs = args;
        this.myPrintDiagnostics = printDiagnostics;
    }

    @NotNull Promise<@Nullable String> eval(@NotNull DlvXValue dlvXValue, @NotNull DlvApi.Variable receiver) {
        if (dlvXValue == null) {
            GoFmtSprintfEvaluator.$$$reportNull$$$0(2);
        }
        if (receiver == null) {
            GoFmtSprintfEvaluator.$$$reportNull$$$0(3);
        }
        List<GoFmtStringToken> tokens = GoFmtStringParser.parse(this.myFormat, true);
        ArrayList<Promise> promises = new ArrayList<Promise>();
        int index = 0;
        for (GoFmtStringToken token : tokens) {
            if (token instanceof GoFmtStringEscapedPercent) {
                promises.add(Promises.resolvedPromise(Optional.of("%")));
                continue;
            }
            if (token instanceof GoFmtStringTextParsed || token instanceof GoFmtStringBadPlaceholder) {
                promises.add(Promises.resolvedPromise(Optional.of(token.getText())));
                continue;
            }
            if (!(token instanceof GoFmtStringPlaceholder)) continue;
            GoFmtStringPlaceholder placeholder = (GoFmtStringPlaceholder)token;
            Promise<String> formattedPromise = Promises.resolvedPromise(null);
            char verb = placeholder.getVerb();
            boolean supportedVerb = true;
            if (placeholder.getWidth() == null && placeholder.getPrecision() == null && placeholder.getVerbIndex() == null) {
                switch (verb) {
                    case 't': {
                        formattedPromise = this.formatBool(dlvXValue, receiver, index);
                        break;
                    }
                    case 'b': {
                        formattedPromise = this.formatBinary(dlvXValue, receiver, index);
                        break;
                    }
                    case 'd': {
                        formattedPromise = this.formatDecimal(dlvXValue, receiver, index);
                        break;
                    }
                    case 'X': 
                    case 'x': {
                        formattedPromise = this.formatHex(dlvXValue, receiver, index, verb == 'X');
                        break;
                    }
                    case 's': {
                        formattedPromise = this.formatString(dlvXValue, receiver, index);
                        break;
                    }
                    case 'F': 
                    case 'f': {
                        formattedPromise = this.formatFloat(dlvXValue, receiver, index);
                        break;
                    }
                    case 'q': {
                        formattedPromise = this.formatQuotedString(dlvXValue, receiver, index);
                        break;
                    }
                    case 'p': {
                        formattedPromise = this.formatPointer(receiver, index);
                        break;
                    }
                    default: {
                        supportedVerb = false;
                    }
                }
            }
            boolean supportedVerbFinal = supportedVerb;
            promises.add(formattedPromise.then(formatted -> {
                if (formatted != null) {
                    return Optional.of(formatted);
                }
                if (this.myPrintDiagnostics) {
                    if (placeholder.getWidth() != null || placeholder.getPrecision() != null || placeholder.getVerbIndex() != null) {
                        return Optional.of("%!" + placeholder.getText() + GoBundle.message((String)"go.debugger.fmt.sprintf.unsupported.format", (Object[])new Object[0]));
                    }
                    if (!supportedVerbFinal) {
                        return Optional.of("%!" + placeholder.getText() + GoBundle.message((String)"go.debugger.fmt.sprintf.unsupported.verb", (Object[])new Object[0]));
                    }
                    return Optional.of("%!" + verb + GoBundle.message((String)"go.debugger.fmt.sprintf.cannot.format.value", (Object[])new Object[0]));
                }
                return Optional.empty();
            }));
            ++index;
        }
        Promise promise = Promises.collectResults(promises).then(values -> {
            StringBuilder result = new StringBuilder();
            for (Optional value : values) {
                if (value.isPresent()) {
                    result.append((String)value.get());
                    continue;
                }
                return null;
            }
            return result.toString();
        });
        if (promise == null) {
            GoFmtSprintfEvaluator.$$$reportNull$$$0(4);
        }
        return promise;
    }

    @NotNull
    private Promise<String> formatFloat(@NotNull DlvXValue dlvXValue, @NotNull DlvApi.Variable receiver, int index) {
        if (dlvXValue == null) {
            GoFmtSprintfEvaluator.$$$reportNull$$$0(5);
        }
        if (receiver == null) {
            GoFmtSprintfEvaluator.$$$reportNull$$$0(6);
        }
        Promise promise = this.getValue(dlvXValue, receiver, index).then(value -> {
            Double d = value != null ? value.getDouble() : null;
            return d != null ? String.format("%f", d) : null;
        });
        if (promise == null) {
            GoFmtSprintfEvaluator.$$$reportNull$$$0(7);
        }
        return promise;
    }

    @NotNull
    private Promise<String> formatQuotedString(@NotNull DlvXValue dlvXValue, @NotNull DlvApi.Variable receiver, int index) {
        if (dlvXValue == null) {
            GoFmtSprintfEvaluator.$$$reportNull$$$0(8);
        }
        if (receiver == null) {
            GoFmtSprintfEvaluator.$$$reportNull$$$0(9);
        }
        Promise promise = this.getValue(dlvXValue, receiver, index).then(value -> {
            if (value == null) {
                return null;
            }
            String s = value.getString();
            if (s != null) {
                return "\"" + StringUtil.escapeStringCharacters((String)s) + "\"";
            }
            byte[] bytes = value.getBytes();
            return bytes != null ? "\"" + StringUtil.escapeStringCharacters((String)new String(bytes, StandardCharsets.UTF_8)) + "\"" : null;
        });
        if (promise == null) {
            GoFmtSprintfEvaluator.$$$reportNull$$$0(10);
        }
        return promise;
    }

    @NotNull
    private Promise<String> formatString(@NotNull DlvXValue dlvXValue, @NotNull DlvApi.Variable receiver, int index) {
        if (dlvXValue == null) {
            GoFmtSprintfEvaluator.$$$reportNull$$$0(11);
        }
        if (receiver == null) {
            GoFmtSprintfEvaluator.$$$reportNull$$$0(12);
        }
        Promise promise = this.getValue(dlvXValue, receiver, index).then(value -> {
            if (value == null) {
                return null;
            }
            String s = value.getString();
            if (s != null) {
                return s;
            }
            byte[] bytes = value.getBytes();
            return bytes != null ? new String(bytes, StandardCharsets.UTF_8) : null;
        });
        if (promise == null) {
            GoFmtSprintfEvaluator.$$$reportNull$$$0(13);
        }
        return promise;
    }

    @NotNull
    private Promise<String> formatPointer(@NotNull DlvApi.Variable receiver, int index) {
        GoFmtSprintfArgumentDynamic arg;
        if (receiver == null) {
            GoFmtSprintfEvaluator.$$$reportNull$$$0(14);
        }
        if ((arg = (GoFmtSprintfArgumentDynamic)ObjectUtils.tryCast((Object)this.getArgument(index), GoFmtSprintfArgumentDynamic.class)) != null) {
            BigInteger address = arg.getValueAddress(receiver);
            Promise promise = Promises.resolvedPromise(address != null ? "0x" + address.toString(16) : null);
            if (promise == null) {
                GoFmtSprintfEvaluator.$$$reportNull$$$0(15);
            }
            return promise;
        }
        Promise promise = Promises.resolvedPromise(null);
        if (promise == null) {
            GoFmtSprintfEvaluator.$$$reportNull$$$0(16);
        }
        return promise;
    }

    @NotNull
    private Promise<String> formatHex(@NotNull DlvXValue dlvXValue, @NotNull DlvApi.Variable receiver, int index, boolean upperCase) {
        if (dlvXValue == null) {
            GoFmtSprintfEvaluator.$$$reportNull$$$0(17);
        }
        if (receiver == null) {
            GoFmtSprintfEvaluator.$$$reportNull$$$0(18);
        }
        Promise promise = this.getValue(dlvXValue, receiver, index).then(value -> {
            if (value == null) {
                return null;
            }
            Long val = value.getInteger();
            if (val != null) {
                return GoFmtSprintfEvaluator.formatHex(val, 0, upperCase);
            }
            byte[] bytes = value.getBytes();
            if (bytes != null) {
                StringBuilder result = new StringBuilder();
                for (byte b : bytes) {
                    result.append(GoFmtSprintfEvaluator.formatHex(Long.valueOf(Byte.toUnsignedInt(b)), 2, upperCase));
                }
                return result.toString();
            }
            String valStr = value.getString();
            if (valStr != null) {
                return GoFmtSprintfEvaluator.formatCharsAsHex(valStr, upperCase);
            }
            return null;
        });
        if (promise == null) {
            GoFmtSprintfEvaluator.$$$reportNull$$$0(19);
        }
        return promise;
    }

    @NotNull
    private static String formatCharsAsHex(@NotNull String s, boolean upperCase) {
        if (s == null) {
            GoFmtSprintfEvaluator.$$$reportNull$$$0(20);
        }
        StringBuilder result = new StringBuilder();
        String format = upperCase ? "%02X" : "%02x";
        for (int i = 0; i < s.length(); ++i) {
            result.append(String.format(format, s.charAt(i)));
        }
        String string = result.toString();
        if (string == null) {
            GoFmtSprintfEvaluator.$$$reportNull$$$0(21);
        }
        return string;
    }

    @Nullable
    private static String formatHex(@Nullable Long val, int zeroPaddingWidth, boolean upperCase) {
        if (val == null) {
            return null;
        }
        Object padding = zeroPaddingWidth > 0 ? "0" + zeroPaddingWidth : "";
        String conversion = upperCase ? "X" : "x";
        String format = "%" + (String)padding + conversion;
        return val < 0L ? "-" + String.format(format, Math.abs(val)) : String.format(format, val);
    }

    @NotNull
    private Promise<String> formatDecimal(@NotNull DlvXValue dlvXValue, @NotNull DlvApi.Variable receiver, int index) {
        if (dlvXValue == null) {
            GoFmtSprintfEvaluator.$$$reportNull$$$0(22);
        }
        if (receiver == null) {
            GoFmtSprintfEvaluator.$$$reportNull$$$0(23);
        }
        Promise promise = this.getValue(dlvXValue, receiver, index).then(value -> GoFmtSprintfEvaluator.formatDecimal(value != null ? value.getInteger() : null));
        if (promise == null) {
            GoFmtSprintfEvaluator.$$$reportNull$$$0(24);
        }
        return promise;
    }

    @Nullable
    private static String formatDecimal(@Nullable Long val) {
        return val != null ? String.format("%d", val) : null;
    }

    @NotNull
    private Promise<String> formatBinary(@NotNull DlvXValue dlvXValue, @NotNull DlvApi.Variable receiver, int index) {
        if (dlvXValue == null) {
            GoFmtSprintfEvaluator.$$$reportNull$$$0(25);
        }
        if (receiver == null) {
            GoFmtSprintfEvaluator.$$$reportNull$$$0(26);
        }
        Promise promise = this.getValue(dlvXValue, receiver, index).then(value -> GoFmtSprintfEvaluator.formatBinary(value != null ? value.getInteger() : null));
        if (promise == null) {
            GoFmtSprintfEvaluator.$$$reportNull$$$0(27);
        }
        return promise;
    }

    @Nullable
    private static String formatBinary(@Nullable Long val) {
        if (val == null) {
            return null;
        }
        return val < 0L ? "-" + Long.toBinaryString(Math.abs(val)) : Long.toBinaryString(val);
    }

    @NotNull
    private Promise<String> formatBool(@NotNull DlvXValue dlvXValue, @NotNull DlvApi.Variable receiver, int index) {
        if (dlvXValue == null) {
            GoFmtSprintfEvaluator.$$$reportNull$$$0(28);
        }
        if (receiver == null) {
            GoFmtSprintfEvaluator.$$$reportNull$$$0(29);
        }
        Promise promise = this.getValue(dlvXValue, receiver, index).then(value -> {
            Boolean bool = value != null ? value.getBool() : null;
            return bool == null ? null : bool.toString();
        });
        if (promise == null) {
            GoFmtSprintfEvaluator.$$$reportNull$$$0(30);
        }
        return promise;
    }

    @NotNull
    private Promise<Value> getValue(@NotNull DlvXValue dlvXValue, @NotNull DlvApi.Variable receiver, int index) {
        GoFmtSprintfArgument arg;
        if (dlvXValue == null) {
            GoFmtSprintfEvaluator.$$$reportNull$$$0(31);
        }
        if (receiver == null) {
            GoFmtSprintfEvaluator.$$$reportNull$$$0(32);
        }
        Promise<Value> promise = (arg = this.getArgument(index)) != null ? arg.getValue(dlvXValue, receiver) : Promises.resolvedPromise(null);
        if (promise == null) {
            GoFmtSprintfEvaluator.$$$reportNull$$$0(33);
        }
        return promise;
    }

    @Nullable
    private GoFmtSprintfArgument getArgument(int index) {
        return index < this.myArgs.size() ? this.myArgs.get(index) : null;
    }

    int getMaxDynamicArgumentAccessorsDepth() {
        int result = 0;
        for (GoFmtSprintfArgument arg : this.myArgs) {
            if (!(arg instanceof GoFmtSprintfArgumentDynamic)) continue;
            result = Math.max(result, ((GoFmtSprintfArgumentDynamic)arg).getAccessorsDepth());
        }
        return result;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 4, 7, 10, 13, 15, 16, 19, 21, 24, 27, 30, 33 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "format";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "args";
                break;
            }
            case 2: 
            case 5: 
            case 8: 
            case 11: 
            case 17: 
            case 22: 
            case 25: 
            case 28: 
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dlvXValue";
                break;
            }
            case 3: 
            case 6: 
            case 9: 
            case 12: 
            case 14: 
            case 18: 
            case 23: 
            case 26: 
            case 29: 
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "receiver";
                break;
            }
            case 4: 
            case 7: 
            case 10: 
            case 13: 
            case 15: 
            case 16: 
            case 19: 
            case 21: 
            case 24: 
            case 27: 
            case 30: 
            case 33: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/goide/dlv/GoFmtSprintfEvaluator";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "s";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/goide/dlv/GoFmtSprintfEvaluator";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "eval";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "formatFloat";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "formatQuotedString";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "formatString";
                break;
            }
            case 15: 
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "formatPointer";
                break;
            }
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "formatHex";
                break;
            }
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "formatCharsAsHex";
                break;
            }
            case 24: {
                objectArray = objectArray2;
                objectArray2[1] = "formatDecimal";
                break;
            }
            case 27: {
                objectArray = objectArray2;
                objectArray2[1] = "formatBinary";
                break;
            }
            case 30: {
                objectArray = objectArray2;
                objectArray2[1] = "formatBool";
                break;
            }
            case 33: {
                objectArray = objectArray2;
                objectArray2[1] = "getValue";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "eval";
                break;
            }
            case 4: 
            case 7: 
            case 10: 
            case 13: 
            case 15: 
            case 16: 
            case 19: 
            case 21: 
            case 24: 
            case 27: 
            case 30: 
            case 33: {
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "formatFloat";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "formatQuotedString";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "formatString";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "formatPointer";
                break;
            }
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "formatHex";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "formatCharsAsHex";
                break;
            }
            case 22: 
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "formatDecimal";
                break;
            }
            case 25: 
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "formatBinary";
                break;
            }
            case 28: 
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "formatBool";
                break;
            }
            case 31: 
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "getValue";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 4, 7, 10, 13, 15, 16, 19, 21, 24, 27, 30, 33 -> new IllegalStateException(string);
        };
    }
}

