/*
 * Decompiled with CFR 0.152.
 */
package com.goide.dlv;

import com.goide.dlv.DlvNamedType;
import com.goide.dlv.DlvSettings;
import com.goide.dlv.DlvStackFrame;
import com.goide.dlv.DlvUtil;
import com.goide.dlv.DlvValueRenderer;
import com.goide.dlv.DlvValueRendererSelectableInUi;
import com.goide.dlv.DlvXValue;
import com.goide.dlv.DvlUnreadableValuePresentation;
import com.goide.dlv.GoFmtSprintfArgument;
import com.goide.dlv.GoFmtSprintfArgumentDynamic;
import com.goide.dlv.GoFmtSprintfArgumentStatic;
import com.goide.dlv.GoFmtSprintfEvaluator;
import com.goide.dlv.protocol.DlvApi;
import com.goide.dlv.protocol.DlvRequest;
import com.goide.i18n.GoBundle;
import com.goide.inspections.fmtstring.GoFmtStringUtil;
import com.goide.psi.GoBlock;
import com.goide.psi.GoCallExpr;
import com.goide.psi.GoExpression;
import com.goide.psi.GoMethodDeclaration;
import com.goide.psi.GoPointerType;
import com.goide.psi.GoReceiver;
import com.goide.psi.GoReferenceExpression;
import com.goide.psi.GoReturnStatement;
import com.goide.psi.GoSignature;
import com.goide.psi.GoType;
import com.goide.psi.GoTypeSpec;
import com.goide.psi.GoUnaryExpr;
import com.goide.psi.impl.GoPsiImplUtil;
import com.goide.psi.impl.GoTypeUtil;
import com.goide.stubs.index.GoMethodIndex;
import com.goide.util.GoPathResolveScope;
import com.goide.util.GoStdlibUtil;
import com.goide.util.Value;
import com.goide.vendor.GoVendoringUtil;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.progress.EmptyProgressIndicator;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.SyntaxTraverser;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.xdebugger.XDebugSession;
import com.intellij.xdebugger.frame.XValueNode;
import com.intellij.xdebugger.frame.presentation.XKeywordValuePresentation;
import com.intellij.xdebugger.frame.presentation.XNumericValuePresentation;
import com.intellij.xdebugger.frame.presentation.XRegularValuePresentation;
import com.intellij.xdebugger.frame.presentation.XStringValuePresentation;
import com.intellij.xdebugger.frame.presentation.XValuePresentation;
import com.intellij.xdebugger.impl.ui.tree.nodes.WatchNodeImpl;
import com.intellij.xdebugger.impl.ui.tree.nodes.XValueNodeImpl;
import java.math.BigInteger;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.time.DateTimeException;
import java.time.LocalDateTime;
import java.time.Month;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.TimeUnit;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.concurrency.AsyncPromise;
import org.jetbrains.concurrency.Promise;
import org.jetbrains.concurrency.Promises;

public class DlvValueRenderers {
    @NlsSafe
    private static final String TIME_DURATION = "time.Duration";
    @NlsSafe
    private static final String TIME_TIME = "time.Time";
    @NlsSafe
    private static final String NET_IP = "net.IP";
    @NlsSafe
    private static final String NET_IPMASK = "net.IPMask";
    @NlsSafe
    private static final String NET_IPNET = "net.IPNet";
    @NlsSafe
    private static final String NET_HTTP_REQUEST = "net/http.Request";
    @NonNls
    private static final ZoneId UTC = ZoneId.of("UTC");
    @NlsSafe
    private static final String NIL = "<nil>";
    private final ConcurrentMap<Object, DlvValueRenderer> myCustomRenderers = new ConcurrentHashMap<Object, DlvValueRenderer>();
    static final DlvValueRendererSelectableInUi BINARY = new IntegerValueRenderer(GoBundle.message((String)"go.debugger.renderers.binary.name", (Object[])new Object[0])){

        @Override
        @NotNull
        public String formatNumericValue(@NotNull DlvApi.Variable var) {
            String string;
            if (var == null) {
                1.$$$reportNull$$$0(0);
            }
            String value = var.value;
            try {
                long v = new BigInteger(value, 10).longValue();
                string = "0b" + Long.toBinaryString(v);
            }
            catch (NumberFormatException e) {
                String string2 = StringUtil.notNullize((String)value);
                if (string2 == null) {
                    1.$$$reportNull$$$0(2);
                }
                return string2;
            }
            if (string == null) {
                1.$$$reportNull$$$0(1);
            }
            return string;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 1, 2 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "var";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/goide/dlv/DlvValueRenderers$1";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/goide/dlv/DlvValueRenderers$1";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "formatNumericValue";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "formatNumericValue";
                    break;
                }
                case 1: 
                case 2: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 1, 2 -> new IllegalStateException(string);
            };
        }
    };
    static final DlvValueRendererSelectableInUi DECIMAL = new IntegerValueRenderer(GoBundle.message((String)"go.debugger.renderers.decimal.name", (Object[])new Object[0])){

        @Override
        @NotNull
        public String formatNumericValue(@NotNull DlvApi.Variable var) {
            if (var == null) {
                2.$$$reportNull$$$0(0);
            }
            String string = StringUtil.notNullize((String)var.value);
            if (string == null) {
                2.$$$reportNull$$$0(1);
            }
            return string;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 1 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "var";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/goide/dlv/DlvValueRenderers$2";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/goide/dlv/DlvValueRenderers$2";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "formatNumericValue";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "formatNumericValue";
                    break;
                }
                case 1: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 1 -> new IllegalStateException(string);
            };
        }
    };
    static final DlvValueRendererSelectableInUi HEX = new IntegerValueRenderer(GoBundle.message((String)"go.debugger.renderers.hex.name", (Object[])new Object[0])){

        @Override
        @NotNull
        public String formatNumericValue(@NotNull DlvApi.Variable var) {
            String string;
            if (var == null) {
                3.$$$reportNull$$$0(0);
            }
            String value = var.value;
            try {
                long v = new BigInteger(value, 10).longValue();
                string = "0x" + StringUtil.toUpperCase((String)Long.toHexString(v));
            }
            catch (NumberFormatException e) {
                String string2 = StringUtil.notNullize((String)value);
                if (string2 == null) {
                    3.$$$reportNull$$$0(2);
                }
                return string2;
            }
            if (string == null) {
                3.$$$reportNull$$$0(1);
            }
            return string;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 1, 2 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "var";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/goide/dlv/DlvValueRenderers$3";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/goide/dlv/DlvValueRenderers$3";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "formatNumericValue";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "formatNumericValue";
                    break;
                }
                case 1: 
                case 2: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 1, 2 -> new IllegalStateException(string);
            };
        }
    };
    public static final DlvValueRenderer DEFAULT = new DlvValueRenderer(){

        @Override
        @NotNull
        public @NotNull Promise<@NotNull XValuePresentation> getPresentation(@NotNull XValueNode node, @NotNull DlvXValue value) {
            if (node == null) {
                4.$$$reportNull$$$0(0);
            }
            if (value == null) {
                4.$$$reportNull$$$0(1);
            }
            DlvApi.Variable var = value.getVariable();
            String varValue = (String)ObjectUtils.notNull((Object)var.value, (Object)"");
            Promise promise = value.getTypePresentationAsync(node).then(typePresentation -> {
                if (var.isNumber()) {
                    return new XNumericValuePresentation(varValue, (String)typePresentation, varValue){
                        final /* synthetic */ String val$typePresentation;
                        final /* synthetic */ String val$varValue;
                        {
                            this.val$typePresentation = string;
                            this.val$varValue = string2;
                            super(arg0);
                        }

                        @Nullable
                        public String getType() {
                            return this.val$typePresentation;
                        }

                        @NotNull
                        public String getSeparator() {
                            String string = StringUtil.isEmpty((String)this.val$typePresentation) && StringUtil.isEmpty((String)this.val$varValue) ? "" : super.getSeparator();
                            if (string == null) {
                                1.$$$reportNull$$$0(0);
                            }
                            return string;
                        }

                        private static /* synthetic */ void $$$reportNull$$$0(int n) {
                            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/goide/dlv/DlvValueRenderers$4$1", "getSeparator"));
                        }
                    };
                }
                if (var.isString()) {
                    return new XStringValuePresentation(varValue, (String)typePresentation){
                        final /* synthetic */ String val$typePresentation;
                        {
                            this.val$typePresentation = string;
                            super(arg0);
                        }

                        @Nullable
                        public String getType() {
                            return this.val$typePresentation;
                        }
                    };
                }
                if (var.isBool()) {
                    return new XKeywordValuePresentation(varValue, (String)typePresentation, varValue){
                        final /* synthetic */ String val$typePresentation;
                        final /* synthetic */ String val$varValue;
                        {
                            this.val$typePresentation = string;
                            this.val$varValue = string2;
                            super(arg0);
                        }

                        @Nullable
                        public String getType() {
                            return this.val$typePresentation;
                        }

                        @NotNull
                        public String getSeparator() {
                            String string = StringUtil.isEmpty((String)this.val$typePresentation) && StringUtil.isEmpty((String)this.val$varValue) ? "" : super.getSeparator();
                            if (string == null) {
                                3.$$$reportNull$$$0(0);
                            }
                            return string;
                        }

                        private static /* synthetic */ void $$$reportNull$$$0(int n) {
                            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/goide/dlv/DlvValueRenderers$4$3", "getSeparator"));
                        }
                    };
                }
                if (var.isSlice() || var.isArray()) {
                    return new DefaultSliceOrArrayPresentation(var, (String)typePresentation);
                }
                return new DlvRegularValuePresentation(varValue, (String)typePresentation);
            });
            if (promise == null) {
                4.$$$reportNull$$$0(2);
            }
            return promise;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 2 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "node";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "value";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/goide/dlv/DlvValueRenderers$4";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/goide/dlv/DlvValueRenderers$4";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getPresentation";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "getPresentation";
                    break;
                }
                case 2: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 2 -> new IllegalStateException(string);
            };
        }
    };

    @NotNull
    public DlvValueRenderer getRenderer(@Nullable DlvStackFrame frame, @NotNull XValueNode node, @NotNull DlvXValue value) {
        if (node == null) {
            DlvValueRenderers.$$$reportNull$$$0(0);
        }
        if (value == null) {
            DlvValueRenderers.$$$reportNull$$$0(1);
        }
        if (value.isUnreadable()) {
            return new DlvUnreadableValueRenderer();
        }
        if (value.isNil()) {
            return new DlvNilValueRenderer();
        }
        Object id = frame != null ? DlvValueRenderers.getId(frame, node) : null;
        DlvValueRenderer customRenderer = id != null ? (DlvValueRenderer)this.myCustomRenderers.get(id) : null;
        return customRenderer != null ? customRenderer : DlvValueRenderers.getDefaultRenderer(node);
    }

    public void setRenderer(@NotNull DlvStackFrame frame, @NotNull XValueNode node, @NotNull DlvValueRenderer renderer) {
        Object id;
        if (frame == null) {
            DlvValueRenderers.$$$reportNull$$$0(2);
        }
        if (node == null) {
            DlvValueRenderers.$$$reportNull$$$0(3);
        }
        if (renderer == null) {
            DlvValueRenderers.$$$reportNull$$$0(4);
        }
        if ((id = DlvValueRenderers.getId(frame, node)) == null) {
            return;
        }
        DlvValueRenderer defaultRenderer = DlvValueRenderers.getDefaultRenderer(node);
        if (renderer == defaultRenderer) {
            this.myCustomRenderers.remove(id);
        } else {
            this.myCustomRenderers.put(id, renderer);
        }
    }

    @NotNull
    public static Collection<DlvValueRendererSelectableInUi> getRenderersSelectableInUi() {
        List<DlvValueRendererSelectableInUi> list = Arrays.asList(BINARY, DECIMAL, HEX);
        if (list == null) {
            DlvValueRenderers.$$$reportNull$$$0(5);
        }
        return list;
    }

    @NotNull
    private static DlvValueRenderer getDefaultRenderer(@NotNull XValueNode node) {
        DlvXValue dlvValue;
        if (node == null) {
            DlvValueRenderers.$$$reportNull$$$0(6);
        }
        if ((dlvValue = DlvXValue.getNodeValue(node)) != null) {
            String type2 = dlvValue.getVariable().type;
            if (TIME_DURATION.equals(type2)) {
                return new DlvDurationValueRenderer();
            }
            if (TIME_TIME.equals(type2)) {
                return new DlvTimeValueRenderer(dlvValue);
            }
            if (NET_IP.equals(type2)) {
                return new DlvIpValueRenderer();
            }
            if (NET_IPMASK.equals(type2)) {
                return new DlvIpMaskValueRenderer();
            }
            if (NET_IPNET.equals(type2)) {
                return new DlvIpNetValueRenderer();
            }
            if (NET_HTTP_REQUEST.equals(type2)) {
                return new DlvHttpRequestRenderer();
            }
            Project project = dlvValue.getProject();
            if (project != null) {
                DlvValueRenderer defaultRenderer = dlvValue.getVariable().isInteger() ? DlvSettings.getInstance().getDefaultIntegerRenderer() : DEFAULT;
                return new DlvStringerValueRenderer(project, defaultRenderer, dlvValue);
            }
        }
        DlvValueRenderer dlvValueRenderer = DEFAULT;
        if (dlvValueRenderer == null) {
            DlvValueRenderers.$$$reportNull$$$0(7);
        }
        return dlvValueRenderer;
    }

    @Nullable
    private static Object getId(@NotNull DlvStackFrame frame, @NotNull XValueNode node) {
        DlvXValue dlvValue;
        if (frame == null) {
            DlvValueRenderers.$$$reportNull$$$0(8);
        }
        if (node == null) {
            DlvValueRenderers.$$$reportNull$$$0(9);
        }
        if (node instanceof XValueNodeImpl && (dlvValue = (DlvXValue)((Object)ObjectUtils.tryCast((Object)((XValueNodeImpl)node).getValueContainer(), DlvXValue.class))) != null) {
            String functionName;
            DlvApi.Function function = frame.getLocation().function;
            String string = functionName = function != null ? function.name : null;
            if (functionName == null) {
                return null;
            }
            DlvApi.Variable var = dlvValue.getVariable();
            return Pair.create((Object)Pair.create((Object)functionName, (Object)var.addr), (Object)Pair.create((Object)var.name, (Object)(node instanceof WatchNodeImpl)));
        }
        return node;
    }

    @NotNull
    private static ZoneId tryGetZoneId(@NotNull String zoneName, int offsetHours) {
        ZoneId zoneId;
        if (zoneName == null) {
            DlvValueRenderers.$$$reportNull$$$0(10);
        }
        try {
            zoneId = ZoneId.of(zoneName);
        }
        catch (DateTimeException e) {
            ZoneId zoneId2 = ZoneId.of(ZoneOffset.ofHours(offsetHours).getId());
            if (zoneId2 == null) {
                DlvValueRenderers.$$$reportNull$$$0(12);
            }
            return zoneId2;
        }
        if (zoneId == null) {
            DlvValueRenderers.$$$reportNull$$$0(11);
        }
        return zoneId;
    }

    private static Promise<DlvApi.Variable> loadChildrenIfNeeded(@NotNull DlvXValue value, @NotNull DlvApi.Variable var) {
        if (value == null) {
            DlvValueRenderers.$$$reportNull$$$0(13);
        }
        if (var == null) {
            DlvValueRenderers.$$$reportNull$$$0(14);
        }
        return var.children.length == 0 ? value.getProcess().send(new DlvRequest.Eval(DlvXValue.evaluationExpression(var), value.myFrameId, value.myGoroutineId)) : Promises.resolvedPromise((Object)var);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 5, 7, 11, 12 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
            case 1: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "value";
                break;
            }
            case 2: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "frame";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "renderer";
                break;
            }
            case 5: 
            case 7: 
            case 11: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/goide/dlv/DlvValueRenderers";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "zoneName";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "var";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/goide/dlv/DlvValueRenderers";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getRenderersSelectableInUi";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getDefaultRenderer";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "tryGetZoneId";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getRenderer";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "setRenderer";
                break;
            }
            case 5: 
            case 7: 
            case 11: 
            case 12: {
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getDefaultRenderer";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getId";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "tryGetZoneId";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "loadChildrenIfNeeded";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 5, 7, 11, 12 -> new IllegalStateException(string);
        };
    }

    private static final class DlvUnreadableValueRenderer
    implements DlvValueRenderer {
        private DlvUnreadableValueRenderer() {
        }

        @Override
        public @NotNull Promise<@Nullable XValuePresentation> getPresentation(@NotNull XValueNode node, @NotNull DlvXValue value) {
            if (node == null) {
                DlvUnreadableValueRenderer.$$$reportNull$$$0(0);
            }
            if (value == null) {
                DlvUnreadableValueRenderer.$$$reportNull$$$0(1);
            }
            Promise promise = value.getTypePresentationAsync(node).then(type2 -> new DvlUnreadableValuePresentation((String)type2, value.getVariable().unreadable));
            if (promise == null) {
                DlvUnreadableValueRenderer.$$$reportNull$$$0(2);
            }
            return promise;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 2 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "node";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "value";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/goide/dlv/DlvValueRenderers$DlvUnreadableValueRenderer";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/goide/dlv/DlvValueRenderers$DlvUnreadableValueRenderer";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getPresentation";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "getPresentation";
                    break;
                }
                case 2: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 2 -> new IllegalStateException(string);
            };
        }
    }

    private static final class DlvNilValueRenderer
    implements DlvValueRenderer {
        private DlvNilValueRenderer() {
        }

        @Override
        public @NotNull Promise<@Nullable XValuePresentation> getPresentation(@NotNull XValueNode node, @NotNull DlvXValue value) {
            if (node == null) {
                DlvNilValueRenderer.$$$reportNull$$$0(0);
            }
            if (value == null) {
                DlvNilValueRenderer.$$$reportNull$$$0(1);
            }
            Promise promise = value.getTypePresentationAsync(node).thenAsync(type2 -> DlvNilValueRenderer.getNonNilConcreteValueTypeAsync(node, value).then(typedNil -> new XValuePresentation((String)typedNil, (String)type2){
                final /* synthetic */ String val$typedNil;
                final /* synthetic */ String val$type;
                {
                    this.val$typedNil = string;
                    this.val$type = string2;
                }

                public void renderValue(@NotNull XValuePresentation.XValueTextRenderer renderer) {
                    if (renderer == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    if (this.val$typedNil != null) {
                        renderer.renderValue(this.val$typedNil);
                    } else {
                        renderer.renderKeywordValue("nil");
                    }
                }

                @Nullable
                public String getType() {
                    return this.val$type;
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "renderer", "com/goide/dlv/DlvValueRenderers$DlvNilValueRenderer$1", "renderValue"));
                }
            }));
            if (promise == null) {
                DlvNilValueRenderer.$$$reportNull$$$0(2);
            }
            return promise;
        }

        private static @NotNull Promise<@Nullable String> getNonNilConcreteValueTypeAsync(@NotNull XValueNode node, @NotNull DlvXValue value) {
            boolean nonNilConcreteValue;
            DlvXValue pointer;
            if (node == null) {
                DlvNilValueRenderer.$$$reportNull$$$0(3);
            }
            if (value == null) {
                DlvNilValueRenderer.$$$reportNull$$$0(4);
            }
            DlvApi.Variable variable = (pointer = value.getTopFollowedPointer()) != null ? pointer.getVariable() : null;
            boolean bl = nonNilConcreteValue = variable != null && variable.isInterface() && variable.children.length == 1 && !DlvXValue.isZero(variable.children[0].addr);
            if (!nonNilConcreteValue) {
                Promise promise = Promises.resolvedPromise(null);
                if (promise == null) {
                    DlvNilValueRenderer.$$$reportNull$$$0(5);
                }
                return promise;
            }
            Promise promise = value.getTypePartsAsync(node).then(typeParts -> {
                if (typeParts.size() > 1) {
                    List typesExceptFirst = typeParts.subList(1, typeParts.size());
                    return String.join((CharSequence)"(", typesExceptFirst) + "(nil" + ")".repeat(typesExceptFirst.size());
                }
                return null;
            });
            if (promise == null) {
                DlvNilValueRenderer.$$$reportNull$$$0(6);
            }
            return promise;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 2, 5, 6 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "node";
                    break;
                }
                case 1: 
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "value";
                    break;
                }
                case 2: 
                case 5: 
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/goide/dlv/DlvValueRenderers$DlvNilValueRenderer";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/goide/dlv/DlvValueRenderers$DlvNilValueRenderer";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getPresentation";
                    break;
                }
                case 5: 
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getNonNilConcreteValueTypeAsync";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "getPresentation";
                    break;
                }
                case 2: 
                case 5: 
                case 6: {
                    break;
                }
                case 3: 
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "getNonNilConcreteValueTypeAsync";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 2, 5, 6 -> new IllegalStateException(string);
            };
        }
    }

    private static class DlvDurationValueRenderer
    implements DlvValueRenderer {
        private DlvDurationValueRenderer() {
        }

        @Override
        public @NotNull Promise<@Nullable XValuePresentation> getPresentation(@NotNull XValueNode node, final @NotNull DlvXValue value) {
            if (node == null) {
                DlvDurationValueRenderer.$$$reportNull$$$0(0);
            }
            if (value == null) {
                DlvDurationValueRenderer.$$$reportNull$$$0(1);
            }
            Promise promise = value.getTypePresentationAsync(node).then(type2 -> new XValuePresentation((String)type2){
                final /* synthetic */ String val$type;
                {
                    this.val$type = string;
                }

                public void renderValue(@NotNull XValuePresentation.XValueTextRenderer renderer) {
                    if (renderer == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    String numericValue = DlvDurationValueRenderer.getNumericValue(value.getVariable().value);
                    renderer.renderNumericValue(numericValue);
                    try {
                        long ns = Long.parseLong(numericValue);
                        renderer.renderSpecialSymbol(" ");
                        renderer.renderComment(DlvDurationValueRenderer.formatDuration(ns));
                    }
                    catch (NumberFormatException numberFormatException) {
                        // empty catch block
                    }
                }

                public String getType() {
                    return this.val$type;
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "renderer", "com/goide/dlv/DlvValueRenderers$DlvDurationValueRenderer$1", "renderValue"));
                }
            });
            if (promise == null) {
                DlvDurationValueRenderer.$$$reportNull$$$0(2);
            }
            return promise;
        }

        private static String getNumericValue(@NotNull @NonNls String value) {
            if (value == null) {
                DlvDurationValueRenderer.$$$reportNull$$$0(3);
            }
            return switch (value) {
                case "Nanosecond", "Nanosecond (1)" -> "1";
                case "Microsecond", "Microsecond (1000)" -> "1000";
                case "Millisecond", "Millisecond (1000000)" -> "1000000";
                case "Second", "Second (1000000000)" -> "1000000000";
                case "Minute", "Minute (60000000000)" -> "60000000000";
                case "Hour", "Hour (3600000000000)" -> "3600000000000";
                default -> value;
            };
        }

        @NonNls
        private static String formatDuration(long ns) {
            long hours;
            if (ns == 0L) {
                return "0s";
            }
            String sign = ns < 0L ? "-" : "";
            if ((ns = Math.abs(ns)) < TimeUnit.MICROSECONDS.toNanos(1L)) {
                return sign + ns + "ns";
            }
            if (ns < TimeUnit.MILLISECONDS.toNanos(1L)) {
                long micros = TimeUnit.NANOSECONDS.toMicros(ns);
                return sign + micros + DlvDurationValueRenderer.getFraction(ns, TimeUnit.MICROSECONDS.toNanos(1L)) + "\u00b5s";
            }
            if (ns < TimeUnit.SECONDS.toNanos(1L)) {
                long millis = TimeUnit.NANOSECONDS.toMillis(ns);
                return sign + millis + DlvDurationValueRenderer.getFraction(ns, TimeUnit.MILLISECONDS.toNanos(1L)) + "ms";
            }
            long seconds = TimeUnit.NANOSECONDS.toSeconds(ns);
            String result = seconds % 60L + DlvDurationValueRenderer.getFraction(ns, TimeUnit.SECONDS.toNanos(1L)) + "s";
            long minutes = seconds / 60L;
            if (minutes > 0L) {
                result = minutes % 60L + "m" + result;
            }
            if ((hours = minutes / 60L) > 0L) {
                result = hours + "h" + result;
            }
            return sign + result;
        }

        @NotNull
        private static String getFraction(long value, long precision) {
            long fraction = value - precision * (value / precision);
            if (fraction == 0L) {
                return "";
            }
            String width = String.valueOf((int)Math.log10(precision));
            String string = StringUtil.trimTrailing((String)String.format(".%0" + width + "d", fraction), (char)'0');
            if (string == null) {
                DlvDurationValueRenderer.$$$reportNull$$$0(4);
            }
            return string;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 2, 4 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "node";
                    break;
                }
                case 1: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "value";
                    break;
                }
                case 2: 
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/goide/dlv/DlvValueRenderers$DlvDurationValueRenderer";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/goide/dlv/DlvValueRenderers$DlvDurationValueRenderer";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getPresentation";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFraction";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "getPresentation";
                    break;
                }
                case 2: 
                case 4: {
                    break;
                }
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "getNumericValue";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 2, 4 -> new IllegalStateException(string);
            };
        }
    }

    private static final class DlvTimeValueRenderer
    implements DlvValueRenderer {
        private static final BigInteger NANOS_MASK = BigInteger.valueOf(0x3FFFFFFFL);
        private static final LocalDateTime MONOTONIC_TIME_ORIGIN = LocalDateTime.of(1885, Month.JANUARY, 1, 0, 0);
        private static final LocalDateTime NON_MONOTONIC_TIME_ORIGIN = LocalDateTime.of(1, Month.JANUARY, 1, 0, 0);
        private final DlvXValue myValue;

        private DlvTimeValueRenderer(@NotNull DlvXValue value) {
            if (value == null) {
                DlvTimeValueRenderer.$$$reportNull$$$0(0);
            }
            this.myValue = value;
        }

        @Override
        public @NotNull Promise<@Nullable XValuePresentation> getPresentation(@NotNull XValueNode node, @NotNull DlvXValue value) {
            if (node == null) {
                DlvTimeValueRenderer.$$$reportNull$$$0(1);
            }
            if (value == null) {
                DlvTimeValueRenderer.$$$reportNull$$$0(2);
            }
            Promise promise = this.computeValue(value.getVariable()).thenAsync(v -> v != null ? value.getTypePresentationAsync(node).then(t -> new DlvRegularValuePresentation((String)v, (String)t)) : DEFAULT.getPresentation(node, value));
            if (promise == null) {
                DlvTimeValueRenderer.$$$reportNull$$$0(3);
            }
            return promise;
        }

        private @NotNull Promise<@Nullable String> computeValue(@NotNull DlvApi.Variable var) {
            Promise promise;
            long nanos;
            long ext;
            DlvApi.Variable locVar;
            block9: {
                if (var == null) {
                    DlvTimeValueRenderer.$$$reportNull$$$0(4);
                }
                DlvApi.Variable[] children = var.children;
                DlvApi.Variable wallVar = DlvUtil.getByName(children, "wall");
                DlvApi.Variable extVar = DlvUtil.getByName(children, "ext");
                locVar = DlvUtil.getByName(children, "loc");
                if (wallVar == null || extVar == null || locVar == null) {
                    Promise promise2 = Promises.resolvedPromise(null);
                    if (promise2 == null) {
                        DlvTimeValueRenderer.$$$reportNull$$$0(5);
                    }
                    return promise2;
                }
                BigInteger wall = new BigInteger(wallVar.value);
                ext = Long.parseLong(extVar.value);
                nanos = wall.and(NANOS_MASK).longValue();
                if (!DlvTimeValueRenderer.hasMonotonic(wall)) break block9;
                long seconds = wall.clearBit(63).shiftRight(30).longValue();
                ZonedDateTime time = ZonedDateTime.of(MONOTONIC_TIME_ORIGIN, UTC).plusSeconds(seconds).plusNanos(nanos).withZoneSameInstant(ZoneId.systemDefault());
                String nanoFormat = DlvTimeValueRenderer.getNanoFormat(time.getNano());
                Promise promise3 = Promises.resolvedPromise((Object)time.format(DateTimeFormatter.ofPattern("uuuu-MM-dd HH:mm:ss" + nanoFormat + " ZZZ 'm=" + DlvTimeValueRenderer.formatMonotonicTime(ext) + "'")));
                if (promise3 == null) {
                    DlvTimeValueRenderer.$$$reportNull$$$0(6);
                }
                return promise3;
            }
            try {
                promise = this.getZoneId(locVar).thenAsync(zoneId -> {
                    if (zoneId == null) {
                        return Promises.resolvedPromise(null);
                    }
                    ZonedDateTime time = ZonedDateTime.of(NON_MONOTONIC_TIME_ORIGIN, UTC).plusSeconds(ext).plusNanos(nanos).withZoneSameInstant((ZoneId)zoneId);
                    String nanoFormat = DlvTimeValueRenderer.getNanoFormat(time.getNano());
                    return Promises.resolvedPromise((Object)time.format(DateTimeFormatter.ofPattern("uuuu-MM-dd HH:mm:ss" + nanoFormat + " ZZZ")));
                });
            }
            catch (NumberFormatException | DateTimeException e) {
                Promise promise4 = Promises.resolvedPromise(null);
                if (promise4 == null) {
                    DlvTimeValueRenderer.$$$reportNull$$$0(8);
                }
                return promise4;
            }
            if (promise == null) {
                DlvTimeValueRenderer.$$$reportNull$$$0(7);
            }
            return promise;
        }

        @NotNull
        private static String getNanoFormat(int nanos) {
            if (nanos == 0) {
                return "";
            }
            int digits = 9;
            while (nanos > 0 && nanos % 10 == 0) {
                --digits;
                nanos /= 10;
            }
            String string = "." + StringUtil.repeat((String)"S", (int)digits);
            if (string == null) {
                DlvTimeValueRenderer.$$$reportNull$$$0(9);
            }
            return string;
        }

        private static boolean hasMonotonic(@NotNull BigInteger wall) {
            if (wall == null) {
                DlvTimeValueRenderer.$$$reportNull$$$0(10);
            }
            return wall.testBit(63);
        }

        @NotNull
        private static String formatMonotonicTime(long ext) {
            long absNanos = Math.abs(ext);
            long seconds = absNanos / TimeUnit.SECONDS.toNanos(1L);
            long nanos = absNanos - seconds * TimeUnit.SECONDS.toNanos(1L);
            String string = String.format("%+d.%09d", (long)Long.signum(ext) * seconds, nanos);
            if (string == null) {
                DlvTimeValueRenderer.$$$reportNull$$$0(11);
            }
            return string;
        }

        private @NotNull Promise<@Nullable ZoneId> getZoneId(@NotNull DlvApi.Variable locationPointer) {
            if (locationPointer == null) {
                DlvTimeValueRenderer.$$$reportNull$$$0(12);
            }
            if (locationPointer.children.length != 1) {
                Promise promise = Promises.resolvedPromise(null);
                if (promise == null) {
                    DlvTimeValueRenderer.$$$reportNull$$$0(13);
                }
                return promise;
            }
            DlvApi.Variable location = locationPointer.children[0];
            if (BigInteger.ZERO.equals(location.addr)) {
                Promise promise = Promises.resolvedPromise((Object)UTC);
                if (promise == null) {
                    DlvTimeValueRenderer.$$$reportNull$$$0(14);
                }
                return promise;
            }
            Promise promise = DlvValueRenderers.loadChildrenIfNeeded(this.myValue, location).then(loaded -> {
                String name;
                DlvApi.Variable nameField = DlvUtil.getByName(loaded.children, "name");
                if (nameField == null) {
                    return null;
                }
                return switch (name = nameField.value) {
                    case "Asia/Qostanay" -> {
                        ZoneId var5_5;
                        yield var5_5 = DlvValueRenderers.tryGetZoneId(name, 6);
                    }
                    case "Asia/Qyzylorda" -> {
                        ZoneId var5_6;
                        yield var5_6 = DlvValueRenderers.tryGetZoneId(name, 5);
                    }
                    case "Factory" -> {
                        ZoneId var5_7;
                        yield var5_7 = ZoneId.of(ZoneOffset.ofHours(0).getId());
                    }
                    case "EST" -> {
                        ZoneId var5_8;
                        yield var5_8 = ZoneId.of(ZoneOffset.ofHours(-5).getId());
                    }
                    case "HST" -> {
                        ZoneId var5_9;
                        yield var5_9 = ZoneId.of(ZoneOffset.ofHours(-10).getId());
                    }
                    case "MST" -> {
                        ZoneId var5_10;
                        yield var5_10 = ZoneId.of(ZoneOffset.ofHours(-7).getId());
                    }
                    case "ROC" -> {
                        ZoneId var5_11;
                        yield var5_11 = ZoneId.of(ZoneOffset.ofHours(8).getId());
                    }
                    case "Local" -> {
                        ZoneId var5_12;
                        yield var5_12 = ZoneId.systemDefault();
                    }
                    default -> {
                        try {
                            ZoneId var5_13;
                            yield var5_13 = ZoneId.of(name);
                        }
                        catch (DateTimeException e) {
                            Object var5_14 = null;
                            yield var5_14;
                        }
                    }
                };
            });
            if (promise == null) {
                DlvTimeValueRenderer.$$$reportNull$$$0(15);
            }
            return promise;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 3, 5, 6, 7, 8, 9, 11, 13, 14, 15 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "value";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "node";
                    break;
                }
                case 3: 
                case 5: 
                case 6: 
                case 7: 
                case 8: 
                case 9: 
                case 11: 
                case 13: 
                case 14: 
                case 15: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/goide/dlv/DlvValueRenderers$DlvTimeValueRenderer";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "var";
                    break;
                }
                case 10: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "wall";
                    break;
                }
                case 12: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "locationPointer";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/goide/dlv/DlvValueRenderers$DlvTimeValueRenderer";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getPresentation";
                    break;
                }
                case 5: 
                case 6: 
                case 7: 
                case 8: {
                    objectArray = objectArray2;
                    objectArray2[1] = "computeValue";
                    break;
                }
                case 9: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getNanoFormat";
                    break;
                }
                case 11: {
                    objectArray = objectArray2;
                    objectArray2[1] = "formatMonotonicTime";
                    break;
                }
                case 13: 
                case 14: 
                case 15: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getZoneId";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "getPresentation";
                    break;
                }
                case 3: 
                case 5: 
                case 6: 
                case 7: 
                case 8: 
                case 9: 
                case 11: 
                case 13: 
                case 14: 
                case 15: {
                    break;
                }
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "computeValue";
                    break;
                }
                case 10: {
                    objectArray = objectArray;
                    objectArray[2] = "hasMonotonic";
                    break;
                }
                case 12: {
                    objectArray = objectArray;
                    objectArray[2] = "getZoneId";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 3, 5, 6, 7, 8, 9, 11, 13, 14, 15 -> new IllegalStateException(string);
            };
        }
    }

    private static class DlvIpValueRenderer
    implements DlvValueRenderer {
        private static final Pattern ZERO_RUN = Pattern.compile("(0:){2,}");

        private DlvIpValueRenderer() {
        }

        @Override
        public @NotNull Promise<@Nullable XValuePresentation> getPresentation(@NotNull XValueNode node, @NotNull DlvXValue value) {
            if (node == null) {
                DlvIpValueRenderer.$$$reportNull$$$0(0);
            }
            if (value == null) {
                DlvIpValueRenderer.$$$reportNull$$$0(1);
            }
            Promise promise = value.getTypePresentationAsync(node).then(type2 -> new DlvRegularValuePresentation(DlvIpValueRenderer.formatValidAddress(value.getVariable()), (String)type2));
            if (promise == null) {
                DlvIpValueRenderer.$$$reportNull$$$0(2);
            }
            return promise;
        }

        @NotNull
        private static String formatValidAddress(@NotNull DlvApi.Variable var) {
            byte[] bytes;
            if (var == null) {
                DlvIpValueRenderer.$$$reportNull$$$0(3);
            }
            if ((bytes = DlvUtil.readBytes(var)) == null) {
                return "";
            }
            if (bytes.length == 0) {
                return DlvValueRenderers.NIL;
            }
            String result = DlvIpValueRenderer.formatValidAddress(bytes);
            return result != null ? result : DlvIpValueRenderer.formatInvalidAddress(bytes);
        }

        @Nullable
        private static String formatValidAddress(byte @NotNull [] bytes) {
            if (bytes == null) {
                DlvIpValueRenderer.$$$reportNull$$$0(4);
            }
            if (bytes.length != 4 && bytes.length != 16) {
                return null;
            }
            try {
                String address = InetAddress.getByAddress(bytes).getHostAddress();
                TextRange range = DlvIpValueRenderer.findLongestZeroRun(address);
                if (range == null) {
                    return address;
                }
                return range.getStartOffset() == 0 ? ":" + range.replace(address, ":") : range.replace(address, ":");
            }
            catch (UnknownHostException e) {
                return null;
            }
        }

        @Nullable
        private static TextRange findLongestZeroRun(@NotNull String s) {
            if (s == null) {
                DlvIpValueRenderer.$$$reportNull$$$0(5);
            }
            Matcher matcher = ZERO_RUN.matcher(s + ":");
            TextRange longestRun = null;
            while (matcher.find()) {
                int start = matcher.start();
                int end = matcher.end();
                if (start > 0 && s.charAt(matcher.start() - 1) != ':' && end - (start += 2) == 2) continue;
                TextRange run2 = TextRange.create((int)start, (int)end);
                if (longestRun != null && run2.getLength() <= longestRun.getLength()) continue;
                longestRun = run2;
            }
            return longestRun != null ? longestRun.intersection(TextRange.allOf((String)s)) : null;
        }

        @NotNull
        private static String formatInvalidAddress(byte[] bytes) {
            String string = "?" + StringUtil.toHexString((byte[])bytes);
            if (string == null) {
                DlvIpValueRenderer.$$$reportNull$$$0(6);
            }
            return string;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 2, 6 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "node";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "value";
                    break;
                }
                case 2: 
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/goide/dlv/DlvValueRenderers$DlvIpValueRenderer";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "var";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "bytes";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "s";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/goide/dlv/DlvValueRenderers$DlvIpValueRenderer";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getPresentation";
                    break;
                }
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[1] = "formatInvalidAddress";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "getPresentation";
                    break;
                }
                case 2: 
                case 6: {
                    break;
                }
                case 3: 
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "formatValidAddress";
                    break;
                }
                case 5: {
                    objectArray = objectArray;
                    objectArray[2] = "findLongestZeroRun";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 2, 6 -> new IllegalStateException(string);
            };
        }
    }

    private static class DlvIpMaskValueRenderer
    implements DlvValueRenderer {
        private DlvIpMaskValueRenderer() {
        }

        @Override
        public @NotNull Promise<@Nullable XValuePresentation> getPresentation(@NotNull XValueNode node, final @NotNull DlvXValue value) {
            if (node == null) {
                DlvIpMaskValueRenderer.$$$reportNull$$$0(0);
            }
            if (value == null) {
                DlvIpMaskValueRenderer.$$$reportNull$$$0(1);
            }
            Promise promise = Promises.resolvedPromise((Object)new XValuePresentation(){

                public void renderValue(@NotNull XValuePresentation.XValueTextRenderer renderer) {
                    byte[] bytes;
                    if (renderer == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    if ((bytes = DlvUtil.readBytes(value.getVariable())) == null) {
                        return;
                    }
                    if (bytes.length == 0) {
                        renderer.renderValue(DlvValueRenderers.NIL);
                    } else {
                        renderer.renderNumericValue(StringUtil.toHexString((byte[])bytes));
                        int maskLength = DlvIpMaskValueRenderer.getSimpleMaskLength(bytes);
                        if (maskLength != -1) {
                            renderer.renderComment(" /" + maskLength);
                        }
                    }
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "renderer", "com/goide/dlv/DlvValueRenderers$DlvIpMaskValueRenderer$1", "renderValue"));
                }
            });
            if (promise == null) {
                DlvIpMaskValueRenderer.$$$reportNull$$$0(2);
            }
            return promise;
        }

        private static int getSimpleMaskLength(byte[] bytes) {
            int result = 0;
            for (int i = 0; i < bytes.length; ++i) {
                byte b = bytes[i];
                if (b == -1) {
                    result += 8;
                    continue;
                }
                while ((b & 0x80) != 0) {
                    ++result;
                    b = (byte)(b << 1);
                }
                if (b != 0) {
                    return -1;
                }
                for (int j = i + 1; j < bytes.length; ++j) {
                    if (bytes[j] == 0) continue;
                    return -1;
                }
                break;
            }
            return result;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 2 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "node";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "value";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/goide/dlv/DlvValueRenderers$DlvIpMaskValueRenderer";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/goide/dlv/DlvValueRenderers$DlvIpMaskValueRenderer";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getPresentation";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "getPresentation";
                    break;
                }
                case 2: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 2 -> new IllegalStateException(string);
            };
        }
    }

    private static class DlvIpNetValueRenderer
    implements DlvValueRenderer {
        private DlvIpNetValueRenderer() {
        }

        @Override
        public @NotNull Promise<@Nullable XValuePresentation> getPresentation(@NotNull XValueNode node, @NotNull DlvXValue value) {
            if (node == null) {
                DlvIpNetValueRenderer.$$$reportNull$$$0(0);
            }
            if (value == null) {
                DlvIpNetValueRenderer.$$$reportNull$$$0(1);
            }
            Promise promise = value.getTypePresentationAsync(node).then(type2 -> new DlvRegularValuePresentation(DlvIpNetValueRenderer.formatMask(value.getVariable()), (String)type2));
            if (promise == null) {
                DlvIpNetValueRenderer.$$$reportNull$$$0(2);
            }
            return promise;
        }

        @NotNull
        private static String formatMask(@NotNull DlvApi.Variable var) {
            int maskLength;
            if (var == null) {
                DlvIpNetValueRenderer.$$$reportNull$$$0(3);
            }
            DlvApi.Variable[] children = var.children;
            DlvApi.Variable ipField = DlvUtil.getByName(children, "IP");
            DlvApi.Variable maskField = DlvUtil.getByName(children, "Mask");
            if (ipField == null || maskField == null) {
                return "";
            }
            byte[] ipBytes = DlvUtil.readBytes(ipField);
            byte[] maskBytes = DlvUtil.readBytes(maskField);
            if (ipBytes == null || maskBytes == null) {
                return "";
            }
            if (ipBytes.length == 0 && maskBytes.length == 0) {
                return DlvValueRenderers.NIL;
            }
            String ip = DlvIpValueRenderer.formatValidAddress(ipBytes);
            if (ip == null || ip.contains(":") && maskBytes.length != 16) {
                return "";
            }
            if (!ip.contains(":") && maskBytes.length == 16) {
                maskBytes = new byte[]{maskBytes[12], maskBytes[13], maskBytes[14], maskBytes[15]};
            }
            String mask = (maskLength = DlvIpMaskValueRenderer.getSimpleMaskLength(maskBytes)) != -1 ? String.valueOf(maskLength) : StringUtil.toHexString((byte[])maskBytes);
            String string = ip + "/" + mask;
            if (string == null) {
                DlvIpNetValueRenderer.$$$reportNull$$$0(4);
            }
            return string;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 2, 4 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "node";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "value";
                    break;
                }
                case 2: 
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/goide/dlv/DlvValueRenderers$DlvIpNetValueRenderer";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "var";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/goide/dlv/DlvValueRenderers$DlvIpNetValueRenderer";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getPresentation";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "formatMask";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "getPresentation";
                    break;
                }
                case 2: 
                case 4: {
                    break;
                }
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "formatMask";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 2, 4 -> new IllegalStateException(string);
            };
        }
    }

    private static final class DlvHttpRequestRenderer
    implements DlvValueRenderer {
        private DlvHttpRequestRenderer() {
        }

        @Override
        public @NotNull Promise<@Nullable XValuePresentation> getPresentation(@NotNull XValueNode node, @NotNull DlvXValue value) {
            DlvApi.Variable urlVar;
            String method;
            if (node == null) {
                DlvHttpRequestRenderer.$$$reportNull$$$0(0);
            }
            if (value == null) {
                DlvHttpRequestRenderer.$$$reportNull$$$0(1);
            }
            if (StringUtil.isEmpty((String)(method = DlvHttpRequestRenderer.getStringValueByName(value.getVariable().children, "Method")))) {
                Promise<XValuePresentation> promise = DEFAULT.getPresentation(node, value);
                if (promise == null) {
                    DlvHttpRequestRenderer.$$$reportNull$$$0(2);
                }
                return promise;
            }
            DlvApi.Variable urlPointerVar = DlvUtil.getByName(value.getVariable().children, "URL");
            DlvApi.Variable variable = urlVar = urlPointerVar != null && urlPointerVar.isPtr() ? urlPointerVar.children[0] : null;
            if (urlVar == null) {
                Promise<XValuePresentation> promise = DEFAULT.getPresentation(node, value);
                if (promise == null) {
                    DlvHttpRequestRenderer.$$$reportNull$$$0(3);
                }
                return promise;
            }
            Promise promise = value.getTypePresentationAsync(node).thenAsync(type2 -> DlvValueRenderers.loadChildrenIfNeeded(value, urlVar).then(loaded -> {
                String path = DlvHttpRequestRenderer.getStringValueByName(loaded.children, "Path");
                String host = DlvHttpRequestRenderer.getStringValueByName(loaded.children, "Host");
                String scheme = DlvHttpRequestRenderer.getStringValueByName(loaded.children, "Scheme");
                String presentation = StringUtil.isNotEmpty((String)scheme) && StringUtil.isNotEmpty((String)host) ? String.format("%s %s://%s%s", method, scheme, host, path) : (StringUtil.isEmpty((String)path) ? method : String.format("%s %s", method, path));
                return new DlvRegularValuePresentation(presentation, (String)type2);
            }));
            if (promise == null) {
                DlvHttpRequestRenderer.$$$reportNull$$$0(4);
            }
            return promise;
        }

        @Nullable
        private static String getStringValueByName(DlvApi.Variable[] vars, @NotNull @NonNls String name) {
            DlvApi.Variable var;
            if (name == null) {
                DlvHttpRequestRenderer.$$$reportNull$$$0(5);
            }
            return (var = DlvUtil.getByName(vars, name)) != null && var.isString() ? var.value : null;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 2, 3, 4 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "node";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "value";
                    break;
                }
                case 2: 
                case 3: 
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/goide/dlv/DlvValueRenderers$DlvHttpRequestRenderer";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "name";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/goide/dlv/DlvValueRenderers$DlvHttpRequestRenderer";
                    break;
                }
                case 2: 
                case 3: 
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getPresentation";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "getPresentation";
                    break;
                }
                case 2: 
                case 3: 
                case 4: {
                    break;
                }
                case 5: {
                    objectArray = objectArray;
                    objectArray[2] = "getStringValueByName";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 2, 3, 4 -> new IllegalStateException(string);
            };
        }
    }

    private static final class DlvStringerValueRenderer
    implements DlvValueRenderer {
        private static final Map<XDebugSession, Map<String, Ref<GoFmtSprintfEvaluator>>> ourEvaluatorCache = new WeakHashMap<XDebugSession, Map<String, Ref<GoFmtSprintfEvaluator>>>();
        private final Project myProject;
        private final DlvValueRenderer myDefaultRenderer;
        private final DlvXValue myValue;

        private DlvStringerValueRenderer(@NotNull Project project, @NotNull DlvValueRenderer defaultRenderer, @NotNull DlvXValue dlvXValue) {
            if (project == null) {
                DlvStringerValueRenderer.$$$reportNull$$$0(0);
            }
            if (defaultRenderer == null) {
                DlvStringerValueRenderer.$$$reportNull$$$0(1);
            }
            if (dlvXValue == null) {
                DlvStringerValueRenderer.$$$reportNull$$$0(2);
            }
            this.myProject = project;
            this.myDefaultRenderer = defaultRenderer;
            this.myValue = dlvXValue;
        }

        @Override
        public @NotNull Promise<@Nullable XValuePresentation> getPresentation(@NotNull XValueNode node, @NotNull DlvXValue value) {
            if (node == null) {
                DlvStringerValueRenderer.$$$reportNull$$$0(3);
            }
            if (value == null) {
                DlvStringerValueRenderer.$$$reportNull$$$0(4);
            }
            DlvApi.Variable var = value.getVariable();
            Promise promise = this.getFmtEvaluatorAsync(node).thenAsync(evaluator -> {
                if (node.isObsolete()) {
                    return Promises.rejectedPromise();
                }
                if (evaluator == null) {
                    return this.myDefaultRenderer.getPresentation(node, value);
                }
                int maxAccessorDepth = evaluator.getMaxDynamicArgumentAccessorsDepth();
                if (maxAccessorDepth == 0 || maxAccessorDepth == 1 && (var.len == 0L || var.children.length > 0)) {
                    return value.getTypePresentationAsync(node).thenAsync(type2 -> evaluator.eval(this.myValue, var).thenAsync(result -> result != null ? Promises.resolvedPromise((Object)((Object)new DlvRegularValuePresentation((String)result, (String)type2))) : this.myDefaultRenderer.getPresentation(node, value)));
                }
                DlvRequest.DlvLoadConfig config = new DlvRequest.DlvLoadConfig(DlvSettings.getInstance()).setMaxArrayValues(0).setMaxVariableRecurse(Math.min(maxAccessorDepth, 3));
                return value.getTypePresentationAsync(node).thenAsync(type2 -> this.myValue.getProcess().send(new DlvRequest.Eval(DlvXValue.evaluationExpression(var), this.myValue.myFrameId, this.myValue.myGoroutineId, config)).thenAsync(valueWithChildren -> evaluator.eval(this.myValue, (DlvApi.Variable)valueWithChildren)).then(result -> result != null ? new DlvRegularValuePresentation((String)result, (String)type2) : null));
            });
            if (promise == null) {
                DlvStringerValueRenderer.$$$reportNull$$$0(5);
            }
            return promise;
        }

        @NotNull
        private Promise<GoFmtSprintfEvaluator> getFmtEvaluatorAsync(@NotNull XValueNode node) {
            if (node == null) {
                DlvStringerValueRenderer.$$$reportNull$$$0(6);
            }
            AsyncPromise result = new AsyncPromise();
            ApplicationManager.getApplication().executeOnPooledThread(() -> result.setResult((Object)this.getFmtEvaluator(node)));
            AsyncPromise asyncPromise = result;
            if (asyncPromise == null) {
                DlvStringerValueRenderer.$$$reportNull$$$0(7);
            }
            return asyncPromise;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Nullable
        private GoFmtSprintfEvaluator getFmtEvaluator(@NotNull XValueNode node) {
            if (node == null) {
                DlvStringerValueRenderer.$$$reportNull$$$0(8);
            }
            if (node.isObsolete()) {
                return null;
            }
            Map<XDebugSession, Map<String, Ref<GoFmtSprintfEvaluator>>> map = ourEvaluatorCache;
            synchronized (map) {
                Ref evaluator;
                XDebugSession session = this.myValue.getProcess().getSession();
                String type2 = this.myValue.getVariable().type;
                Map evaluators = ourEvaluatorCache.get(session);
                Ref ref = evaluator = evaluators != null ? evaluators.get(type2) : null;
                if (evaluator == null) {
                    Ref evaluatorRef = Ref.create();
                    ProgressManager.getInstance().runProcess(() -> evaluatorRef.set((Object)((GoFmtSprintfEvaluator)ReadAction.compute(this::getFmtEvaluatorInner))), (ProgressIndicator)new EmptyProgressIndicator());
                    evaluator = evaluatorRef;
                    evaluators = ourEvaluatorCache.computeIfAbsent(session, it -> new HashMap());
                    evaluators.put(type2, evaluator);
                }
                return (GoFmtSprintfEvaluator)evaluator.get();
            }
        }

        @Nullable
        private GoFmtSprintfEvaluator getFmtEvaluatorInner() {
            GoCallExpr call;
            String receiverName;
            GoMethodDeclaration stringMethod = this.findStringMethod();
            GoBlock block = stringMethod != null ? stringMethod.getBlock() : null;
            List returns = ((SyntaxTraverser)SyntaxTraverser.psiTraverser((PsiElement)block).filter(it -> it instanceof GoReturnStatement)).toList();
            GoReturnStatement returnStatement = (GoReturnStatement)ObjectUtils.tryCast((Object)ContainerUtil.getOnlyItem((Collection)returns), GoReturnStatement.class);
            GoExpression returnExpression = (GoExpression)ContainerUtil.getOnlyItem(returnStatement != null ? returnStatement.getExpressionList() : null);
            if (returnExpression == null) {
                return null;
            }
            String stringMethodName = stringMethod != null ? stringMethod.getName() : null;
            boolean printDiagnostics = "debugString".equals(stringMethodName) || "DebugString".equals(stringMethodName);
            Value value = returnExpression.getValue();
            if (value != null) {
                return new GoFmtSprintfEvaluator("%s", Collections.singletonList(new GoFmtSprintfArgumentStatic(value)), printDiagnostics);
            }
            GoReceiver receiver = stringMethod != null ? stringMethod.getReceiver() : null;
            String string = receiverName = receiver != null ? receiver.getName() : null;
            if (receiverName == null || "_".equals(receiverName)) {
                return null;
            }
            if (returnExpression instanceof GoReferenceExpression) {
                return new GoFmtSprintfEvaluator("%s", Collections.singletonList(new GoFmtSprintfArgumentDynamic(returnExpression.getProject(), receiverName, returnExpression.getText(), false, false)), printDiagnostics);
            }
            if (returnExpression instanceof GoCallExpr && GoStdlibUtil.isStdLibCall(call = (GoCallExpr)returnExpression, "fmt", "Sprintf")) {
                String format;
                List<GoExpression> arguments = call.getArgumentList().getExpressionList();
                GoExpression formatArg = (GoExpression)ContainerUtil.getFirstItem(arguments);
                String string2 = format = formatArg != null ? GoFmtStringUtil.getStringValue(formatArg) : null;
                if (format == null) {
                    return null;
                }
                List<GoFmtSprintfArgument> args = DlvStringerValueRenderer.getFmtArguments(receiverName, arguments.subList(1, arguments.size()));
                return args != null ? new GoFmtSprintfEvaluator(format, args, printDiagnostics) : null;
            }
            return null;
        }

        @Nullable
        private static List<GoFmtSprintfArgument> getFmtArguments(@NotNull String receiverName, @NotNull List<GoExpression> arguments) {
            if (receiverName == null) {
                DlvStringerValueRenderer.$$$reportNull$$$0(9);
            }
            if (arguments == null) {
                DlvStringerValueRenderer.$$$reportNull$$$0(10);
            }
            ArrayList<GoFmtSprintfArgument> args = new ArrayList<GoFmtSprintfArgument>();
            for (GoExpression arg : arguments) {
                GoType type2;
                GoReferenceExpression callExpression;
                GoTypeSpec typeConversionCall;
                GoCallExpr call;
                GoExpression callArgument;
                GoFmtSprintfArgument fmtArg = null;
                Value value = arg.getValue();
                if (value != null) {
                    fmtArg = new GoFmtSprintfArgumentStatic(value);
                } else if (arg instanceof GoReferenceExpression) {
                    GoType type3 = arg.getGoType(null);
                    fmtArg = new GoFmtSprintfArgumentDynamic(arg.getProject(), receiverName, arg.getText(), false, type3 instanceof GoPointerType);
                } else if (arg instanceof GoUnaryExpr) {
                    GoUnaryExpr unaryExpr = (GoUnaryExpr)arg;
                    if (unaryExpr.getMul() != null && unaryExpr.getExpression() instanceof GoReferenceExpression) {
                        fmtArg = new GoFmtSprintfArgumentDynamic(arg.getProject(), receiverName, unaryExpr.getExpression().getText(), true, false);
                    } else if (unaryExpr.getBitAnd() != null && unaryExpr.getExpression() instanceof GoReferenceExpression) {
                        fmtArg = new GoFmtSprintfArgumentDynamic(arg.getProject(), receiverName, unaryExpr.getExpression().getText(), false, true);
                    }
                } else if (arg instanceof GoCallExpr && (callArgument = (GoExpression)ContainerUtil.getOnlyItem((call = (GoCallExpr)arg).getArgumentList().getExpressionList())) != null && (typeConversionCall = (GoTypeSpec)ObjectUtils.tryCast((Object)((callExpression = (GoReferenceExpression)ObjectUtils.tryCast((Object)call.getExpression(), GoReferenceExpression.class)) != null ? callExpression.resolve() : null), GoTypeSpec.class)) != null && GoPsiImplUtil.isBuiltinFile((PsiFile)typeConversionCall.getContainingFile()) && (type2 = callArgument.getGoType(null)) != null && GoTypeUtil.identical(type2.getUnderlyingType(callArgument), typeConversionCall.getSpecType(), true, arg)) {
                    fmtArg = new GoFmtSprintfArgumentDynamic(arg.getProject(), receiverName, callArgument.getText(), false, type2 instanceof GoPointerType);
                }
                if (fmtArg != null) {
                    args.add(fmtArg);
                    continue;
                }
                return null;
            }
            return args;
        }

        @Nullable
        private GoMethodDeclaration findStringMethod() {
            GlobalSearchScope scope;
            Module module = DlvUtil.getModule(this.myValue.getProcess().getSession());
            if (DumbService.getInstance((Project)this.myProject).isDumb() || module == null) {
                return null;
            }
            DlvNamedType dlvNamedType = DlvNamedType.parse(this.myValue.getVariable().type);
            if (dlvNamedType == null) {
                return null;
            }
            GlobalSearchScope globalSearchScope = scope = dlvNamedType.isFromMainPackage() ? this.myValue.getProcess().getMainPackageScope() : GoPathResolveScope.create(this.myProject, module, null);
            if (scope == null) {
                return null;
            }
            boolean vendoring = GoVendoringUtil.isVendoringEnabled(module);
            Set<String> pkgNames = this.myValue.getProcess().getSymbolPrettier().getPackageNames(dlvNamedType.getDlvPackagePath());
            for (String pkgName : pkgNames) {
                Collection<GoMethodDeclaration> methods = GoMethodIndex.find(DlvStringerValueRenderer.getNameForMethodIndex(pkgName, dlvNamedType), this.myProject, scope, null);
                String methodNames = Registry.stringValue((String)"go.debugger.presentation.methods");
                for (String methodName : StringUtil.split((String)methodNames, (String)",")) {
                    if ((methodName = methodName.trim()).isEmpty()) continue;
                    for (GoMethodDeclaration method : methods) {
                        GoType resultType;
                        int paramsCount;
                        GoSignature signature;
                        if (!methodName.equals(method.getName()) || (signature = method.getSignature()) == null || (paramsCount = signature.getParameters().getParameterDeclarationList().size()) != 0 || !GoTypeUtil.isString(resultType = signature.getResultType(), method) || !dlvNamedType.isFromMainPackage() && !dlvNamedType.getPackagePath().equals("command-line-arguments") && !dlvNamedType.getPackagePath().equals(method.getContainingFile().getImportPath(vendoring))) continue;
                        return method;
                    }
                }
            }
            return null;
        }

        @NotNull
        private static String getNameForMethodIndex(@NotNull String packageName, @NotNull DlvNamedType dlvNamedType) {
            if (packageName == null) {
                DlvStringerValueRenderer.$$$reportNull$$$0(11);
            }
            if (dlvNamedType == null) {
                DlvStringerValueRenderer.$$$reportNull$$$0(12);
            }
            Object object = StringUtil.isEmpty((String)packageName) ? dlvNamedType.getTypeName() : packageName + "." + dlvNamedType.getTypeName();
            if (object == null) {
                DlvStringerValueRenderer.$$$reportNull$$$0(13);
            }
            return object;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 5, 7, 13 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "defaultRenderer";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "dlvXValue";
                    break;
                }
                case 3: 
                case 6: 
                case 8: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "node";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "value";
                    break;
                }
                case 5: 
                case 7: 
                case 13: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/goide/dlv/DlvValueRenderers$DlvStringerValueRenderer";
                    break;
                }
                case 9: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "receiverName";
                    break;
                }
                case 10: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "arguments";
                    break;
                }
                case 11: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "packageName";
                    break;
                }
                case 12: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "dlvNamedType";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/goide/dlv/DlvValueRenderers$DlvStringerValueRenderer";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getPresentation";
                    break;
                }
                case 7: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFmtEvaluatorAsync";
                    break;
                }
                case 13: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getNameForMethodIndex";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 3: 
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "getPresentation";
                    break;
                }
                case 5: 
                case 7: 
                case 13: {
                    break;
                }
                case 6: {
                    objectArray = objectArray;
                    objectArray[2] = "getFmtEvaluatorAsync";
                    break;
                }
                case 8: {
                    objectArray = objectArray;
                    objectArray[2] = "getFmtEvaluator";
                    break;
                }
                case 9: 
                case 10: {
                    objectArray = objectArray;
                    objectArray[2] = "getFmtArguments";
                    break;
                }
                case 11: 
                case 12: {
                    objectArray = objectArray;
                    objectArray[2] = "getNameForMethodIndex";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 5, 7, 13 -> new IllegalStateException(string);
            };
        }
    }

    static class DefaultSliceOrArrayPresentation
    extends DlvRegularValuePresentation {
        private DefaultSliceOrArrayPresentation(@NotNull DlvApi.Variable var, @Nullable String type2) {
            if (var == null) {
                DefaultSliceOrArrayPresentation.$$$reportNull$$$0(0);
            }
            super("len:" + var.len + (String)(var.isSlice() ? ", cap:" + var.cap : ""), type2);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "var", "com/goide/dlv/DlvValueRenderers$DefaultSliceOrArrayPresentation", "<init>"));
        }
    }

    private static class DlvRegularValuePresentation
    extends XRegularValuePresentation {
        private DlvRegularValuePresentation(@NotNull String value, @Nullable String type2) {
            if (value == null) {
                DlvRegularValuePresentation.$$$reportNull$$$0(0);
            }
            super(value, type2, StringUtil.isEmpty((String)value) && StringUtil.isEmpty((String)type2) ? "" : " = ");
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "value", "com/goide/dlv/DlvValueRenderers$DlvRegularValuePresentation", "<init>"));
        }
    }

    private static abstract class IntegerValueRenderer
    implements DlvValueRendererSelectableInUi {
        @Nls
        private final String myName;

        protected IntegerValueRenderer(@NotNull @Nls String name) {
            if (name == null) {
                IntegerValueRenderer.$$$reportNull$$$0(0);
            }
            this.myName = name;
        }

        @Override
        @NotNull
        @Nls
        public String getName() {
            String string = this.myName;
            if (string == null) {
                IntegerValueRenderer.$$$reportNull$$$0(1);
            }
            return string;
        }

        @Override
        public boolean isApplicable(@Nullable DlvXValue value) {
            return value != null && value.getVariable().isInteger();
        }

        @Override
        public @NotNull Promise<@Nullable XValuePresentation> getPresentation(@NotNull XValueNode node, @NotNull DlvXValue value) {
            if (node == null) {
                IntegerValueRenderer.$$$reportNull$$$0(2);
            }
            if (value == null) {
                IntegerValueRenderer.$$$reportNull$$$0(3);
            }
            String valuePresentation = this.formatNumericValue(value.getVariable());
            Promise promise = value.getTypePresentationAsync(node).then(typePresentation -> new XNumericValuePresentation(valuePresentation, (String)typePresentation, valuePresentation){
                final /* synthetic */ String val$typePresentation;
                final /* synthetic */ String val$valuePresentation;
                {
                    this.val$typePresentation = string;
                    this.val$valuePresentation = string2;
                    super(arg0);
                }

                @Nullable
                public String getType() {
                    return this.val$typePresentation;
                }

                @NotNull
                public String getSeparator() {
                    String string = StringUtil.isEmpty((String)this.val$typePresentation) && StringUtil.isEmpty((String)this.val$valuePresentation) ? "" : super.getSeparator();
                    if (string == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    return string;
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/goide/dlv/DlvValueRenderers$IntegerValueRenderer$1", "getSeparator"));
                }
            });
            if (promise == null) {
                IntegerValueRenderer.$$$reportNull$$$0(4);
            }
            return promise;
        }

        @NotNull
        abstract String formatNumericValue(@NotNull DlvApi.Variable var1);

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 1, 4 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "name";
                    break;
                }
                case 1: 
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/goide/dlv/DlvValueRenderers$IntegerValueRenderer";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "node";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "value";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/goide/dlv/DlvValueRenderers$IntegerValueRenderer";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getName";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getPresentation";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: 
                case 4: {
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "getPresentation";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 1, 4 -> new IllegalStateException(string);
            };
        }
    }
}

