/*
 * Decompiled with CFR 0.152.
 */
package com.goide.dlv;

import com.goide.dlv.protocol.DlvApi;
import com.intellij.execution.configurations.ModuleBasedConfiguration;
import com.intellij.execution.configurations.RunProfile;
import com.intellij.openapi.module.Module;
import com.intellij.xdebugger.XDebugSession;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class DlvUtil {
    @Nullable
    static Module getModule(@NotNull XDebugSession session) {
        RunProfile profile;
        if (session == null) {
            DlvUtil.$$$reportNull$$$0(0);
        }
        return (profile = session.getRunProfile()) instanceof ModuleBasedConfiguration ? ((ModuleBasedConfiguration)profile).getConfigurationModule().getModule() : null;
    }

    static byte @Nullable [] readBytes(@NotNull DlvApi.Variable var) {
        if (var == null) {
            DlvUtil.$$$reportNull$$$0(1);
        }
        try {
            byte[] result = new byte[var.children.length];
            for (int i = 0; i < var.children.length; ++i) {
                DlvApi.Variable child = var.children[i];
                result[i] = (byte)Integer.parseInt(child.value);
            }
            return result;
        }
        catch (NumberFormatException e) {
            return null;
        }
    }

    @Nullable
    static DlvApi.Variable getByName(DlvApi.Variable[] vars, @NotNull @NonNls String name) {
        if (name == null) {
            DlvUtil.$$$reportNull$$$0(2);
        }
        for (DlvApi.Variable var : vars) {
            if (!name.equals(var.name)) continue;
            return var;
        }
        return null;
    }

    @Nullable
    static String currentFunctionName(@NotNull DlvApi.DebuggerState s) {
        DlvApi.Location loc;
        if (s == null) {
            DlvUtil.$$$reportNull$$$0(3);
        }
        return (loc = DlvUtil.getCurrentLocation(s)) != null ? loc.name() : null;
    }

    @Nullable
    static DlvApi.Location getCurrentLocation(@NotNull DlvApi.DebuggerState s) {
        DlvApi.Goroutine goroutine;
        if (s == null) {
            DlvUtil.$$$reportNull$$$0(4);
        }
        return (goroutine = s.currentGoroutine) != null ? goroutine.currentLoc : null;
    }

    static boolean isAutogenerated(@Nullable DlvApi.Location loc) {
        return loc != null && "<autogenerated>".equals(loc.file) && loc.line == 1;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "session";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "var";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "s";
                break;
            }
        }
        objectArray2[1] = "com/goide/dlv/DlvUtil";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "getModule";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "readBytes";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "getByName";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "currentFunctionName";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "getCurrentLocation";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

