/*
 * Decompiled with CFR 0.152.
 */
package com.goide.directiveComment;

import com.goide.directiveComment.GoDirectiveComment;
import com.goide.directiveComment.GoDirectiveCommentArgument;
import com.goide.directiveComment.GoEmbedFileReferenceSet;
import com.goide.psi.impl.manipulator.GoStringManipulator;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiComment;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.FileReference;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.text.StringTokenizer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GoEmbedComment
extends GoDirectiveComment {
    public static final String NAME = "embed";
    private static final String COMMENT_PREFIX = "//go:embed";
    private static final GoEmbedComment WITHOUT_ARGUMENTS = new GoEmbedComment(Collections.emptyList());
    private static final String ALL_PREFIX = "all:";

    public GoEmbedComment(@NotNull List<GoDirectiveCommentArgument> arguments) {
        if (arguments == null) {
            GoEmbedComment.$$$reportNull$$$0(0);
        }
        super(NAME, arguments);
    }

    @Nullable
    public static GoEmbedComment embedCommentFrom(@NotNull PsiComment comment) {
        GoDirectiveComment directiveComment;
        if (comment == null) {
            GoEmbedComment.$$$reportNull$$$0(1);
        }
        if ((directiveComment = GoDirectiveComment.directiveCommentFrom(comment)) == null || !NAME.equals(directiveComment.getName())) {
            return null;
        }
        return GoEmbedComment.parseEmbedComment(directiveComment);
    }

    public static boolean isEmbedComment(@NotNull CharSequence commentText) {
        if (commentText == null) {
            GoEmbedComment.$$$reportNull$$$0(2);
        }
        return StringUtil.startsWith((CharSequence)commentText, (CharSequence)COMMENT_PREFIX);
    }

    @NotNull
    public static List<FileReference> getReferences(@NotNull PsiComment comment, @NotNull GoDirectiveCommentArgument argument) {
        if (comment == null) {
            GoEmbedComment.$$$reportNull$$$0(3);
        }
        if (argument == null) {
            GoEmbedComment.$$$reportNull$$$0(4);
        }
        if (GoEmbedComment.hasWildcards(argument)) {
            List<FileReference> list = Collections.emptyList();
            if (list == null) {
                GoEmbedComment.$$$reportNull$$$0(5);
            }
            return list;
        }
        GoDirectiveCommentArgument unquoted = GoEmbedComment.unquote(argument);
        GoDirectiveCommentArgument withoutPrefix = GoEmbedComment.dropAllPrefix(unquoted);
        GoEmbedFileReferenceSet referenceSet = new GoEmbedFileReferenceSet(comment, withoutPrefix, !argument.equals(unquoted));
        List<FileReference> list = Arrays.asList(referenceSet.getAllReferences());
        if (list == null) {
            GoEmbedComment.$$$reportNull$$$0(6);
        }
        return list;
    }

    public static boolean hasWildcards(@NotNull GoDirectiveCommentArgument argument) {
        if (argument == null) {
            GoEmbedComment.$$$reportNull$$$0(7);
        }
        return StringUtil.containsAnyChar((String)argument.getText(), (String)"*?[^]\\");
    }

    public static boolean hasAllPrefix(@NotNull GoDirectiveCommentArgument argument) {
        if (argument == null) {
            GoEmbedComment.$$$reportNull$$$0(8);
        }
        return GoEmbedComment.unquote(argument).getText().startsWith(ALL_PREFIX);
    }

    @NotNull
    public static GoDirectiveCommentArgument unquote(@NotNull GoDirectiveCommentArgument argument) {
        if (argument == null) {
            GoEmbedComment.$$$reportNull$$$0(9);
        }
        String text = argument.getText();
        String unquoted = GoStringManipulator.unquote(text);
        GoDirectiveCommentArgument goDirectiveCommentArgument = text.length() != unquoted.length() ? new GoDirectiveCommentArgument(unquoted, argument.getStartOffset() + 1) : argument;
        if (goDirectiveCommentArgument == null) {
            GoEmbedComment.$$$reportNull$$$0(10);
        }
        return goDirectiveCommentArgument;
    }

    @NotNull
    public static GoDirectiveCommentArgument dropAllPrefix(@NotNull GoDirectiveCommentArgument argument) {
        String text;
        if (argument == null) {
            GoEmbedComment.$$$reportNull$$$0(11);
        }
        GoDirectiveCommentArgument goDirectiveCommentArgument = (text = argument.getText()).startsWith(ALL_PREFIX) ? new GoDirectiveCommentArgument(text.substring(ALL_PREFIX.length()), argument.getStartOffset() + ALL_PREFIX.length()) : argument;
        if (goDirectiveCommentArgument == null) {
            GoEmbedComment.$$$reportNull$$$0(12);
        }
        return goDirectiveCommentArgument;
    }

    @Nullable
    private static GoEmbedComment parseEmbedComment(@NotNull GoDirectiveComment directiveComment) {
        GoDirectiveCommentArgument argument;
        if (directiveComment == null) {
            GoEmbedComment.$$$reportNull$$$0(13);
        }
        if ((argument = (GoDirectiveCommentArgument)ContainerUtil.getOnlyItem(directiveComment.getArguments())) == null) {
            return WITHOUT_ARGUMENTS;
        }
        MyArgumentsLexer lexer = new MyArgumentsLexer(argument.getText());
        ArrayList<GoDirectiveCommentArgument> arguments = new ArrayList<GoDirectiveCommentArgument>();
        int initialOffset = argument.getStartOffset();
        GoEmbedComment.consumeWhitespaces(lexer);
        if (lexer.getCurrentToken() == null) {
            return WITHOUT_ARGUMENTS;
        }
        GoDirectiveCommentArgument embedArgument = GoEmbedComment.consumeArgument(lexer, initialOffset);
        GoDirectiveCommentArgument goDirectiveCommentArgument = embedArgument = embedArgument != null ? embedArgument : GoEmbedComment.consumeQuotedArgument(lexer, initialOffset);
        if (embedArgument == null) {
            return null;
        }
        arguments.add(embedArgument);
        while (lexer.getCurrentToken() != null && GoEmbedComment.consumeWhitespaces(lexer)) {
            embedArgument = GoEmbedComment.consumeArgument(lexer, initialOffset);
            GoDirectiveCommentArgument goDirectiveCommentArgument2 = embedArgument = embedArgument != null ? embedArgument : GoEmbedComment.consumeQuotedArgument(lexer, initialOffset);
            if (embedArgument == null) break;
            arguments.add(embedArgument);
        }
        if (lexer.getCurrentToken() != null && !GoEmbedComment.consumeWhitespaces(lexer)) {
            return null;
        }
        return new GoEmbedComment(arguments);
    }

    private static boolean consumeWhitespaces(@NotNull MyArgumentsLexer lexer) {
        if (lexer == null) {
            GoEmbedComment.$$$reportNull$$$0(14);
        }
        boolean consumed = false;
        while (lexer.getCurrentToken() != null && GoEmbedComment.isWhitespace(lexer.getCurrentToken())) {
            consumed = true;
            lexer.advance();
        }
        return consumed;
    }

    private static boolean isWhitespace(@Nullable String token) {
        return " ".equals(token) || "\t".equals(token);
    }

    @Nullable
    private static GoDirectiveCommentArgument consumeArgument(@NotNull MyArgumentsLexer lexer, int offsetShift) {
        String token;
        if (lexer == null) {
            GoEmbedComment.$$$reportNull$$$0(15);
        }
        if ((token = lexer.getCurrentToken()) != null && !GoEmbedComment.isWhitespace(token) && !GoEmbedComment.isQuote(token)) {
            int offset = lexer.getTokenStartOffset();
            lexer.advance();
            return new GoDirectiveCommentArgument(token, offsetShift + offset);
        }
        return null;
    }

    private static boolean isQuote(@Nullable String token) {
        return "\"".equals(token) || "`".equals(token);
    }

    @Nullable
    private static GoDirectiveCommentArgument consumeQuotedArgument(@NotNull MyArgumentsLexer lexer, int offsetShift) {
        String token;
        if (lexer == null) {
            GoEmbedComment.$$$reportNull$$$0(16);
        }
        if ((token = lexer.getCurrentToken()) == null || !GoEmbedComment.isQuote(token)) {
            return null;
        }
        StringBuilder argument = new StringBuilder(token);
        int offset = lexer.getTokenStartOffset();
        lexer.advance();
        while (lexer.getCurrentToken() != null && !GoEmbedComment.isQuote(lexer.getCurrentToken())) {
            argument.append(lexer.getCurrentToken());
            lexer.advance();
        }
        if (lexer.getCurrentToken() != null) {
            argument.append(lexer.getCurrentToken());
            lexer.advance();
        }
        return new GoDirectiveCommentArgument(argument.toString(), offsetShift + offset);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 5, 6, 10, 12 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "arguments";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "comment";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "commentText";
                break;
            }
            case 4: 
            case 7: 
            case 8: 
            case 9: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "argument";
                break;
            }
            case 5: 
            case 6: 
            case 10: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/goide/directiveComment/GoEmbedComment";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "directiveComment";
                break;
            }
            case 14: 
            case 15: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "lexer";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/goide/directiveComment/GoEmbedComment";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getReferences";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "unquote";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "dropAllPrefix";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "embedCommentFrom";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "isEmbedComment";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getReferences";
                break;
            }
            case 5: 
            case 6: 
            case 10: 
            case 12: {
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "hasWildcards";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "hasAllPrefix";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "unquote";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "dropAllPrefix";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "parseEmbedComment";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "consumeWhitespaces";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "consumeArgument";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "consumeQuotedArgument";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 5, 6, 10, 12 -> new IllegalStateException(string);
        };
    }

    private static class MyArgumentsLexer {
        @NotNull
        private final StringTokenizer myTokenizer;
        @Nullable
        private String myCurrentToken;

        MyArgumentsLexer(@NotNull String str) {
            if (str == null) {
                MyArgumentsLexer.$$$reportNull$$$0(0);
            }
            this.myTokenizer = new StringTokenizer(str, " \t\"`", true);
            this.advance();
        }

        void advance() {
            this.myCurrentToken = this.myTokenizer.hasMoreTokens() ? this.myTokenizer.nextToken() : null;
        }

        @Nullable
        String getCurrentToken() {
            return this.myCurrentToken;
        }

        int getTokenStartOffset() {
            if (this.myCurrentToken == null) {
                throw new IllegalStateException("Current token is null");
            }
            return this.myTokenizer.getCurrentPosition() - this.myCurrentToken.length();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "str", "com/goide/directiveComment/GoEmbedComment$MyArgumentsLexer", "<init>"));
        }
    }
}

