/*
 * Decompiled with CFR 0.152.
 */
package com.goide.dataflow;

import com.goide.controlflow.GoControlFlowUtil;
import com.goide.controlflow.instructions.GoAssignmentStatementInstruction;
import com.goide.controlflow.instructions.GoBranchInstruction;
import com.goide.controlflow.instructions.GoBranchInstructionBase;
import com.goide.controlflow.instructions.GoCaseBranchInstruction;
import com.goide.controlflow.instructions.GoExpressionInstruction;
import com.goide.controlflow.instructions.GoForLoopBranchInstruction;
import com.goide.controlflow.instructions.GoParameterDeclarationInstruction;
import com.goide.controlflow.instructions.GoRecvStatementInstruction;
import com.goide.controlflow.instructions.GoShortVarDeclarationInstruction;
import com.goide.controlflow.instructions.GoTypeInSwitchCaseInstruction;
import com.goide.controlflow.instructions.GoVarDeclarationInstruction;
import com.goide.dataflow.GoDataFlow;
import com.goide.dataflow.GoDataFlowFunction;
import com.goide.dataflow.GoDataFlowUtil;
import com.goide.dataflow.GoNilness;
import com.goide.inspections.GoInspectionUtil;
import com.goide.psi.GoAssignmentStatement;
import com.goide.psi.GoBuiltinCallExpr;
import com.goide.psi.GoCallExpr;
import com.goide.psi.GoCompositeLit;
import com.goide.psi.GoExpression;
import com.goide.psi.GoInterfaceType;
import com.goide.psi.GoNamedElement;
import com.goide.psi.GoParamDefinition;
import com.goide.psi.GoParameterDeclaration;
import com.goide.psi.GoRangeClause;
import com.goide.psi.GoRecvStatement;
import com.goide.psi.GoResult;
import com.goide.psi.GoShortVarDeclaration;
import com.goide.psi.GoType;
import com.goide.psi.GoTypeAssertionExpr;
import com.goide.psi.GoTypeOwner;
import com.goide.psi.GoTypeSwitchGuard;
import com.goide.psi.GoUnaryExpr;
import com.goide.psi.GoVarDeclaration;
import com.goide.psi.GoVarDefinition;
import com.goide.psi.GoVarSpec;
import com.goide.psi.impl.GoElementFactory;
import com.goide.psi.impl.GoExpressionUtil;
import com.goide.psi.impl.GoPsiUtil;
import com.goide.psi.impl.GoTypeUtil;
import com.goide.util.GoStdlibUtil;
import com.intellij.codeInsight.controlflow.Instruction;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GoNilnessFunction
implements GoDataFlowFunction {
    private final GoDataFlow myDataFlow;

    public GoNilnessFunction(@NotNull GoDataFlow dataFlow) {
        if (dataFlow == null) {
            GoNilnessFunction.$$$reportNull$$$0(0);
        }
        this.myDataFlow = dataFlow;
    }

    @Override
    @NotNull
    public GoDataFlow getDataFlow() {
        GoDataFlow goDataFlow = this.myDataFlow;
        if (goDataFlow == null) {
            GoNilnessFunction.$$$reportNull$$$0(1);
        }
        return goDataFlow;
    }

    @Override
    public boolean recalculate(@NotNull Instruction instruction) {
        Map<GoNamedElement, GoNilness> merged;
        Map<GoNamedElement, GoNilness> nilnessMap;
        if (instruction == null) {
            GoNilnessFunction.$$$reportNull$$$0(2);
        }
        boolean recalculated = false;
        boolean previousInstructionsUnreachable = this.allPreviousInstructionsUnreachable(instruction);
        if (previousInstructionsUnreachable != this.myDataFlow.isUnreachable(instruction)) {
            this.myDataFlow.setUnreachable(instruction, previousInstructionsUnreachable);
            recalculated = true;
            if (previousInstructionsUnreachable) {
                return true;
            }
        }
        if ((nilnessMap = this.myDataFlow.getNilnessDataFlow().getNilnessMap(instruction)) == null) {
            nilnessMap = new HashMap<GoNamedElement, GoNilness>();
            this.myDataFlow.getNilnessDataFlow().setNilnessMap(instruction, nilnessMap);
            recalculated = true;
        }
        if (!(merged = GoNilnessFunction.mergeDataFlowOfPreviousInstructions(instruction, this.myDataFlow, false)).equals(nilnessMap)) {
            nilnessMap.clear();
            nilnessMap.putAll(merged);
            recalculated = true;
        }
        InstructionProcessor processor2 = new InstructionProcessor(nilnessMap);
        recalculated |= processor2.process(instruction);
        if (processor2.instructionIsUnreachable != this.myDataFlow.isUnreachable(instruction)) {
            this.myDataFlow.setUnreachable(instruction, processor2.instructionIsUnreachable);
            return true;
        }
        return recalculated;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean allPreviousInstructionsUnreachable(@NotNull Instruction instruction) {
        if (instruction == null) {
            GoNilnessFunction.$$$reportNull$$$0(3);
        }
        if (instruction.allPred().isEmpty()) return false;
        if (!ContainerUtil.all((Collection)instruction.allPred(), this.myDataFlow::isUnreachable)) return false;
        return true;
    }

    @NotNull
    static Map<GoNamedElement, GoNilness> mergeDataFlowOfPreviousInstructions(@NotNull Instruction instruction, @NotNull GoDataFlow dataFlow, boolean ignoreBackEdges) {
        if (instruction == null) {
            GoNilnessFunction.$$$reportNull$$$0(4);
        }
        if (dataFlow == null) {
            GoNilnessFunction.$$$reportNull$$$0(5);
        }
        SmartList prevNilnessMaps = new SmartList();
        for (Instruction prev : instruction.allPred()) {
            Map<GoNamedElement, GoNilness> prevMap;
            if (ignoreBackEdges && GoControlFlowUtil.isBackEdge(prev, instruction) || (prevMap = dataFlow.getNilnessDataFlow().getNilnessMap(prev)) == null || dataFlow.isUnreachable(prev)) continue;
            prevNilnessMaps.add(prevMap);
        }
        HashMap<GoNamedElement, GoNilness> merged = new HashMap<GoNamedElement, GoNilness>();
        boolean first = true;
        for (Map prev : prevNilnessMaps) {
            if (first) {
                merged.putAll(prev);
                first = false;
                continue;
            }
            merged.keySet().retainAll(prev.keySet());
            prev.forEach((prevVar, prevNilness) -> {
                if (merged.containsKey(prevVar)) {
                    merged.merge((GoNamedElement)prevVar, (GoNilness)((Object)prevNilness), GoNilness::max);
                }
            });
        }
        HashMap<GoNamedElement, GoNilness> hashMap = merged;
        if (hashMap == null) {
            GoNilnessFunction.$$$reportNull$$$0(6);
        }
        return hashMap;
    }

    @NotNull
    public static GoNilness getExpressionNilness(@Nullable GoExpression expression) {
        if (expression == null) {
            GoNilness goNilness = GoNilness.UNKNOWN;
            if (goNilness == null) {
                GoNilnessFunction.$$$reportNull$$$0(7);
            }
            return goNilness;
        }
        GoExpression unwrapped = expression.unwrapParentheses();
        if (GoExpressionUtil.isNil(unwrapped)) {
            GoNilness goNilness = GoNilness.NIL;
            if (goNilness == null) {
                GoNilnessFunction.$$$reportNull$$$0(8);
            }
            return goNilness;
        }
        if (expression instanceof GoCompositeLit) {
            GoNilness goNilness = GoNilness.NOT_NIL;
            if (goNilness == null) {
                GoNilnessFunction.$$$reportNull$$$0(9);
            }
            return goNilness;
        }
        if (expression instanceof GoBuiltinCallExpr && ((GoBuiltinCallExpr)expression).isTrulyBuiltin()) {
            GoNilness goNilness = GoNilness.NOT_NIL;
            if (goNilness == null) {
                GoNilnessFunction.$$$reportNull$$$0(10);
            }
            return goNilness;
        }
        if (expression instanceof GoUnaryExpr && ((GoUnaryExpr)expression).getBitAnd() != null && ((GoUnaryExpr)expression).getExpression() instanceof GoCompositeLit) {
            GoNilness goNilness = GoNilness.NOT_NIL;
            if (goNilness == null) {
                GoNilnessFunction.$$$reportNull$$$0(11);
            }
            return goNilness;
        }
        if (expression instanceof GoCallExpr) {
            GoCallExpr callExpr = (GoCallExpr)expression;
            if (GoTypeUtil.isError(expression.getGoType(null), expression)) {
                if (GoStdlibUtil.isErrorConstructor(callExpr)) {
                    GoNilness goNilness = GoNilness.NOT_NIL;
                    if (goNilness == null) {
                        GoNilnessFunction.$$$reportNull$$$0(12);
                    }
                    return goNilness;
                }
                if (GoStdlibUtil.isPkgErrorsCall(callExpr, "WithMessage", "WithMessagef", "WithStack", "Wrap", "Wrapf", "Cause")) {
                    GoNilness goNilness = GoNilness.UNKNOWN;
                    if (goNilness == null) {
                        GoNilnessFunction.$$$reportNull$$$0(13);
                    }
                    return goNilness;
                }
                GoNilness goNilness = GoNilness.MAYBE_NIL;
                if (goNilness == null) {
                    GoNilnessFunction.$$$reportNull$$$0(14);
                }
                return goNilness;
            }
        }
        GoNilness goNilness = GoNilness.UNKNOWN;
        if (goNilness == null) {
            GoNilnessFunction.$$$reportNull$$$0(15);
        }
        return goNilness;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataFlow";
                break;
            }
            case 1: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/goide/dataflow/GoNilnessFunction";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "instruction";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/goide/dataflow/GoNilnessFunction";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getDataFlow";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "mergeDataFlowOfPreviousInstructions";
                break;
            }
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "getExpressionNilness";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "recalculate";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "allPreviousInstructionsUnreachable";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "mergeDataFlowOfPreviousInstructions";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15 -> new IllegalStateException(string);
        };
    }

    private static final class InstructionProcessor {
        private final Map<GoNamedElement, GoNilness> nilnessMap;
        boolean instructionIsUnreachable;

        private InstructionProcessor(@NotNull Map<GoNamedElement, GoNilness> map) {
            if (map == null) {
                InstructionProcessor.$$$reportNull$$$0(0);
            }
            this.nilnessMap = map;
        }

        private boolean process(@NotNull Instruction instruction) {
            if (instruction == null) {
                InstructionProcessor.$$$reportNull$$$0(1);
            }
            if (instruction instanceof GoExpressionInstruction) {
                return this.processExpression((GoExpression)((GoExpressionInstruction)instruction).getPsi());
            }
            if (instruction instanceof GoParameterDeclarationInstruction) {
                return this.processParameterDeclaration((GoParameterDeclaration)((GoParameterDeclarationInstruction)instruction).getPsi());
            }
            if (instruction instanceof GoVarDeclarationInstruction) {
                GoVarDeclaration varDeclaration = (GoVarDeclaration)((GoVarDeclarationInstruction)instruction).getPsi();
                boolean recalculated = false;
                for (GoVarSpec varSpec : varDeclaration.getVarSpecList()) {
                    recalculated |= this.processVarDefinitions(varSpec.getDefinitionList(), varSpec.getExpressionList());
                }
                return recalculated;
            }
            if (instruction instanceof GoShortVarDeclarationInstruction) {
                GoShortVarDeclaration declaration = (GoShortVarDeclaration)((GoShortVarDeclarationInstruction)instruction).getPsi();
                return this.processShortVarDeclaration(declaration.getDefinitionList(), declaration.getExpressionList());
            }
            if (instruction instanceof GoAssignmentStatementInstruction) {
                GoAssignmentStatement assignment = (GoAssignmentStatement)((GoAssignmentStatementInstruction)instruction).getPsi();
                return this.processAssignments(assignment.getLeftHandExprList().getExpressionList(), assignment.getExpressionList());
            }
            if (instruction instanceof GoRecvStatementInstruction) {
                GoRecvStatement statement = (GoRecvStatement)((GoRecvStatementInstruction)instruction).getPsi();
                if (statement.getAssign() != null) {
                    return this.processAssignments(statement.getLeftExpressionsList(), statement.getRightExpressionsList());
                }
                return false;
            }
            if (instruction instanceof GoBranchInstruction) {
                GoBranchInstruction branchInstruction = (GoBranchInstruction)instruction;
                GoExpression condition = branchInstruction.getCondition();
                if (condition != null) {
                    return this.processBranchInstruction(branchInstruction, Collections.singletonList(condition));
                }
                return false;
            }
            if (instruction instanceof GoForLoopBranchInstruction) {
                GoForLoopBranchInstruction branchInstruction = (GoForLoopBranchInstruction)instruction;
                GoExpression condition = branchInstruction.getConditionExpression();
                if (condition != null) {
                    return this.processBranchInstruction(branchInstruction, Collections.singletonList(condition));
                }
                GoRangeClause rangeClause = branchInstruction.getRangeClause();
                if (rangeClause != null) {
                    return this.processRangeBranchInstruction(branchInstruction, rangeClause);
                }
                return false;
            }
            if (instruction instanceof GoCaseBranchInstruction) {
                return this.processCaseBranchInstruction((GoCaseBranchInstruction)instruction);
            }
            if (instruction instanceof GoTypeInSwitchCaseInstruction) {
                return this.processTypeInSwitchCaseInstruction((GoTypeInSwitchCaseInstruction)instruction);
            }
            return false;
        }

        private boolean processExpression(@NotNull GoExpression expression) {
            if (expression == null) {
                InstructionProcessor.$$$reportNull$$$0(2);
            }
            if (expression instanceof GoCallExpr) {
                for (GoExpression argument : ((GoCallExpr)expression).getArgumentList().getExpressionList()) {
                    GoNamedElement var = GoDataFlowUtil.findVarDefinition(argument);
                    if (var == null || !this.nilnessMap.containsKey(var) || !GoStdlibUtil.implementsError(var.getGoType(null), var)) continue;
                    this.nilnessMap.put(var, GoNilness.UNKNOWN);
                }
            }
            boolean nilnessUpdated = false;
            for (GoNamedElement var : GoDataFlowUtil.findUnpredictableVars(expression)) {
                nilnessUpdated |= this.nilnessMap.remove(var) != null;
            }
            return nilnessUpdated;
        }

        private boolean processParameterDeclaration(@NotNull GoParameterDeclaration declaration) {
            List<GoParamDefinition> nillableParameters;
            if (declaration == null) {
                InstructionProcessor.$$$reportNull$$$0(3);
            }
            if ((nillableParameters = InstructionProcessor.filterNillableDefinitions(declaration.getParamDefinitionList())).isEmpty()) {
                return false;
            }
            GoNilness value = PsiTreeUtil.getParentOfType((PsiElement)declaration, GoResult.class) != null ? GoNilness.NIL : GoNilness.UNKNOWN;
            nillableParameters.forEach(def -> this.nilnessMap.put((GoNamedElement)def, value));
            return true;
        }

        private boolean processVarDefinitions(@NotNull List<GoVarDefinition> definitions, @NotNull List<GoExpression> expressions) {
            List<GoVarDefinition> nillableVars;
            if (definitions == null) {
                InstructionProcessor.$$$reportNull$$$0(4);
            }
            if (expressions == null) {
                InstructionProcessor.$$$reportNull$$$0(5);
            }
            if ((nillableVars = InstructionProcessor.filterNillableDefinitions(definitions)).isEmpty()) {
                return false;
            }
            if (expressions.isEmpty()) {
                nillableVars.forEach(def -> this.nilnessMap.put((GoNamedElement)def, GoNilness.NIL));
            } else if (expressions.size() != definitions.size()) {
                GoVarDefinition errorVariable = GoDataFlowUtil.findLastErrorInMultiValueAssignment(definitions, expressions);
                nillableVars.forEach(def -> this.nilnessMap.put((GoNamedElement)def, def == errorVariable ? GoNilness.MAYBE_NIL : GoNilness.UNKNOWN));
            } else {
                for (GoVarDefinition def2 : nillableVars) {
                    GoExpression rightExpression = GoPsiUtil.getCorrespondingRightExpr(def2, definitions, expressions);
                    this.nilnessMap.put(def2, this.getExpressionOrVariableNilness(rightExpression, def2.getGoUnderlyingType(null) instanceof GoInterfaceType));
                }
            }
            return true;
        }

        private boolean processShortVarDeclaration(@NotNull List<GoVarDefinition> definitions, @NotNull List<GoExpression> expressions) {
            if (definitions == null) {
                InstructionProcessor.$$$reportNull$$$0(6);
            }
            if (expressions == null) {
                InstructionProcessor.$$$reportNull$$$0(7);
            }
            SmartList primaryNillableVars = new SmartList();
            SmartList originalDefinitions = new SmartList();
            for (GoVarDefinition definition : definitions) {
                GoNamedElement primaryDefinition = GoInspectionUtil.getPrimaryDefinition(definition);
                GoType type2 = primaryDefinition != null ? primaryDefinition.getGoType(null) : null;
                if (type2 == null || !GoTypeUtil.isAllowedComparingToNil(type2, primaryDefinition)) continue;
                primaryNillableVars.add(primaryDefinition);
                originalDefinitions.add(definition);
            }
            if (primaryNillableVars.isEmpty()) {
                return false;
            }
            this.processAssignments((List)definitions, expressions, (List<GoNamedElement>)primaryNillableVars, (List)originalDefinitions);
            return true;
        }

        private boolean processAssignments(@NotNull List<GoExpression> leftExpressions, @NotNull List<GoExpression> rightExpressions) {
            if (leftExpressions == null) {
                InstructionProcessor.$$$reportNull$$$0(8);
            }
            if (rightExpressions == null) {
                InstructionProcessor.$$$reportNull$$$0(9);
            }
            SmartList nillableVars = new SmartList();
            SmartList originalExpressions = new SmartList();
            for (GoExpression expression : leftExpressions) {
                GoNamedElement varDefinition = InstructionProcessor.findNillableVarDefinition(expression);
                if (varDefinition == null || !this.nilnessMap.containsKey(varDefinition)) continue;
                nillableVars.add(varDefinition);
                originalExpressions.add(expression);
            }
            if (nillableVars.isEmpty()) {
                return false;
            }
            this.processAssignments((List)leftExpressions, rightExpressions, (List<GoNamedElement>)nillableVars, (List)originalExpressions);
            return true;
        }

        private <T extends GoTypeOwner> void processAssignments(@NotNull List<T> leftElements, @NotNull List<GoExpression> rightExpressions, @NotNull List<GoNamedElement> leftNillableVars, @NotNull List<T> originalElementsForNillableVars) {
            if (leftElements == null) {
                InstructionProcessor.$$$reportNull$$$0(10);
            }
            if (rightExpressions == null) {
                InstructionProcessor.$$$reportNull$$$0(11);
            }
            if (leftNillableVars == null) {
                InstructionProcessor.$$$reportNull$$$0(12);
            }
            if (originalElementsForNillableVars == null) {
                InstructionProcessor.$$$reportNull$$$0(13);
            }
            if (rightExpressions.size() != leftElements.size()) {
                T error = GoDataFlowUtil.findLastErrorInMultiValueAssignment(leftElements, rightExpressions);
                for (Pair pair : ContainerUtil.zip(leftNillableVars, originalElementsForNillableVars)) {
                    this.nilnessMap.put((GoNamedElement)pair.first, pair.second == error ? GoNilness.MAYBE_NIL : GoNilness.UNKNOWN);
                }
            } else {
                HashMap<GoNamedElement, GoNilness> updates = new HashMap<GoNamedElement, GoNilness>();
                for (Pair pair : ContainerUtil.zip(leftNillableVars, originalElementsForNillableVars)) {
                    GoExpression right = GoPsiUtil.getCorrespondingRightExpr((GoTypeOwner)pair.second, leftElements, rightExpressions);
                    updates.put((GoNamedElement)pair.first, this.getExpressionOrVariableNilness(right, ((GoNamedElement)pair.first).getGoUnderlyingType(null) instanceof GoInterfaceType));
                }
                this.nilnessMap.putAll(updates);
            }
        }

        @NotNull
        private static <T extends GoTypeOwner> List<T> filterNillableDefinitions(@NotNull List<T> definitions) {
            if (definitions == null) {
                InstructionProcessor.$$$reportNull$$$0(14);
            }
            List list = ContainerUtil.filter(definitions, definition -> {
                GoType type2 = definition.getGoType(null);
                return type2 != null && GoTypeUtil.isAllowedComparingToNil(type2, definition);
            });
            if (list == null) {
                InstructionProcessor.$$$reportNull$$$0(15);
            }
            return list;
        }

        @Nullable
        private static GoNamedElement findNillableVarDefinition(@Nullable GoExpression expression) {
            GoNamedElement varDefinition = GoDataFlowUtil.findVarDefinition(expression);
            GoType type2 = varDefinition != null ? varDefinition.getGoType(null) : null;
            return type2 != null && GoTypeUtil.isAllowedComparingToNil(type2, expression) ? varDefinition : null;
        }

        @NotNull
        private GoNilness getExpressionOrVariableNilness(@Nullable GoExpression expression, boolean typedNilIsNotNil) {
            if (expression == null) {
                GoNilness goNilness = GoNilness.UNKNOWN;
                if (goNilness == null) {
                    InstructionProcessor.$$$reportNull$$$0(16);
                }
                return goNilness;
            }
            GoNilness nilness = GoNilnessFunction.getExpressionNilness(expression);
            if (nilness != GoNilness.UNKNOWN) {
                GoNilness goNilness = nilness;
                if (goNilness == null) {
                    InstructionProcessor.$$$reportNull$$$0(17);
                }
                return goNilness;
            }
            GoNamedElement varDefinition = InstructionProcessor.findNillableVarDefinition(expression);
            if (varDefinition != null) {
                GoNilness varNilness = this.nilnessMap.getOrDefault(varDefinition, GoNilness.UNKNOWN);
                if (varNilness == GoNilness.NIL && typedNilIsNotNil) {
                    GoNilness goNilness = !(expression.getGoUnderlyingType(null) instanceof GoInterfaceType) ? GoNilness.NOT_NIL : varNilness;
                    if (goNilness == null) {
                        InstructionProcessor.$$$reportNull$$$0(18);
                    }
                    return goNilness;
                }
                GoNilness goNilness = varNilness;
                if (goNilness == null) {
                    InstructionProcessor.$$$reportNull$$$0(19);
                }
                return goNilness;
            }
            GoNilness goNilness = GoNilness.UNKNOWN;
            if (goNilness == null) {
                InstructionProcessor.$$$reportNull$$$0(20);
            }
            return goNilness;
        }

        private boolean processBranchInstruction(@NotNull GoBranchInstructionBase instruction, @NotNull List<GoExpression> conditions) {
            if (instruction == null) {
                InstructionProcessor.$$$reportNull$$$0(21);
            }
            if (conditions == null) {
                InstructionProcessor.$$$reportNull$$$0(22);
            }
            GoDataFlowUtil.ParsedCondition parsedCondition = GoDataFlowUtil.parseAsSingleCondition(conditions);
            Set<GoNamedElement> definedVars = this.nilnessMap.keySet();
            parsedCondition.varsEqNil.retainAll(definedVars);
            parsedCondition.varsNotEqNil.retainAll(definedVars);
            parsedCondition.varsWithZeroLen.retainAll(definedVars);
            parsedCondition.varsWithNonZeroLen.retainAll(definedVars);
            if (parsedCondition.varsEqNil.isEmpty() && parsedCondition.varsNotEqNil.isEmpty() && parsedCondition.varsWithZeroLen.isEmpty() && parsedCondition.varsWithNonZeroLen.isEmpty()) {
                return false;
            }
            return this.updateNilnessWithConditions(instruction, parsedCondition);
        }

        private boolean updateNilnessWithConditions(@NotNull GoBranchInstructionBase instruction, @NotNull GoDataFlowUtil.ParsedCondition condition) {
            if (instruction == null) {
                InstructionProcessor.$$$reportNull$$$0(23);
            }
            if (condition == null) {
                InstructionProcessor.$$$reportNull$$$0(24);
            }
            if (condition.conditionType == GoDataFlowUtil.ConditionType.ATOMIC) {
                return instruction.isTrue() ? this.processTrueBranchForAtomicConditionOrChainOfAnd(condition) : this.processFalseBranchForAtomicConditionOrChainOfOr(condition);
            }
            if (condition.conditionType == GoDataFlowUtil.ConditionType.AND_CHAIN) {
                return instruction.isTrue() ? this.processTrueBranchForAtomicConditionOrChainOfAnd(condition) : this.processFalseBranchForChainOfAnd(condition);
            }
            if (condition.conditionType == GoDataFlowUtil.ConditionType.OR_CHAIN) {
                return instruction.isTrue() ? this.processTrueBranchForChainOfOr(condition) : this.processFalseBranchForAtomicConditionOrChainOfOr(condition);
            }
            if (condition.conditionType == GoDataFlowUtil.ConditionType.MIXED_CHAIN) {
                condition.varsEqNil.forEach(var -> this.nilnessMap.put((GoNamedElement)var, GoNilness.UNKNOWN));
                condition.varsNotEqNil.forEach(var -> this.nilnessMap.put((GoNamedElement)var, GoNilness.UNKNOWN));
                condition.varsWithZeroLen.forEach(var -> this.nilnessMap.put((GoNamedElement)var, GoNilness.UNKNOWN));
                condition.varsWithNonZeroLen.forEach(var -> this.nilnessMap.put((GoNamedElement)var, GoNilness.UNKNOWN));
                return true;
            }
            throw new IllegalArgumentException("Unexpected condition type");
        }

        private boolean processTrueBranchForAtomicConditionOrChainOfAnd(@NotNull GoDataFlowUtil.ParsedCondition condition) {
            if (condition == null) {
                InstructionProcessor.$$$reportNull$$$0(25);
            }
            if (this.anyConditionIsAlwaysFalse(condition)) {
                this.instructionIsUnreachable = true;
                return true;
            }
            if (this.allConditionsAreAlwaysTrue(condition)) {
                return false;
            }
            condition.varsEqNil.forEach(var -> this.nilnessMap.put((GoNamedElement)var, GoNilness.NIL));
            condition.varsNotEqNil.forEach(var -> this.nilnessMap.put((GoNamedElement)var, GoNilness.NOT_NIL));
            condition.varsWithNonZeroLen.forEach(var -> this.nilnessMap.put((GoNamedElement)var, GoNilness.NOT_NIL));
            return true;
        }

        private boolean processFalseBranchForAtomicConditionOrChainOfOr(@NotNull GoDataFlowUtil.ParsedCondition condition) {
            if (condition == null) {
                InstructionProcessor.$$$reportNull$$$0(26);
            }
            if (this.anyConditionIsAlwaysTrue(condition)) {
                this.instructionIsUnreachable = true;
                return true;
            }
            if (this.allConditionsAreAlwaysFalse(condition)) {
                return false;
            }
            condition.varsEqNil.forEach(var -> this.nilnessMap.put((GoNamedElement)var, GoNilness.NOT_NIL));
            condition.varsNotEqNil.forEach(var -> this.nilnessMap.put((GoNamedElement)var, GoNilness.NIL));
            condition.varsWithZeroLen.forEach(var -> this.nilnessMap.put((GoNamedElement)var, GoNilness.NOT_NIL));
            return true;
        }

        private boolean processFalseBranchForChainOfAnd(@NotNull GoDataFlowUtil.ParsedCondition condition) {
            if (condition == null) {
                InstructionProcessor.$$$reportNull$$$0(27);
            }
            if (!condition.hasSubConditionsWithUnknownMeaning && this.allConditionsAreAlwaysTrue(condition)) {
                this.instructionIsUnreachable = true;
                return true;
            }
            if (this.anyConditionIsAlwaysFalse(condition)) {
                return false;
            }
            boolean recalculated = false;
            for (GoNamedElement var : condition.varsNotEqNil) {
                if (this.nilnessMap.get(var) != GoNilness.UNKNOWN) continue;
                this.nilnessMap.put(var, GoNilness.MAYBE_NIL);
                recalculated = true;
            }
            return recalculated;
        }

        private boolean processTrueBranchForChainOfOr(@NotNull GoDataFlowUtil.ParsedCondition condition) {
            if (condition == null) {
                InstructionProcessor.$$$reportNull$$$0(28);
            }
            if (!condition.hasSubConditionsWithUnknownMeaning && this.allConditionsAreAlwaysFalse(condition)) {
                this.instructionIsUnreachable = true;
                return true;
            }
            if (this.anyConditionIsAlwaysTrue(condition)) {
                return false;
            }
            boolean recalculated = false;
            for (GoNamedElement var : condition.varsEqNil) {
                if (this.nilnessMap.get(var) != GoNilness.UNKNOWN) continue;
                this.nilnessMap.put(var, GoNilness.MAYBE_NIL);
                recalculated = true;
            }
            return recalculated;
        }

        private boolean allConditionsAreAlwaysTrue(@NotNull GoDataFlowUtil.ParsedCondition condition) {
            if (condition == null) {
                InstructionProcessor.$$$reportNull$$$0(29);
            }
            return ContainerUtil.all(condition.varsEqNil, var -> this.nilnessMap.get(var) == GoNilness.NIL) && ContainerUtil.all(condition.varsNotEqNil, var -> this.nilnessMap.get(var) == GoNilness.NOT_NIL) && ContainerUtil.all(condition.varsWithZeroLen, var -> this.nilnessMap.get(var) == GoNilness.NIL) && condition.varsWithNonZeroLen.isEmpty();
        }

        private boolean anyConditionIsAlwaysFalse(@NotNull GoDataFlowUtil.ParsedCondition condition) {
            if (condition == null) {
                InstructionProcessor.$$$reportNull$$$0(30);
            }
            return ContainerUtil.or(condition.varsEqNil, var -> this.nilnessMap.get(var) == GoNilness.NOT_NIL) || ContainerUtil.or(condition.varsNotEqNil, var -> this.nilnessMap.get(var) == GoNilness.NIL) || ContainerUtil.or(condition.varsWithNonZeroLen, var -> this.nilnessMap.get(var) == GoNilness.NIL);
        }

        private boolean allConditionsAreAlwaysFalse(@NotNull GoDataFlowUtil.ParsedCondition condition) {
            if (condition == null) {
                InstructionProcessor.$$$reportNull$$$0(31);
            }
            return ContainerUtil.all(condition.varsEqNil, var -> this.nilnessMap.get(var) == GoNilness.NOT_NIL) && ContainerUtil.all(condition.varsNotEqNil, var -> this.nilnessMap.get(var) == GoNilness.NIL) && condition.varsWithZeroLen.isEmpty() && ContainerUtil.all(condition.varsWithNonZeroLen, var -> this.nilnessMap.get(var) == GoNilness.NIL);
        }

        private boolean anyConditionIsAlwaysTrue(@NotNull GoDataFlowUtil.ParsedCondition condition) {
            if (condition == null) {
                InstructionProcessor.$$$reportNull$$$0(32);
            }
            return ContainerUtil.or(condition.varsEqNil, var -> this.nilnessMap.get(var) == GoNilness.NIL) || ContainerUtil.or(condition.varsNotEqNil, var -> this.nilnessMap.get(var) == GoNilness.NOT_NIL) || ContainerUtil.or(condition.varsWithZeroLen, var -> this.nilnessMap.get(var) == GoNilness.NIL);
        }

        private boolean processCaseBranchInstruction(@NotNull GoCaseBranchInstruction instruction) {
            List<GoExpression> expressions;
            if (instruction == null) {
                InstructionProcessor.$$$reportNull$$$0(33);
            }
            if ((expressions = instruction.getCaseExpressions()).isEmpty()) {
                return false;
            }
            GoExpression switchCondition = instruction.getCondition();
            return switchCondition != null ? this.processBranchInstruction(instruction, Collections.singletonList(InstructionProcessor.asChainOfOr(switchCondition, expressions))) : this.processBranchInstruction(instruction, expressions);
        }

        @NotNull
        private static GoExpression asChainOfOr(@NotNull GoExpression switchCondition, @NotNull List<GoExpression> switchCases) {
            if (switchCondition == null) {
                InstructionProcessor.$$$reportNull$$$0(34);
            }
            if (switchCases == null) {
                InstructionProcessor.$$$reportNull$$$0(35);
            }
            if (switchCases.isEmpty()) {
                throw new IllegalArgumentException("Cannot create conditions from empty switch cases");
            }
            String conditionEqualsText = switchCondition.getText() + " == ";
            String expressionText = StringUtil.join(switchCases, c -> conditionEqualsText + c.getText(), (String)" || ");
            GoExpression goExpression = GoElementFactory.createExpression(switchCondition.getProject(), expressionText, switchCases.get(0));
            if (goExpression == null) {
                InstructionProcessor.$$$reportNull$$$0(36);
            }
            return goExpression;
        }

        private boolean processTypeInSwitchCaseInstruction(@NotNull GoTypeInSwitchCaseInstruction instruction) {
            GoTypeSwitchGuard guard;
            GoTypeAssertionExpr typeAssertion;
            GoNamedElement var;
            if (instruction == null) {
                InstructionProcessor.$$$reportNull$$$0(37);
            }
            GoNamedElement goNamedElement = var = (typeAssertion = (GoTypeAssertionExpr)ObjectUtils.tryCast((Object)(guard = instruction.getTypeSwitchGuard()).getExpression(), GoTypeAssertionExpr.class)) != null ? GoDataFlowUtil.findVarDefinition(typeAssertion.getExpression()) : null;
            if (var == null || !this.nilnessMap.containsKey(var)) {
                return false;
            }
            GoType type2 = (GoType)instruction.getPsi();
            if (GoExpressionUtil.isNil(type2.resolve(guard))) {
                this.nilnessMap.put(var, GoNilness.NIL);
            } else {
                this.nilnessMap.put(var, GoNilness.NOT_NIL);
            }
            return false;
        }

        private boolean processRangeBranchInstruction(@NotNull GoForLoopBranchInstruction instruction, @NotNull GoRangeClause rangeClause) {
            GoNamedElement varDefinition;
            if (instruction == null) {
                InstructionProcessor.$$$reportNull$$$0(38);
            }
            if (rangeClause == null) {
                InstructionProcessor.$$$reportNull$$$0(39);
            }
            if (!instruction.isTrue()) {
                return false;
            }
            boolean recalculated = false;
            GoExpression expression = rangeClause.getRangeExpression();
            if (expression != null && (varDefinition = GoDataFlowUtil.findVarDefinition(expression)) != null && this.nilnessMap.containsKey(varDefinition)) {
                this.nilnessMap.put(varDefinition, GoNilness.NOT_NIL);
                recalculated = true;
            }
            if (rangeClause.getVarAssign() != null) {
                List<GoVarDefinition> nillableVars = InstructionProcessor.filterNillableDefinitions(rangeClause.getVarDefinitionList());
                if (!nillableVars.isEmpty()) {
                    nillableVars.forEach(def -> this.nilnessMap.put((GoNamedElement)def, GoNilness.UNKNOWN));
                    recalculated = true;
                }
            } else if (rangeClause.getAssign() != null) {
                for (GoExpression leftExpression : rangeClause.getLeftExpressionsList()) {
                    GoNamedElement varDefinition2 = InstructionProcessor.findNillableVarDefinition(leftExpression);
                    if (varDefinition2 == null || !this.nilnessMap.containsKey(varDefinition2)) continue;
                    this.nilnessMap.put(varDefinition2, GoNilness.UNKNOWN);
                    recalculated = true;
                }
            }
            return recalculated;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 15, 16, 17, 18, 19, 20, 36 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "map";
                    break;
                }
                case 1: 
                case 21: 
                case 23: 
                case 33: 
                case 37: 
                case 38: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "instruction";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "expression";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "declaration";
                    break;
                }
                case 4: 
                case 6: 
                case 14: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "definitions";
                    break;
                }
                case 5: 
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "expressions";
                    break;
                }
                case 8: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "leftExpressions";
                    break;
                }
                case 9: 
                case 11: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "rightExpressions";
                    break;
                }
                case 10: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "leftElements";
                    break;
                }
                case 12: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "leftNillableVars";
                    break;
                }
                case 13: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "originalElementsForNillableVars";
                    break;
                }
                case 15: 
                case 16: 
                case 17: 
                case 18: 
                case 19: 
                case 20: 
                case 36: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/goide/dataflow/GoNilnessFunction$InstructionProcessor";
                    break;
                }
                case 22: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "conditions";
                    break;
                }
                case 24: 
                case 25: 
                case 26: 
                case 27: 
                case 28: 
                case 29: 
                case 30: 
                case 31: 
                case 32: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "condition";
                    break;
                }
                case 34: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "switchCondition";
                    break;
                }
                case 35: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "switchCases";
                    break;
                }
                case 39: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "rangeClause";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/goide/dataflow/GoNilnessFunction$InstructionProcessor";
                    break;
                }
                case 15: {
                    objectArray = objectArray2;
                    objectArray2[1] = "filterNillableDefinitions";
                    break;
                }
                case 16: 
                case 17: 
                case 18: 
                case 19: 
                case 20: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getExpressionOrVariableNilness";
                    break;
                }
                case 36: {
                    objectArray = objectArray2;
                    objectArray2[1] = "asChainOfOr";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "process";
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "processExpression";
                    break;
                }
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "processParameterDeclaration";
                    break;
                }
                case 4: 
                case 5: {
                    objectArray = objectArray;
                    objectArray[2] = "processVarDefinitions";
                    break;
                }
                case 6: 
                case 7: {
                    objectArray = objectArray;
                    objectArray[2] = "processShortVarDeclaration";
                    break;
                }
                case 8: 
                case 9: 
                case 10: 
                case 11: 
                case 12: 
                case 13: {
                    objectArray = objectArray;
                    objectArray[2] = "processAssignments";
                    break;
                }
                case 14: {
                    objectArray = objectArray;
                    objectArray[2] = "filterNillableDefinitions";
                    break;
                }
                case 15: 
                case 16: 
                case 17: 
                case 18: 
                case 19: 
                case 20: 
                case 36: {
                    break;
                }
                case 21: 
                case 22: {
                    objectArray = objectArray;
                    objectArray[2] = "processBranchInstruction";
                    break;
                }
                case 23: 
                case 24: {
                    objectArray = objectArray;
                    objectArray[2] = "updateNilnessWithConditions";
                    break;
                }
                case 25: {
                    objectArray = objectArray;
                    objectArray[2] = "processTrueBranchForAtomicConditionOrChainOfAnd";
                    break;
                }
                case 26: {
                    objectArray = objectArray;
                    objectArray[2] = "processFalseBranchForAtomicConditionOrChainOfOr";
                    break;
                }
                case 27: {
                    objectArray = objectArray;
                    objectArray[2] = "processFalseBranchForChainOfAnd";
                    break;
                }
                case 28: {
                    objectArray = objectArray;
                    objectArray[2] = "processTrueBranchForChainOfOr";
                    break;
                }
                case 29: {
                    objectArray = objectArray;
                    objectArray[2] = "allConditionsAreAlwaysTrue";
                    break;
                }
                case 30: {
                    objectArray = objectArray;
                    objectArray[2] = "anyConditionIsAlwaysFalse";
                    break;
                }
                case 31: {
                    objectArray = objectArray;
                    objectArray[2] = "allConditionsAreAlwaysFalse";
                    break;
                }
                case 32: {
                    objectArray = objectArray;
                    objectArray[2] = "anyConditionIsAlwaysTrue";
                    break;
                }
                case 33: {
                    objectArray = objectArray;
                    objectArray[2] = "processCaseBranchInstruction";
                    break;
                }
                case 34: 
                case 35: {
                    objectArray = objectArray;
                    objectArray[2] = "asChainOfOr";
                    break;
                }
                case 37: {
                    objectArray = objectArray;
                    objectArray[2] = "processTypeInSwitchCaseInstruction";
                    break;
                }
                case 38: 
                case 39: {
                    objectArray = objectArray;
                    objectArray[2] = "processRangeBranchInstruction";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 15, 16, 17, 18, 19, 20, 36 -> new IllegalStateException(string);
            };
        }
    }
}

