/*
 * Decompiled with CFR 0.152.
 */
package com.goide.dataflow;

import com.goide.controlflow.GoControlFlowIterator;
import com.goide.controlflow.GoControlFlowUtil;
import com.goide.controlflow.instructions.GoForLoopEndInstruction;
import com.goide.controlflow.instructions.GoForLoopStartInstruction;
import com.goide.controlflow.instructions.GoGotoStatementInstruction;
import com.goide.dataflow.GoDataFlow;
import com.goide.dataflow.GoNilness;
import com.goide.dataflow.GoNilnessFunction;
import com.goide.dataflow.GoVarsAndErrorsFunction;
import com.goide.psi.GoNamedElement;
import com.intellij.codeInsight.controlflow.ControlFlow;
import com.intellij.codeInsight.controlflow.Instruction;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.jetbrains.annotations.NotNull;

public final class GoDataFlowBuilder {
    private static final Logger LOG = Logger.getInstance(GoDataFlowBuilder.class);
    private static final long TIME_LIMIT = TimeUnit.SECONDS.toNanos(1L);
    private static final int CONTROL_FLOW_SIZE_LIMIT = 1500;

    @NotNull
    public static GoDataFlow build(@NotNull ControlFlow controlFlow, @NotNull PsiElement enclosingFunction) {
        if (controlFlow == null) {
            GoDataFlowBuilder.$$$reportNull$$$0(0);
        }
        if (enclosingFunction == null) {
            GoDataFlowBuilder.$$$reportNull$$$0(1);
        }
        if (controlFlow.getInstructions().length > 1500) {
            LOG.debug("Give up on too large control flow\n" + GoDataFlowBuilder.info(enclosingFunction));
            GoDataFlow goDataFlow = GoDataFlow.EMPTY;
            if (goDataFlow == null) {
                GoDataFlowBuilder.$$$reportNull$$$0(2);
            }
            return goDataFlow;
        }
        if (GoControlFlowUtil.hasUnreachableInstructions(controlFlow) || GoDataFlowBuilder.hasGotoLoops(controlFlow)) {
            GoDataFlow goDataFlow = GoDataFlow.EMPTY;
            if (goDataFlow == null) {
                GoDataFlowBuilder.$$$reportNull$$$0(3);
            }
            return goDataFlow;
        }
        GoDataFlow dataFlow = new GoDataFlow(controlFlow);
        GoNilnessFunction nilnessFunction = new GoNilnessFunction(dataFlow);
        GoVarsAndErrorsFunction varsAndErrorsFunction = new GoVarsAndErrorsFunction(dataFlow);
        HashSet<GoForLoopStartInstruction> canRecalculate = new HashSet<GoForLoopStartInstruction>();
        Instruction prev = null;
        int iterationLimit = GoDataFlowBuilder.getIterationLimit(controlFlow);
        int iterationCount = 0;
        long startTime = System.nanoTime();
        GoControlFlowIterator iterator = new GoControlFlowIterator(controlFlow);
        while (iterator.hasNext()) {
            GoForLoopStartInstruction startInstruction;
            Instruction instruction = iterator.next();
            if (instruction instanceof GoForLoopStartInstruction && !(prev instanceof GoForLoopEndInstruction)) {
                canRecalculate.add((GoForLoopStartInstruction)instruction);
            } else if (instruction instanceof GoForLoopEndInstruction && canRecalculate.remove((Object)(startInstruction = ((GoForLoopEndInstruction)instruction).getLoopStartInstruction())) && GoDataFlowBuilder.recalculate((Instruction)startInstruction, nilnessFunction, varsAndErrorsFunction)) {
                iterator.setNext((Instruction)startInstruction);
                iterator.next();
                prev = instruction;
                ++iterationCount;
                continue;
            }
            GoDataFlowBuilder.recalculate(instruction, nilnessFunction, varsAndErrorsFunction);
            prev = instruction;
            if (GoDataFlowBuilder.iterationOrTimeLimitExceeded(++iterationCount, iterationLimit, startTime, enclosingFunction)) {
                GoDataFlow goDataFlow = GoDataFlow.EMPTY;
                if (goDataFlow == null) {
                    GoDataFlowBuilder.$$$reportNull$$$0(4);
                }
                return goDataFlow;
            }
            ProgressManager.checkCanceled();
        }
        GoDataFlow goDataFlow = dataFlow;
        if (goDataFlow == null) {
            GoDataFlowBuilder.$$$reportNull$$$0(5);
        }
        return goDataFlow;
    }

    @NotNull
    public static Map<GoNamedElement, GoNilness> getNilnessBefore(@NotNull Instruction instruction, @NotNull GoDataFlow dataFlow) {
        if (instruction == null) {
            GoDataFlowBuilder.$$$reportNull$$$0(6);
        }
        if (dataFlow == null) {
            GoDataFlowBuilder.$$$reportNull$$$0(7);
        }
        Map<GoNamedElement, GoNilness> map = GoNilnessFunction.mergeDataFlowOfPreviousInstructions(instruction, dataFlow, true);
        if (map == null) {
            GoDataFlowBuilder.$$$reportNull$$$0(8);
        }
        return map;
    }

    private static boolean recalculate(@NotNull Instruction instruction, @NotNull GoNilnessFunction nilnessFunction, @NotNull GoVarsAndErrorsFunction varsAndErrorsFunction) {
        if (instruction == null) {
            GoDataFlowBuilder.$$$reportNull$$$0(9);
        }
        if (nilnessFunction == null) {
            GoDataFlowBuilder.$$$reportNull$$$0(10);
        }
        if (varsAndErrorsFunction == null) {
            GoDataFlowBuilder.$$$reportNull$$$0(11);
        }
        boolean recalculated = nilnessFunction.recalculate(instruction);
        if (nilnessFunction.getDataFlow().isUnreachable(instruction)) {
            return recalculated;
        }
        return recalculated |= varsAndErrorsFunction.recalculate(instruction);
    }

    private static int getIterationLimit(@NotNull ControlFlow controlFlow) {
        if (controlFlow == null) {
            GoDataFlowBuilder.$$$reportNull$$$0(12);
        }
        int allPred = controlFlow.getInstructions().length;
        for (Instruction instruction : controlFlow.getInstructions()) {
            allPred += instruction.allPred().size();
        }
        return allPred * 2;
    }

    /*
     * WARNING - void declaration
     */
    private static boolean iterationOrTimeLimitExceeded(int iterationCount, int iterationLimit, long startTime, @NotNull PsiElement psiElement) {
        void enclosingFunction;
        if (psiElement == null) {
            GoDataFlowBuilder.$$$reportNull$$$0(13);
        }
        if (iterationCount > iterationLimit) {
            LOG.debug("Iteration limit exceeded\n" + GoDataFlowBuilder.info((PsiElement)enclosingFunction));
            return true;
        }
        if (!ApplicationManager.getApplication().isHeadlessEnvironment() && System.nanoTime() - startTime > TIME_LIMIT) {
            LOG.debug("Time limit exceeded\n" + GoDataFlowBuilder.info((PsiElement)enclosingFunction));
            return true;
        }
        return false;
    }

    @NotNull
    private static String info(@NotNull PsiElement enclosingFunction) {
        String functionText;
        VirtualFile virtualFile;
        if (enclosingFunction == null) {
            GoDataFlowBuilder.$$$reportNull$$$0(14);
        }
        StringBuilder info = new StringBuilder();
        PsiFile file = enclosingFunction.getContainingFile();
        VirtualFile virtualFile2 = virtualFile = file != null ? file.getVirtualFile() : null;
        if (virtualFile != null) {
            info.append("file: ").append(virtualFile.getPath()).append('\n');
        }
        String prefix = (functionText = enclosingFunction.getText()).length() >= 80 ? functionText.substring(0, 80) : functionText;
        info.append("function: ").append(prefix);
        String string = info.toString();
        if (string == null) {
            GoDataFlowBuilder.$$$reportNull$$$0(15);
        }
        return string;
    }

    private static boolean hasGotoLoops(@NotNull ControlFlow controlFlow) {
        if (controlFlow == null) {
            GoDataFlowBuilder.$$$reportNull$$$0(16);
        }
        for (Instruction instruction : controlFlow.getInstructions()) {
            Instruction next;
            if (!(instruction instanceof GoGotoStatementInstruction) || (next = (Instruction)ContainerUtil.getFirstItem((Collection)instruction.allSucc())) == null || !GoControlFlowUtil.isBackEdge(instruction, next)) continue;
            return true;
        }
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2, 3, 4, 5, 8, 15 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "controlFlow";
                break;
            }
            case 1: 
            case 13: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "enclosingFunction";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 8: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/goide/dataflow/GoDataFlowBuilder";
                break;
            }
            case 6: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "instruction";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataFlow";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "nilnessFunction";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "varsAndErrorsFunction";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/goide/dataflow/GoDataFlowBuilder";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "build";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getNilnessBefore";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "info";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "build";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 8: 
            case 15: {
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getNilnessBefore";
                break;
            }
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "recalculate";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "getIterationLimit";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "iterationOrTimeLimitExceeded";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "info";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "hasGotoLoops";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2, 3, 4, 5, 8, 15 -> new IllegalStateException(string);
        };
    }
}

