/*
 * Decompiled with CFR 0.152.
 */
package com.goide.configuration;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.util.Disposer;
import com.intellij.ui.BrowserHyperlinkListener;
import com.intellij.ui.ColorUtil;
import com.intellij.util.ui.AsyncProcessIcon;
import com.intellij.util.ui.HTMLEditorKitBuilder;
import com.intellij.util.ui.TimerUtil;
import com.intellij.util.ui.UIUtil;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.JPanel;
import javax.swing.JTextPane;
import javax.swing.Timer;
import javax.swing.event.HyperlinkListener;
import javax.swing.text.html.HTMLEditorKit;
import org.jetbrains.annotations.NotNull;

public final class GoUIUtil {
    private static final String CONTENT_TYPE = "text/html";

    private GoUIUtil() {
    }

    @NotNull
    public static JTextPane createDescriptionPane(boolean allowSelection) {
        JTextPane result = new JTextPane();
        result.addHyperlinkListener((HyperlinkListener)new BrowserHyperlinkListener());
        result.setContentType(CONTENT_TYPE);
        Font descriptionFont = UIUtil.getLabelFont((UIUtil.FontSize)UIUtil.FontSize.SMALL);
        HTMLEditorKit editorKit = HTMLEditorKitBuilder.simple();
        editorKit.getStyleSheet().addRule("body, p {color:#" + ColorUtil.toHex((Color)UIUtil.getLabelFontColor((UIUtil.FontColor)UIUtil.FontColor.BRIGHTER)) + ";font-family:" + descriptionFont.getFamily() + ";font-size:" + descriptionFont.getSize() + "pt;}");
        if (!allowSelection) {
            result.setHighlighter(null);
        }
        result.setEditorKit(editorKit);
        result.setOpaque(false);
        JTextPane jTextPane = result;
        if (jTextPane == null) {
            GoUIUtil.$$$reportNull$$$0(0);
        }
        return jTextPane;
    }

    @NotNull
    public static AsyncProcessIcon createProcessIcon(@NotNull String name, @NotNull Disposable parentDisposable, @NotNull Runnable repaintCallback) {
        if (name == null) {
            GoUIUtil.$$$reportNull$$$0(1);
        }
        if (parentDisposable == null) {
            GoUIUtil.$$$reportNull$$$0(2);
        }
        if (repaintCallback == null) {
            GoUIUtil.$$$reportNull$$$0(3);
        }
        AsyncProcessIcon myAsyncProcessIcon = new AsyncProcessIcon(name);
        myAsyncProcessIcon.resume();
        Disposer.register((Disposable)parentDisposable, (Disposable)myAsyncProcessIcon);
        ActionListener repaint = e -> repaintCallback.run();
        Timer repaintIconTimer = TimerUtil.createNamedTimer((String)(name + " icon repaint"), (int)(AsyncProcessIcon.CYCLE_LENGTH / AsyncProcessIcon.COUNT), (ActionListener)repaint);
        repaintIconTimer.start();
        Disposer.register((Disposable)myAsyncProcessIcon, () -> {
            repaintIconTimer.stop();
            repaintIconTimer.removeActionListener(repaint);
            repaintCallback.run();
        });
        AsyncProcessIcon asyncProcessIcon = myAsyncProcessIcon;
        if (asyncProcessIcon == null) {
            GoUIUtil.$$$reportNull$$$0(4);
        }
        return asyncProcessIcon;
    }

    @NotNull
    public static JPanel wrapWithPreviewPanel(@NotNull JPanel leftPanel, @NotNull JPanel previewPanel) {
        if (leftPanel == null) {
            GoUIUtil.$$$reportNull$$$0(5);
        }
        if (previewPanel == null) {
            GoUIUtil.$$$reportNull$$$0(6);
        }
        JPanel result = new JPanel(new BorderLayout());
        leftPanel.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        result.add((Component)leftPanel, "West");
        result.add((Component)previewPanel, "Center");
        JPanel jPanel = result;
        if (jPanel == null) {
            GoUIUtil.$$$reportNull$$$0(7);
        }
        return jPanel;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 1, 2, 3, 5, 6 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/goide/configuration/GoUIUtil";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parentDisposable";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "repaintCallback";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "leftPanel";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "previewPanel";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "createDescriptionPane";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "com/goide/configuration/GoUIUtil";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "createProcessIcon";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "wrapWithPreviewPanel";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "createProcessIcon";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "wrapWithPreviewPanel";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 1, 2, 3, 5, 6 -> new IllegalArgumentException(string);
        };
    }
}

